// third_party/blink/public/mojom/worker/shared_worker_info.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/worker/shared_worker_info.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/worker/shared_worker_info.mojom-params-data.h"
#include "third_party/blink/public/mojom/worker/shared_worker_info.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/worker/shared_worker_info.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_INFO_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_INFO_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
SharedWorkerInfo::SharedWorkerInfo()
    : url(),
      options(),
      content_security_policies(),
      creation_address_space(),
      outside_fetch_client_settings_object() {}

SharedWorkerInfo::SharedWorkerInfo(
    const ::GURL& url_in,
    ::blink::mojom::WorkerOptionsPtr options_in,
    std::vector<::network::mojom::ContentSecurityPolicyPtr> content_security_policies_in,
    ::network::mojom::IPAddressSpace creation_address_space_in,
    ::blink::mojom::FetchClientSettingsObjectPtr outside_fetch_client_settings_object_in)
    : url(std::move(url_in)),
      options(std::move(options_in)),
      content_security_policies(std::move(content_security_policies_in)),
      creation_address_space(std::move(creation_address_space_in)),
      outside_fetch_client_settings_object(std::move(outside_fetch_client_settings_object_in)) {}

SharedWorkerInfo::~SharedWorkerInfo() = default;

void SharedWorkerInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "options"), this->options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::WorkerOptionsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_security_policies"), this->content_security_policies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::network::mojom::ContentSecurityPolicyPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "creation_address_space"), this->creation_address_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::IPAddressSpace>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "outside_fetch_client_settings_object"), this->outside_fetch_client_settings_object,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::FetchClientSettingsObjectPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedWorkerInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::SharedWorkerInfo::DataView, ::blink::mojom::SharedWorkerInfoPtr>::Read(
    ::blink::mojom::SharedWorkerInfo::DataView input,
    ::blink::mojom::SharedWorkerInfoPtr* output) {
  bool success = true;
  ::blink::mojom::SharedWorkerInfoPtr result(::blink::mojom::SharedWorkerInfo::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadOptions(&result->options))
        success = false;
      if (success && !input.ReadContentSecurityPolicies(&result->content_security_policies))
        success = false;
      if (success && !input.ReadCreationAddressSpace(&result->creation_address_space))
        success = false;
      if (success && !input.ReadOutsideFetchClientSettingsObject(&result->outside_fetch_client_settings_object))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif