// ui/base/mojom/ui_base_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/base/mojom/ui_base_types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/base/mojom/ui_base_types.mojom-params-data.h"
namespace ui {
namespace mojom {

static NOINLINE const char* DialogButtonToStringHelper(DialogButton value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DialogButton::NONE:
      return "NONE";
    case DialogButton::OK:
      return "OK";
    case DialogButton::CANCEL:
      return "CANCEL";
    default:
      return nullptr;
  }
}

std::string DialogButtonToString(DialogButton value) {
  const char *str = DialogButtonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DialogButton value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DialogButton value) {
  return os << DialogButtonToString(value);
}

static NOINLINE const char* ModalTypeToStringHelper(ModalType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ModalType::NONE:
      return "NONE";
    case ModalType::WINDOW:
      return "WINDOW";
    case ModalType::CHILD:
      return "CHILD";
    case ModalType::SYSTEM:
      return "SYSTEM";
    default:
      return nullptr;
  }
}

std::string ModalTypeToString(ModalType value) {
  const char *str = ModalTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ModalType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ModalType value) {
  return os << ModalTypeToString(value);
}

static NOINLINE const char* MenuSourceTypeToStringHelper(MenuSourceType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MenuSourceType::NONE:
      return "NONE";
    case MenuSourceType::MOUSE:
      return "MOUSE";
    case MenuSourceType::KEYBOARD:
      return "KEYBOARD";
    case MenuSourceType::TOUCH:
      return "TOUCH";
    case MenuSourceType::TOUCH_EDIT_MENU:
      return "TOUCH_EDIT_MENU";
    case MenuSourceType::LONG_PRESS:
      return "LONG_PRESS";
    case MenuSourceType::LONG_TAP:
      return "LONG_TAP";
    case MenuSourceType::TOUCH_HANDLE:
      return "TOUCH_HANDLE";
    case MenuSourceType::STYLUS:
      return "STYLUS";
    case MenuSourceType::ADJUST_SELECTION:
      return "ADJUST_SELECTION";
    case MenuSourceType::ADJUST_SELECTION_RESET:
      return "ADJUST_SELECTION_RESET";
    default:
      return nullptr;
  }
}

std::string MenuSourceTypeToString(MenuSourceType value) {
  const char *str = MenuSourceTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MenuSourceType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MenuSourceType value) {
  return os << MenuSourceTypeToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace ui

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::DialogButton>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::DialogButton value) {
  return std::move(context).WriteString(::ui::mojom::DialogButtonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::ModalType>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::ModalType value) {
  return std::move(context).WriteString(::ui::mojom::ModalTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::MenuSourceType>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::MenuSourceType value) {
  return std::move(context).WriteString(::ui::mojom::MenuSourceTypeToString(value));
}

} // namespace perfetto
