// ui/display/mojom/display_constants.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/display/mojom/display_constants.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/display/mojom/display_constants.mojom-params-data.h"
namespace display {
namespace mojom {

static NOINLINE const char* DisplayConnectionTypeToStringHelper(DisplayConnectionType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DisplayConnectionType::DISPLAY_CONNECTION_TYPE_NONE:
      return "DISPLAY_CONNECTION_TYPE_NONE";
    case DisplayConnectionType::DISPLAY_CONNECTION_TYPE_UNKNOWN:
      return "DISPLAY_CONNECTION_TYPE_UNKNOWN";
    case DisplayConnectionType::DISPLAY_CONNECTION_TYPE_INTERNAL:
      return "DISPLAY_CONNECTION_TYPE_INTERNAL";
    case DisplayConnectionType::DISPLAY_CONNECTION_TYPE_VGA:
      return "DISPLAY_CONNECTION_TYPE_VGA";
    case DisplayConnectionType::DISPLAY_CONNECTION_TYPE_HDMI:
      return "DISPLAY_CONNECTION_TYPE_HDMI";
    case DisplayConnectionType::DISPLAY_CONNECTION_TYPE_DVI:
      return "DISPLAY_CONNECTION_TYPE_DVI";
    case DisplayConnectionType::DISPLAY_CONNECTION_TYPE_DISPLAYPORT:
      return "DISPLAY_CONNECTION_TYPE_DISPLAYPORT";
    case DisplayConnectionType::DISPLAY_CONNECTION_TYPE_NETWORK:
      return "DISPLAY_CONNECTION_TYPE_NETWORK";
    default:
      return nullptr;
  }
}

std::string DisplayConnectionTypeToString(DisplayConnectionType value) {
  const char *str = DisplayConnectionTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DisplayConnectionType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DisplayConnectionType value) {
  return os << DisplayConnectionTypeToString(value);
}

static NOINLINE const char* HDCPStateToStringHelper(HDCPState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case HDCPState::HDCP_STATE_UNDESIRED:
      return "HDCP_STATE_UNDESIRED";
    case HDCPState::HDCP_STATE_DESIRED:
      return "HDCP_STATE_DESIRED";
    case HDCPState::HDCP_STATE_ENABLED:
      return "HDCP_STATE_ENABLED";
    default:
      return nullptr;
  }
}

std::string HDCPStateToString(HDCPState value) {
  const char *str = HDCPStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown HDCPState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, HDCPState value) {
  return os << HDCPStateToString(value);
}

static NOINLINE const char* ContentProtectionMethodToStringHelper(ContentProtectionMethod value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ContentProtectionMethod::CONTENT_PROTECTION_METHOD_NONE:
      return "CONTENT_PROTECTION_METHOD_NONE";
    case ContentProtectionMethod::CONTENT_PROTECTION_METHOD_HDCP_TYPE_0:
      return "CONTENT_PROTECTION_METHOD_HDCP_TYPE_0";
    case ContentProtectionMethod::CONTENT_PROTECTION_METHOD_HDCP_TYPE_1:
      return "CONTENT_PROTECTION_METHOD_HDCP_TYPE_1";
    default:
      return nullptr;
  }
}

std::string ContentProtectionMethodToString(ContentProtectionMethod value) {
  const char *str = ContentProtectionMethodToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ContentProtectionMethod value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ContentProtectionMethod value) {
  return os << ContentProtectionMethodToString(value);
}

static NOINLINE const char* PanelOrientationToStringHelper(PanelOrientation value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PanelOrientation::NORMAL:
      return "NORMAL";
    case PanelOrientation::BOTTOM_UP:
      return "BOTTOM_UP";
    case PanelOrientation::LEFT_UP:
      return "LEFT_UP";
    case PanelOrientation::RIGHT_UP:
      return "RIGHT_UP";
    default:
      return nullptr;
  }
}

std::string PanelOrientationToString(PanelOrientation value) {
  const char *str = PanelOrientationToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PanelOrientation value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PanelOrientation value) {
  return os << PanelOrientationToString(value);
}

static NOINLINE const char* PrivacyScreenStateToStringHelper(PrivacyScreenState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PrivacyScreenState::DISABLED:
      return "DISABLED";
    case PrivacyScreenState::ENABLED:
      return "ENABLED";
    case PrivacyScreenState::NOT_SUPPORTED:
      return "NOT_SUPPORTED";
    default:
      return nullptr;
  }
}

std::string PrivacyScreenStateToString(PrivacyScreenState value) {
  const char *str = PrivacyScreenStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PrivacyScreenState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PrivacyScreenState value) {
  return os << PrivacyScreenStateToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace display

namespace perfetto {

// static
void TraceFormatTraits<::display::mojom::DisplayConnectionType>::WriteIntoTrace(
   perfetto::TracedValue context, ::display::mojom::DisplayConnectionType value) {
  return std::move(context).WriteString(::display::mojom::DisplayConnectionTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::display::mojom::HDCPState>::WriteIntoTrace(
   perfetto::TracedValue context, ::display::mojom::HDCPState value) {
  return std::move(context).WriteString(::display::mojom::HDCPStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::display::mojom::ContentProtectionMethod>::WriteIntoTrace(
   perfetto::TracedValue context, ::display::mojom::ContentProtectionMethod value) {
  return std::move(context).WriteString(::display::mojom::ContentProtectionMethodToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::display::mojom::PanelOrientation>::WriteIntoTrace(
   perfetto::TracedValue context, ::display::mojom::PanelOrientation value) {
  return std::move(context).WriteString(::display::mojom::PanelOrientationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::display::mojom::PrivacyScreenState>::WriteIntoTrace(
   perfetto::TracedValue context, ::display::mojom::PrivacyScreenState value) {
  return std::move(context).WriteString(::display::mojom::PrivacyScreenStateToString(value));
}

} // namespace perfetto
