// ui/display/mojom/screen_info.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/display/mojom/screen_info.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/display/mojom/screen_info.mojom-params-data.h"
#include "ui/display/mojom/screen_info.mojom-shared-message-ids.h"

#include "ui/display/mojom/screen_info.mojom-import-headers.h"


#ifndef UI_DISPLAY_MOJOM_SCREEN_INFO_MOJOM_JUMBO_H_
#define UI_DISPLAY_MOJOM_SCREEN_INFO_MOJOM_JUMBO_H_
#endif
namespace display {
namespace mojom {
ScreenInfo::ScreenInfo()
    : device_scale_factor(1),
      display_color_spaces(),
      depth(),
      depth_per_component(),
      is_monochrome(false),
      display_frequency(),
      rect(),
      available_rect(),
      orientation_type(::display::mojom::ScreenOrientation::kUndefined),
      orientation_angle(),
      is_extended(),
      is_primary(false),
      is_internal(false),
      display_id() {}

ScreenInfo::ScreenInfo(
    float device_scale_factor_in,
    const ::gfx::DisplayColorSpaces& display_color_spaces_in,
    uint32_t depth_in,
    uint32_t depth_per_component_in,
    bool is_monochrome_in,
    uint32_t display_frequency_in,
    const ::gfx::Rect& rect_in,
    const ::gfx::Rect& available_rect_in,
    ::display::mojom::ScreenOrientation orientation_type_in,
    uint16_t orientation_angle_in,
    bool is_extended_in,
    bool is_primary_in,
    bool is_internal_in,
    int64_t display_id_in)
    : device_scale_factor(std::move(device_scale_factor_in)),
      display_color_spaces(std::move(display_color_spaces_in)),
      depth(std::move(depth_in)),
      depth_per_component(std::move(depth_per_component_in)),
      is_monochrome(std::move(is_monochrome_in)),
      display_frequency(std::move(display_frequency_in)),
      rect(std::move(rect_in)),
      available_rect(std::move(available_rect_in)),
      orientation_type(std::move(orientation_type_in)),
      orientation_angle(std::move(orientation_angle_in)),
      is_extended(std::move(is_extended_in)),
      is_primary(std::move(is_primary_in)),
      is_internal(std::move(is_internal_in)),
      display_id(std::move(display_id_in)) {}

ScreenInfo::~ScreenInfo() = default;

void ScreenInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_scale_factor"), this->device_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_color_spaces"), this->display_color_spaces,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::DisplayColorSpaces&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depth"), this->depth,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depth_per_component"), this->depth_per_component,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_monochrome"), this->is_monochrome,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_frequency"), this->display_frequency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rect"), this->rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "available_rect"), this->available_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "orientation_type"), this->orientation_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::display::mojom::ScreenOrientation>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "orientation_angle"), this->orientation_angle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_extended"), this->is_extended,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_primary"), this->is_primary,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_internal"), this->is_internal,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_id"), this->display_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScreenInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace display

namespace mojo {


// static
bool StructTraits<::display::mojom::ScreenInfo::DataView, ::display::mojom::ScreenInfoPtr>::Read(
    ::display::mojom::ScreenInfo::DataView input,
    ::display::mojom::ScreenInfoPtr* output) {
  bool success = true;
  ::display::mojom::ScreenInfoPtr result(::display::mojom::ScreenInfo::New());
  
      if (success)
        result->device_scale_factor = input.device_scale_factor();
      if (success && !input.ReadDisplayColorSpaces(&result->display_color_spaces))
        success = false;
      if (success)
        result->depth = input.depth();
      if (success)
        result->depth_per_component = input.depth_per_component();
      if (success)
        result->is_monochrome = input.is_monochrome();
      if (success)
        result->display_frequency = input.display_frequency();
      if (success && !input.ReadRect(&result->rect))
        success = false;
      if (success && !input.ReadAvailableRect(&result->available_rect))
        success = false;
      if (success && !input.ReadOrientationType(&result->orientation_type))
        success = false;
      if (success)
        result->orientation_angle = input.orientation_angle();
      if (success)
        result->is_extended = input.is_extended();
      if (success)
        result->is_primary = input.is_primary();
      if (success)
        result->is_internal = input.is_internal();
      if (success)
        result->display_id = input.display_id();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif