// ui/events/mojom/event.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/events/mojom/event.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/events/mojom/event.mojom-params-data.h"
namespace ui {
namespace mojom {

namespace internal {


// static
bool KeyData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const KeyData_Data* object = static_cast<const KeyData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

KeyData_Data::KeyData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocationData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LocationData_Data* object = static_cast<const LocationData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->relative_location, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->relative_location, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->root_location, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->root_location, validation_context))
    return false;

  return true;
}

LocationData_Data::LocationData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GestureData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GestureData_Data* object = static_cast<const GestureData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->location, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->location, validation_context))
    return false;


  if (!::ui::mojom::internal::GestureDeviceType_Data
        ::Validate(object->device_type, validation_context))
    return false;

  return true;
}

GestureData_Data::GestureData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScrollData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ScrollData_Data* object = static_cast<const ScrollData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->location, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->location, validation_context))
    return false;


  if (!::ui::mojom::internal::EventMomentumPhase_Data
        ::Validate(object->momentum_phase, validation_context))
    return false;


  if (!::ui::mojom::internal::ScrollEventPhase_Data
        ::Validate(object->scroll_event_phase, validation_context))
    return false;

  return true;
}

ScrollData_Data::ScrollData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PointerDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PointerDetails_Data* object = static_cast<const PointerDetails_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::ui::mojom::internal::EventPointerType_Data
        ::Validate(object->pointer_type, validation_context))
    return false;

  return true;
}

PointerDetails_Data::PointerDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MouseData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MouseData_Data* object = static_cast<const MouseData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->location, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->location, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pointer_details, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pointer_details, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->wheel_offset, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->wheel_offset, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tick_120ths, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tick_120ths, validation_context))
    return false;

  return true;
}

MouseData_Data::MouseData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TouchData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TouchData_Data* object = static_cast<const TouchData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->location, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->location, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pointer_details, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pointer_details, validation_context))
    return false;

  return true;
}

TouchData_Data::TouchData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Event_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Event_Data* object = static_cast<const Event_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::ui::mojom::internal::EventType_Data
        ::Validate(object->action, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time_stamp, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time_stamp, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->latency, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->latency, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->key_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->gesture_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->scroll_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->touch_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->mouse_data, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams properties_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  if (!mojo::internal::ValidateContainer(object->properties, validation_context,
                                         &properties_validate_params)) {
    return false;
  }

  return true;
}

Event_Data::Event_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace ui
