// ui/gfx/mojom/delegated_ink_point_renderer.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/gfx/mojom/delegated_ink_point_renderer.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/gfx/mojom/delegated_ink_point_renderer.mojom-params-data.h"
#include "ui/gfx/mojom/delegated_ink_point_renderer.mojom-shared-message-ids.h"

#include "ui/gfx/mojom/delegated_ink_point_renderer.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef UI_GFX_MOJOM_DELEGATED_INK_POINT_RENDERER_MOJOM_BLINK_JUMBO_H_
#define UI_GFX_MOJOM_DELEGATED_INK_POINT_RENDERER_MOJOM_BLINK_JUMBO_H_
#endif
namespace gfx {
namespace mojom {
namespace blink {
const char DelegatedInkPointRenderer::Name_[] = "gfx.mojom.DelegatedInkPointRenderer";

DelegatedInkPointRendererProxy::DelegatedInkPointRendererProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DelegatedInkPointRendererProxy::StoreDelegatedInkPoint(
    ::gfx::mojom::blink::DelegatedInkPointPtr in_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "gfx::mojom::DelegatedInkPointRenderer::StoreDelegatedInkPoint", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("point"), in_point,
                        "<value of type ::gfx::mojom::blink::DelegatedInkPointPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDelegatedInkPointRenderer_StoreDelegatedInkPoint_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gfx::mojom::internal::DelegatedInkPointRenderer_StoreDelegatedInkPoint_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->point)::BaseType> point_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::DelegatedInkPointDataView>(
      in_point, point_fragment);
  params->point.Set(
      point_fragment.is_null() ? nullptr : point_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->point.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null point in DelegatedInkPointRenderer.StoreDelegatedInkPoint request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DelegatedInkPointRenderer::Name_);
  message.set_method_name("StoreDelegatedInkPoint");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DelegatedInkPointRendererProxy::ResetPrediction(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "gfx::mojom::DelegatedInkPointRenderer::ResetPrediction");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDelegatedInkPointRenderer_ResetPrediction_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::gfx::mojom::internal::DelegatedInkPointRenderer_ResetPrediction_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DelegatedInkPointRenderer::Name_);
  message.set_method_name("ResetPrediction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DelegatedInkPointRendererStubDispatch::Accept(
    DelegatedInkPointRenderer* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDelegatedInkPointRenderer_StoreDelegatedInkPoint_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gfx::mojom::DelegatedInkPointRenderer::StoreDelegatedInkPoint",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gfx::mojom::DelegatedInkPointRenderer::StoreDelegatedInkPoint");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DelegatedInkPointRenderer_StoreDelegatedInkPoint_Params_Data* params =
          reinterpret_cast<internal::DelegatedInkPointRenderer_StoreDelegatedInkPoint_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::mojom::blink::DelegatedInkPointPtr p_point{};
      DelegatedInkPointRenderer_StoreDelegatedInkPoint_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPoint(&p_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DelegatedInkPointRenderer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StoreDelegatedInkPoint(
std::move(p_point));
      return true;
    }
    case internal::kDelegatedInkPointRenderer_ResetPrediction_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)gfx::mojom::DelegatedInkPointRenderer::ResetPrediction",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)gfx::mojom::DelegatedInkPointRenderer::ResetPrediction");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DelegatedInkPointRenderer_ResetPrediction_Params_Data* params =
          reinterpret_cast<internal::DelegatedInkPointRenderer_ResetPrediction_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DelegatedInkPointRenderer_ResetPrediction_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DelegatedInkPointRenderer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetPrediction();
      return true;
    }
  }
  return false;
}

// static
bool DelegatedInkPointRendererStubDispatch::AcceptWithResponder(
    DelegatedInkPointRenderer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDelegatedInkPointRenderer_StoreDelegatedInkPoint_Name: {
      break;
    }
    case internal::kDelegatedInkPointRenderer_ResetPrediction_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDelegatedInkPointRendererValidationInfo[] = {
    {internal::kDelegatedInkPointRenderer_StoreDelegatedInkPoint_Name,
     {&internal::DelegatedInkPointRenderer_StoreDelegatedInkPoint_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDelegatedInkPointRenderer_ResetPrediction_Name,
     {&internal::DelegatedInkPointRenderer_ResetPrediction_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DelegatedInkPointRendererRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::gfx::mojom::blink::DelegatedInkPointRenderer::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDelegatedInkPointRendererValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace gfx

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif