// ui/ozone/public/mojom/device_cursor.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/ozone/public/mojom/device_cursor.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/ozone/public/mojom/device_cursor.mojom-params-data.h"
#include "ui/ozone/public/mojom/device_cursor.mojom-shared-message-ids.h"

#include "ui/ozone/public/mojom/device_cursor.mojom-import-headers.h"


#ifndef UI_OZONE_PUBLIC_MOJOM_DEVICE_CURSOR_MOJOM_JUMBO_H_
#define UI_OZONE_PUBLIC_MOJOM_DEVICE_CURSOR_MOJOM_JUMBO_H_
#endif
namespace ui {
namespace ozone {
namespace mojom {
const char DeviceCursor::Name_[] = "ui.ozone.mojom.DeviceCursor";

DeviceCursorProxy::DeviceCursorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DeviceCursorProxy::SetCursor(
    ::gfx::AcceleratedWidget in_window, const std::vector<::SkBitmap>& in_bitmaps, const ::gfx::Point& in_point, ::base::TimeDelta in_frame_delay) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "ui::ozone::mojom::DeviceCursor::SetCursor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window"), in_window,
                        "<value of type ::gfx::AcceleratedWidget>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bitmaps"), in_bitmaps,
                        "<value of type const std::vector<::SkBitmap>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("point"), in_point,
                        "<value of type const ::gfx::Point&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_delay"), in_frame_delay,
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceCursor_SetCursor_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::DeviceCursor_SetCursor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->window)::BaseType> window_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::AcceleratedWidgetDataView>(
      in_window, window_fragment);
  params->window.Set(
      window_fragment.is_null() ? nullptr : window_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->window.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null window in DeviceCursor.SetCursor request");
  mojo::internal::MessageFragment<
      typename decltype(params->bitmaps)::BaseType>
      bitmaps_fragment(params.message());
  const mojo::internal::ContainerValidateParams bitmaps_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::skia::mojom::BitmapN32DataView>>(
      in_bitmaps, bitmaps_fragment, &bitmaps_validate_params);
  params->bitmaps.Set(
      bitmaps_fragment.is_null() ? nullptr : bitmaps_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bitmaps.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bitmaps in DeviceCursor.SetCursor request");
  mojo::internal::MessageFragment<
      typename decltype(params->point)::BaseType> point_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_point, point_fragment);
  params->point.Set(
      point_fragment.is_null() ? nullptr : point_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->point.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null point in DeviceCursor.SetCursor request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame_delay)::BaseType> frame_delay_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_frame_delay, frame_delay_fragment);
  params->frame_delay.Set(
      frame_delay_fragment.is_null() ? nullptr : frame_delay_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_delay.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_delay in DeviceCursor.SetCursor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceCursor::Name_);
  message.set_method_name("SetCursor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DeviceCursorProxy::MoveCursor(
    ::gfx::AcceleratedWidget in_window, const ::gfx::Point& in_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "ui::ozone::mojom::DeviceCursor::MoveCursor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window"), in_window,
                        "<value of type ::gfx::AcceleratedWidget>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("point"), in_point,
                        "<value of type const ::gfx::Point&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceCursor_MoveCursor_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::DeviceCursor_MoveCursor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->window)::BaseType> window_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::AcceleratedWidgetDataView>(
      in_window, window_fragment);
  params->window.Set(
      window_fragment.is_null() ? nullptr : window_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->window.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null window in DeviceCursor.MoveCursor request");
  mojo::internal::MessageFragment<
      typename decltype(params->point)::BaseType> point_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_point, point_fragment);
  params->point.Set(
      point_fragment.is_null() ? nullptr : point_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->point.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null point in DeviceCursor.MoveCursor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceCursor::Name_);
  message.set_method_name("MoveCursor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DeviceCursorStubDispatch::Accept(
    DeviceCursor* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDeviceCursor_SetCursor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ui::ozone::mojom::DeviceCursor::SetCursor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ui::ozone::mojom::DeviceCursor::SetCursor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DeviceCursor_SetCursor_Params_Data* params =
          reinterpret_cast<internal::DeviceCursor_SetCursor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::AcceleratedWidget p_window{};
      std::vector<::SkBitmap> p_bitmaps{};
      ::gfx::Point p_point{};
      ::base::TimeDelta p_frame_delay{};
      DeviceCursor_SetCursor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWindow(&p_window))
        success = false;
      if (success && !input_data_view.ReadBitmaps(&p_bitmaps))
        success = false;
      if (success && !input_data_view.ReadPoint(&p_point))
        success = false;
      if (success && !input_data_view.ReadFrameDelay(&p_frame_delay))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceCursor::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCursor(
std::move(p_window), 
std::move(p_bitmaps), 
std::move(p_point), 
std::move(p_frame_delay));
      return true;
    }
    case internal::kDeviceCursor_MoveCursor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ui::ozone::mojom::DeviceCursor::MoveCursor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ui::ozone::mojom::DeviceCursor::MoveCursor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DeviceCursor_MoveCursor_Params_Data* params =
          reinterpret_cast<internal::DeviceCursor_MoveCursor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::AcceleratedWidget p_window{};
      ::gfx::Point p_point{};
      DeviceCursor_MoveCursor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWindow(&p_window))
        success = false;
      if (success && !input_data_view.ReadPoint(&p_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceCursor::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MoveCursor(
std::move(p_window), 
std::move(p_point));
      return true;
    }
  }
  return false;
}

// static
bool DeviceCursorStubDispatch::AcceptWithResponder(
    DeviceCursor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDeviceCursor_SetCursor_Name: {
      break;
    }
    case internal::kDeviceCursor_MoveCursor_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDeviceCursorValidationInfo[] = {
    {internal::kDeviceCursor_SetCursor_Name,
     {&internal::DeviceCursor_SetCursor_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDeviceCursor_MoveCursor_Name,
     {&internal::DeviceCursor_MoveCursor_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DeviceCursorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::ui::ozone::mojom::DeviceCursor::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDeviceCursorValidationInfo);
}

}  // namespace mojom
}  // namespace ozone
}  // namespace ui

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif