// ui/ozone/public/mojom/gesture_properties_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/ozone/public/mojom/gesture_properties_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/ozone/public/mojom/gesture_properties_service.mojom-params-data.h"
namespace ui {
namespace ozone {
namespace mojom {

static NOINLINE const char* SetGesturePropErrorCodeToStringHelper(SetGesturePropErrorCode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SetGesturePropErrorCode::SUCCESS:
      return "SUCCESS";
    case SetGesturePropErrorCode::UNKNOWN_ERROR:
      return "UNKNOWN_ERROR";
    case SetGesturePropErrorCode::NOT_FOUND:
      return "NOT_FOUND";
    case SetGesturePropErrorCode::READ_ONLY:
      return "READ_ONLY";
    case SetGesturePropErrorCode::TYPE_MISMATCH:
      return "TYPE_MISMATCH";
    case SetGesturePropErrorCode::SIZE_MISMATCH:
      return "SIZE_MISMATCH";
    default:
      return nullptr;
  }
}

std::string SetGesturePropErrorCodeToString(SetGesturePropErrorCode value) {
  const char *str = SetGesturePropErrorCodeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SetGesturePropErrorCode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SetGesturePropErrorCode value) {
  return os << SetGesturePropErrorCodeToString(value);
}

namespace internal {
// static
bool GesturePropValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const GesturePropValue_Data* object = static_cast<const GesturePropValue_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case GesturePropValue_Tag::INTS: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_ints, 1, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams ints_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_ints, validation_context,
                                             &ints_validate_params)) {
        return false;
      }
      return true;
    }
    case GesturePropValue_Tag::SHORTS: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_shorts, 2, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams shorts_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_shorts, validation_context,
                                             &shorts_validate_params)) {
        return false;
      }
      return true;
    }
    case GesturePropValue_Tag::BOOLS: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_bools, 3, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams bools_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_bools, validation_context,
                                             &bools_validate_params)) {
        return false;
      }
      return true;
    }
    case GesturePropValue_Tag::STR: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_str, 4, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams str_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_str, validation_context,
                                             &str_validate_params)) {
        return false;
      }
      return true;
    }
    case GesturePropValue_Tag::REALS: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_reals, 5, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams reals_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_reals, validation_context,
                                             &reals_validate_params)) {
        return false;
      }
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in GesturePropValue");
      return false;
    }
  }
}


// static
bool GesturePropertiesService_ListDevices_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GesturePropertiesService_ListDevices_Params_Data* object = static_cast<const GesturePropertiesService_ListDevices_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

GesturePropertiesService_ListDevices_Params_Data::GesturePropertiesService_ListDevices_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GesturePropertiesService_ListDevices_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GesturePropertiesService_ListDevices_ResponseParams_Data* object = static_cast<const GesturePropertiesService_ListDevices_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams result_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  if (!mojo::internal::ValidateContainer(object->result, validation_context,
                                         &result_validate_params)) {
    return false;
  }

  return true;
}

GesturePropertiesService_ListDevices_ResponseParams_Data::GesturePropertiesService_ListDevices_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GesturePropertiesService_ListProperties_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GesturePropertiesService_ListProperties_Params_Data* object = static_cast<const GesturePropertiesService_ListProperties_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

GesturePropertiesService_ListProperties_Params_Data::GesturePropertiesService_ListProperties_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GesturePropertiesService_ListProperties_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GesturePropertiesService_ListProperties_ResponseParams_Data* object = static_cast<const GesturePropertiesService_ListProperties_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->properties, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams properties_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->properties, validation_context,
                                         &properties_validate_params)) {
    return false;
  }

  return true;
}

GesturePropertiesService_ListProperties_ResponseParams_Data::GesturePropertiesService_ListProperties_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GesturePropertiesService_GetProperty_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GesturePropertiesService_GetProperty_Params_Data* object = static_cast<const GesturePropertiesService_GetProperty_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  return true;
}

GesturePropertiesService_GetProperty_Params_Data::GesturePropertiesService_GetProperty_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GesturePropertiesService_GetProperty_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GesturePropertiesService_GetProperty_ResponseParams_Data* object = static_cast<const GesturePropertiesService_GetProperty_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnion(object->value, validation_context))
    return false;

  return true;
}

GesturePropertiesService_GetProperty_ResponseParams_Data::GesturePropertiesService_GetProperty_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GesturePropertiesService_SetProperty_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GesturePropertiesService_SetProperty_Params_Data* object = static_cast<const GesturePropertiesService_SetProperty_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->value, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->value, validation_context))
    return false;

  return true;
}

GesturePropertiesService_SetProperty_Params_Data::GesturePropertiesService_SetProperty_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GesturePropertiesService_SetProperty_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GesturePropertiesService_SetProperty_ResponseParams_Data* object = static_cast<const GesturePropertiesService_SetProperty_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::ui::ozone::mojom::internal::SetGesturePropErrorCode_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

GesturePropertiesService_SetProperty_ResponseParams_Data::GesturePropertiesService_SetProperty_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace ozone
}  // namespace ui

namespace perfetto {

// static
void TraceFormatTraits<::ui::ozone::mojom::SetGesturePropErrorCode>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::ozone::mojom::SetGesturePropErrorCode value) {
  return std::move(context).WriteString(::ui::ozone::mojom::SetGesturePropErrorCodeToString(value));
}

} // namespace perfetto
