// url/mojom/origin.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "url/mojom/origin.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "url/mojom/origin.mojom-params-data.h"
#include "url/mojom/origin.mojom-shared-message-ids.h"

#include "url/mojom/origin.mojom-import-headers.h"


#ifndef URL_MOJOM_ORIGIN_MOJOM_JUMBO_H_
#define URL_MOJOM_ORIGIN_MOJOM_JUMBO_H_
#endif
namespace url {
namespace mojom {
Origin::Origin()
    : scheme(),
      host(),
      port(),
      nonce_if_opaque() {}

Origin::Origin(
    const std::string& scheme_in,
    const std::string& host_in,
    uint16_t port_in,
    const absl::optional<::base::UnguessableToken>& nonce_if_opaque_in)
    : scheme(std::move(scheme_in)),
      host(std::move(host_in)),
      port(std::move(port_in)),
      nonce_if_opaque(std::move(nonce_if_opaque_in)) {}

Origin::~Origin() = default;

void Origin::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scheme"), this->scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host"), this->host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "port"), this->port,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nonce_if_opaque"), this->nonce_if_opaque,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Origin::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace url

namespace mojo {


// static
bool StructTraits<::url::mojom::Origin::DataView, ::url::mojom::OriginPtr>::Read(
    ::url::mojom::Origin::DataView input,
    ::url::mojom::OriginPtr* output) {
  bool success = true;
  ::url::mojom::OriginPtr result(::url::mojom::Origin::New());
  
      if (success && !input.ReadScheme(&result->scheme))
        success = false;
      if (success && !input.ReadHost(&result->host))
        success = false;
      if (success)
        result->port = input.port();
      if (success && !input.ReadNonceIfOpaque(&result->nonce_if_opaque))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif