/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.tld;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.descriptor.Constants;
import org.apache.tomcat.util.descriptor.DigesterFactory;
import org.apache.tomcat.util.descriptor.XmlErrorHandler;
import org.apache.tomcat.util.descriptor.tld.TaglibXml;
import org.apache.tomcat.util.descriptor.tld.TldResourcePath;
import org.apache.tomcat.util.descriptor.tld.TldRuleSet;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.apache.tomcat.util.security.PrivilegedGetTccl;
import org.apache.tomcat.util.security.PrivilegedSetTccl;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TldParser {
    private final Log log = LogFactory.getLog(TldParser.class);
    private final Digester digester;

    public TldParser(boolean bl, boolean bl2, boolean bl3) {
        this(bl, bl2, new TldRuleSet(), bl3);
    }

    public TldParser(boolean bl, boolean bl2, RuleSet ruleSet, boolean bl3) {
        this.digester = DigesterFactory.newDigester(bl2, bl, ruleSet, bl3);
    }

    /*
     * Loose catch block
     */
    public TaglibXml parse(TldResourcePath tldResourcePath) throws IOException, SAXException {
        ClassLoader classLoader;
        Object object;
        if (Constants.IS_SECURITY_ENABLED) {
            object = new PrivilegedGetTccl();
            classLoader = (ClassLoader)AccessController.doPrivileged(object);
        } else {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        try {
            object = tldResourcePath.openStream();
            Throwable throwable = null;
            try {
                Object object2;
                if (Constants.IS_SECURITY_ENABLED) {
                    object2 = new PrivilegedSetTccl(TldParser.class.getClassLoader());
                    AccessController.doPrivileged(object2);
                } else {
                    Thread.currentThread().setContextClassLoader(TldParser.class.getClassLoader());
                }
                object2 = new XmlErrorHandler();
                this.digester.setErrorHandler((ErrorHandler)object2);
                TaglibXml taglibXml = new TaglibXml();
                this.digester.push(taglibXml);
                InputSource inputSource = new InputSource(tldResourcePath.toExternalForm());
                inputSource.setByteStream((InputStream)object);
                this.digester.parse(inputSource);
                if (!((XmlErrorHandler)object2).getWarnings().isEmpty() || !((XmlErrorHandler)object2).getErrors().isEmpty()) {
                    ((XmlErrorHandler)object2).logFindings(this.log, inputSource.getSystemId());
                    if (!((XmlErrorHandler)object2).getErrors().isEmpty()) {
                        throw ((XmlErrorHandler)object2).getErrors().iterator().next();
                    }
                }
                TaglibXml taglibXml2 = taglibXml;
                return taglibXml2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStream)object).close();
                    }
                }
            }
            {
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
        finally {
            this.digester.reset();
            if (Constants.IS_SECURITY_ENABLED) {
                PrivilegedSetTccl privilegedSetTccl = new PrivilegedSetTccl(classLoader);
                AccessController.doPrivileged(privilegedSetTccl);
            } else {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.digester.setClassLoader(classLoader);
    }
}

