/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObjectInfoMBean;

public class DefaultPooledObjectInfo
implements DefaultPooledObjectInfoMBean {
    private final PooledObject<?> pooledObject;

    public DefaultPooledObjectInfo(PooledObject<?> pooledObject) {
        this.pooledObject = pooledObject;
    }

    @Override
    public long getCreateTime() {
        return this.pooledObject.getCreateTime();
    }

    @Override
    public String getCreateTimeFormatted() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        return simpleDateFormat.format(this.pooledObject.getCreateTime());
    }

    @Override
    public long getLastBorrowTime() {
        return this.pooledObject.getLastBorrowTime();
    }

    @Override
    public String getLastBorrowTimeFormatted() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        return simpleDateFormat.format(this.pooledObject.getLastBorrowTime());
    }

    @Override
    public String getLastBorrowTrace() {
        StringWriter stringWriter = new StringWriter();
        this.pooledObject.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    @Override
    public long getLastReturnTime() {
        return this.pooledObject.getLastReturnTime();
    }

    @Override
    public String getLastReturnTimeFormatted() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        return simpleDateFormat.format(this.pooledObject.getLastReturnTime());
    }

    @Override
    public String getPooledObjectType() {
        return this.pooledObject.getObject().getClass().getName();
    }

    @Override
    public String getPooledObjectToString() {
        return this.pooledObject.getObject().toString();
    }

    @Override
    public long getBorrowedCount() {
        return this.pooledObject.getBorrowedCount();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DefaultPooledObjectInfo [pooledObject=");
        stringBuilder.append(this.pooledObject);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

