/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.Executor;

public final class Join {
    public static final Executor TRIVIAL_EXECUTOR = new Executor(){

        @Override
        public void execute(Runnable command) {
            new Thread(command).start();
        }
    };
    private final Executor executor;
    private final LinkedList[] writes;
    private final long asyncMask;
    private long mask = 0L;
    private final Reaction[][] reactionsPerChannel;

    private Join(long asyncMask, Reaction[][] reactionsPerChannel, Executor executor) {
        LinkedList[] writes = new LinkedList[reactionsPerChannel.length];
        for (int i2 = 0; i2 < writes.length; ++i2) {
            if (reactionsPerChannel[i2] == null) continue;
            writes[i2] = new LinkedList();
        }
        this.asyncMask = asyncMask;
        this.reactionsPerChannel = reactionsPerChannel;
        this.writes = writes;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRaw(int index2, Object message2) {
        Reaction selectedReaction = null;
        Object[] args2 = null;
        Join join2 = this;
        synchronized (join2) {
            Reaction[] reactions;
            LinkedList writing = this.writes[index2];
            if (writing == null) {
                throw new IndexOutOfBoundsException();
            }
            writing.addLast(message2);
            this.mask |= 1L << index2;
            for (Reaction reaction : reactions = this.reactionsPerChannel[index2]) {
                if ((reaction.mask & this.mask) != reaction.mask) continue;
                int[] indices = reaction.indices;
                args2 = new Object[indices.length];
                for (int i2 = 0; i2 < indices.length; ++i2) {
                    int readIndex = indices[i2];
                    LinkedList reading = this.writes[readIndex];
                    args2[i2] = reading.removeFirst();
                    if (!reading.isEmpty()) continue;
                    this.mask &= 1L << readIndex ^ 0xFFFFFFFFFFFFFFFFL;
                }
                selectedReaction = reaction;
                break;
            }
        }
        if (selectedReaction != null) {
            selectedReaction.dispatch(this, args2);
        }
    }

    public boolean isAsync(int channel) {
        return (1L << channel & this.asyncMask) != 0L;
    }

    public void send(int channel, Object message2) {
        if (this.isAsync(channel)) {
            this.sendRaw(channel, message2);
        } else {
            this.sendRaw(channel, new AsyncCall(message2));
        }
    }

    public void send(Enum<?> channel, Object message2) {
        this.send(channel.ordinal(), message2);
    }

    public Object call(int channel, Object message2) {
        if (this.isAsync(channel)) {
            this.sendRaw(channel, message2);
            return null;
        }
        SyncCall request = new SyncCall(message2);
        this.sendRaw(channel, request);
        return request.call();
    }

    public Object call(Enum<?> channel, Object message2) {
        return this.call(channel.ordinal(), message2);
    }

    private static class SyncCall
    extends Call {
        private Join join = null;
        private SyncReaction reaction = null;
        private Object[] args = null;

        public SyncCall(Object message2) {
            super(message2);
        }

        @Override
        public synchronized void activate(Join join2, SyncReaction reaction, Object[] args2) {
            this.join = join2;
            this.reaction = reaction;
            this.args = args2;
            this.notifyAll();
        }

        public synchronized Object call() {
            boolean interrupted = false;
            try {
                while (this.reaction == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.reaction.react(this.join, this.args);
        }
    }

    private static class AsyncCall
    extends Call {
        public AsyncCall(Object message2) {
            super(message2);
        }

        @Override
        public void activate(final Join join2, final SyncReaction reaction, final Object[] args2) {
            join2.executor.execute(new Runnable(){

                @Override
                public void run() {
                    reaction.react(join2, args2);
                }
            });
        }
    }

    private static abstract class Call {
        private final Object message;

        public Call(Object message2) {
            this.message = message2;
        }

        public Object getMessage() {
            return this.message;
        }

        public abstract void activate(Join var1, SyncReaction var2, Object[] var3);
    }

    public static abstract class SyncReaction
    extends Reaction {
        public SyncReaction(int[] indices) {
            super((int[])indices.clone(), false);
        }

        public SyncReaction(Enum<?> head, Enum<?> ... channels) {
            super(head, channels, false);
        }

        @Override
        void dispatch(Join join2, Object[] args2) {
            Call call2 = (Call)args2[0];
            args2[0] = call2.getMessage();
            call2.activate(join2, this, args2);
        }

        public abstract Object react(Join var1, Object[] var2);
    }

    public static abstract class AsyncReaction
    extends Reaction {
        public AsyncReaction(int[] indices) {
            super((int[])indices.clone(), true);
        }

        public AsyncReaction(Enum<?> head, Enum<?> ... channels) {
            super(head, channels, true);
        }

        @Override
        void dispatch(final Join join2, final Object[] args2) {
            final AsyncReaction reaction = this;
            join2.executor.execute(new Runnable(){

                @Override
                public void run() {
                    reaction.react(join2, args2);
                }
            });
        }

        public abstract void react(Join var1, Object[] var2);
    }

    public static abstract class FastReaction
    extends Reaction {
        public FastReaction(int[] indices) {
            super((int[])indices.clone(), true);
        }

        public FastReaction(Enum<?> head, Enum<?> ... channels) {
            super(head, channels, true);
        }

        @Override
        void dispatch(Join join2, Object[] args2) {
            try {
                this.react(join2, args2);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }

        public abstract void react(Join var1, Object[] var2);
    }

    public static abstract class Reaction {
        private final int[] indices;
        private final long mask;
        private final long asyncMask;

        private static int[] toIndices(Enum<?> head, Enum<?>[] channels) {
            int[] indices = new int[channels.length + 1];
            indices[0] = head.ordinal();
            for (int i2 = 0; i2 < channels.length; ++i2) {
                indices[i2 + 1] = channels[i2].ordinal();
            }
            return indices;
        }

        Reaction(Enum<?> head, Enum<?>[] channels, boolean isAsync) {
            this(Reaction.toIndices(head, channels), isAsync);
        }

        Reaction(int[] indices, boolean isAsync) {
            long mask = 0L;
            for (int i2 = 0; i2 < indices.length; ++i2) {
                int index2 = indices[i2];
                if (index2 < 0 || index2 > 63) {
                    throw new IndexOutOfBoundsException();
                }
                if ((mask & 1L << index2) != 0L) {
                    throw new IllegalArgumentException("Duplicate channels in reaction");
                }
                mask |= 1L << index2;
            }
            this.indices = indices;
            this.mask = mask;
            this.asyncMask = isAsync ? mask : mask & (1L << indices[0] ^ 0xFFFFFFFFFFFFFFFFL);
        }

        abstract void dispatch(Join var1, Object[] var2);
    }

    public static class Spec {
        private final ArrayList<ArrayList<Reaction>> reactionsPerChannel = new ArrayList();
        private long asyncMask = 0L;
        private long mask = 0L;
        private volatile Reaction[][] cachedReactionsPerChannel = null;
        private static final Reaction[] EMPTY_REACTIONS = new Reaction[0];

        public void addReaction(Reaction reaction) {
            if ((this.mask & (this.asyncMask ^ 0xFFFFFFFFFFFFFFFFL) & reaction.asyncMask) != 0L) {
                throw new IllegalArgumentException("Cannot use a synchronous channel in a non-head position");
            }
            if ((reaction.mask & (reaction.asyncMask ^ 0xFFFFFFFFFFFFFFFFL) & this.asyncMask) != 0L) {
                throw new IllegalArgumentException("Cannot use an asynchronous channel in the head position of a synchronous reaction");
            }
            this.cachedReactionsPerChannel = null;
            int[] indices = reaction.indices;
            for (int i2 = 0; i2 < indices.length; ++i2) {
                ArrayList<Reaction> reactions;
                int index2 = indices[i2];
                if (this.reactionsPerChannel.size() <= index2) {
                    this.reactionsPerChannel.ensureCapacity(index2 + 1);
                    while (this.reactionsPerChannel.size() <= index2) {
                        this.reactionsPerChannel.add(null);
                    }
                }
                if ((reactions = this.reactionsPerChannel.get(index2)) == null) {
                    reactions = new ArrayList();
                    this.reactionsPerChannel.set(index2, reactions);
                }
                reactions.add(reaction);
            }
            this.asyncMask |= reaction.asyncMask;
            this.mask |= reaction.mask;
        }

        public Join createJoin() {
            return this.createJoin(TRIVIAL_EXECUTOR);
        }

        public Join createJoin(Executor executor) {
            if (this.cachedReactionsPerChannel == null) {
                int length2 = this.reactionsPerChannel.size();
                Reaction[][] localReactionsPerChannel = new Reaction[length2][];
                for (int i2 = 0; i2 < length2; ++i2) {
                    ArrayList<Reaction> reactions = this.reactionsPerChannel.get(i2);
                    if (reactions == null) continue;
                    localReactionsPerChannel[i2] = reactions.toArray(EMPTY_REACTIONS);
                }
                this.cachedReactionsPerChannel = localReactionsPerChannel;
            }
            return new Join(this.asyncMask, this.cachedReactionsPerChannel, executor);
        }
    }
}

