/*! For license information please see oauth2-oauth2.js.LICENSE.txt */
!function(){"use strict";var e,n={62411:function(e,n,r){var i=r(20144),o=r(4820),a={name:"OAuthItem",props:{client:{type:Object,required:!0}},data:function(){return{id:this.client.id,name:this.client.name,redirectUri:this.client.redirectUri,clientId:this.client.clientId,clientSecret:this.client.clientSecret,renderSecret:!1}},computed:{renderedSecret:function(){return this.renderSecret?this.clientSecret:"****"}},methods:{toggleSecret:function(){this.renderSecret=!this.renderSecret}}},l=r(93379),s=r.n(l),d=r(7795),c=r.n(d),u=r(90569),h=r.n(u),p=r(3565),m=r.n(p),f=r(19216),A=r.n(f),v=r(44589),g=r.n(v),C=r(72580),b={};b.styleTagTransform=g(),b.setAttributes=m(),b.insert=h().bind(null,"head"),b.domAPI=c(),b.insertStyleElement=A(),s()(C.Z,b),C.Z&&C.Z.locals&&C.Z.locals;var w=r(51900),y=(0,w.Z)(a,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("tr",[n("td",[n("table",{staticClass:"inline"},[n("tr",[n("td",[t._v(t._s(t.t("oauth2","Name")))]),t._v(" "),n("td",[t._v(t._s(t.name))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.t("oauth2","Redirection URI")))]),t._v(" "),n("td",[t._v(t._s(t.redirectUri))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.t("oauth2","Client Identifier")))]),t._v(" "),n("td",[n("code",[t._v(t._s(t.clientId))])])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.t("oauth2","Secret")))]),t._v(" "),n("td",[n("code",[t._v(t._s(t.renderedSecret))]),n("a",{staticClass:"icon-toggle has-tooltip",attrs:{title:t.t("oauth2","Show client secret")},on:{click:t.toggleSecret}})])])])]),t._v(" "),n("td",{staticClass:"action-column"},[n("span",[n("a",{staticClass:"icon-delete has-tooltip",attrs:{title:t.t("oauth2","Delete")},on:{click:function(e){return t.$emit("delete",t.id)}}})])])])}),[],!1,null,"665ff3f1",null).exports,_=r(79753),U={name:"App",components:{OAuthItem:y},props:{clients:{type:Array,required:!0}},data:function(){return{newClient:{name:"",redirectUri:"",errorMsg:"",error:!1}}},methods:{deleteClient:function(t){var e=this;o.default.delete((0,_.generateUrl)("apps/oauth2/clients/{id}",{id:t})).then((function(n){e.clients=e.clients.filter((function(e){return e.id!==t}))}))},addClient:function(){var t=this;this.newClient.error=!1,o.default.post((0,_.generateUrl)("apps/oauth2/clients"),{name:this.newClient.name,redirectUri:this.newClient.redirectUri}).then((function(e){t.clients.push(e.data),t.newClient.name="",t.newClient.redirectUri=""})).catch((function(e){t.newClient.error=!0,t.newClient.errorMsg=e.response.data.message}))}}},S=r(39720),x={};x.styleTagTransform=g(),x.setAttributes=m(),x.insert=h().bind(null,"head"),x.domAPI=c(),x.insertStyleElement=A(),s()(S.Z,x),S.Z&&S.Z.locals&&S.Z.locals;var O=(0,w.Z)(U,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("div",{staticClass:"section",attrs:{id:"oauth2"}},[n("h2",[t._v(t._s(t.t("oauth2","OAuth 2.0 clients")))]),t._v(" "),n("p",{staticClass:"settings-hint"},[t._v("\n\t\t\t"+t._s(t.t("oauth2","OAuth 2.0 allows external services to request access to {instanceName}.",{instanceName:t.OC.theme.name}))+"\n\t\t")]),t._v(" "),t.clients.length>0?n("table",{staticClass:"grid"},[t._m(0),t._v(" "),n("tbody",t._l(t.clients,(function(e){return n("OAuthItem",{key:e.id,attrs:{client:e},on:{delete:t.deleteClient}})})),1)]):t._e(),t._v(" "),n("br"),t._v(" "),n("h3",[t._v(t._s(t.t("oauth2","Add client")))]),t._v(" "),t.newClient.error?n("span",{staticClass:"msg error"},[t._v(t._s(t.newClient.errorMsg))]):t._e(),t._v(" "),n("form",{on:{submit:function(e){return e.preventDefault(),t.addClient.apply(null,arguments)}}},[n("input",{directives:[{name:"model",rawName:"v-model",value:t.newClient.name,expression:"newClient.name"}],attrs:{id:"name",type:"text",name:"name",placeholder:t.t("oauth2","Name")},domProps:{value:t.newClient.name},on:{input:function(e){e.target.composing||t.$set(t.newClient,"name",e.target.value)}}}),t._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:t.newClient.redirectUri,expression:"newClient.redirectUri"}],attrs:{id:"redirectUri",type:"url",name:"redirectUri",placeholder:t.t("oauth2","Redirection URI")},domProps:{value:t.newClient.redirectUri},on:{input:function(e){e.target.composing||t.$set(t.newClient,"redirectUri",e.target.value)}}}),t._v(" "),n("input",{staticClass:"button",attrs:{type:"submit"},domProps:{value:t.t("oauth2","Add")}})])])}),[function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("thead",[n("tr",[n("th",{attrs:{id:"headerContent"}}),t._v(" "),n("th",{attrs:{id:"headerRemove"}},[t._v("\n \n\t\t\t\t\t")])])])}],!1,null,"7098866e",null),I=O.exports,R=r(16453);i.default.prototype.t=t,i.default.prototype.OC=OC;var N=(0,R.loadState)("oauth2","clients");new(i.default.extend(I))({propsData:{clients:N}}).$mount("#oauth2")},39720:function(t,e,n){var r=n(87537),i=n.n(r),o=n(23645),a=n.n(o)()(i());a.push([t.id,"\ntable[data-v-7098866e] {\n\tmax-width: 800px;\n}\n","",{version:3,sources:["webpack://./apps/oauth2/src/App.vue"],names:[],mappings:";AAyHA;CACA,gBAAA;AACA",sourcesContent:['\x3c!--\n  - @copyright Copyright (c) 2018 Roeland Jago Douma <roeland@famdouma.nl>\n  -\n  - @author Roeland Jago Douma <roeland@famdouma.nl>\n  -\n  - @license GNU AGPL version 3 or any later version\n  -\n  - This program is free software: you can redistribute it and/or modify\n  - it under the terms of the GNU Affero General Public License as\n  - published by the Free Software Foundation, either version 3 of the\n  - License, or (at your option) any later version.\n  -\n  - This program is distributed in the hope that it will be useful,\n  - but WITHOUT ANY WARRANTY; without even the implied warranty of\n  - MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n  - GNU Affero General Public License for more details.\n  -\n  - You should have received a copy of the GNU Affero General Public License\n  - along with this program. If not, see <http://www.gnu.org/licenses/>.\n  -\n  --\x3e\n<template>\n\t<div id="oauth2" class="section">\n\t\t<h2>{{ t(\'oauth2\', \'OAuth 2.0 clients\') }}</h2>\n\t\t<p class="settings-hint">\n\t\t\t{{ t(\'oauth2\', \'OAuth 2.0 allows external services to request access to {instanceName}.\', { instanceName: OC.theme.name}) }}\n\t\t</p>\n\t\t<table v-if="clients.length > 0" class="grid">\n\t\t\t<thead>\n\t\t\t\t<tr>\n\t\t\t\t\t<th id="headerContent" />\n\t\t\t\t\t<th id="headerRemove">\n&nbsp;\n\t\t\t\t\t</th>\n\t\t\t\t</tr>\n\t\t\t</thead>\n\t\t\t<tbody>\n\t\t\t\t<OAuthItem v-for="client in clients"\n\t\t\t\t\t:key="client.id"\n\t\t\t\t\t:client="client"\n\t\t\t\t\t@delete="deleteClient" />\n\t\t\t</tbody>\n\t\t</table>\n\n\t\t<br>\n\t\t<h3>{{ t(\'oauth2\', \'Add client\') }}</h3>\n\t\t<span v-if="newClient.error" class="msg error">{{ newClient.errorMsg }}</span>\n\t\t<form @submit.prevent="addClient">\n\t\t\t<input id="name"\n\t\t\t\tv-model="newClient.name"\n\t\t\t\ttype="text"\n\t\t\t\tname="name"\n\t\t\t\t:placeholder="t(\'oauth2\', \'Name\')">\n\t\t\t<input id="redirectUri"\n\t\t\t\tv-model="newClient.redirectUri"\n\t\t\t\ttype="url"\n\t\t\t\tname="redirectUri"\n\t\t\t\t:placeholder="t(\'oauth2\', \'Redirection URI\')">\n\t\t\t<input type="submit" class="button" :value="t(\'oauth2\', \'Add\')">\n\t\t</form>\n\t</div>\n</template>\n\n<script>\nimport axios from \'@nextcloud/axios\'\nimport OAuthItem from \'./components/OAuthItem\'\nimport { generateUrl } from \'@nextcloud/router\'\n\nexport default {\n\tname: \'App\',\n\tcomponents: {\n\t\tOAuthItem,\n\t},\n\tprops: {\n\t\tclients: {\n\t\t\ttype: Array,\n\t\t\trequired: true,\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tnewClient: {\n\t\t\t\tname: \'\',\n\t\t\t\tredirectUri: \'\',\n\t\t\t\terrorMsg: \'\',\n\t\t\t\terror: false,\n\t\t\t},\n\t\t}\n\t},\n\tmethods: {\n\t\tdeleteClient(id) {\n\t\t\taxios.delete(generateUrl(\'apps/oauth2/clients/{id}\', { id }))\n\t\t\t\t.then((response) => {\n\t\t\t\t\t// eslint-disable-next-line vue/no-mutating-props\n\t\t\t\t\tthis.clients = this.clients.filter(client => client.id !== id)\n\t\t\t\t})\n\t\t},\n\t\taddClient() {\n\t\t\tthis.newClient.error = false\n\n\t\t\taxios.post(\n\t\t\t\tgenerateUrl(\'apps/oauth2/clients\'),\n\t\t\t\t{\n\t\t\t\t\tname: this.newClient.name,\n\t\t\t\t\tredirectUri: this.newClient.redirectUri,\n\t\t\t\t}\n\t\t\t).then(response => {\n\t\t\t\t// eslint-disable-next-line vue/no-mutating-props\n\t\t\t\tthis.clients.push(response.data)\n\n\t\t\t\tthis.newClient.name = \'\'\n\t\t\t\tthis.newClient.redirectUri = \'\'\n\t\t\t}).catch(reason => {\n\t\t\t\tthis.newClient.error = true\n\t\t\t\tthis.newClient.errorMsg = reason.response.data.message\n\t\t\t})\n\t\t},\n\t},\n}\n<\/script>\n<style scoped>\n\ttable {\n\t\tmax-width: 800px;\n\t}\n</style>\n'],sourceRoot:""}]),e.Z=a},72580:function(t,e,n){var r=n(87537),i=n.n(r),o=n(23645),a=n.n(o)()(i());a.push([t.id,"\n.icon-toggle[data-v-665ff3f1],\n.icon-delete[data-v-665ff3f1] {\n\tdisplay: inline-block;\n\twidth: 16px;\n\theight: 16px;\n\tpadding: 10px;\n\tvertical-align: middle;\n}\ntd code[data-v-665ff3f1] {\n\tdisplay: inline-block;\n\tvertical-align: middle;\n}\ntable.inline td[data-v-665ff3f1] {\n\tborder: none;\n\tpadding: 5px;\n}\n","",{version:3,sources:["webpack://./apps/oauth2/src/components/OAuthItem.vue"],names:[],mappings:";AAsFA;;CAEA,qBAAA;CACA,WAAA;CACA,YAAA;CACA,aAAA;CACA,sBAAA;AACA;AACA;CACA,qBAAA;CACA,sBAAA;AACA;AACA;CACA,YAAA;CACA,YAAA;AACA",sourcesContent:["\x3c!--\n  - @copyright Copyright (c) 2018 Roeland Jago Douma <roeland@famdouma.nl>\n  -\n  - @author Roeland Jago Douma <roeland@famdouma.nl>\n  -\n  - @license GNU AGPL version 3 or any later version\n  -\n  - This program is free software: you can redistribute it and/or modify\n  - it under the terms of the GNU Affero General Public License as\n  - published by the Free Software Foundation, either version 3 of the\n  - License, or (at your option) any later version.\n  -\n  - This program is distributed in the hope that it will be useful,\n  - but WITHOUT ANY WARRANTY; without even the implied warranty of\n  - MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n  - GNU Affero General Public License for more details.\n  -\n  - You should have received a copy of the GNU Affero General Public License\n  - along with this program. If not, see <http://www.gnu.org/licenses/>.\n  -\n  --\x3e\n<template>\n\t<tr>\n\t\t<td>\n\t\t\t<table class=\"inline\">\n\t\t\t\t<tr>\n\t\t\t\t\t<td>{{ t('oauth2', 'Name') }}</td>\n\t\t\t\t\t<td>{{ name }}</td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>{{ t('oauth2', 'Redirection URI') }}</td>\n\t\t\t\t\t<td>{{ redirectUri }}</td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>{{ t('oauth2', 'Client Identifier') }}</td>\n\t\t\t\t\t<td><code>{{ clientId }}</code></td>\n\t\t\t\t</tr>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>{{ t('oauth2', 'Secret') }}</td>\n\t\t\t\t\t<td><code>{{ renderedSecret }}</code><a class=\"icon-toggle has-tooltip\" :title=\"t('oauth2', 'Show client secret')\" @click=\"toggleSecret\" /></td>\n\t\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t\t<td class=\"action-column\">\n\t\t\t<span><a class=\"icon-delete has-tooltip\" :title=\"t('oauth2', 'Delete')\" @click=\"$emit('delete', id)\" /></span>\n\t\t</td>\n\t</tr>\n</template>\n\n<script>\nexport default {\n\tname: 'OAuthItem',\n\tprops: {\n\t\tclient: {\n\t\t\ttype: Object,\n\t\t\trequired: true,\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tid: this.client.id,\n\t\t\tname: this.client.name,\n\t\t\tredirectUri: this.client.redirectUri,\n\t\t\tclientId: this.client.clientId,\n\t\t\tclientSecret: this.client.clientSecret,\n\t\t\trenderSecret: false,\n\t\t}\n\t},\n\tcomputed: {\n\t\trenderedSecret() {\n\t\t\tif (this.renderSecret) {\n\t\t\t\treturn this.clientSecret\n\t\t\t} else {\n\t\t\t\treturn '****'\n\t\t\t}\n\t\t},\n\t},\n\tmethods: {\n\t\ttoggleSecret() {\n\t\t\tthis.renderSecret = !this.renderSecret\n\t\t},\n\t},\n}\n<\/script>\n\n<style scoped>\n\t.icon-toggle,\n\t.icon-delete {\n\t\tdisplay: inline-block;\n\t\twidth: 16px;\n\t\theight: 16px;\n\t\tpadding: 10px;\n\t\tvertical-align: middle;\n\t}\n\ttd code {\n\t\tdisplay: inline-block;\n\t\tvertical-align: middle;\n\t}\n\ttable.inline td {\n\t\tborder: none;\n\t\tpadding: 5px;\n\t}\n</style>\n"],sourceRoot:""}]),e.Z=a}},r={};function i(t){var e=r[t];if(void 0!==e)return e.exports;var o=r[t]={id:t,loaded:!1,exports:{}};return n[t].call(o.exports,o,o.exports,i),o.loaded=!0,o.exports}i.m=n,i.amdD=function(){throw new Error("define cannot be used indirect")},i.amdO={},e=[],i.O=function(t,n,r,o){if(!n){var a=1/0;for(c=0;c<e.length;c++){n=e[c][0],r=e[c][1],o=e[c][2];for(var l=!0,s=0;s<n.length;s++)(!1&o||a>=o)&&Object.keys(i.O).every((function(t){return i.O[t](n[s])}))?n.splice(s--,1):(l=!1,o<a&&(a=o));if(l){e.splice(c--,1);var d=r();void 0!==d&&(t=d)}}return t}o=o||0;for(var c=e.length;c>0&&e[c-1][2]>o;c--)e[c]=e[c-1];e[c]=[n,r,o]},i.n=function(t){var e=t&&t.__esModule?function(){return t.default}:function(){return t};return i.d(e,{a:e}),e},i.d=function(t,e){for(var n in e)i.o(e,n)&&!i.o(t,n)&&Object.defineProperty(t,n,{enumerable:!0,get:e[n]})},i.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(t){if("object"==typeof window)return window}}(),i.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},i.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},i.nmd=function(t){return t.paths=[],t.children||(t.children=[]),t},i.j=5053,function(){i.b=document.baseURI||self.location.href;var t={5053:0};i.O.j=function(e){return 0===t[e]};var e=function(e,n){var r,o,a=n[0],l=n[1],s=n[2],d=0;if(a.some((function(e){return 0!==t[e]}))){for(r in l)i.o(l,r)&&(i.m[r]=l[r]);if(s)var c=s(i)}for(e&&e(n);d<a.length;d++)o=a[d],i.o(t,o)&&t[o]&&t[o][0](),t[o]=0;return i.O(c)},n=self.webpackChunknextcloud=self.webpackChunknextcloud||[];n.forEach(e.bind(null,0)),n.push=e.bind(null,n.push.bind(n))}();var o=i.O(void 0,[7874],(function(){return i(62411)}));o=i.O(o)}();
//# sourceMappingURL=oauth2-oauth2.js.map?v=7bcaac9c20151a31e51e