/* gcalc-math-function.c generated by valac 0.56.1, the Vala compiler
 * generated from gcalc-math-function.vala, do not modify */

/* gcalc-math-function.vala
 *
 * Copyright (C) 2018  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include "gcalc/gcalc.h"
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include "gcalc.h"

static gboolean gcalc_math_function_real_verify_params (GCalcMathFunction* self,
                                                 GError** error);
static GType gcalc_math_function_get_type_once (void);

/**
   * Evaluate the function returning a resulting {@link MathExpression}.
   *
   * In some cases return is a {@link MathConstant}
   */
GCalcMathExpression*
gcalc_math_function_evaluate (GCalcMathFunction* self,
                              GError** error)
{
	GCalcMathFunctionIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GCALC_MATH_FUNCTION_GET_INTERFACE (self);
	if (_iface_->evaluate) {
		return _iface_->evaluate (self, error);
	}
	return NULL;
}

/**
   * Check the paratemeters given to the function agains {@link param_types}
   * and number of parameters using {@link n_params}
   */
static gboolean
gcalc_math_function_real_verify_params (GCalcMathFunction* self,
                                        GError** error)
{
	GCalcExpressionContainer* _tmp0_;
	GCalcExpressionContainer* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	_tmp0_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gcalc_math_function_get_n_params (self);
	_tmp3_ = _tmp2_;
	if (g_list_model_get_n_items ((GListModel*) _tmp1_) != _tmp3_) {
		guint _tmp4_;
		guint _tmp5_;
		GCalcExpressionContainer* _tmp6_;
		GCalcExpressionContainer* _tmp7_;
		GError* _tmp8_;
		gboolean _tmp9_ = FALSE;
		_tmp4_ = gcalc_math_function_get_n_params (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_error_new (GCALC_FUNCTION_ERROR, GCALC_FUNCTION_ERROR_INVALID_PARAMETERS_ERROR, _ ("Invalid number of parameters. Required %u, provided: %u"), _tmp5_, g_list_model_get_n_items ((GListModel*) _tmp7_));
		_inner_error0_ = _tmp8_;
		g_propagate_error (error, _inner_error0_);
		return _tmp9_;
	}
	result = TRUE;
	return result;
}

gboolean
gcalc_math_function_verify_params (GCalcMathFunction* self,
                                   GError** error)
{
	GCalcMathFunctionIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GCALC_MATH_FUNCTION_GET_INTERFACE (self);
	if (_iface_->verify_params) {
		return _iface_->verify_params (self, error);
	}
	return FALSE;
}

GCalcExpressionContainer*
gcalc_math_function_get_param_types (GCalcMathFunction* self)
{
	GCalcMathFunctionIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GCALC_MATH_FUNCTION_GET_INTERFACE (self);
	if (_iface_->get_param_types) {
		return _iface_->get_param_types (self);
	}
	return NULL;
}

const gchar*
gcalc_math_function_get_name (GCalcMathFunction* self)
{
	GCalcMathFunctionIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GCALC_MATH_FUNCTION_GET_INTERFACE (self);
	if (_iface_->get_name) {
		return _iface_->get_name (self);
	}
	return NULL;
}

void
gcalc_math_function_set_name (GCalcMathFunction* self,
                              const gchar* value)
{
	GCalcMathFunctionIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GCALC_MATH_FUNCTION_GET_INTERFACE (self);
	if (_iface_->set_name) {
		_iface_->set_name (self, value);
	}
}

guint
gcalc_math_function_get_n_params (GCalcMathFunction* self)
{
	GCalcMathFunctionIface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = GCALC_MATH_FUNCTION_GET_INTERFACE (self);
	if (_iface_->get_n_params) {
		return _iface_->get_n_params (self);
	}
	return 0U;
}

void
gcalc_math_function_set_n_params (GCalcMathFunction* self,
                                  guint value)
{
	GCalcMathFunctionIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GCALC_MATH_FUNCTION_GET_INTERFACE (self);
	if (_iface_->set_n_params) {
		_iface_->set_n_params (self, value);
	}
}

gboolean
gcalc_math_function_get_closed (GCalcMathFunction* self)
{
	GCalcMathFunctionIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GCALC_MATH_FUNCTION_GET_INTERFACE (self);
	if (_iface_->get_closed) {
		return _iface_->get_closed (self);
	}
	return FALSE;
}

void
gcalc_math_function_set_closed (GCalcMathFunction* self,
                                gboolean value)
{
	GCalcMathFunctionIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GCALC_MATH_FUNCTION_GET_INTERFACE (self);
	if (_iface_->set_closed) {
		_iface_->set_closed (self, value);
	}
}

static void
gcalc_math_function_default_init (GCalcMathFunctionIface * iface,
                                  gpointer iface_data)
{
	/**
	   * Parameters used by the function, objects representing
	   * the expected types. See {@link verify_params}
	   */
	g_object_interface_install_property (iface, g_param_spec_object ("param-types", "param-types", "param-types", GCALC_TYPE_EXPRESSION_CONTAINER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Function's name
	   */
	g_object_interface_install_property (iface, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * Number of parameters required by this function
	   */
	g_object_interface_install_property (iface, g_param_spec_uint ("n-params", "n-params", "n-params", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * A condition used while parsing, as a flag when the function
	   * has been closed or finished and no more parameters should
	   * be parsed.
	   */
	g_object_interface_install_property (iface, g_param_spec_boolean ("closed", "closed", "closed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	iface->verify_params = gcalc_math_function_real_verify_params;
}

/**
 * A Function as part of a {@link MathExpression}
 */
static GType
gcalc_math_function_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GCalcMathFunctionIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcalc_math_function_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gcalc_math_function_type_id;
	gcalc_math_function_type_id = g_type_register_static (G_TYPE_INTERFACE, "GCalcMathFunction", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gcalc_math_function_type_id, G_TYPE_OBJECT);
	g_type_interface_add_prerequisite (gcalc_math_function_type_id, GCALC_TYPE_MATH_EXPRESSION);
	return gcalc_math_function_type_id;
}

GType
gcalc_math_function_get_type (void)
{
	static volatile gsize gcalc_math_function_type_id__once = 0;
	if (g_once_init_enter (&gcalc_math_function_type_id__once)) {
		GType gcalc_math_function_type_id;
		gcalc_math_function_type_id = gcalc_math_function_get_type_once ();
		g_once_init_leave (&gcalc_math_function_type_id__once, gcalc_math_function_type_id);
	}
	return gcalc_math_function_type_id__once;
}

GQuark
gcalc_function_error_quark (void)
{
	return g_quark_from_static_string ("gcalc-function-error-quark");
}

static GType
gcalc_function_error_get_type_once (void)
{
	static const GEnumValue values[] = {{GCALC_FUNCTION_ERROR_INVALID_PARAMETERS_ERROR, "GCALC_FUNCTION_ERROR_INVALID_PARAMETERS_ERROR", "invalid-parameters-error"}, {GCALC_FUNCTION_ERROR_INVOCATION_ERROR, "GCALC_FUNCTION_ERROR_INVOCATION_ERROR", "invocation-error"}, {0, NULL, NULL}};
	GType gcalc_function_error_type_id;
	gcalc_function_error_type_id = g_enum_register_static ("GCalcFunctionError", values);
	return gcalc_function_error_type_id;
}

GType
gcalc_function_error_get_type (void)
{
	static volatile gsize gcalc_function_error_type_id__once = 0;
	if (g_once_init_enter (&gcalc_function_error_type_id__once)) {
		GType gcalc_function_error_type_id;
		gcalc_function_error_type_id = gcalc_function_error_get_type_once ();
		g_once_init_leave (&gcalc_function_error_type_id__once, gcalc_function_error_type_id);
	}
	return gcalc_function_error_type_id__once;
}

