/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.tomcat.jakartaee.bcel.Constants;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantPool;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantUtf8;
import org.apache.tomcat.jakartaee.bcel.classfile.Node;
import org.apache.tomcat.jakartaee.bcel.classfile.Utility;
import org.apache.tomcat.jakartaee.bcel.classfile.Visitor;

public final class LocalVariable
implements Cloneable,
Node,
Constants {
    private int startPc;
    private int length;
    private int nameIndex;
    private int signatureIndex;
    private int index;
    private ConstantPool constantPool;
    private int origIndex;

    public LocalVariable(LocalVariable localVariable) {
        this(localVariable.getStartPC(), localVariable.getLength(), localVariable.getNameIndex(), localVariable.getSignatureIndex(), localVariable.getIndex(), localVariable.getConstantPool());
        this.origIndex = localVariable.getOrigIndex();
    }

    LocalVariable(DataInput file, ConstantPool constant_pool) throws IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort(), constant_pool);
    }

    public LocalVariable(int startPc, int length, int nameIndex, int signatureIndex, int index, ConstantPool constantPool) {
        this.startPc = startPc;
        this.length = length;
        this.nameIndex = nameIndex;
        this.signatureIndex = signatureIndex;
        this.index = index;
        this.constantPool = constantPool;
        this.origIndex = index;
    }

    public LocalVariable(int startPc, int length, int nameIndex, int signatureIndex, int index, ConstantPool constantPool, int origIndex) {
        this.startPc = startPc;
        this.length = length;
        this.nameIndex = nameIndex;
        this.signatureIndex = signatureIndex;
        this.index = index;
        this.constantPool = constantPool;
        this.origIndex = origIndex;
    }

    @Override
    public void accept(Visitor v) {
        v.visitLocalVariable(this);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.startPc);
        dataOutputStream.writeShort(this.length);
        dataOutputStream.writeShort(this.nameIndex);
        dataOutputStream.writeShort(this.signatureIndex);
        dataOutputStream.writeShort(this.index);
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public int getLength() {
        return this.length;
    }

    public String getName() {
        ConstantUtf8 c = (ConstantUtf8)this.constantPool.getConstant(this.nameIndex, (byte)1);
        return c.getBytes();
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public String getSignature() {
        ConstantUtf8 c = (ConstantUtf8)this.constantPool.getConstant(this.signatureIndex, (byte)1);
        return c.getBytes();
    }

    public int getSignatureIndex() {
        return this.signatureIndex;
    }

    public int getIndex() {
        return this.index;
    }

    public int getOrigIndex() {
        return this.origIndex;
    }

    public int getStartPC() {
        return this.startPc;
    }

    String toStringShared(boolean typeTable) {
        String name = this.getName();
        String signature = Utility.signatureToString(this.getSignature(), false);
        String label = "LocalVariable" + (typeTable ? "Types" : "");
        return label + "(startPc = " + this.startPc + ", length = " + this.length + ", index = " + this.index + ":" + signature + " " + name + ")";
    }

    public void setConstantPool(ConstantPool constantPool) {
        this.constantPool = constantPool;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setNameIndex(int nameIndex) {
        this.nameIndex = nameIndex;
    }

    public void setSignatureIndex(int signatureIndex) {
        this.signatureIndex = signatureIndex;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setStartPC(int startPc) {
        this.startPc = startPc;
    }

    public String toString() {
        return this.toStringShared(false);
    }

    public LocalVariable copy() {
        try {
            return (LocalVariable)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

