/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.startup.StartLog;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.lookup.Lookups;

final class WarmUpSupport
implements Runnable {
    private static final RequestProcessor.Task TASK;
    private static final Logger err;

    WarmUpSupport() {
    }

    static Task warmUp(long l) {
        TASK.schedule((int)l);
        return TASK;
    }

    static Task waitTask() {
        return TASK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        err.fine("Warmup starting...");
        StartLog.logStart("Warmup");
        try {
            Collection collection = Lookups.forPath((String)"WarmUp").lookupResult(Runnable.class).allItems();
            err.log(Level.FINE, "Found {0} warm up task(s)", collection.size());
            for (Lookup.Item item : collection) {
                try {
                    Runnable runnable = (Runnable)item.getInstance();
                    if (runnable == null) {
                        err.log(Level.WARNING, "Got null warmup task from lookup: id={0}, displayName={1}, class={2}, type={3}", new Object[]{item.getId(), item.getDisplayName(), item.getClass(), item.getType()});
                        continue;
                    }
                    runnable.run();
                    StartLog.logProgress("Warmup task executed " + item.getId());
                }
                catch (Exception exception) {
                    Logger.getLogger(WarmUpSupport.class.getName()).log(Level.WARNING, null, exception);
                }
            }
            err.fine("Warmup done.");
        }
        finally {
            StartLog.logEnd("Warmup");
            StartLog.impl.flush();
        }
    }

    static {
        RequestProcessor requestProcessor = new RequestProcessor("Warm Up");
        TASK = requestProcessor.create((Runnable)new WarmUpSupport(), true);
        err = Logger.getLogger("org.netbeans.core.WarmUpSupport");
    }
}

