/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.board;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.api.ThemeStyle;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.board.Activity;
import net.sourceforge.plantuml.board.PostIt;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class BoardDiagram
extends UmlDiagram {
    private final List<Activity> activities = new ArrayList<Activity>();

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("Board");
    }

    public BoardDiagram(ThemeStyle style, UmlSource source) {
        super(style, source, UmlDiagramType.BOARD, null);
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTextBlock()).write(os);
    }

    private TextBlockBackcolored getTextBlock() {
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                BoardDiagram.this.drawMe(ug);
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                double width = 200.0;
                double height = 200.0;
                return new Dimension2DDouble(200.0, 200.0);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                throw new UnsupportedOperationException();
            }

            @Override
            public HColor getBackcolor() {
                return null;
            }
        };
    }

    private void drawMe(UGraphic ug) {
        UGraphic mug = ug;
        for (Activity activity : this.activities) {
            activity.drawMe(mug);
            mug = mug.apply(UTranslate.dx(activity.getFullWidth()));
        }
        ULine line = ULine.hline(this.getFullWidth());
        for (int i = 0; i < this.getMaxStage(); ++i) {
            double dy = (double)(i + 1) * PostIt.getHeight() - 10.0;
            ug.apply(HColorUtils.BLACK).apply(new UStroke(5.0, 5.0, 0.5)).apply(UTranslate.dy(dy)).draw(line);
        }
    }

    private double getFullWidth() {
        double width = 0.0;
        for (Activity activity : this.activities) {
            width += activity.getFullWidth();
        }
        return width;
    }

    private int getMaxStage() {
        int max = 0;
        for (Activity activity : this.activities) {
            max = Math.max(max, activity.getMaxStage());
        }
        return max;
    }

    private Activity getLastActivity() {
        return this.activities.get(this.activities.size() - 1);
    }

    public CommandExecutionResult addLine(String plus, String label) {
        if (plus.length() == 0) {
            Activity activity = new Activity(this, label, this.getSkinParam());
            this.activities.add(activity);
            return CommandExecutionResult.ok();
        }
        this.getLastActivity().addRelease(plus.length(), label);
        return CommandExecutionResult.ok();
    }
}

