/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.timingdiagram.TimeProjected;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public abstract class Player
implements TimeProjected {
    protected final ISkinParam skinParam;
    protected final TimingRuler ruler;
    private final boolean compact;
    private final Display title;
    protected int suggestedHeight;

    public Player(String title, ISkinParam skinParam, TimingRuler ruler, boolean compact) {
        this.skinParam = skinParam;
        this.compact = compact;
        this.ruler = ruler;
        this.title = Display.getWithNewlines(title);
    }

    public boolean isCompact() {
        return this.compact;
    }

    protected abstract StyleSignatureBasic getStyleSignature();

    protected abstract SymbolContext getContextLegacy();

    protected final Style getStyle() {
        return this.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    protected final FontConfiguration getFontConfiguration() {
        if (!UseStyle.useBetaStyle()) {
            return FontConfiguration.create(this.skinParam, FontParam.TIMING, null);
        }
        return FontConfiguration.create(this.skinParam, StyleSignatureBasic.of(SName.root, SName.element, SName.timingDiagram).getMergedStyle(this.skinParam.getCurrentStyleBuilder()));
    }

    protected final UStroke getStroke() {
        Style style = this.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        return style.getStroke();
    }

    protected final SymbolContext getContext() {
        if (!UseStyle.useBetaStyle()) {
            return this.getContextLegacy();
        }
        Style style = this.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        HColor lineColor = style.value(PName.LineColor).asColor(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
        HColor backgroundColor = style.value(PName.BackGroundColor).asColor(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
        return new SymbolContext(backgroundColor, lineColor).withStroke(this.getStroke());
    }

    protected final TextBlock getTitle() {
        return this.title.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    public abstract void addNote(TimeTick var1, Display var2, Position var3);

    public abstract void defineState(String var1, String var2);

    public abstract void setState(TimeTick var1, String var2, Colors var3, String ... var4);

    public abstract void createConstraint(TimeTick var1, TimeTick var2, String var3);

    public abstract TextBlock getPart1(double var1, double var3);

    public abstract UDrawable getPart2();

    public abstract double getFullHeight(StringBounder var1);

    public final void setHeight(int height) {
        this.suggestedHeight = height;
    }
}

