complete -c uu-dd -l if -d '(alternatively if=FILE) specifies the file used for input. When not specified, stdin is used instead' -r -F
complete -c uu-dd -l of -d '(alternatively of=FILE) specifies the file used for output. When not specified, stdout is used instead' -r -F
complete -c uu-dd -l ibs -d '(alternatively ibs=N) specifies the size of buffer used for reads (default: 512). Multiplier strings permitted.' -r
complete -c uu-dd -l obs -d '(alternatively obs=N) specifies the size of buffer used for writes (default: 512). Multiplier strings permitted.' -r
complete -c uu-dd -l bs -d '(alternatively bs=N) specifies ibs=N and obs=N (default: 512). If ibs or obs are also specified, bs=N takes precedence. Multiplier strings permitted.' -r
complete -c uu-dd -l cbs -d '(alternatively cbs=BYTES) specifies the \'conversion block size\' in bytes. Applies to the conv=block, and conv=unblock operations. Multiplier strings permitted.' -r
complete -c uu-dd -l skip -d '(alternatively skip=N) causes N ibs-sized records of input to be skipped before beginning copy/convert operations. See iflag=count_bytes if skipping N bytes is preferred. Multiplier strings permitted.' -r
complete -c uu-dd -l seek -d '(alternatively seek=N) seeks N obs-sized records into output before beginning copy/convert operations. See oflag=seek_bytes if seeking N bytes is preferred. Multiplier strings permitted.' -r
complete -c uu-dd -l iseek -d '(alternatively iseek=N) seeks N obs-sized records into input before beginning copy/convert operations. See iflag=seek_bytes if seeking N bytes is preferred. Multiplier strings permitted.' -r
complete -c uu-dd -l oseek -d '(alternatively oseek=N) seeks N obs-sized records into output before beginning copy/convert operations. See oflag=seek_bytes if seeking N bytes is preferred. Multiplier strings permitted.' -r
complete -c uu-dd -l count -d '(alternatively count=N) stop reading input after N ibs-sized read operations rather than proceeding until EOF. See iflag=count_bytes if stopping after N bytes is preferred. Multiplier strings permitted.' -r
complete -c uu-dd -l status -d '(alternatively status=LEVEL) controls whether volume and performance stats are written to stderr.

When unspecified, dd will print stats upon completion. An example is below.
	6+0 records in
	16+0 records out
	8192 bytes (8.2 kB, 8.0 KiB) copied, 0.00057009 s, 14.4 MB/s
The first two lines are the \'volume\' stats and the final line is the \'performance\' stats.
The volume stats indicate the number of complete and partial ibs-sized reads, or obs-sized writes that took place during the copy. The format of the volume stats is <complete>+<partial>. If records have been truncated (see conv=block), the volume stats will contain the number of truncated records.

Permissible LEVEL values are:
	 progress: Print periodic performance stats as the copy proceeds.
	 noxfer: Print final volume stats, but not performance stats.
	 none: Do not print any stats.

Printing performance stats is also triggered by the INFO signal (where supported), or the USR1 signal. Setting the POSIXLY_CORRECT environment variable to any value (including an empty value) will cause the USR1 signal to be ignored.

' -r
complete -c uu-dd -l conv -d '(alternatively conv=CONV[,CONV]) specifies a comma-separated list of conversion options or (for legacy reasons) file flags. Conversion options and file flags may be intermixed.

Conversion options:
	 One of {ascii, ebcdic, ibm} will perform an encoding conversion.
		 \'ascii\' converts from EBCDIC to ASCII. This is the inverse of the \'ebcdic\' option.
		 \'ebcdic\' converts from ASCII to EBCDIC. This is the inverse of the \'ascii\' option.
		 \'ibm\' converts from ASCII to EBCDIC, applying the conventions for \'[\', \']\' and \'~\' specified in POSIX.

	 One of {ucase, lcase} will perform a case conversion. Works in conjunction with option {ascii, ebcdic, ibm} to infer input encoding. If no other conversion option is specified, input is assumed to be ascii.
		 \'ucase\' converts from lower-case to upper-case
		 \'lcase\' converts from upper-case to lower-case.

	 One of {block, unblock}. Convert between lines terminated by newline characters, and fixed-width lines padded by spaces (without any newlines). Both the \'block\' and \'unblock\' options require cbs=BYTES be specified.
		 \'block\' for each newline less than the size indicated by cbs=BYTES, remove the newline and pad with spaces up to cbs. Lines longer than cbs are truncated.
		 \'unblock\' for each block of input of the size indicated by cbs=BYTES, remove right-trailing spaces and replace with a newline character.

	 \'sparse\' attempts to seek the output when an obs-sized block consists of only zeros.
	 \'swab\' swaps each adjacent pair of bytes. If an odd number of bytes is present, the final byte is omitted.
	 \'sync\' pad each ibs-sided block with zeros. If \'block\' or \'unblock\' is specified, pad with spaces instead.

Conversion Flags:
	 One of {excl, nocreat}
		 \'excl\' the output file must be created. Fail if the output file is already present.
		 \'nocreat\' the output file will not be created. Fail if the output file in not already present.
	 \'notrunc\' the output file will not be truncated. If this option is not present, output will be truncated when opened.
	 \'noerror\' all read errors will be ignored. If this option is not present, dd will only ignore Error::Interrupted.
	 \'fdatasync\' data will be written before finishing.
	 \'fsync\' data and metadata will be written before finishing.

' -r
complete -c uu-dd -l iflag -d '(alternatively iflag=FLAG[,FLAG]) a comma separated list of input flags which specify how the input source is treated. FLAG may be any of the input-flags or general-flags specified below.

Input-Flags
	 \'count_bytes\' a value to count=N will be interpreted as bytes.
	 \'skip_bytes\' a value to skip=N will be interpreted as bytes.
	 \'fullblock\' wait for ibs bytes from each read. zero-length reads are still considered EOF.

General-Flags
	 \'direct\' use direct I/O for data.
	 \'directory\' fail unless the given input (if used as an iflag) or output (if used as an oflag) is a directory.
	 \'dsync\' use synchronized I/O for data.
	 \'sync\' use synchronized I/O for data and metadata.
	 \'nonblock\' use non-blocking I/O.
	 \'noatime\' do not update access time.
	 \'nocache\' request that OS drop cache.
	 \'noctty\' do not assign a controlling tty.
	 \'nofollow\' do not follow system links.

' -r
complete -c uu-dd -l oflag -d '(alternatively oflag=FLAG[,FLAG]) a comma separated list of output flags which specify how the output source is treated. FLAG may be any of the output-flags or general-flags specified below.

Output-Flags
	 \'append\' open file in append mode. Consider setting conv=notrunc as well.
	 \'seek_bytes\' a value to seek=N will be interpreted as bytes.

General-Flags
	 \'direct\' use direct I/O for data.
	 \'directory\' fail unless the given input (if used as an iflag) or output (if used as an oflag) is a directory.
	 \'dsync\' use synchronized I/O for data.
	 \'sync\' use synchronized I/O for data and metadata.
	 \'nonblock\' use non-blocking I/O.
	 \'noatime\' do not update access time.
	 \'nocache\' request that OS drop cache.
	 \'noctty\' do not assign a controlling tty.
	 \'nofollow\' do not follow system links.

' -r
complete -c uu-dd -s h -l help -d 'Print help information'
complete -c uu-dd -s V -l version -d 'Print version information'
