/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "ipc-service.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Sysprof3.Service
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:IpcService
 * @title: IpcService
 * @short_description: Generated C code for the org.gnome.Sysprof3.Service D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Sysprof3-Service.top_of_page">org.gnome.Sysprof3.Service</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Sysprof3.Service ---- */

static const _ExtendedGDBusArgInfo _ipc_service_method_info_perf_event_open_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_service_method_info_perf_event_open_IN_ARG_pid =
{
  {
    -1,
    (gchar *) "pid",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_service_method_info_perf_event_open_IN_ARG_cpu =
{
  {
    -1,
    (gchar *) "cpu",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_service_method_info_perf_event_open_IN_ARG_group_fd =
{
  {
    -1,
    (gchar *) "group_fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_service_method_info_perf_event_open_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_service_method_info_perf_event_open_IN_ARG_pointers[] =
{
  &_ipc_service_method_info_perf_event_open_IN_ARG_options.parent_struct,
  &_ipc_service_method_info_perf_event_open_IN_ARG_pid.parent_struct,
  &_ipc_service_method_info_perf_event_open_IN_ARG_cpu.parent_struct,
  &_ipc_service_method_info_perf_event_open_IN_ARG_group_fd.parent_struct,
  &_ipc_service_method_info_perf_event_open_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ipc_service_method_info_perf_event_open_OUT_ARG_perf_stream_fd =
{
  {
    -1,
    (gchar *) "perf_stream_fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_service_method_info_perf_event_open_OUT_ARG_pointers[] =
{
  &_ipc_service_method_info_perf_event_open_OUT_ARG_perf_stream_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_service_method_info_perf_event_open =
{
  {
    -1,
    (gchar *) "PerfEventOpen",
    (GDBusArgInfo **) &_ipc_service_method_info_perf_event_open_IN_ARG_pointers,
    (GDBusArgInfo **) &_ipc_service_method_info_perf_event_open_OUT_ARG_pointers,
    NULL
  },
  "handle-perf-event-open",
  TRUE
};

static const _ExtendedGDBusArgInfo _ipc_service_method_info_get_proc_file_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_service_method_info_get_proc_file_IN_ARG_pointers[] =
{
  &_ipc_service_method_info_get_proc_file_IN_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ipc_service_method_info_get_proc_file_OUT_ARG_contents =
{
  {
    -1,
    (gchar *) "contents",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_service_method_info_get_proc_file_OUT_ARG_pointers[] =
{
  &_ipc_service_method_info_get_proc_file_OUT_ARG_contents.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_service_method_info_get_proc_file =
{
  {
    -1,
    (gchar *) "GetProcFile",
    (GDBusArgInfo **) &_ipc_service_method_info_get_proc_file_IN_ARG_pointers,
    (GDBusArgInfo **) &_ipc_service_method_info_get_proc_file_OUT_ARG_pointers,
    NULL
  },
  "handle-get-proc-file",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_service_method_info_get_proc_fd_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_service_method_info_get_proc_fd_IN_ARG_pointers[] =
{
  &_ipc_service_method_info_get_proc_fd_IN_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ipc_service_method_info_get_proc_fd_OUT_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_service_method_info_get_proc_fd_OUT_ARG_pointers[] =
{
  &_ipc_service_method_info_get_proc_fd_OUT_ARG_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_service_method_info_get_proc_fd =
{
  {
    -1,
    (gchar *) "GetProcFd",
    (GDBusArgInfo **) &_ipc_service_method_info_get_proc_fd_IN_ARG_pointers,
    (GDBusArgInfo **) &_ipc_service_method_info_get_proc_fd_OUT_ARG_pointers,
    NULL
  },
  "handle-get-proc-fd",
  TRUE
};

static const _ExtendedGDBusArgInfo _ipc_service_method_info_list_processes_OUT_ARG_processes =
{
  {
    -1,
    (gchar *) "processes",
    (gchar *) "ai",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_service_method_info_list_processes_OUT_ARG_pointers[] =
{
  &_ipc_service_method_info_list_processes_OUT_ARG_processes.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_service_method_info_list_processes =
{
  {
    -1,
    (gchar *) "ListProcesses",
    NULL,
    (GDBusArgInfo **) &_ipc_service_method_info_list_processes_OUT_ARG_pointers,
    NULL
  },
  "handle-list-processes",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_service_method_info_get_process_info_IN_ARG_attributes =
{
  {
    -1,
    (gchar *) "attributes",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_service_method_info_get_process_info_IN_ARG_pointers[] =
{
  &_ipc_service_method_info_get_process_info_IN_ARG_attributes.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ipc_service_method_info_get_process_info_OUT_ARG_processes =
{
  {
    -1,
    (gchar *) "processes",
    (gchar *) "aa{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_service_method_info_get_process_info_OUT_ARG_pointers[] =
{
  &_ipc_service_method_info_get_process_info_OUT_ARG_processes.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_service_method_info_get_process_info =
{
  {
    -1,
    (gchar *) "GetProcessInfo",
    (GDBusArgInfo **) &_ipc_service_method_info_get_process_info_IN_ARG_pointers,
    (GDBusArgInfo **) &_ipc_service_method_info_get_process_info_OUT_ARG_pointers,
    NULL
  },
  "handle-get-process-info",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_service_method_info_set_governor_IN_ARG_governor =
{
  {
    -1,
    (gchar *) "governor",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_service_method_info_set_governor_IN_ARG_pointers[] =
{
  &_ipc_service_method_info_set_governor_IN_ARG_governor.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ipc_service_method_info_set_governor_OUT_ARG_old_governor =
{
  {
    -1,
    (gchar *) "old_governor",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_service_method_info_set_governor_OUT_ARG_pointers[] =
{
  &_ipc_service_method_info_set_governor_OUT_ARG_old_governor.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_service_method_info_set_governor =
{
  {
    -1,
    (gchar *) "SetGovernor",
    (GDBusArgInfo **) &_ipc_service_method_info_set_governor_IN_ARG_pointers,
    (GDBusArgInfo **) &_ipc_service_method_info_set_governor_OUT_ARG_pointers,
    NULL
  },
  "handle-set-governor",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_service_method_info_set_paranoid_IN_ARG_paranoid =
{
  {
    -1,
    (gchar *) "paranoid",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_service_method_info_set_paranoid_IN_ARG_pointers[] =
{
  &_ipc_service_method_info_set_paranoid_IN_ARG_paranoid.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ipc_service_method_info_set_paranoid_OUT_ARG_old_paranoid =
{
  {
    -1,
    (gchar *) "old_paranoid",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_service_method_info_set_paranoid_OUT_ARG_pointers[] =
{
  &_ipc_service_method_info_set_paranoid_OUT_ARG_old_paranoid.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_service_method_info_set_paranoid =
{
  {
    -1,
    (gchar *) "SetParanoid",
    (GDBusArgInfo **) &_ipc_service_method_info_set_paranoid_IN_ARG_pointers,
    (GDBusArgInfo **) &_ipc_service_method_info_set_paranoid_OUT_ARG_pointers,
    NULL
  },
  "handle-set-paranoid",
  FALSE
};

static const GDBusMethodInfo * const _ipc_service_method_info_pointers[] =
{
  &_ipc_service_method_info_perf_event_open.parent_struct,
  &_ipc_service_method_info_get_proc_file.parent_struct,
  &_ipc_service_method_info_get_proc_fd.parent_struct,
  &_ipc_service_method_info_list_processes.parent_struct,
  &_ipc_service_method_info_get_process_info.parent_struct,
  &_ipc_service_method_info_set_governor.parent_struct,
  &_ipc_service_method_info_set_paranoid.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _ipc_service_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Sysprof3.Service",
    (GDBusMethodInfo **) &_ipc_service_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "service",
};


/**
 * ipc_service_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Sysprof3-Service.top_of_page">org.gnome.Sysprof3.Service</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
ipc_service_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_ipc_service_interface_info.parent_struct;
}

/**
 * ipc_service_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #IpcService interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
ipc_service_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * IpcService:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Sysprof3-Service.top_of_page">org.gnome.Sysprof3.Service</link>.
 */

/**
 * IpcServiceIface:
 * @parent_iface: The parent interface.
 * @handle_get_proc_fd: Handler for the #IpcService::handle-get-proc-fd signal.
 * @handle_get_proc_file: Handler for the #IpcService::handle-get-proc-file signal.
 * @handle_get_process_info: Handler for the #IpcService::handle-get-process-info signal.
 * @handle_list_processes: Handler for the #IpcService::handle-list-processes signal.
 * @handle_perf_event_open: Handler for the #IpcService::handle-perf-event-open signal.
 * @handle_set_governor: Handler for the #IpcService::handle-set-governor signal.
 * @handle_set_paranoid: Handler for the #IpcService::handle-set-paranoid signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Sysprof3-Service.top_of_page">org.gnome.Sysprof3.Service</link>.
 */

typedef IpcServiceIface IpcServiceInterface;
G_DEFINE_INTERFACE (IpcService, ipc_service, G_TYPE_OBJECT)

static void
ipc_service_default_init (IpcServiceIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * IpcService::handle-perf-event-open:
   * @object: A #IpcService.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_options: Argument passed by remote caller.
   * @arg_pid: Argument passed by remote caller.
   * @arg_cpu: Argument passed by remote caller.
   * @arg_group_fd: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.PerfEventOpen">PerfEventOpen()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_service_complete_perf_event_open() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-perf-event-open",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcServiceIface, handle_perf_event_open),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    7,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT, G_TYPE_INT, G_TYPE_INT, G_TYPE_VARIANT, G_TYPE_UINT64);

  /**
   * IpcService::handle-get-proc-file:
   * @object: A #IpcService.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_path: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.GetProcFile">GetProcFile()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_service_complete_get_proc_file() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-proc-file",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcServiceIface, handle_get_proc_file),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * IpcService::handle-get-proc-fd:
   * @object: A #IpcService.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_path: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.GetProcFd">GetProcFd()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_service_complete_get_proc_fd() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-proc-fd",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcServiceIface, handle_get_proc_fd),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_STRING);

  /**
   * IpcService::handle-list-processes:
   * @object: A #IpcService.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.ListProcesses">ListProcesses()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_service_complete_list_processes() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list-processes",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcServiceIface, handle_list_processes),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * IpcService::handle-get-process-info:
   * @object: A #IpcService.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_attributes: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.GetProcessInfo">GetProcessInfo()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_service_complete_get_process_info() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-process-info",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcServiceIface, handle_get_process_info),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * IpcService::handle-set-governor:
   * @object: A #IpcService.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_governor: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.SetGovernor">SetGovernor()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_service_complete_set_governor() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-governor",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcServiceIface, handle_set_governor),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * IpcService::handle-set-paranoid:
   * @object: A #IpcService.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_paranoid: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.SetParanoid">SetParanoid()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_service_complete_set_paranoid() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-paranoid",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcServiceIface, handle_set_paranoid),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT);

}

/**
 * ipc_service_call_perf_event_open:
 * @proxy: A #IpcServiceProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_pid: Argument to pass with the method invocation.
 * @arg_cpu: Argument to pass with the method invocation.
 * @arg_group_fd: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.PerfEventOpen">PerfEventOpen()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_service_call_perf_event_open_finish() to get the result of the operation.
 *
 * See ipc_service_call_perf_event_open_sync() for the synchronous, blocking version of this method.
 */
void
ipc_service_call_perf_event_open (
    IpcService *proxy,
    GVariant *arg_options,
    gint arg_pid,
    gint arg_cpu,
    GVariant *arg_group_fd,
    guint64 arg_flags,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "PerfEventOpen",
    g_variant_new ("(@a{sv}ii@ht)",
                   arg_options,
                   arg_pid,
                   arg_cpu,
                   arg_group_fd,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_service_call_perf_event_open_finish:
 * @proxy: A #IpcServiceProxy.
 * @out_perf_stream_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_service_call_perf_event_open().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_service_call_perf_event_open().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_service_call_perf_event_open_finish (
    IpcService *proxy,
    GVariant **out_perf_stream_fd,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_perf_stream_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_service_call_perf_event_open_sync:
 * @proxy: A #IpcServiceProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_pid: Argument to pass with the method invocation.
 * @arg_cpu: Argument to pass with the method invocation.
 * @arg_group_fd: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_perf_stream_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.PerfEventOpen">PerfEventOpen()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_service_call_perf_event_open() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_service_call_perf_event_open_sync (
    IpcService *proxy,
    GVariant *arg_options,
    gint arg_pid,
    gint arg_cpu,
    GVariant *arg_group_fd,
    guint64 arg_flags,
    GUnixFDList  *fd_list,
    GVariant **out_perf_stream_fd,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "PerfEventOpen",
    g_variant_new ("(@a{sv}ii@ht)",
                   arg_options,
                   arg_pid,
                   arg_cpu,
                   arg_group_fd,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_perf_stream_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_service_call_get_proc_file:
 * @proxy: A #IpcServiceProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.GetProcFile">GetProcFile()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_service_call_get_proc_file_finish() to get the result of the operation.
 *
 * See ipc_service_call_get_proc_file_sync() for the synchronous, blocking version of this method.
 */
void
ipc_service_call_get_proc_file (
    IpcService *proxy,
    const gchar *arg_path,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetProcFile",
    g_variant_new ("(^ay)",
                   arg_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_service_call_get_proc_file_finish:
 * @proxy: A #IpcServiceProxy.
 * @out_contents: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_service_call_get_proc_file().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_service_call_get_proc_file().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_service_call_get_proc_file_finish (
    IpcService *proxy,
    gchar **out_contents,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ay)",
                 out_contents);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_service_call_get_proc_file_sync:
 * @proxy: A #IpcServiceProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @out_contents: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.GetProcFile">GetProcFile()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_service_call_get_proc_file() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_service_call_get_proc_file_sync (
    IpcService *proxy,
    const gchar *arg_path,
    gchar **out_contents,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetProcFile",
    g_variant_new ("(^ay)",
                   arg_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ay)",
                 out_contents);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_service_call_get_proc_fd:
 * @proxy: A #IpcServiceProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.GetProcFd">GetProcFd()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_service_call_get_proc_fd_finish() to get the result of the operation.
 *
 * See ipc_service_call_get_proc_fd_sync() for the synchronous, blocking version of this method.
 */
void
ipc_service_call_get_proc_fd (
    IpcService *proxy,
    const gchar *arg_path,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "GetProcFd",
    g_variant_new ("(^ay)",
                   arg_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_service_call_get_proc_fd_finish:
 * @proxy: A #IpcServiceProxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_service_call_get_proc_fd().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_service_call_get_proc_fd().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_service_call_get_proc_fd_finish (
    IpcService *proxy,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_service_call_get_proc_fd_sync:
 * @proxy: A #IpcServiceProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.GetProcFd">GetProcFd()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_service_call_get_proc_fd() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_service_call_get_proc_fd_sync (
    IpcService *proxy,
    const gchar *arg_path,
    GUnixFDList  *fd_list,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "GetProcFd",
    g_variant_new ("(^ay)",
                   arg_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_service_call_list_processes:
 * @proxy: A #IpcServiceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.ListProcesses">ListProcesses()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_service_call_list_processes_finish() to get the result of the operation.
 *
 * See ipc_service_call_list_processes_sync() for the synchronous, blocking version of this method.
 */
void
ipc_service_call_list_processes (
    IpcService *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ListProcesses",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_service_call_list_processes_finish:
 * @proxy: A #IpcServiceProxy.
 * @out_processes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_service_call_list_processes().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_service_call_list_processes().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_service_call_list_processes_finish (
    IpcService *proxy,
    GVariant **out_processes,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@ai)",
                 out_processes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_service_call_list_processes_sync:
 * @proxy: A #IpcServiceProxy.
 * @out_processes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.ListProcesses">ListProcesses()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_service_call_list_processes() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_service_call_list_processes_sync (
    IpcService *proxy,
    GVariant **out_processes,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ListProcesses",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@ai)",
                 out_processes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_service_call_get_process_info:
 * @proxy: A #IpcServiceProxy.
 * @arg_attributes: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.GetProcessInfo">GetProcessInfo()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_service_call_get_process_info_finish() to get the result of the operation.
 *
 * See ipc_service_call_get_process_info_sync() for the synchronous, blocking version of this method.
 */
void
ipc_service_call_get_process_info (
    IpcService *proxy,
    const gchar *arg_attributes,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetProcessInfo",
    g_variant_new ("(s)",
                   arg_attributes),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_service_call_get_process_info_finish:
 * @proxy: A #IpcServiceProxy.
 * @out_processes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_service_call_get_process_info().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_service_call_get_process_info().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_service_call_get_process_info_finish (
    IpcService *proxy,
    GVariant **out_processes,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@aa{sv})",
                 out_processes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_service_call_get_process_info_sync:
 * @proxy: A #IpcServiceProxy.
 * @arg_attributes: Argument to pass with the method invocation.
 * @out_processes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.GetProcessInfo">GetProcessInfo()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_service_call_get_process_info() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_service_call_get_process_info_sync (
    IpcService *proxy,
    const gchar *arg_attributes,
    GVariant **out_processes,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetProcessInfo",
    g_variant_new ("(s)",
                   arg_attributes),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@aa{sv})",
                 out_processes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_service_call_set_governor:
 * @proxy: A #IpcServiceProxy.
 * @arg_governor: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.SetGovernor">SetGovernor()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_service_call_set_governor_finish() to get the result of the operation.
 *
 * See ipc_service_call_set_governor_sync() for the synchronous, blocking version of this method.
 */
void
ipc_service_call_set_governor (
    IpcService *proxy,
    const gchar *arg_governor,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetGovernor",
    g_variant_new ("(s)",
                   arg_governor),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_service_call_set_governor_finish:
 * @proxy: A #IpcServiceProxy.
 * @out_old_governor: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_service_call_set_governor().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_service_call_set_governor().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_service_call_set_governor_finish (
    IpcService *proxy,
    gchar **out_old_governor,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_old_governor);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_service_call_set_governor_sync:
 * @proxy: A #IpcServiceProxy.
 * @arg_governor: Argument to pass with the method invocation.
 * @out_old_governor: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.SetGovernor">SetGovernor()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_service_call_set_governor() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_service_call_set_governor_sync (
    IpcService *proxy,
    const gchar *arg_governor,
    gchar **out_old_governor,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetGovernor",
    g_variant_new ("(s)",
                   arg_governor),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_old_governor);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_service_call_set_paranoid:
 * @proxy: A #IpcServiceProxy.
 * @arg_paranoid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.SetParanoid">SetParanoid()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_service_call_set_paranoid_finish() to get the result of the operation.
 *
 * See ipc_service_call_set_paranoid_sync() for the synchronous, blocking version of this method.
 */
void
ipc_service_call_set_paranoid (
    IpcService *proxy,
    gint arg_paranoid,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetParanoid",
    g_variant_new ("(i)",
                   arg_paranoid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_service_call_set_paranoid_finish:
 * @proxy: A #IpcServiceProxy.
 * @out_old_paranoid: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_service_call_set_paranoid().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_service_call_set_paranoid().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_service_call_set_paranoid_finish (
    IpcService *proxy,
    gint *out_old_paranoid,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_old_paranoid);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_service_call_set_paranoid_sync:
 * @proxy: A #IpcServiceProxy.
 * @arg_paranoid: Argument to pass with the method invocation.
 * @out_old_paranoid: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.SetParanoid">SetParanoid()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_service_call_set_paranoid() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_service_call_set_paranoid_sync (
    IpcService *proxy,
    gint arg_paranoid,
    gint *out_old_paranoid,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetParanoid",
    g_variant_new ("(i)",
                   arg_paranoid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_old_paranoid);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_service_complete_perf_event_open:
 * @object: A #IpcService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @perf_stream_fd: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.PerfEventOpen">PerfEventOpen()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_service_complete_perf_event_open (
    IpcService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *perf_stream_fd)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@h)",
                   perf_stream_fd),
    fd_list);
}

/**
 * ipc_service_complete_get_proc_file:
 * @object: A #IpcService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @contents: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.GetProcFile">GetProcFile()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_service_complete_get_proc_file (
    IpcService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *contents)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ay)",
                   contents));
}

/**
 * ipc_service_complete_get_proc_fd:
 * @object: A #IpcService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @fd: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.GetProcFd">GetProcFd()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_service_complete_get_proc_fd (
    IpcService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *fd)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@h)",
                   fd),
    fd_list);
}

/**
 * ipc_service_complete_list_processes:
 * @object: A #IpcService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @processes: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.ListProcesses">ListProcesses()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_service_complete_list_processes (
    IpcService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *processes)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@ai)",
                   processes));
}

/**
 * ipc_service_complete_get_process_info:
 * @object: A #IpcService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @processes: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.GetProcessInfo">GetProcessInfo()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_service_complete_get_process_info (
    IpcService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *processes)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@aa{sv})",
                   processes));
}

/**
 * ipc_service_complete_set_governor:
 * @object: A #IpcService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @old_governor: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.SetGovernor">SetGovernor()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_service_complete_set_governor (
    IpcService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *old_governor)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   old_governor));
}

/**
 * ipc_service_complete_set_paranoid:
 * @object: A #IpcService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @old_paranoid: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Sysprof3-Service.SetParanoid">SetParanoid()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_service_complete_set_paranoid (
    IpcService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint old_paranoid)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i)",
                   old_paranoid));
}

/* ------------------------------------------------------------------------ */

/**
 * IpcServiceProxy:
 *
 * The #IpcServiceProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * IpcServiceProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #IpcServiceProxy.
 */

struct _IpcServiceProxyPrivate
{
  GData *qdata;
};

static void ipc_service_proxy_iface_init (IpcServiceIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (IpcServiceProxy, ipc_service_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (IpcServiceProxy)
                         G_IMPLEMENT_INTERFACE (IPC_TYPE_SERVICE, ipc_service_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (IpcServiceProxy, ipc_service_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (IPC_TYPE_SERVICE, ipc_service_proxy_iface_init))

#endif
static void
ipc_service_proxy_finalize (GObject *object)
{
  IpcServiceProxy *proxy = IPC_SERVICE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (ipc_service_proxy_parent_class)->finalize (object);
}

static void
ipc_service_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
ipc_service_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
ipc_service_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_ipc_service_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], IPC_TYPE_SERVICE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, IPC_TYPE_SERVICE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
ipc_service_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  IpcServiceProxy *proxy = IPC_SERVICE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ipc_service_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ipc_service_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
ipc_service_proxy_init (IpcServiceProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = ipc_service_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, IPC_TYPE_SERVICE_PROXY, IpcServiceProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), ipc_service_interface_info ());
}

static void
ipc_service_proxy_class_init (IpcServiceProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = ipc_service_proxy_finalize;
  gobject_class->get_property = ipc_service_proxy_get_property;
  gobject_class->set_property = ipc_service_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = ipc_service_proxy_g_signal;
  proxy_class->g_properties_changed = ipc_service_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (IpcServiceProxyPrivate));
#endif
}

static void
ipc_service_proxy_iface_init (IpcServiceIface *iface G_GNUC_UNUSED)
{
}

/**
 * ipc_service_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Sysprof3-Service.top_of_page">org.gnome.Sysprof3.Service</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_service_proxy_new_finish() to get the result of the operation.
 *
 * See ipc_service_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
ipc_service_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (IPC_TYPE_SERVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Sysprof3.Service", NULL);
}

/**
 * ipc_service_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_service_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ipc_service_proxy_new().
 *
 * Returns: (transfer full) (type IpcServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
IpcService *
ipc_service_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return IPC_SERVICE (ret);
  else
    return NULL;
}

/**
 * ipc_service_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Sysprof3-Service.top_of_page">org.gnome.Sysprof3.Service</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ipc_service_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type IpcServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
IpcService *
ipc_service_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (IPC_TYPE_SERVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Sysprof3.Service", NULL);
  if (ret != NULL)
    return IPC_SERVICE (ret);
  else
    return NULL;
}


/**
 * ipc_service_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like ipc_service_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_service_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See ipc_service_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
ipc_service_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (IPC_TYPE_SERVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Sysprof3.Service", NULL);
}

/**
 * ipc_service_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_service_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ipc_service_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type IpcServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
IpcService *
ipc_service_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return IPC_SERVICE (ret);
  else
    return NULL;
}

/**
 * ipc_service_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like ipc_service_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ipc_service_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type IpcServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
IpcService *
ipc_service_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (IPC_TYPE_SERVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Sysprof3.Service", NULL);
  if (ret != NULL)
    return IPC_SERVICE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * IpcServiceSkeleton:
 *
 * The #IpcServiceSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * IpcServiceSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #IpcServiceSkeleton.
 */

struct _IpcServiceSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_ipc_service_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  IpcServiceSkeleton *skeleton = IPC_SERVICE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], IPC_TYPE_SERVICE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, IPC_TYPE_SERVICE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_ipc_service_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  IpcServiceSkeleton *skeleton = IPC_SERVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ipc_service_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_ipc_service_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  IpcServiceSkeleton *skeleton = IPC_SERVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ipc_service_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _ipc_service_skeleton_vtable =
{
  _ipc_service_skeleton_handle_method_call,
  _ipc_service_skeleton_handle_get_property,
  _ipc_service_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
ipc_service_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return ipc_service_interface_info ();
}

static GDBusInterfaceVTable *
ipc_service_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_ipc_service_skeleton_vtable;
}

static GVariant *
ipc_service_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  IpcServiceSkeleton *skeleton = IPC_SERVICE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_ipc_service_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _ipc_service_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _ipc_service_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _ipc_service_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Sysprof3.Service", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
ipc_service_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void ipc_service_skeleton_iface_init (IpcServiceIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (IpcServiceSkeleton, ipc_service_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (IpcServiceSkeleton)
                         G_IMPLEMENT_INTERFACE (IPC_TYPE_SERVICE, ipc_service_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (IpcServiceSkeleton, ipc_service_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (IPC_TYPE_SERVICE, ipc_service_skeleton_iface_init))

#endif
static void
ipc_service_skeleton_finalize (GObject *object)
{
  IpcServiceSkeleton *skeleton = IPC_SERVICE_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (ipc_service_skeleton_parent_class)->finalize (object);
}

static void
ipc_service_skeleton_init (IpcServiceSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = ipc_service_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, IPC_TYPE_SERVICE_SKELETON, IpcServiceSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
ipc_service_skeleton_class_init (IpcServiceSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = ipc_service_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = ipc_service_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = ipc_service_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = ipc_service_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = ipc_service_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (IpcServiceSkeletonPrivate));
#endif
}

static void
ipc_service_skeleton_iface_init (IpcServiceIface *iface G_GNUC_UNUSED)
{
}

/**
 * ipc_service_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Sysprof3-Service.top_of_page">org.gnome.Sysprof3.Service</link>.
 *
 * Returns: (transfer full) (type IpcServiceSkeleton): The skeleton object.
 */
IpcService *
ipc_service_skeleton_new (void)
{
  return IPC_SERVICE (g_object_new (IPC_TYPE_SERVICE_SKELETON, NULL));
}

