/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.SecureRandom;
import java.util.Map;
import org.bouncycastle.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.BN;
import org.jruby.ext.openssl.Cipher;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.ExtConfig;
import org.jruby.ext.openssl.HMAC;
import org.jruby.ext.openssl.KDF;
import org.jruby.ext.openssl.NetscapeSPKI;
import org.jruby.ext.openssl.OCSP;
import org.jruby.ext.openssl.PKCS5;
import org.jruby.ext.openssl.PKCS7;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.Random;
import org.jruby.ext.openssl.SSL;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.StringHelper;
import org.jruby.ext.openssl.X509;
import org.jruby.ext.openssl.util.CryptoSecurity;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.SafePropertyAccessor;

@JRubyModule(name={"OpenSSL"})
public final class OpenSSL {
    private static boolean debug;
    private static boolean warn;
    private static boolean tryContextSecureRandom;

    public static void load(Ruby runtime) {
        OpenSSL.createOpenSSL(runtime);
    }

    public static boolean isProviderAvailable() {
        return SecurityHelper.isProviderAvailable("BC");
    }

    public static void createOpenSSL(Ruby runtime) {
        SecurityHelper.setRegisterProvider(SafePropertyAccessor.getBoolean((String)"jruby.openssl.provider.register"));
        RubyModule _OpenSSL = runtime.getOrCreateModule("OpenSSL");
        RubyClass StandardError = runtime.getStandardError();
        RubyClass OpenSSLError = _OpenSSL.defineClassUnder("OpenSSLError", StandardError, StandardError.getAllocator());
        _OpenSSL.defineAnnotatedMethods(OpenSSL.class);
        OpenSSL.setDebug((IRubyObject)_OpenSSL, (IRubyObject)runtime.newBoolean(SafePropertyAccessor.getBoolean((String)"jruby.openssl.debug")));
        String warn = SafePropertyAccessor.getProperty((String)"jruby.openssl.warn");
        OpenSSL.warn = warn != null ? Boolean.parseBoolean(warn) : runtime.warningsEnabled();
        ExtConfig.create(runtime, _OpenSSL);
        PKey.createPKey(runtime, _OpenSSL, OpenSSLError);
        BN.createBN(runtime, _OpenSSL, OpenSSLError);
        Digest.createDigest(runtime, _OpenSSL, OpenSSLError);
        Cipher.createCipher(runtime, _OpenSSL, OpenSSLError);
        Random.createRandom(runtime, _OpenSSL, OpenSSLError);
        HMAC.createHMAC(runtime, _OpenSSL, OpenSSLError);
        ASN1.createASN1(runtime, _OpenSSL, OpenSSLError);
        X509.createX509(runtime, _OpenSSL, OpenSSLError);
        NetscapeSPKI.createNetscapeSPKI(runtime, _OpenSSL, OpenSSLError);
        SSL.createSSL(runtime, _OpenSSL, OpenSSLError);
        PKCS7.createPKCS7(runtime, _OpenSSL, OpenSSLError);
        PKCS5.createPKCS5(runtime, _OpenSSL);
        OCSP.createOCSP(runtime, _OpenSSL, OpenSSLError);
        KDF.createKDF(runtime, _OpenSSL, OpenSSLError);
        runtime.getLoadService().require("jopenssl/version");
        byte[] version2 = new byte[]{50, 46, 50, 46, 49};
        _OpenSSL.setConstant("VERSION", (IRubyObject)StringHelper.newString(runtime, version2));
        RubyModule JOpenSSL = runtime.getModule("JOpenSSL");
        RubyString jVERSION = JOpenSSL.getConstantAt("VERSION").asString();
        byte[] JRuby_OpenSSL_ = new byte[]{74, 82, 117, 98, 121, 45, 79, 112, 101, 110, 83, 83, 76, 32};
        int OPENSSL_VERSION_NUMBER = 999999999;
        ByteList OPENSSL_VERSION = new ByteList(jVERSION.getByteList().getRealSize() + JRuby_OpenSSL_.length);
        OPENSSL_VERSION.setEncoding(jVERSION.getEncoding());
        OPENSSL_VERSION.append(JRuby_OpenSSL_);
        OPENSSL_VERSION.append(jVERSION.getByteList());
        RubyString VERSION = runtime.newString(OPENSSL_VERSION);
        _OpenSSL.setConstant("OPENSSL_VERSION", (IRubyObject)VERSION);
        _OpenSSL.setConstant("OPENSSL_VERSION_NUMBER", (IRubyObject)runtime.newFixnum(999999999));
        _OpenSSL.setConstant("OPENSSL_LIBRARY_VERSION", (IRubyObject)VERSION);
        _OpenSSL.setConstant("OPENSSL_FIPS", (IRubyObject)runtime.getFalse());
    }

    static RubyClass _OpenSSLError(Ruby runtime) {
        return (RubyClass)runtime.getModule("OpenSSL").getConstantAt("OpenSSLError");
    }

    @JRubyMethod(name={"errors"}, meta=true)
    public static IRubyObject errors(IRubyObject self) {
        Ruby runtime = self.getRuntime();
        RubyArray result = runtime.newArray();
        for (Map.Entry<Integer, String> e : X509.getErrors().entrySet()) {
            result.add((Object)runtime.newString(e.getValue()));
        }
        return result;
    }

    @JRubyMethod(name={"debug"}, meta=true)
    public static IRubyObject getDebug(IRubyObject self) {
        return (IRubyObject)OpenSSL.getDebug((RubyModule)self);
    }

    private static Object getDebug(RubyModule self) {
        return self.getInternalVariable("debug");
    }

    @JRubyMethod(name={"debug="}, meta=true)
    public static IRubyObject setDebug(IRubyObject self, IRubyObject debug) {
        ((RubyModule)self).setInternalVariable("debug", (Object)debug);
        OpenSSL.debug = debug.isTrue();
        return debug;
    }

    @JRubyMethod(name={"Digest"}, meta=true)
    public static IRubyObject Digest(IRubyObject self, IRubyObject name2) {
        Ruby runtime = self.getRuntime();
        RubyClass Digest2 = runtime.getModule("OpenSSL").getClass("Digest");
        return Digest2.getConstantAt(name2.asJavaString());
    }

    @JRubyMethod(meta=true)
    public static IRubyObject fixed_length_secure_compare(ThreadContext context2, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
        ByteList str1 = arg1.convertToString().getByteList();
        ByteList str2 = arg2.convertToString().getByteList();
        if (str1.length() != str2.length()) {
            throw context2.runtime.newArgumentError("inputs must be of equal length");
        }
        return context2.runtime.newBoolean(Arrays.constantTimeAreEqual((int)str1.length(), (byte[])str1.unsafeBytes(), (int)str1.begin(), (byte[])str2.unsafeBytes(), (int)str2.begin()));
    }

    @JRubyMethod(meta=true)
    public static IRubyObject deprecated_warning_flag(IRubyObject self) {
        return self.getRuntime().getNil();
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject check_func(IRubyObject self, IRubyObject[] args) {
        return self.getRuntime().getNil();
    }

    @JRubyMethod(name={"fips_mode"}, meta=true)
    public static IRubyObject get_fips_mode(ThreadContext context2, IRubyObject self) {
        OpenSSL.warn(context2, "FIPS mode not implemented on JRuby-OpenSSL");
        return context2.nil;
    }

    @JRubyMethod(name={"fips_mode="}, meta=true)
    public static IRubyObject set_fips_mode(ThreadContext context2, IRubyObject self, IRubyObject value2) {
        if (value2.isTrue()) {
            OpenSSL.warn(context2, "FIPS mode not implemented on JRuby-OpenSSL");
        }
        return value2;
    }

    @JRubyMethod(name={"_disable_security_restrictions!"}, visibility=Visibility.PRIVATE, meta=true)
    public static IRubyObject _disable_security_restrictions(ThreadContext context2, IRubyObject self) {
        Boolean unrestrict = CryptoSecurity.unrestrictSecurity();
        Boolean allPerm = CryptoSecurity.setAllPermissionPolicy();
        if (unrestrict == null || allPerm == null) {
            return context2.nil;
        }
        return context2.runtime.newBoolean(unrestrict != false && allPerm != false);
    }

    static boolean isDebug() {
        return debug;
    }

    public static void debugStackTrace(Throwable e) {
        if (OpenSSL.isDebug()) {
            e.printStackTrace(System.out);
        }
    }

    public static void debug(String msg) {
        if (OpenSSL.isDebug()) {
            System.out.println(msg);
        }
    }

    public static void debug(String msg, Throwable e) {
        if (OpenSSL.isDebug()) {
            System.out.println(msg + ' ' + e);
        }
    }

    static boolean isDebug(Ruby runtime) {
        RubyModule OpenSSL2 = runtime.getModule("OpenSSL");
        if (OpenSSL2 == null) {
            return debug;
        }
        return OpenSSL.getDebug(OpenSSL2) == runtime.getTrue();
    }

    static void debugStackTrace(Ruby runtime, Throwable e) {
        if (OpenSSL.isDebug(runtime)) {
            e.printStackTrace(runtime.getOut());
        }
    }

    public static void debug(Ruby runtime, CharSequence msg) {
        if (OpenSSL.isDebug(runtime)) {
            runtime.getOut().println(msg.toString());
        }
    }

    public static void debug(Ruby runtime, CharSequence msg, Throwable e) {
        if (OpenSSL.isDebug(runtime)) {
            runtime.getOut().println(msg.toString() + ' ' + e);
        }
    }

    static void warn(ThreadContext context2, CharSequence msg) {
        if (warn) {
            OpenSSL.warn(context2, RubyString.newString((Ruby)context2.runtime, (CharSequence)msg));
        }
    }

    static void warn(ThreadContext context2, RubyString msg) {
        OpenSSL.warn(context2, (IRubyObject)msg);
    }

    static void warn(ThreadContext context2, IRubyObject msg) {
        if (warn) {
            context2.runtime.getModule("OpenSSL").callMethod(context2, "warn", msg);
        }
    }

    private static String javaVersion(String def, int len) {
        String javaVersion = SafePropertyAccessor.getProperty((String)"java.version", (String)def);
        if ("0".equals(javaVersion)) {
            javaVersion = "1.7.0";
        }
        return javaVersion.length() > len && len > -1 ? javaVersion.substring(0, len) : javaVersion;
    }

    static boolean javaVersion7(boolean atLeast) {
        int gt = "1.7".compareTo(OpenSSL.javaVersion("0.0", 3));
        return atLeast ? gt <= 0 : gt == 0;
    }

    static boolean javaVersion8(boolean atLeast) {
        int gt = "1.8".compareTo(OpenSSL.javaVersion("0.0", 3));
        return atLeast ? gt <= 0 : gt == 0;
    }

    public static boolean javaVersion9(boolean atLeast) {
        int major = OpenSSL.parseIntDot(OpenSSL.javaVersion("0", -1));
        return atLeast ? major >= 9 : major == 9;
    }

    static boolean javaVersion10(boolean atLeast) {
        int major = OpenSSL.parseIntDot(OpenSSL.javaVersion("0", -1));
        return atLeast ? major >= 10 : major == 10;
    }

    private static int parseIntDot(String version2) {
        String[] parts = version2.split("[-_]")[0].split("\\.");
        try {
            return Integer.parseInt(parts[0]);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    private static String javaName(String def) {
        return SafePropertyAccessor.getProperty((String)"java.vm.name", (String)def);
    }

    public static boolean javaHotSpot() {
        return OpenSSL.javaName("").contains("HotSpot(TM)");
    }

    public static boolean javaOpenJDK() {
        return OpenSSL.javaName("").contains("OpenJDK");
    }

    static SecureRandom getSecureRandom(Ruby runtime) {
        return OpenSSL.getSecureRandom(runtime, false);
    }

    static SecureRandom getSecureRandom(Ruby runtime, boolean nullByDefault) {
        SecureRandom random;
        if (tryContextSecureRandom && (random = OpenSSL.getSecureRandomFrom(runtime.getCurrentContext())) != null) {
            return random;
        }
        return nullByDefault ? null : new SecureRandom();
    }

    static SecureRandom getSecureRandom(ThreadContext context2) {
        SecureRandom random;
        if (tryContextSecureRandom && (random = OpenSSL.getSecureRandomFrom(context2)) != null) {
            return random;
        }
        return new SecureRandom();
    }

    private static SecureRandom getSecureRandomFrom(ThreadContext context2) {
        try {
            return context2.getSecureRandom();
        }
        catch (Throwable ex) {
            tryContextSecureRandom = false;
            OpenSSL.debug(context2.runtime, "JRuby-OpenSSL failed to retrieve secure random from thread-context", ex);
            return null;
        }
    }

    static IRubyObject to_der_if_possible(ThreadContext context2, IRubyObject obj) {
        if (obj instanceof RubyString || obj instanceof RubyIO) {
            return obj;
        }
        if (!obj.respondsTo("to_der")) {
            return obj;
        }
        return obj.callMethod(context2, "to_der");
    }

    static String bcExceptionMessage(Throwable ex) {
        return "You need to configure JVM/classpath to enable BouncyCastle Security Provider: " + ex;
    }

    static {
        warn = true;
        tryContextSecureRandom = true;
    }
}

