<?php
// This file is automatically generated using maintenance/generateConfigSchema.php.
// phpcs:disable Generic.Files.LineLength
return [
	'config-schema' => [
		'ConfigRegistry' => [
			'default' => [
				'main' => 'GlobalVarConfig::newInstance',
			],
			'type' => 'object',
		],
		'Sitename' => [
			'default' => 'MediaWiki',
		],
		'Server' => [
			'default' => false,
		],
		'CanonicalServer' => [
			'default' => false,
		],
		'ServerName' => [
			'default' => false,
		],
		'AssumeProxiesUseDefaultProtocolPorts' => [
			'default' => true,
			'type' => 'boolean',
		],
		'HttpsPort' => [
			'default' => 443,
		],
		'ForceHTTPS' => [
			'default' => false,
			'type' => 'boolean',
		],
		'ScriptPath' => [
			'default' => '/wiki',
		],
		'UsePathInfo' => [
			'default' => true,
		],
		'Script' => [
			'default' => false,
		],
		'LoadScript' => [
			'default' => false,
		],
		'RestPath' => [
			'default' => false,
		],
		'StylePath' => [
			'default' => false,
		],
		'LocalStylePath' => [
			'default' => false,
		],
		'ExtensionAssetsPath' => [
			'default' => false,
		],
		'ExtensionDirectory' => [
			'default' => null,
			'type' => [
				0 => 'null',
				1 => 'string',
			],
		],
		'StyleDirectory' => [
			'default' => null,
			'type' => [
				0 => 'null',
				1 => 'string',
			],
		],
		'BaseDirectory' => [
			'default' => null,
		],
		'ArticlePath' => [
			'default' => false,
		],
		'UploadPath' => [
			'default' => false,
		],
		'ImgAuthPath' => [
			'default' => false,
		],
		'ThumbPath' => [
			'default' => false,
		],
		'UploadDirectory' => [
			'default' => false,
		],
		'FileCacheDirectory' => [
			'default' => false,
		],
		'Logo' => [
			'default' => false,
		],
		'Logos' => [
			'default' => false,
			'type' => [
				0 => 'object',
				1 => 'boolean',
			],
		],
		'LogoHD' => [
			'default' => false,
			'type' => [
				0 => 'object',
				1 => 'boolean',
			],
		],
		'Favicon' => [
			'default' => '/favicon.ico',
		],
		'AppleTouchIcon' => [
			'default' => false,
		],
		'ReferrerPolicy' => [
			'default' => false,
			'type' => [
				0 => 'array',
				1 => 'string',
				2 => 'boolean',
			],
		],
		'TmpDirectory' => [
			'default' => false,
		],
		'UploadBaseUrl' => [
			'default' => '',
		],
		'UploadStashScalerBaseUrl' => [
			'default' => false,
		],
		'ActionPaths' => [
			'default' => [
			],
			'type' => 'object',
		],
		'MainPageIsDomainRoot' => [
			'default' => false,
			'type' => 'boolean',
		],
		'EnableUploads' => [
			'default' => false,
		],
		'UploadStashMaxAge' => [
			'default' => 21600,
		],
		'EnableAsyncUploads' => [
			'default' => false,
		],
		'UploadMaintenance' => [
			'default' => false,
		],
		'IllegalFileChars' => [
			'default' => ':\\/\\\\',
		],
		'DeletedDirectory' => [
			'default' => false,
		],
		'ImgAuthDetails' => [
			'default' => false,
		],
		'ImgAuthUrlPathMap' => [
			'default' => [
			],
			'type' => 'object',
		],
		'LocalFileRepo' => [
			'default' => false,
			'type' => [
				0 => 'object',
				1 => 'boolean',
			],
		],
		'ForeignFileRepos' => [
			'default' => [
			],
			'type' => 'array',
		],
		'UseInstantCommons' => [
			'default' => false,
		],
		'UseSharedUploads' => [
			'default' => false,
			'type' => 'boolean',
		],
		'SharedUploadDirectory' => [
			'default' => null,
			'type' => [
				0 => 'string',
				1 => 'null',
			],
		],
		'SharedUploadPath' => [
			'default' => null,
			'type' => [
				0 => 'string',
				1 => 'null',
			],
		],
		'HashedSharedUploadDirectory' => [
			'default' => true,
			'type' => 'boolean',
		],
		'RepositoryBaseUrl' => [
			'default' => 'https://commons.wikimedia.org/wiki/File:',
		],
		'FetchCommonsDescriptions' => [
			'default' => false,
			'type' => 'boolean',
		],
		'SharedUploadDBname' => [
			'default' => false,
			'type' => [
				0 => 'boolean',
				1 => 'string',
			],
		],
		'SharedUploadDBprefix' => [
			'default' => '',
			'type' => 'string',
		],
		'CacheSharedUploads' => [
			'default' => true,
			'type' => 'boolean',
		],
		'ForeignUploadTargets' => [
			'default' => [
				0 => 'local',
			],
			'type' => 'array',
		],
		'UploadDialog' => [
			'default' => [
				'fields' => [
					'description' => true,
					'date' => false,
					'categories' => false,
				],
				'licensemessages' => [
					'local' => 'generic-local',
					'foreign' => 'generic-foreign',
				],
				'comment' => [
					'local' => '',
					'foreign' => '',
				],
				'format' => [
					'filepage' => '$DESCRIPTION',
					'description' => '$TEXT',
					'ownwork' => '',
					'license' => '',
					'uncategorized' => '',
				],
			],
			'type' => 'object',
		],
		'FileBackends' => [
			'default' => [
			],
			'type' => 'object',
		],
		'LockManagers' => [
			'default' => [
			],
			'type' => 'array',
		],
		'ShowEXIF' => [
			'default' => true,
		],
		'UpdateCompatibleMetadata' => [
			'default' => false,
		],
		'AllowCopyUploads' => [
			'default' => false,
		],
		'CopyUploadsDomains' => [
			'default' => [
			],
			'type' => 'array',
		],
		'CopyUploadsFromSpecialUpload' => [
			'default' => false,
		],
		'CopyUploadProxy' => [
			'default' => false,
		],
		'CopyUploadTimeout' => [
			'default' => false,
			'type' => [
				0 => 'integer',
				1 => 'boolean',
			],
		],
		'MaxUploadSize' => [
			'default' => 104857600,
		],
		'MinUploadChunkSize' => [
			'default' => 1024,
		],
		'UploadNavigationUrl' => [
			'default' => false,
		],
		'UploadMissingFileUrl' => [
			'default' => false,
		],
		'ThumbnailScriptPath' => [
			'default' => false,
		],
		'SharedThumbnailScriptPath' => [
			'default' => false,
			'type' => [
				0 => 'string',
				1 => 'boolean',
			],
		],
		'HashedUploadDirectory' => [
			'default' => true,
			'type' => 'boolean',
		],
		'FileExtensions' => [
			'default' => [
				0 => 'png',
				1 => 'gif',
				2 => 'jpg',
				3 => 'jpeg',
				4 => 'webp',
			],
			'type' => 'array',
		],
		'ProhibitedFileExtensions' => [
			'default' => [
				0 => 'html',
				1 => 'htm',
				2 => 'js',
				3 => 'jsb',
				4 => 'mhtml',
				5 => 'mht',
				6 => 'xhtml',
				7 => 'xht',
				8 => 'php',
				9 => 'phtml',
				10 => 'php3',
				11 => 'php4',
				12 => 'php5',
				13 => 'phps',
				14 => 'phar',
				15 => 'shtml',
				16 => 'jhtml',
				17 => 'pl',
				18 => 'py',
				19 => 'cgi',
				20 => 'exe',
				21 => 'scr',
				22 => 'dll',
				23 => 'msi',
				24 => 'vbs',
				25 => 'bat',
				26 => 'com',
				27 => 'pif',
				28 => 'cmd',
				29 => 'vxd',
				30 => 'cpl',
			],
			'type' => 'array',
		],
		'MimeTypeExclusions' => [
			'default' => [
				0 => 'text/html',
				1 => 'application/javascript',
				2 => 'text/javascript',
				3 => 'text/x-javascript',
				4 => 'application/x-shellscript',
				5 => 'application/x-php',
				6 => 'text/x-php',
				7 => 'text/x-python',
				8 => 'text/x-perl',
				9 => 'text/x-bash',
				10 => 'text/x-sh',
				11 => 'text/x-csh',
				12 => 'text/scriptlet',
				13 => 'application/x-msdownload',
				14 => 'application/x-msmetafile',
			],
			'type' => 'array',
		],
		'AllowJavaUploads' => [
			'default' => false,
		],
		'CheckFileExtensions' => [
			'default' => true,
		],
		'StrictFileExtensions' => [
			'default' => true,
		],
		'DisableUploadScriptChecks' => [
			'default' => false,
		],
		'UploadSizeWarning' => [
			'default' => false,
		],
		'TrustedMediaFormats' => [
			'default' => [
				0 => 'BITMAP',
				1 => 'AUDIO',
				2 => 'VIDEO',
				3 => 'image/svg+xml',
				4 => 'application/pdf',
			],
			'type' => 'array',
		],
		'MediaHandlers' => [
			'default' => [
			],
			'type' => 'object',
		],
		'NativeImageLazyLoading' => [
			'default' => false,
			'type' => 'boolean',
		],
		'ParserTestMediaHandlers' => [
			'default' => [
				'image/jpeg' => 'MockBitmapHandler',
				'image/png' => 'MockBitmapHandler',
				'image/gif' => 'MockBitmapHandler',
				'image/tiff' => 'MockBitmapHandler',
				'image/webp' => 'MockBitmapHandler',
				'image/x-ms-bmp' => 'MockBitmapHandler',
				'image/x-bmp' => 'MockBitmapHandler',
				'image/x-xcf' => 'MockBitmapHandler',
				'image/svg+xml' => 'MockSvgHandler',
				'image/vnd.djvu' => 'MockDjVuHandler',
			],
			'type' => 'object',
		],
		'UseImageResize' => [
			'default' => true,
		],
		'UseImageMagick' => [
			'default' => false,
		],
		'ImageMagickConvertCommand' => [
			'default' => '/usr/bin/convert',
		],
		'MaxInterlacingAreas' => [
			'default' => [
			],
			'type' => 'object',
		],
		'SharpenParameter' => [
			'default' => '0x0.4',
		],
		'SharpenReductionThreshold' => [
			'default' => 0.85,
		],
		'ImageMagickTempDir' => [
			'default' => false,
		],
		'CustomConvertCommand' => [
			'default' => false,
		],
		'JpegTran' => [
			'default' => '/usr/bin/jpegtran',
		],
		'JpegPixelFormat' => [
			'default' => 'yuv420',
		],
		'JpegQuality' => [
			'default' => 80,
		],
		'Exiv2Command' => [
			'default' => '/usr/bin/exiv2',
		],
		'Exiftool' => [
			'default' => '/usr/bin/exiftool',
		],
		'SVGConverters' => [
			'default' => [
				'ImageMagick' => '$path/convert -background "#ffffff00" -thumbnail $widthx$height\\! $input PNG:$output',
				'sodipodi' => '$path/sodipodi -z -w $width -f $input -e $output',
				'inkscape' => '$path/inkscape -z -w $width -f $input -e $output',
				'batik' => 'java -Djava.awt.headless=true -jar $path/batik-rasterizer.jar -w $width -d $output $input',
				'rsvg' => '$path/rsvg-convert -w $width -h $height -o $output $input',
				'imgserv' => '$path/imgserv-wrapper -i svg -o png -w$width $input $output',
				'ImagickExt' => [
					0 => 'SvgHandler::rasterizeImagickExt',
				],
			],
			'type' => 'object',
		],
		'SVGConverter' => [
			'default' => 'ImageMagick',
		],
		'SVGConverterPath' => [
			'default' => '',
		],
		'SVGMaxSize' => [
			'default' => 5120,
		],
		'SVGMetadataCutoff' => [
			'default' => 262144,
		],
		'MediaInTargetLanguage' => [
			'default' => true,
		],
		'MaxImageArea' => [
			'default' => 12500000,
			'type' => [
				0 => 'string',
				1 => 'integer',
				2 => 'boolean',
			],
		],
		'MaxAnimatedGifArea' => [
			'default' => 12500000,
		],
		'TiffThumbnailType' => [
			'default' => [
			],
			'type' => 'array',
			'mergeStrategy' => 'replace',
		],
		'ThumbnailEpoch' => [
			'default' => '20030516000000',
		],
		'AttemptFailureEpoch' => [
			'default' => 1,
		],
		'IgnoreImageErrors' => [
			'default' => false,
		],
		'GenerateThumbnailOnParse' => [
			'default' => true,
			'type' => 'boolean',
		],
		'ShowArchiveThumbnails' => [
			'default' => true,
		],
		'EnableAutoRotation' => [
			'default' => null,
			'type' => [
				0 => 'null',
				1 => 'boolean',
			],
		],
		'Antivirus' => [
			'default' => null,
			'type' => [
				0 => 'null',
				1 => 'string',
			],
		],
		'AntivirusSetup' => [
			'default' => [
				'clamav' => [
					'command' => 'clamscan --no-summary ',
					'codemap' => [
						0 => 0,
						1 => 1,
						52 => -1,
						'*' => false,
					],
					'messagepattern' => '/.*?:(.*)/sim',
				],
			],
			'type' => 'object',
		],
		'AntivirusRequired' => [
			'default' => true,
		],
		'VerifyMimeType' => [
			'default' => true,
		],
		'VerifyMimeTypeIE' => [
			'default' => true,
		],
		'MimeTypeFile' => [
			'default' => 'internal',
		],
		'MimeInfoFile' => [
			'default' => 'internal',
		],
		'MimeDetectorCommand' => [
			'default' => null,
			'type' => [
				0 => 'null',
				1 => 'string',
			],
		],
		'TrivialMimeDetection' => [
			'default' => false,
		],
		'XMLMimeTypes' => [
			'default' => [
				'http://www.w3.org/2000/svg:svg' => 'image/svg+xml',
				'svg' => 'image/svg+xml',
				'http://www.lysator.liu.se/~alla/dia/:diagram' => 'application/x-dia-diagram',
				'http://www.w3.org/1999/xhtml:html' => 'text/html',
				'html' => 'text/html',
			],
			'type' => 'object',
		],
		'ImageLimits' => [
			'default' => [
				0 => [
					0 => 320,
					1 => 240,
				],
				1 => [
					0 => 640,
					1 => 480,
				],
				2 => [
					0 => 800,
					1 => 600,
				],
				3 => [
					0 => 1024,
					1 => 768,
				],
				4 => [
					0 => 1280,
					1 => 1024,
				],
				5 => [
					0 => 2560,
					1 => 2048,
				],
			],
			'type' => 'array',
		],
		'ThumbLimits' => [
			'default' => [
				0 => 120,
				1 => 150,
				2 => 180,
				3 => 200,
				4 => 250,
				5 => 300,
			],
			'type' => 'array',
		],
		'ThumbnailBuckets' => [
			'default' => null,
			'type' => [
				0 => 'null',
				1 => 'array',
			],
		],
		'ThumbnailMinimumBucketDistance' => [
			'default' => 50,
		],
		'UploadThumbnailRenderMap' => [
			'default' => [
			],
			'type' => 'object',
		],
		'UploadThumbnailRenderMethod' => [
			'default' => 'jobqueue',
		],
		'UploadThumbnailRenderHttpCustomHost' => [
			'default' => false,
		],
		'UploadThumbnailRenderHttpCustomDomain' => [
			'default' => false,
		],
		'UseTinyRGBForJPGThumbnails' => [
			'default' => false,
		],
		'GalleryOptions' => [
			'default' => [
			],
			'type' => 'object',
		],
		'ThumbUpright' => [
			'default' => 0.75,
		],
		'DirectoryMode' => [
			'default' => 511,
		],
		'ResponsiveImages' => [
			'default' => true,
		],
		'ImagePreconnect' => [
			'default' => false,
		],
		'DjvuDump' => [
			'default' => null,
			'type' => [
				0 => 'null',
				1 => 'string',
			],
		],
		'DjvuRenderer' => [
			'default' => null,
			'type' => [
				0 => 'null',
				1 => 'string',
			],
		],
		'DjvuTxt' => [
			'default' => null,
			'type' => [
				0 => 'null',
				1 => 'string',
			],
		],
		'DjvuPostProcessor' => [
			'default' => 'pnmtojpeg',
			'type' => [
				0 => 'null',
				1 => 'string',
			],
		],
		'DjvuOutputExtension' => [
			'default' => 'jpg',
		],
		'EmergencyContact' => [
			'default' => false,
		],
		'PasswordSender' => [
			'default' => false,
		],
		'NoReplyAddress' => [
			'default' => false,
		],
		'EnableEmail' => [
			'default' => true,
		],
		'EnableUserEmail' => [
			'default' => true,
		],
		'EnableSpecialMute' => [
			'default' => false,
		],
		'EnableUserEmailMuteList' => [
			'default' => false,
		],
		'UserEmailUseReplyTo' => [
			'default' => true,
		],
		'PasswordReminderResendTime' => [
			'default' => 24,
		],
		'NewPasswordExpiry' => [
			'default' => 604800,
		],
		'UserEmailConfirmationTokenExpiry' => [
			'default' => 604800,
		],
		'PasswordExpirationDays' => [
			'default' => false,
		],
		'PasswordExpireGrace' => [
			'default' => 604800,
		],
		'SMTP' => [
			'default' => false,
			'type' => [
				0 => 'boolean',
				1 => 'object',
			],
		],
		'AdditionalMailParams' => [
			'default' => null,
		],
		'AllowHTMLEmail' => [
			'default' => false,
		],
		'EnotifFromEditor' => [
			'default' => false,
			'type' => 'boolean',
		],
		'EmailAuthentication' => [
			'default' => true,
		],
		'EnotifWatchlist' => [
			'default' => false,
		],
		'EnotifUserTalk' => [
			'default' => false,
		],
		'EnotifRevealEditorAddress' => [
			'default' => false,
			'type' => 'boolean',
		],
		'EnotifMinorEdits' => [
			'default' => true,
		],
		'EnotifImpersonal' => [
			'default' => false,
		],
		'EnotifMaxRecips' => [
			'default' => 500,
		],
		'EnotifUseRealName' => [
			'default' => false,
		],
		'UsersNotifiedOnAllChanges' => [
			'default' => [
			],
			'type' => 'object',
		],
		'DBname' => [
			'default' => 'my_wiki',
		],
		'DBmwschema' => [
			'default' => null,
			'type' => [
				0 => 'null',
				1 => 'string',
			],
		],
		'DBprefix' => [
			'default' => '',
		],
		'DBserver' => [
			'default' => 'localhost',
		],
		'DBport' => [
			'default' => 5432,
		],
		'DBuser' => [
			'default' => 'wikiuser',
		],
		'DBpassword' => [
			'default' => '',
		],
		'DBtype' => [
			'default' => 'mysql',
		],
		'DBssl' => [
			'default' => false,
		],
		'DBcompress' => [
			'default' => false,
		],
		'DBadminuser' => [
			'default' => null,
		],
		'DBadminpassword' => [
			'default' => null,
		],
		'SearchType' => [
			'default' => null,
		],
		'SearchTypeAlternatives' => [
			'default' => null,
		],
		'DBTableOptions' => [
			'default' => 'ENGINE=InnoDB, DEFAULT CHARSET=binary',
		],
		'SQLMode' => [
			'default' => '',
		],
		'DBDefaultGroup' => [
			'default' => null,
		],
		'SQLiteDataDir' => [
			'default' => '',
		],
		'SharedDB' => [
			'default' => null,
		],
		'SharedPrefix' => [
			'default' => false,
		],
		'SharedTables' => [
			'default' => [
				0 => 'user',
				1 => 'user_properties',
			],
			'type' => 'array',
		],
		'SharedSchema' => [
			'default' => false,
		],
		'DBservers' => [
			'default' => false,
			'type' => [
				0 => 'boolean',
				1 => 'array',
			],
		],
		'LBFactoryConf' => [
			'default' => [
				'class' => 'Wikimedia\\Rdbms\\LBFactorySimple',
			],
			'type' => 'object',
			'mergeStrategy' => 'replace',
		],
		'DataCenterUpdateStickTTL' => [
			'default' => 10,
		],
		'DBerrorLog' => [
			'default' => false,
		],
		'DBerrorLogTZ' => [
			'default' => false,
		],
		'LocalDatabases' => [
			'default' => [
			],
			'type' => 'array',
			'items' => [
				'type' => 'string',
			],
		],
		'DatabaseReplicaLagWarning' => [
			'default' => 10,
		],
		'DatabaseReplicaLagCritical' => [
			'default' => 30,
		],
		'MaxExecutionTimeForExpensiveQueries' => [
			'default' => 0,
		],
		'MultiContentRevisionSchemaMigrationStage' => [
			'default' => 768,
			'type' => 'integer',
		],
		'ActorTableSchemaMigrationStage' => [
			'default' => 48,
			'type' => 'integer',
		],
		'TemplateLinksSchemaMigrationStage' => [
			'default' => 3,
			'type' => 'integer',
		],
		'ContentHandlers' => [
			'default' => [
				'wikitext' => 'WikitextContentHandler',
				'javascript' => 'JavaScriptContentHandler',
				'json' => 'JsonContentHandler',
				'css' => 'CssContentHandler',
				'text' => 'TextContentHandler',
				'unknown' => 'FallbackContentHandler',
			],
			'type' => 'object',
		],
		'NamespaceContentModels' => [
			'default' => [
			],
			'type' => 'object',
		],
		'ContentHandlerTextFallback' => [
			'default' => 'ignore',
		],
		'TextModelsToParse' => [
			'default' => [
				0 => 'wikitext',
				1 => 'javascript',
				2 => 'css',
			],
			'type' => 'array',
		],
		'CompressRevisions' => [
			'default' => false,
		],
		'ExternalStores' => [
			'default' => [
			],
			'type' => 'array',
		],
		'ExternalServers' => [
			'default' => [
			],
			'type' => 'object',
		],
		'DefaultExternalStore' => [
			'default' => false,
			'type' => [
				0 => 'array',
				1 => 'boolean',
			],
		],
		'RevisionCacheExpiry' => [
			'default' => 604800,
			'type' => 'integer',
		],
		'PageLanguageUseDB' => [
			'default' => false,
			'type' => 'boolean',
		],
		'DiffEngine' => [
			'default' => null,
			'type' => [
				0 => 'string',
				1 => 'null',
			],
		],
		'ExternalDiffEngine' => [
			'default' => false,
			'type' => [
				0 => 'string',
				1 => 'boolean',
			],
		],
		'RequestTimeLimit' => [
			'default' => null,
			'type' => [
				0 => 'integer',
				1 => 'null',
			],
		],
		'TransactionalTimeLimit' => [
			'default' => 120,
		],
		'CriticalSectionTimeLimit' => [
			'default' => 180,
			'type' => 'integer',
		],
		'MiserMode' => [
			'default' => false,
		],
		'DisableQueryPages' => [
			'default' => false,
		],
		'QueryCacheLimit' => [
			'default' => 1000,
		],
		'WantedPagesThreshold' => [
			'default' => 1,
		],
		'AllowSlowParserFunctions' => [
			'default' => false,
		],
		'AllowSchemaUpdates' => [
			'default' => true,
		],
		'MaxArticleSize' => [
			'default' => 2048,
		],
		'MemoryLimit' => [
			'default' => '50M',
		],
		'PoolCounterConf' => [
			'default' => null,
			'type' => [
				0 => 'null',
				1 => 'object',
			],
		],
		'MaxUserDBWriteDuration' => [
			'default' => false,
			'type' => [
				0 => 'integer',
				1 => 'boolean',
			],
		],
		'MaxJobDBWriteDuration' => [
			'default' => false,
			'type' => [
				0 => 'integer',
				1 => 'boolean',
			],
		],
		'LinkHolderBatchSize' => [
			'default' => 1000,
		],
		'MaximumMovedPages' => [
			'default' => 100,
		],
		'ForceDeferredUpdatesPreSend' => [
			'default' => false,
		],
		'CacheDirectory' => [
			'default' => false,
		],
		'MainCacheType' => [
			'default' => 0,
		],
		'MessageCacheType' => [
			'default' => -1,
		],
		'ParserCacheType' => [
			'default' => -1,
		],
		'SessionCacheType' => [
			'default' => -1,
		],
		'LanguageConverterCacheType' => [
			'default' => -1,
		],
		'ObjectCaches' => [
			'default' => [
				0 => [
					'class' => 'EmptyBagOStuff',
					'reportDupes' => false,
				],
				1 => [
					'class' => 'SqlBagOStuff',
					'loggroup' => 'SQLBagOStuff',
				],
				-1 => [
					'factory' => 'ObjectCache::newAnything',
				],
				3 => [
					'factory' => 'ObjectCache::getLocalServerInstance',
				],
				'db-replicated' => [
					'class' => 'ReplicatedBagOStuff',
					'readFactory' => [
						'factory' => 'ObjectCache::newFromParams',
						'args' => [
							0 => [
								'class' => 'SqlBagOStuff',
								'replicaOnly' => true,
							],
						],
					],
					'writeFactory' => [
						'factory' => 'ObjectCache::newFromParams',
						'args' => [
							0 => [
								'class' => 'SqlBagOStuff',
								'replicaOnly' => false,
							],
						],
					],
					'loggroup' => 'SQLBagOStuff',
					'reportDupes' => false,
				],
				'memcached-php' => [
					'class' => 'MemcachedPhpBagOStuff',
					'loggroup' => 'memcached',
				],
				'memcached-pecl' => [
					'class' => 'MemcachedPeclBagOStuff',
					'loggroup' => 'memcached',
				],
				'hash' => [
					'class' => 'HashBagOStuff',
					'reportDupes' => false,
				],
				'apc' => [
					'class' => 'APCUBagOStuff',
					'reportDupes' => false,
				],
				'apcu' => [
					'class' => 'APCUBagOStuff',
					'reportDupes' => false,
				],
				'wincache' => [
					'class' => 'WinCacheBagOStuff',
					'reportDupes' => false,
				],
			],
			'type' => 'object',
		],
		'MainWANCache' => [
			'default' => false,
			'type' => [
				0 => 'integer',
				1 => 'string',
				2 => 'boolean',
			],
		],
		'WANObjectCaches' => [
			'default' => [
				0 => [
					'class' => 'WANObjectCache',
					'cacheId' => 0,
				],
			],
			'type' => 'object',
		],
		'EnableWANCacheReaper' => [
			'default' => false,
			'type' => 'boolean',
		],
		'MainStash' => [
			'default' => 'db-replicated',
		],
		'ChronologyProtectorStash' => [
			'default' => null,
			'type' => [
				0 => 'string',
				1 => 'null',
			],
		],
		'ParserCacheExpireTime' => [
			'default' => 86400,
		],
		'OldRevisionParserCacheExpireTime' => [
			'default' => 3600,
		],
		'ObjectCacheSessionExpiry' => [
			'default' => 3600,
		],
		'PHPSessionHandling' => [
			'default' => 'enable',
			'type' => 'string',
		],
		'SuspiciousIpExpiry' => [
			'default' => false,
			'type' => [
				0 => 'integer',
				1 => 'boolean',
			],
		],
		'SessionPbkdf2Iterations' => [
			'default' => 10001,
		],
		'MemCachedServers' => [
			'default' => [
				0 => '127.0.0.1:11211',
			],
			'type' => 'array',
		],
		'MemCachedPersistent' => [
			'default' => false,
		],
		'MemCachedTimeout' => [
			'default' => 500000,
		],
		'UseLocalMessageCache' => [
			'default' => false,
		],
		'AdaptiveMessageCache' => [
			'default' => false,
		],
		'LocalisationCacheConf' => [
			'default' => [
				'class' => 'LocalisationCache',
				'store' => 'detect',
				'storeClass' => false,
				'storeDirectory' => false,
				'storeServer' => [
				],
				'forceRecache' => false,
				'manualRecache' => false,
			],
			'type' => 'object',
		],
		'CachePages' => [
			'default' => true,
		],
		'CacheEpoch' => [
			'default' => '20030516000000',
		],
		'GitInfoCacheDirectory' => [
			'default' => false,
		],
		'UseFileCache' => [
			'default' => false,
		],
		'FileCacheDepth' => [
			'default' => 2,
		],
		'RenderHashAppend' => [
			'default' => '',
		],
		'EnableSidebarCache' => [
			'default' => false,
		],
		'SidebarCacheExpiry' => [
			'default' => 86400,
		],
		'FooterLinkCacheExpiry' => [
			'default' => 0,
		],
		'UseGzip' => [
			'default' => false,
		],
		'InvalidateCacheOnLocalSettingsChange' => [
			'default' => true,
		],
		'ExtensionInfoMTime' => [
			'default' => false,
			'type' => [
				0 => 'integer',
				1 => 'boolean',
			],
		],
		'ParserCacheUseJson' => [
			'default' => true,
		],
		'EnableRemoteBagOStuffTests' => [
			'default' => false,
		],
		'UseCdn' => [
			'default' => false,
		],
		'VaryOnXFP' => [
			'default' => false,
		],
		'InternalServer' => [
			'default' => false,
		],
		'CdnMaxAge' => [
			'default' => 18000,
		],
		'CdnMaxageLagged' => [
			'default' => 30,
		],
		'CdnMaxageStale' => [
			'default' => 10,
		],
		'CdnReboundPurgeDelay' => [
			'default' => 0,
		],
		'CdnMaxageSubstitute' => [
			'default' => 60,
		],
		'ForcedRawSMaxage' => [
			'default' => 300,
		],
		'CdnServers' => [
			'default' => [
			],
			'type' => 'object',
		],
		'CdnServersNoPurge' => [
			'default' => [
			],
			'type' => 'object',
		],
		'SquidPurgeUseHostHeader' => [
			'default' => true,
		],
		'HTCPRouting' => [
			'default' => [
			],
			'type' => 'object',
		],
		'HTCPMulticastTTL' => [
			'default' => 1,
		],
		'UsePrivateIPs' => [
			'default' => false,
		],
		'LanguageCode' => [
			'default' => 'en',
		],
		'GrammarForms' => [
			'default' => [
			],
			'type' => 'object',
		],
		'InterwikiMagic' => [
			'default' => true,
		],
		'HideInterlanguageLinks' => [
			'default' => false,
		],
		'ExtraInterlanguageLinkPrefixes' => [
			'default' => [
			],
			'type' => 'object',
		],
		'InterlanguageLinkCodeMap' => [
			'default' => [
			],
			'type' => 'object',
		],
		'ExtraLanguageNames' => [
			'default' => [
			],
			'type' => 'object',
		],
		'ExtraLanguageCodes' => [
			'default' => [
				'bh' => 'bho',
				'no' => 'nb',
				'simple' => 'en',
			],
			'type' => 'object',
		],
		'DummyLanguageCodes' => [
			'default' => [
			],
			'type' => 'object',
		],
		'AllUnicodeFixes' => [
			'default' => false,
		],
		'LegacyEncoding' => [
			'default' => false,
		],
		'LegacySchemaConversion' => [
			'default' => false,
		],
		'AmericanDates' => [
			'default' => false,
		],
		'TranslateNumerals' => [
			'default' => true,
		],
		'UseDatabaseMessages' => [
			'default' => true,
		],
		'MaxMsgCacheEntrySize' => [
			'default' => 10000,
		],
		'DisableLangConversion' => [
			'default' => false,
		],
		'DisableTitleConversion' => [
			'default' => false,
		],
		'DefaultLanguageVariant' => [
			'default' => false,
		],
		'UsePigLatinVariant' => [
			'default' => false,
		],
		'DisabledVariants' => [
			'default' => [
			],
			'type' => 'object',
		],
		'VariantArticlePath' => [
			'default' => false,
		],
		'LoginLanguageSelector' => [
			'default' => false,
		],
		'ForceUIMsgAsContentMsg' => [
			'default' => [
			],
			'type' => 'object',
		],
		'RawHtmlMessages' => [
			'default' => [
				0 => 'copyright',
				1 => 'history_copyright',
				2 => 'googlesearch',
				3 => 'feedback-terms',
				4 => 'feedback-termsofuse',
			],
			'type' => 'array',
			'items' => [
				'type' => 'string',
			],
		],
		'Localtimezone' => [
			'default' => null,
		],
		'LocalTZoffset' => [
			'default' => null,
		],
		'OverrideUcfirstCharacters' => [
			'default' => [
			],
			'type' => 'object',
		],
		'MimeType' => [
			'default' => 'text/html',
		],
		'Html5Version' => [
			'default' => null,
		],
		'HTMLFormAllowTableFormat' => [
			'default' => true,
		],
		'UseMediaWikiUIEverywhere' => [
			'default' => false,
		],
		'EditSubmitButtonLabelPublish' => [
			'default' => false,
		],
		'XhtmlNamespaces' => [
			'default' => [
			],
			'type' => 'object',
		],
		'SiteNotice' => [
			'default' => '',
		],
		'BrowserFormatDetection' => [
			'default' => 'telephone=no',
			'type' => 'string',
		],
		'SkinMetaTags' => [
			'default' => [
			],
			'type' => 'object',
		],
		'DefaultSkin' => [
			'default' => 'vector',
		],
		'FallbackSkin' => [
			'default' => 'fallback',
		],
		'SkipSkins' => [
			'default' => [
			],
			'type' => 'object',
		],
		'DisableOutputCompression' => [
			'default' => false,
		],
		'FragmentMode' => [
			'default' => [
				0 => 'html5',
				1 => 'legacy',
			],
			'type' => 'array',
		],
		'ExternalInterwikiFragmentMode' => [
			'default' => 'legacy',
		],
		'FooterIcons' => [
			'default' => [
				'copyright' => [
					'copyright' => [
					],
				],
				'poweredby' => [
					'mediawiki' => [
						'src' => null,
						'url' => 'https://www.mediawiki.org/',
						'alt' => 'Powered by MediaWiki',
					],
				],
			],
			'type' => 'object',
		],
		'UseCombinedLoginLink' => [
			'default' => false,
		],
		'Edititis' => [
			'default' => false,
		],
		'Send404Code' => [
			'default' => true,
		],
		'ShowRollbackEditCount' => [
			'default' => 10,
		],
		'EnableCanonicalServerLink' => [
			'default' => false,
		],
		'MangleFlashPolicy' => [
			'default' => true,
		],
		'ResourceModules' => [
			'default' => [
			],
			'type' => 'object',
		],
		'ResourceModuleSkinStyles' => [
			'default' => [
			],
			'type' => 'object',
		],
		'ResourceLoaderSources' => [
			'default' => [
			],
			'type' => 'object',
		],
		'ResourceBasePath' => [
			'default' => null,
		],
		'ResourceLoaderMaxage' => [
			'default' => [
				'versioned' => 2592000,
				'unversioned' => 300,
			],
			'type' => 'object',
		],
		'ResourceLoaderUseObjectCacheForDeps' => [
			'default' => false,
		],
		'ResourceLoaderDebug' => [
			'default' => false,
		],
		'IncludeLegacyJavaScript' => [
			'default' => false,
		],
		'ResourceLoaderMaxQueryLength' => [
			'default' => false,
			'type' => [
				0 => 'integer',
				1 => 'boolean',
			],
		],
		'ResourceLoaderValidateJS' => [
			'default' => true,
		],
		'ResourceLoaderEnableJSProfiler' => [
			'default' => false,
		],
		'ResourceLoaderStorageEnabled' => [
			'default' => true,
		],
		'ResourceLoaderStorageVersion' => [
			'default' => 1,
		],
		'AllowSiteCSSOnRestrictedPages' => [
			'default' => false,
		],
		'VueDevelopmentMode' => [
			'default' => false,
		],
		'MetaNamespace' => [
			'default' => false,
		],
		'MetaNamespaceTalk' => [
			'default' => false,
		],
		'CanonicalNamespaceNames' => [
			'default' => [
				-2 => 'Media',
				-1 => 'Special',
				0 => '',
				1 => 'Talk',
				2 => 'User',
				3 => 'User_talk',
				4 => 'Project',
				5 => 'Project_talk',
				6 => 'File',
				7 => 'File_talk',
				8 => 'MediaWiki',
				9 => 'MediaWiki_talk',
				10 => 'Template',
				11 => 'Template_talk',
				12 => 'Help',
				13 => 'Help_talk',
				14 => 'Category',
				15 => 'Category_talk',
			],
			'type' => 'object',
		],
		'ExtraNamespaces' => [
			'default' => [
			],
			'type' => 'object',
		],
		'ExtraGenderNamespaces' => [
			'default' => [
			],
			'type' => 'object',
		],
		'NamespaceAliases' => [
			'default' => [
			],
			'type' => 'object',
		],
		'LegalTitleChars' => [
			'default' => ' %!"$&\'()*,\\-.\\/0-9:;=?@A-Z\\\\^_`a-z~\\x80-\\xFF+',
		],
		'CapitalLinks' => [
			'default' => true,
		],
		'CapitalLinkOverrides' => [
			'default' => [
			],
			'type' => 'object',
		],
		'NamespacesWithSubpages' => [
			'default' => [
				1 => true,
				2 => true,
				3 => true,
				4 => true,
				5 => true,
				7 => true,
				8 => true,
				9 => true,
				10 => true,
				11 => true,
				12 => true,
				13 => true,
				15 => true,
			],
			'type' => 'object',
		],
		'ContentNamespaces' => [
			'default' => [
				0 => 0,
			],
			'type' => 'array',
		],
		'ShortPagesNamespaceExclusions' => [
			'default' => [
			],
			'type' => 'array',
		],
		'ExtraSignatureNamespaces' => [
			'default' => [
			],
			'type' => 'array',
		],
		'MaxRedirects' => [
			'default' => 1,
		],
		'InvalidRedirectTargets' => [
			'default' => [
				0 => 'Filepath',
				1 => 'Mypage',
				2 => 'Mytalk',
				3 => 'Redirect',
			],
			'type' => 'array',
		],
		'DisableHardRedirects' => [
			'default' => false,
		],
		'FixDoubleRedirects' => [
			'default' => false,
		],
		'InterwikiPrefixDisplayTypes' => [
			'default' => [
			],
			'type' => 'object',
		],
		'LocalInterwikis' => [
			'default' => [
			],
			'type' => 'array',
		],
		'InterwikiExpiry' => [
			'default' => 10800,
		],
		'InterwikiCache' => [
			'default' => false,
			'type' => [
				0 => 'boolean',
				1 => 'object',
				2 => 'string',
			],
			'mergeStrategy' => 'replace',
		],
		'InterwikiScopes' => [
			'default' => 3,
		],
		'InterwikiFallbackSite' => [
			'default' => 'wiki',
		],
		'RedirectSources' => [
			'default' => false,
		],
		'SiteTypes' => [
			'default' => [
				'mediawiki' => 'MediaWikiSite',
			],
			'type' => 'object',
		],
		'MaxTocLevel' => [
			'default' => 999,
		],
		'MaxPPNodeCount' => [
			'default' => 1000000,
		],
		'MaxTemplateDepth' => [
			'default' => 100,
		],
		'MaxPPExpandDepth' => [
			'default' => 100,
		],
		'UrlProtocols' => [
			'default' => [
				0 => 'bitcoin:',
				1 => 'ftp://',
				2 => 'ftps://',
				3 => 'geo:',
				4 => 'git://',
				5 => 'gopher://',
				6 => 'http://',
				7 => 'https://',
				8 => 'irc://',
				9 => 'ircs://',
				10 => 'magnet:',
				11 => 'mailto:',
				12 => 'mms://',
				13 => 'news:',
				14 => 'nntp://',
				15 => 'redis://',
				16 => 'sftp://',
				17 => 'sip:',
				18 => 'sips:',
				19 => 'sms:',
				20 => 'ssh://',
				21 => 'svn://',
				22 => 'tel:',
				23 => 'telnet://',
				24 => 'urn:',
				25 => 'worldwind://',
				26 => 'xmpp:',
				27 => '//',
			],
			'type' => 'array',
		],
		'CleanSignatures' => [
			'default' => true,
		],
		'AllowExternalImages' => [
			'default' => false,
		],
		'AllowExternalImagesFrom' => [
			'default' => '',
		],
		'EnableImageWhitelist' => [
			'default' => false,
		],
		'AllowImageTag' => [
			'default' => false,
		],
		'TidyConfig' => [
			'default' => [
			],
			'type' => 'object',
		],
		'ParserEnableLegacyMediaDOM' => [
			'default' => true,
		],
		'UseContentMediaStyles' => [
			'default' => false,
		],
		'RawHtml' => [
			'default' => false,
		],
		'ExternalLinkTarget' => [
			'default' => false,
		],
		'NoFollowLinks' => [
			'default' => true,
		],
		'NoFollowNsExceptions' => [
			'default' => [
			],
			'type' => 'array',
		],
		'NoFollowDomainExceptions' => [
			'default' => [
				0 => 'mediawiki.org',
			],
			'type' => 'array',
		],
		'RegisterInternalExternals' => [
			'default' => false,
		],
		'AllowDisplayTitle' => [
			'default' => true,
		],
		'RestrictDisplayTitle' => [
			'default' => true,
		],
		'ExpensiveParserFunctionLimit' => [
			'default' => 100,
		],
		'PreprocessorCacheThreshold' => [
			'default' => 1000,
		],
		'EnableScaryTranscluding' => [
			'default' => false,
		],
		'TranscludeCacheExpiry' => [
			'default' => 3600,
		],
		'EnableMagicLinks' => [
			'default' => [
				'ISBN' => false,
				'PMID' => false,
				'RFC' => false,
			],
			'type' => 'object',
		],
		'ArticleCountMethod' => [
			'default' => 'link',
		],
		'ActiveUserDays' => [
			'default' => 30,
		],
		'LearnerEdits' => [
			'default' => 10,
		],
		'LearnerMemberSince' => [
			'default' => 4,
		],
		'ExperiencedUserEdits' => [
			'default' => 500,
		],
		'ExperiencedUserMemberSince' => [
			'default' => 30,
		],
		'ManualRevertSearchRadius' => [
			'default' => 15,
			'type' => 'integer',
		],
		'RevertedTagMaxDepth' => [
			'default' => 15,
			'type' => 'integer',
		],
		'CentralIdLookupProviders' => [
			'default' => [
				'local' => [
					'class' => 'LocalIdLookup',
					'services' => [
						0 => 'MainConfig',
						1 => 'DBLoadBalancer',
					],
				],
			],
			'type' => 'object',
		],
		'CentralIdLookupProvider' => [
			'default' => 'local',
			'type' => 'string',
		],
		'PasswordPolicy' => [
			'default' => [
				'policies' => [
					'bureaucrat' => [
						'MinimalPasswordLength' => 10,
						'MinimumPasswordLengthToLogin' => 1,
					],
					'sysop' => [
						'MinimalPasswordLength' => 10,
						'MinimumPasswordLengthToLogin' => 1,
					],
					'interface-admin' => [
						'MinimalPasswordLength' => 10,
						'MinimumPasswordLengthToLogin' => 1,
					],
					'bot' => [
						'MinimalPasswordLength' => 10,
						'MinimumPasswordLengthToLogin' => 1,
					],
					'default' => [
						'MinimalPasswordLength' => [
							'value' => 1,
							'suggestChangeOnLogin' => true,
						],
						'PasswordCannotBeSubstringInUsername' => [
							'value' => true,
							'suggestChangeOnLogin' => true,
						],
						'PasswordCannotMatchDefaults' => [
							'value' => true,
							'suggestChangeOnLogin' => true,
						],
						'MaximalPasswordLength' => [
							'value' => 4096,
							'suggestChangeOnLogin' => true,
						],
						'PasswordNotInCommonList' => [
							'value' => true,
							'suggestChangeOnLogin' => true,
						],
					],
				],
				'checks' => [
					'MinimalPasswordLength' => 'PasswordPolicyChecks::checkMinimalPasswordLength',
					'MinimumPasswordLengthToLogin' => 'PasswordPolicyChecks::checkMinimumPasswordLengthToLogin',
					'PasswordCannotBeSubstringInUsername' => 'PasswordPolicyChecks::checkPasswordCannotBeSubstringInUsername',
					'PasswordCannotMatchDefaults' => 'PasswordPolicyChecks::checkPasswordCannotMatchDefaults',
					'MaximalPasswordLength' => 'PasswordPolicyChecks::checkMaximalPasswordLength',
					'PasswordNotInCommonList' => 'PasswordPolicyChecks::checkPasswordNotInCommonList',
				],
			],
			'type' => 'object',
			'mergeStrategy' => 'array_replace_recursive',
		],
		'AuthManagerConfig' => [
			'default' => null,
			'type' => [
				0 => 'object',
				1 => 'null',
			],
		],
		'AuthManagerAutoConfig' => [
			'default' => [
				'preauth' => [
					'MediaWiki\\Auth\\ThrottlePreAuthenticationProvider' => [
						'class' => 'MediaWiki\\Auth\\ThrottlePreAuthenticationProvider',
						'sort' => 0,
					],
				],
				'primaryauth' => [
					'MediaWiki\\Auth\\TemporaryPasswordPrimaryAuthenticationProvider' => [
						'class' => 'MediaWiki\\Auth\\TemporaryPasswordPrimaryAuthenticationProvider',
						'services' => [
							0 => 'DBLoadBalancer',
						],
						'args' => [
							0 => [
								'authoritative' => false,
							],
						],
						'sort' => 0,
					],
					'MediaWiki\\Auth\\LocalPasswordPrimaryAuthenticationProvider' => [
						'class' => 'MediaWiki\\Auth\\LocalPasswordPrimaryAuthenticationProvider',
						'services' => [
							0 => 'DBLoadBalancer',
						],
						'args' => [
							0 => [
								'authoritative' => true,
							],
						],
						'sort' => 100,
					],
				],
				'secondaryauth' => [
					'MediaWiki\\Auth\\CheckBlocksSecondaryAuthenticationProvider' => [
						'class' => 'MediaWiki\\Auth\\CheckBlocksSecondaryAuthenticationProvider',
						'sort' => 0,
					],
					'MediaWiki\\Auth\\ResetPasswordSecondaryAuthenticationProvider' => [
						'class' => 'MediaWiki\\Auth\\ResetPasswordSecondaryAuthenticationProvider',
						'sort' => 100,
					],
					'MediaWiki\\Auth\\EmailNotificationSecondaryAuthenticationProvider' => [
						'class' => 'MediaWiki\\Auth\\EmailNotificationSecondaryAuthenticationProvider',
						'services' => [
							0 => 'DBLoadBalancer',
						],
						'sort' => 200,
					],
				],
			],
			'type' => 'object',
			'mergeStrategy' => 'array_plus_2d',
		],
		'RememberMe' => [
			'default' => 'choose',
			'type' => 'string',
		],
		'ReauthenticateTime' => [
			'default' => [
				'default' => 300,
			],
			'type' => 'object',
			'additionalProperties' => [
				'type' => 'integer',
			],
		],
		'AllowSecuritySensitiveOperationIfCannotReauthenticate' => [
			'default' => [
				'default' => true,
			],
			'type' => 'object',
			'additionalProperties' => [
				'type' => 'boolean',
			],
		],
		'ChangeCredentialsBlacklist' => [
			'default' => [
				0 => 'MediaWiki\\Auth\\TemporaryPasswordAuthenticationRequest',
			],
			'type' => 'array',
			'items' => [
				'type' => 'string',
			],
		],
		'RemoveCredentialsBlacklist' => [
			'default' => [
				0 => 'MediaWiki\\Auth\\PasswordAuthenticationRequest',
			],
			'type' => 'array',
			'items' => [
				'type' => 'string',
			],
		],
		'MinimalPasswordLength' => [
			'default' => false,
		],
		'MaximalPasswordLength' => [
			'default' => false,
		],
		'InvalidPasswordReset' => [
			'default' => true,
		],
		'PasswordDefault' => [
			'default' => 'pbkdf2',
		],
		'PasswordConfig' => [
			'default' => [
				'A' => [
					'class' => 'MWOldPassword',
				],
				'B' => [
					'class' => 'MWSaltedPassword',
				],
				'pbkdf2-legacyA' => [
					'class' => 'LayeredParameterizedPassword',
					'types' => [
						0 => 'A',
						1 => 'pbkdf2',
					],
				],
				'pbkdf2-legacyB' => [
					'class' => 'LayeredParameterizedPassword',
					'types' => [
						0 => 'B',
						1 => 'pbkdf2',
					],
				],
				'bcrypt' => [
					'class' => 'BcryptPassword',
					'cost' => 9,
				],
				'pbkdf2' => [
					'class' => 'Pbkdf2Password',
					'algo' => 'sha512',
					'cost' => '30000',
					'length' => '64',
				],
				'argon2' => [
					'class' => 'Argon2Password',
					'algo' => 'auto',
				],
			],
			'type' => 'object',
		],
		'PasswordResetRoutes' => [
			'default' => [
				'username' => true,
				'email' => true,
			],
			'type' => 'object',
		],
		'MaxSigChars' => [
			'default' => 255,
		],
		'SignatureValidation' => [
			'default' => 'warning',
		],
		'SignatureAllowedLintErrors' => [
			'default' => [
				0 => 'obsolete-tag',
			],
			'type' => 'array',
		],
		'MaxNameChars' => [
			'default' => 255,
		],
		'ReservedUsernames' => [
			'default' => [
				0 => 'MediaWiki default',
				1 => 'Conversion script',
				2 => 'Maintenance script',
				3 => 'Template namespace initialisation script',
				4 => 'ScriptImporter',
				5 => 'Unknown user',
				6 => 'msg:double-redirect-fixer',
				7 => 'msg:usermessage-editor',
				8 => 'msg:proxyblocker',
				9 => 'msg:sorbs',
				10 => 'msg:spambot_username',
				11 => 'msg:autochange-username',
			],
			'type' => 'array',
		],
		'DefaultUserOptions' => [
			'default' => [
				'ccmeonemails' => 0,
				'date' => 'default',
				'diffonly' => 0,
				'disablemail' => 0,
				'editfont' => 'monospace',
				'editondblclick' => 0,
				'editsectiononrightclick' => 0,
				'email-allow-new-users' => 1,
				'enotifminoredits' => 0,
				'enotifrevealaddr' => 0,
				'enotifusertalkpages' => 1,
				'enotifwatchlistpages' => 1,
				'extendwatchlist' => 1,
				'fancysig' => 0,
				'forceeditsummary' => 0,
				'gender' => 'unknown',
				'hideminor' => 0,
				'hidepatrolled' => 0,
				'hidecategorization' => 1,
				'imagesize' => 2,
				'minordefault' => 0,
				'newpageshidepatrolled' => 0,
				'nickname' => '',
				'pst-cssjs' => 1,
				'norollbackdiff' => 0,
				'previewonfirst' => 0,
				'previewontop' => 1,
				'rcdays' => 7,
				'rcenhancedfilters-disable' => 0,
				'rclimit' => 50,
				'search-match-redirect' => true,
				'search-special-page' => 'Search',
				'searchlimit' => 20,
				'showhiddencats' => 0,
				'shownumberswatching' => 1,
				'showrollbackconfirmation' => 0,
				'skin' => false,
				'thumbsize' => 5,
				'underline' => 2,
				'uselivepreview' => 0,
				'usenewrc' => 1,
				'watchcreations' => 1,
				'watchdefault' => 1,
				'watchdeletion' => 0,
				'watchuploads' => 1,
				'watchlistdays' => 7,
				'watchlisthideanons' => 0,
				'watchlisthidebots' => 0,
				'watchlisthideliu' => 0,
				'watchlisthideminor' => 0,
				'watchlisthideown' => 0,
				'watchlisthidepatrolled' => 0,
				'watchlisthidecategorization' => 1,
				'watchlistreloadautomatically' => 0,
				'watchlistunwatchlinks' => 0,
				'watchmoves' => 0,
				'watchrollback' => 0,
				'wlenhancedfilters-disable' => 0,
				'wllimit' => 250,
				'useeditwarning' => 1,
				'prefershttps' => 1,
				'requireemail' => 0,
				'skin-responsive' => 1,
			],
			'type' => 'object',
		],
		'HiddenPrefs' => [
			'default' => [
			],
			'type' => 'array',
		],
		'InvalidUsernameCharacters' => [
			'default' => '@:',
		],
		'UserrightsInterwikiDelimiter' => [
			'default' => '@',
		],
		'SecureLogin' => [
			'default' => false,
		],
		'AuthenticationTokenVersion' => [
			'default' => null,
			'type' => [
				0 => 'string',
				1 => 'null',
			],
		],
		'SessionProviders' => [
			'type' => 'array',
			'ignoreKeys' => true,
			'default' => [
				'MediaWiki\\Session\\CookieSessionProvider' => [
					'class' => 'MediaWiki\\Session\\CookieSessionProvider',
					'args' => [
						0 => [
							'priority' => 30,
							'callUserSetCookiesHook' => true,
						],
					],
				],
				'MediaWiki\\Session\\BotPasswordSessionProvider' => [
					'class' => 'MediaWiki\\Session\\BotPasswordSessionProvider',
					'args' => [
						0 => [
							'priority' => 75,
						],
					],
				],
			],
		],
		'AllowRequiringEmailForResets' => [
			'default' => false,
		],
		'AutoblockExpiry' => [
			'default' => 86400,
		],
		'BlockAllowsUTEdit' => [
			'default' => true,
		],
		'BlockCIDRLimit' => [
			'default' => [
				'IPv4' => 16,
				'IPv6' => 19,
			],
			'type' => 'object',
		],
		'BlockDisablesLogin' => [
			'default' => false,
		],
		'EnablePartialActionBlocks' => [
			'default' => false,
			'type' => 'boolean',
		],
		'WhitelistRead' => [
			'default' => false,
		],
		'WhitelistReadRegexp' => [
			'default' => false,
		],
		'EmailConfirmToEdit' => [
			'default' => false,
		],
		'HideIdentifiableRedirects' => [
			'default' => true,
		],
		'GroupPermissions' => [
			'type' => 'object',
			'additionalProperties' => [
				'type' => 'object',
				'additionalProperties' => [
					'type' => 'boolean',
				],
			],
			'mergeStrategy' => 'array_plus_2d',
			'default' => [
				'*' => [
					'createaccount' => true,
					'read' => true,
					'edit' => true,
					'createpage' => true,
					'createtalk' => true,
					'writeapi' => true,
					'viewmywatchlist' => true,
					'editmywatchlist' => true,
					'viewmyprivateinfo' => true,
					'editmyprivateinfo' => true,
					'editmyoptions' => true,
				],
				'user' => [
					'move' => true,
					'move-subpages' => true,
					'move-rootuserpages' => true,
					'move-categorypages' => true,
					'movefile' => true,
					'read' => true,
					'edit' => true,
					'createpage' => true,
					'createtalk' => true,
					'writeapi' => true,
					'upload' => true,
					'reupload' => true,
					'reupload-shared' => true,
					'minoredit' => true,
					'editmyusercss' => true,
					'editmyuserjson' => true,
					'editmyuserjs' => true,
					'editmyuserjsredirect' => true,
					'purge' => true,
					'sendemail' => true,
					'applychangetags' => true,
					'changetags' => true,
					'editcontentmodel' => true,
				],
				'autoconfirmed' => [
					'autoconfirmed' => true,
					'editsemiprotected' => true,
				],
				'bot' => [
					'bot' => true,
					'autoconfirmed' => true,
					'editsemiprotected' => true,
					'nominornewtalk' => true,
					'autopatrol' => true,
					'suppressredirect' => true,
					'apihighlimits' => true,
					'writeapi' => true,
				],
				'sysop' => [
					'block' => true,
					'createaccount' => true,
					'delete' => true,
					'bigdelete' => true,
					'deletedhistory' => true,
					'deletedtext' => true,
					'undelete' => true,
					'editinterface' => true,
					'editsitejson' => true,
					'edituserjson' => true,
					'import' => true,
					'importupload' => true,
					'move' => true,
					'move-subpages' => true,
					'move-rootuserpages' => true,
					'move-categorypages' => true,
					'patrol' => true,
					'autopatrol' => true,
					'protect' => true,
					'editprotected' => true,
					'rollback' => true,
					'upload' => true,
					'reupload' => true,
					'reupload-shared' => true,
					'unwatchedpages' => true,
					'autoconfirmed' => true,
					'editsemiprotected' => true,
					'ipblock-exempt' => true,
					'blockemail' => true,
					'markbotedits' => true,
					'apihighlimits' => true,
					'browsearchive' => true,
					'noratelimit' => true,
					'movefile' => true,
					'unblockself' => true,
					'suppressredirect' => true,
					'mergehistory' => true,
					'managechangetags' => true,
					'deletechangetags' => true,
				],
				'interface-admin' => [
					'editinterface' => true,
					'editsitecss' => true,
					'editsitejson' => true,
					'editsitejs' => true,
					'editusercss' => true,
					'edituserjson' => true,
					'edituserjs' => true,
				],
				'bureaucrat' => [
					'userrights' => true,
					'noratelimit' => true,
				],
				'suppress' => [
					'hideuser' => true,
					'suppressrevision' => true,
					'viewsuppressed' => true,
					'suppressionlog' => true,
					'deleterevision' => true,
					'deletelogentry' => true,
				],
			],
		],
		'RevokePermissions' => [
			'default' => [
			],
			'type' => 'object',
			'mergeStrategy' => 'array_plus_2d',
		],
		'GroupInheritsPermissions' => [
			'default' => [
			],
			'type' => 'array',
			'items' => [
				'type' => 'string',
			],
		],
		'ImplicitGroups' => [
			'default' => [
				0 => '*',
				1 => 'user',
				2 => 'autoconfirmed',
			],
			'type' => 'array',
		],
		'GroupsAddToSelf' => [
			'default' => [
			],
			'type' => 'object',
		],
		'GroupsRemoveFromSelf' => [
			'default' => [
			],
			'type' => 'object',
		],
		'RestrictionTypes' => [
			'default' => [
				0 => 'create',
				1 => 'edit',
				2 => 'move',
				3 => 'upload',
			],
			'type' => 'array',
		],
		'RestrictionLevels' => [
			'default' => [
				0 => '',
				1 => 'autoconfirmed',
				2 => 'sysop',
			],
			'type' => 'array',
		],
		'CascadingRestrictionLevels' => [
			'default' => [
				0 => 'sysop',
			],
			'type' => 'array',
		],
		'SemiprotectedRestrictionLevels' => [
			'default' => [
				0 => 'autoconfirmed',
			],
			'type' => 'array',
		],
		'NamespaceProtection' => [
			'default' => [
			],
			'type' => 'object',
		],
		'NonincludableNamespaces' => [
			'default' => [
			],
			'type' => 'object',
		],
		'AutoConfirmAge' => [
			'default' => 0,
		],
		'AutoConfirmCount' => [
			'default' => 0,
		],
		'Autopromote' => [
			'default' => [
				'autoconfirmed' => [
					0 => '&',
					1 => [
						0 => 1,
						1 => null,
					],
					2 => [
						0 => 2,
						1 => null,
					],
				],
			],
			'type' => 'object',
		],
		'AutopromoteOnce' => [
			'default' => [
				'onEdit' => [
				],
			],
			'type' => 'object',
		],
		'AutopromoteOnceLogInRC' => [
			'default' => true,
		],
		'AddGroups' => [
			'default' => [
			],
			'type' => 'object',
		],
		'RemoveGroups' => [
			'default' => [
			],
			'type' => 'object',
		],
		'AvailableRights' => [
			'default' => [
			],
			'type' => 'array',
		],
		'DeleteRevisionsLimit' => [
			'default' => 0,
		],
		'DeleteRevisionsBatchSize' => [
			'default' => 1000,
		],
		'HideUserContribLimit' => [
			'default' => 1000,
		],
		'AccountCreationThrottle' => [
			'default' => [
				0 => [
					'count' => 0,
					'seconds' => 86400,
				],
			],
			'type' => 'array',
		],
		'SpamRegex' => [
			'default' => [
			],
			'type' => 'array',
		],
		'SummarySpamRegex' => [
			'default' => [
			],
			'type' => 'array',
		],
		'EnableDnsBlacklist' => [
			'default' => false,
		],
		'DnsBlacklistUrls' => [
			'default' => [
				0 => 'http.dnsbl.sorbs.net.',
			],
			'type' => 'array',
		],
		'ProxyList' => [
			'default' => [
			],
			'type' => [
				0 => 'string',
				1 => 'array',
			],
		],
		'ProxyWhitelist' => [
			'default' => [
			],
			'type' => 'array',
		],
		'SoftBlockRanges' => [
			'default' => [
			],
			'type' => 'array',
			'items' => [
				'type' => 'string',
			],
		],
		'ApplyIpBlocksToXff' => [
			'default' => false,
		],
		'RateLimits' => [
			'default' => [
				'edit' => [
					'ip' => [
						0 => 8,
						1 => 60,
					],
					'newbie' => [
						0 => 8,
						1 => 60,
					],
					'user' => [
						0 => 90,
						1 => 60,
					],
				],
				'move' => [
					'newbie' => [
						0 => 2,
						1 => 120,
					],
					'user' => [
						0 => 8,
						1 => 60,
					],
				],
				'upload' => [
					'ip' => [
						0 => 8,
						1 => 60,
					],
					'newbie' => [
						0 => 8,
						1 => 60,
					],
				],
				'rollback' => [
					'user' => [
						0 => 10,
						1 => 60,
					],
					'newbie' => [
						0 => 5,
						1 => 120,
					],
				],
				'mailpassword' => [
					'ip' => [
						0 => 5,
						1 => 3600,
					],
				],
				'emailuser' => [
					'ip' => [
						0 => 5,
						1 => 86400,
					],
					'newbie' => [
						0 => 5,
						1 => 86400,
					],
					'user' => [
						0 => 20,
						1 => 86400,
					],
				],
				'changeemail' => [
					'ip-all' => [
						0 => 10,
						1 => 3600,
					],
					'user' => [
						0 => 4,
						1 => 86400,
					],
				],
				'confirmemail' => [
					'ip-all' => [
						0 => 10,
						1 => 3600,
					],
					'user' => [
						0 => 4,
						1 => 86400,
					],
				],
				'purge' => [
					'ip' => [
						0 => 30,
						1 => 60,
					],
					'user' => [
						0 => 30,
						1 => 60,
					],
				],
				'linkpurge' => [
					'ip' => [
						0 => 30,
						1 => 60,
					],
					'user' => [
						0 => 30,
						1 => 60,
					],
				],
				'renderfile' => [
					'ip' => [
						0 => 700,
						1 => 30,
					],
					'user' => [
						0 => 700,
						1 => 30,
					],
				],
				'renderfile-nonstandard' => [
					'ip' => [
						0 => 70,
						1 => 30,
					],
					'user' => [
						0 => 70,
						1 => 30,
					],
				],
				'stashedit' => [
					'ip' => [
						0 => 30,
						1 => 60,
					],
					'newbie' => [
						0 => 30,
						1 => 60,
					],
				],
				'changetag' => [
					'ip' => [
						0 => 8,
						1 => 60,
					],
					'newbie' => [
						0 => 8,
						1 => 60,
					],
				],
				'editcontentmodel' => [
					'newbie' => [
						0 => 2,
						1 => 120,
					],
					'user' => [
						0 => 8,
						1 => 60,
					],
				],
			],
			'type' => 'object',
			'mergeStrategy' => 'array_plus_2d',
		],
		'RateLimitsExcludedIPs' => [
			'default' => [
			],
			'type' => 'array',
		],
		'PutIPinRC' => [
			'default' => true,
		],
		'QueryPageDefaultLimit' => [
			'default' => 50,
		],
		'PasswordAttemptThrottle' => [
			'default' => [
				0 => [
					'count' => 5,
					'seconds' => 300,
				],
				1 => [
					'count' => 150,
					'seconds' => 172800,
				],
			],
			'type' => 'array',
		],
		'GrantPermissions' => [
			'default' => [
				'basic' => [
					'autocreateaccount' => true,
					'autoconfirmed' => true,
					'autopatrol' => true,
					'editsemiprotected' => true,
					'ipblock-exempt' => true,
					'nominornewtalk' => true,
					'patrolmarks' => true,
					'purge' => true,
					'read' => true,
					'writeapi' => true,
					'unwatchedpages' => true,
				],
				'highvolume' => [
					'bot' => true,
					'apihighlimits' => true,
					'noratelimit' => true,
					'markbotedits' => true,
				],
				'import' => [
					'import' => true,
					'importupload' => true,
				],
				'editpage' => [
					'edit' => true,
					'minoredit' => true,
					'applychangetags' => true,
					'changetags' => true,
					'editcontentmodel' => true,
				],
				'editprotected' => [
					'edit' => true,
					'minoredit' => true,
					'applychangetags' => true,
					'changetags' => true,
					'editcontentmodel' => true,
					'editprotected' => true,
				],
				'editmycssjs' => [
					'edit' => true,
					'minoredit' => true,
					'applychangetags' => true,
					'changetags' => true,
					'editcontentmodel' => true,
					'editmyusercss' => true,
					'editmyuserjson' => true,
					'editmyuserjs' => true,
				],
				'editmyoptions' => [
					'editmyoptions' => true,
					'editmyuserjson' => true,
				],
				'editinterface' => [
					'edit' => true,
					'minoredit' => true,
					'applychangetags' => true,
					'changetags' => true,
					'editcontentmodel' => true,
					'editinterface' => true,
					'edituserjson' => true,
					'editsitejson' => true,
				],
				'editsiteconfig' => [
					'edit' => true,
					'minoredit' => true,
					'applychangetags' => true,
					'changetags' => true,
					'editcontentmodel' => true,
					'editinterface' => true,
					'edituserjson' => true,
					'editsitejson' => true,
					'editusercss' => true,
					'edituserjs' => true,
					'editsitecss' => true,
					'editsitejs' => true,
				],
				'createeditmovepage' => [
					'edit' => true,
					'minoredit' => true,
					'applychangetags' => true,
					'changetags' => true,
					'editcontentmodel' => true,
					'createpage' => true,
					'createtalk' => true,
					'delete-redirect' => true,
					'move' => true,
					'move-rootuserpages' => true,
					'move-subpages' => true,
					'move-categorypages' => true,
					'suppressredirect' => true,
				],
				'uploadfile' => [
					'upload' => true,
					'reupload-own' => true,
				],
				'uploadeditmovefile' => [
					'upload' => true,
					'reupload-own' => true,
					'reupload' => true,
					'reupload-shared' => true,
					'upload_by_url' => true,
					'movefile' => true,
					'suppressredirect' => true,
				],
				'patrol' => [
					'patrol' => true,
				],
				'rollback' => [
					'rollback' => true,
				],
				'blockusers' => [
					'block' => true,
					'blockemail' => true,
				],
				'viewdeleted' => [
					'browsearchive' => true,
					'deletedhistory' => true,
					'deletedtext' => true,
				],
				'viewrestrictedlogs' => [
					'suppressionlog' => true,
				],
				'delete' => [
					'edit' => true,
					'minoredit' => true,
					'applychangetags' => true,
					'changetags' => true,
					'editcontentmodel' => true,
					'browsearchive' => true,
					'deletedhistory' => true,
					'deletedtext' => true,
					'delete' => true,
					'bigdelete' => true,
					'deletelogentry' => true,
					'deleterevision' => true,
					'undelete' => true,
				],
				'oversight' => [
					'suppressrevision' => true,
					'viewsuppressed' => true,
				],
				'protect' => [
					'edit' => true,
					'minoredit' => true,
					'applychangetags' => true,
					'changetags' => true,
					'editcontentmodel' => true,
					'editprotected' => true,
					'protect' => true,
				],
				'viewmywatchlist' => [
					'viewmywatchlist' => true,
				],
				'editmywatchlist' => [
					'editmywatchlist' => true,
				],
				'sendemail' => [
					'sendemail' => true,
				],
				'createaccount' => [
					'createaccount' => true,
				],
				'privateinfo' => [
					'viewmyprivateinfo' => true,
				],
				'mergehistory' => [
					'mergehistory' => true,
				],
			],
			'type' => 'object',
			'mergeStrategy' => 'array_plus_2d',
			'additionalProperties' => [
				'type' => 'object',
				'additionalProperties' => [
					'type' => 'boolean',
				],
			],
		],
		'GrantPermissionGroups' => [
			'default' => [
				'basic' => 'hidden',
				'editpage' => 'page-interaction',
				'createeditmovepage' => 'page-interaction',
				'editprotected' => 'page-interaction',
				'patrol' => 'page-interaction',
				'uploadfile' => 'file-interaction',
				'uploadeditmovefile' => 'file-interaction',
				'sendemail' => 'email',
				'viewmywatchlist' => 'watchlist-interaction',
				'editviewmywatchlist' => 'watchlist-interaction',
				'editmycssjs' => 'customization',
				'editmyoptions' => 'customization',
				'editinterface' => 'administration',
				'editsiteconfig' => 'administration',
				'rollback' => 'administration',
				'blockusers' => 'administration',
				'delete' => 'administration',
				'viewdeleted' => 'administration',
				'viewrestrictedlogs' => 'administration',
				'protect' => 'administration',
				'oversight' => 'administration',
				'createaccount' => 'administration',
				'mergehistory' => 'administration',
				'import' => 'administration',
				'highvolume' => 'high-volume',
				'privateinfo' => 'private-information',
			],
			'type' => 'object',
			'additionalProperties' => [
				'type' => 'string',
			],
		],
		'EnableBotPasswords' => [
			'default' => true,
			'type' => 'boolean',
		],
		'BotPasswordsCluster' => [
			'default' => false,
			'type' => [
				0 => 'string',
				1 => 'boolean',
			],
		],
		'BotPasswordsDatabase' => [
			'default' => false,
			'type' => [
				0 => 'string',
				1 => 'boolean',
			],
		],
		'SecretKey' => [
			'default' => false,
		],
		'AllowUserJs' => [
			'default' => false,
		],
		'AllowUserCss' => [
			'default' => false,
		],
		'AllowUserCssPrefs' => [
			'default' => true,
		],
		'UseSiteJs' => [
			'default' => true,
		],
		'UseSiteCss' => [
			'default' => true,
		],
		'BreakFrames' => [
			'default' => false,
		],
		'EditPageFrameOptions' => [
			'default' => 'DENY',
		],
		'ApiFrameOptions' => [
			'default' => 'DENY',
		],
		'CSPHeader' => [
			'default' => false,
			'type' => [
				0 => 'boolean',
				1 => 'array',
			],
		],
		'CSPReportOnlyHeader' => [
			'default' => false,
			'type' => [
				0 => 'boolean',
				1 => 'array',
			],
		],
		'CSPFalsePositiveUrls' => [
			'default' => [
				'https://3hub.co' => true,
				'https://morepro.info' => true,
				'https://p.ato.mx' => true,
				'https://s.ato.mx' => true,
				'https://adserver.adtech.de' => true,
				'https://ums.adtechus.com' => true,
				'https://cas.criteo.com' => true,
				'https://cat.nl.eu.criteo.com' => true,
				'https://atpixel.alephd.com' => true,
				'https://rtb.metrigo.com' => true,
				'https://d5p.de17a.com' => true,
				'https://ad.lkqd.net/vpaid/vpaid.js' => true,
				'https://ad.lkqd.net/vpaid/vpaid.js?fusion=1.0' => true,
				'https://t.lkqd.net/t' => true,
				'chrome-extension' => true,
			],
			'type' => 'object',
		],
		'AllowCrossOrigin' => [
			'default' => false,
			'type' => 'boolean',
		],
		'RestAllowCrossOriginCookieAuth' => [
			'default' => false,
			'type' => 'boolean',
		],
		'SessionSecret' => [
			'default' => false,
		],
		'SessionInsecureSecrets' => [
			'default' => false,
		],
		'HKDFSecret' => [
			'default' => false,
		],
		'HKDFAlgorithm' => [
			'default' => 'sha256',
		],
		'CookieExpiration' => [
			'default' => 2592000,
		],
		'ExtendedLoginCookieExpiration' => [
			'default' => 15552000,
		],
		'CookieDomain' => [
			'default' => '',
		],
		'CookiePath' => [
			'default' => '/',
		],
		'CookieSecure' => [
			'default' => 'detect',
		],
		'DisableCookieCheck' => [
			'default' => false,
		],
		'CookiePrefix' => [
			'default' => false,
		],
		'CookieHttpOnly' => [
			'default' => true,
		],
		'CookieSameSite' => [
			'default' => null,
			'type' => [
				0 => 'string',
				1 => 'null',
			],
		],
		'UseSameSiteLegacyCookies' => [
			'default' => false,
			'type' => 'boolean',
		],
		'CacheVaryCookies' => [
			'default' => [
			],
			'type' => 'array',
		],
		'SessionName' => [
			'default' => false,
		],
		'CookieSetOnAutoblock' => [
			'default' => true,
		],
		'CookieSetOnIpBlock' => [
			'default' => true,
		],
		'DebugLogFile' => [
			'default' => '',
		],
		'DebugLogPrefix' => [
			'default' => '',
		],
		'DebugRedirects' => [
			'default' => false,
		],
		'DebugRawPage' => [
			'default' => false,
		],
		'DebugComments' => [
			'default' => false,
		],
		'DebugDumpSql' => [
			'default' => false,
		],
		'TrxProfilerLimits' => [
			'default' => [
				'GET' => [
					'masterConns' => 0,
					'writes' => 0,
					'readQueryTime' => 5,
					'readQueryRows' => 10000,
				],
				'POST' => [
					'readQueryTime' => 5,
					'writeQueryTime' => 1,
					'readQueryRows' => 100000,
					'maxAffected' => 1000,
				],
				'POST-nonwrite' => [
					'writes' => 0,
					'readQueryTime' => 5,
					'readQueryRows' => 10000,
				],
				'PostSend-GET' => [
					'readQueryTime' => 5,
					'writeQueryTime' => 1,
					'readQueryRows' => 10000,
					'maxAffected' => 1000,
					'masterConns' => 0,
					'writes' => 0,
				],
				'PostSend-POST' => [
					'readQueryTime' => 5,
					'writeQueryTime' => 1,
					'readQueryRows' => 100000,
					'maxAffected' => 1000,
				],
				'JobRunner' => [
					'readQueryTime' => 30,
					'writeQueryTime' => 5,
					'readQueryRows' => 100000,
					'maxAffected' => 500,
				],
				'Maintenance' => [
					'writeQueryTime' => 5,
					'maxAffected' => 1000,
				],
			],
			'type' => 'object',
		],
		'DebugLogGroups' => [
			'default' => [
			],
			'type' => 'object',
		],
		'MWLoggerDefaultSpi' => [
			'default' => [
				'class' => 'MediaWiki\\Logger\\LegacySpi',
			],
			'mergeStrategy' => 'replace',
			'type' => 'object',
		],
		'ShowDebug' => [
			'default' => false,
		],
		'SpecialVersionShowHooks' => [
			'default' => false,
		],
		'ShowExceptionDetails' => [
			'default' => false,
		],
		'LogExceptionBacktrace' => [
			'default' => true,
		],
		'PropagateErrors' => [
			'default' => true,
		],
		'ShowHostnames' => [
			'default' => false,
		],
		'OverrideHostname' => [
			'default' => false,
		],
		'DevelopmentWarnings' => [
			'default' => false,
		],
		'DeprecationReleaseLimit' => [
			'default' => false,
		],
		'Profiler' => [
			'default' => [
			],
			'type' => 'object',
			'mergeStrategy' => 'replace',
		],
		'StatsdServer' => [
			'default' => false,
		],
		'StatsdMetricPrefix' => [
			'default' => 'MediaWiki',
		],
		'StatsdSamplingRates' => [
			'default' => [
			],
			'type' => 'object',
		],
		'MetricsTarget' => [
			'default' => null,
			'type' => [
				0 => 'string',
				1 => 'null',
			],
		],
		'MetricsFormat' => [
			'default' => null,
			'type' => [
				0 => 'string',
				1 => 'null',
			],
		],
		'MetricsPrefix' => [
			'default' => 'mediawiki',
			'type' => 'string',
		],
		'PageInfoTransclusionLimit' => [
			'default' => 50,
		],
		'ParserTestFiles' => [
			'default' => [
			],
			'type' => 'object',
		],
		'EnableJavaScriptTest' => [
			'default' => false,
		],
		'CachePrefix' => [
			'default' => false,
		],
		'DebugToolbar' => [
			'default' => false,
		],
		'DisableTextSearch' => [
			'default' => false,
		],
		'AdvancedSearchHighlighting' => [
			'default' => false,
		],
		'SearchHighlightBoundaries' => [
			'default' => '[\\p{Z}\\p{P}\\p{C}]',
		],
		'OpenSearchTemplate' => [
			'default' => false,
		],
		'OpenSearchTemplates' => [
			'default' => [
				'application/x-suggestions+json' => false,
				'application/x-suggestions+xml' => false,
			],
			'type' => 'object',
		],
		'EnableOpenSearchSuggest' => [
			'default' => true,
		],
		'OpenSearchDefaultLimit' => [
			'default' => 10,
		],
		'OpenSearchDescriptionLength' => [
			'default' => 100,
		],
		'SearchSuggestCacheExpiry' => [
			'default' => 1200,
		],
		'DisableSearchUpdate' => [
			'default' => false,
		],
		'NamespacesToBeSearchedDefault' => [
			'default' => [
				0 => true,
			],
			'type' => 'object',
		],
		'DisableInternalSearch' => [
			'default' => false,
		],
		'SearchForwardUrl' => [
			'default' => null,
		],
		'SitemapNamespaces' => [
			'default' => false,
			'type' => [
				0 => 'boolean',
				1 => 'array',
			],
		],
		'SitemapNamespacesPriorities' => [
			'default' => false,
			'type' => [
				0 => 'boolean',
				1 => 'object',
			],
		],
		'EnableSearchContributorsByIP' => [
			'default' => true,
		],
		'SpecialSearchFormOptions' => [
			'default' => [
			],
			'type' => 'object',
		],
		'SearchMatchRedirectPreference' => [
			'default' => false,
			'type' => 'boolean',
		],
		'SearchRunSuggestedQuery' => [
			'default' => true,
			'type' => 'boolean',
		],
		'Diff3' => [
			'default' => '/usr/bin/diff3',
		],
		'Diff' => [
			'default' => '/usr/bin/diff',
		],
		'PreviewOnOpenNamespaces' => [
			'default' => [
				14 => true,
			],
			'type' => 'object',
		],
		'UniversalEditButton' => [
			'default' => true,
		],
		'UseAutomaticEditSummaries' => [
			'default' => true,
		],
		'CommandLineMode' => [
			'default' => false,
		],
		'CommandLineDarkBg' => [
			'default' => false,
		],
		'ReadOnly' => [
			'default' => null,
		],
		'ReadOnlyWatchedItemStore' => [
			'default' => false,
			'type' => 'boolean',
		],
		'ReadOnlyFile' => [
			'default' => false,
		],
		'UpgradeKey' => [
			'default' => false,
		],
		'GitBin' => [
			'default' => '/usr/bin/git',
		],
		'GitRepositoryViewers' => [
			'default' => [
				'https://(?:[a-z0-9_]+@)?gerrit.wikimedia.org/r/(?:p/)?(.*)' => 'https://gerrit.wikimedia.org/g/%R/+/%H',
				'ssh://(?:[a-z0-9_]+@)?gerrit.wikimedia.org:29418/(.*)' => 'https://gerrit.wikimedia.org/g/%R/+/%H',
			],
			'type' => 'object',
		],
		'RCMaxAge' => [
			'default' => 7776000,
		],
		'WatchersMaxAge' => [
			'default' => 15552000,
		],
		'UnwatchedPageSecret' => [
			'default' => 1,
		],
		'RCFilterByAge' => [
			'default' => false,
		],
		'RCLinkLimits' => [
			'default' => [
				0 => 50,
				1 => 100,
				2 => 250,
				3 => 500,
			],
			'type' => 'array',
		],
		'RCLinkDays' => [
			'default' => [
				0 => 1,
				1 => 3,
				2 => 7,
				3 => 14,
				4 => 30,
			],
			'type' => 'array',
		],
		'RCFeeds' => [
			'default' => [
			],
			'type' => 'object',
		],
		'RCEngines' => [
			'default' => [
				'redis' => 'RedisPubSubFeedEngine',
				'udp' => 'UDPRCFeedEngine',
			],
			'type' => 'object',
		],
		'RCWatchCategoryMembership' => [
			'default' => false,
		],
		'UseRCPatrol' => [
			'default' => true,
		],
		'StructuredChangeFiltersLiveUpdatePollingRate' => [
			'default' => 3,
		],
		'UseNPPatrol' => [
			'default' => true,
		],
		'UseFilePatrol' => [
			'default' => true,
		],
		'Feed' => [
			'default' => true,
		],
		'FeedLimit' => [
			'default' => 50,
		],
		'FeedCacheTimeout' => [
			'default' => 60,
		],
		'FeedDiffCutoff' => [
			'default' => 32768,
		],
		'OverrideSiteFeed' => [
			'default' => [
			],
			'type' => 'object',
		],
		'FeedClasses' => [
			'default' => [
				'rss' => 'RSSFeed',
				'atom' => 'AtomFeed',
			],
			'type' => 'object',
		],
		'AdvertisedFeedTypes' => [
			'default' => [
				0 => 'atom',
			],
			'type' => 'array',
		],
		'RCShowWatchingUsers' => [
			'default' => false,
		],
		'RCShowChangedSize' => [
			'default' => true,
		],
		'RCChangedSizeThreshold' => [
			'default' => 500,
		],
		'ShowUpdatedMarker' => [
			'default' => true,
		],
		'DisableAnonTalk' => [
			'default' => false,
		],
		'UseTagFilter' => [
			'default' => true,
		],
		'SoftwareTags' => [
			'default' => [
				'mw-contentmodelchange' => true,
				'mw-new-redirect' => true,
				'mw-removed-redirect' => true,
				'mw-changed-redirect-target' => true,
				'mw-blank' => true,
				'mw-replace' => true,
				'mw-rollback' => true,
				'mw-undo' => true,
				'mw-manual-revert' => true,
				'mw-reverted' => true,
				'mw-server-side-upload' => true,
			],
			'type' => 'object',
			'additionalProperties' => [
				'type' => 'boolean',
			],
		],
		'UnwatchedPageThreshold' => [
			'default' => false,
		],
		'RecentChangesFlags' => [
			'default' => [
				'newpage' => [
					'letter' => 'newpageletter',
					'title' => 'recentchanges-label-newpage',
					'legend' => 'recentchanges-legend-newpage',
					'grouping' => 'any',
				],
				'minor' => [
					'letter' => 'minoreditletter',
					'title' => 'recentchanges-label-minor',
					'legend' => 'recentchanges-legend-minor',
					'class' => 'minoredit',
					'grouping' => 'all',
				],
				'bot' => [
					'letter' => 'boteditletter',
					'title' => 'recentchanges-label-bot',
					'legend' => 'recentchanges-legend-bot',
					'class' => 'botedit',
					'grouping' => 'all',
				],
				'unpatrolled' => [
					'letter' => 'unpatrolledletter',
					'title' => 'recentchanges-label-unpatrolled',
					'legend' => 'recentchanges-legend-unpatrolled',
					'grouping' => 'any',
				],
			],
			'type' => 'object',
		],
		'WatchlistExpiry' => [
			'default' => false,
			'type' => 'boolean',
		],
		'WatchlistPurgeRate' => [
			'default' => 0.1,
			'type' => 'number',
		],
		'WatchlistExpiryMaxDuration' => [
			'default' => '6 months',
			'type' => [
				0 => 'string',
				1 => 'null',
			],
		],
		'RightsPage' => [
			'default' => null,
		],
		'RightsUrl' => [
			'default' => null,
		],
		'RightsText' => [
			'default' => null,
		],
		'RightsIcon' => [
			'default' => null,
		],
		'UseCopyrightUpload' => [
			'default' => false,
		],
		'MaxCredits' => [
			'default' => 0,
		],
		'ShowCreditsIfMax' => [
			'default' => true,
		],
		'ImportSources' => [
			'default' => [
			],
			'type' => 'object',
		],
		'ImportTargetNamespace' => [
			'default' => null,
		],
		'ExportAllowHistory' => [
			'default' => true,
		],
		'ExportMaxHistory' => [
			'default' => 0,
		],
		'ExportAllowListContributors' => [
			'default' => false,
		],
		'ExportMaxLinkDepth' => [
			'default' => 0,
		],
		'ExportFromNamespaces' => [
			'default' => false,
		],
		'ExportAllowAll' => [
			'default' => false,
		],
		'ExportPagelistLimit' => [
			'default' => 5000,
		],
		'XmlDumpSchemaVersion' => [
			'default' => '0.11',
		],
		'WikiFarmSettingsDirectory' => [
			'default' => null,
		],
		'WikiFarmSettingsExtension' => [
			'default' => 'yaml',
		],
		'WikiFarmSiteDetector' => [
			'default' => null,
		],
		'ExtensionFunctions' => [
			'default' => [
			],
			'type' => 'array',
		],
		'ExtensionMessagesFiles' => [
			'default' => [
			],
			'type' => 'object',
		],
		'MessagesDirs' => [
			'default' => [
			],
			'type' => 'object',
		],
		'ExtensionEntryPointListFiles' => [
			'default' => [
			],
			'type' => 'object',
		],
		'ParserOutputHooks' => [
			'default' => [
			],
			'type' => 'object',
		],
		'EnableParserLimitReporting' => [
			'default' => true,
		],
		'ValidSkinNames' => [
			'default' => [
			],
			'type' => 'object',
		],
		'SpecialPages' => [
			'default' => [
			],
			'type' => 'object',
		],
		'AutoloadAttemptLowercase' => [
			'default' => false,
		],
		'ExtensionCredits' => [
			'default' => [
			],
			'type' => 'object',
		],
		'Hooks' => [
			'default' => [
			],
			'type' => 'object',
			'mergeStrategy' => 'array_merge_recursive',
		],
		'ServiceWiringFiles' => [
			'default' => [
			],
			'type' => 'array',
		],
		'JobClasses' => [
			'default' => [
				'deletePage' => 'DeletePageJob',
				'refreshLinks' => 'RefreshLinksJob',
				'deleteLinks' => 'DeleteLinksJob',
				'htmlCacheUpdate' => 'HTMLCacheUpdateJob',
				'sendMail' => 'EmaillingJob',
				'enotifNotify' => 'EnotifNotifyJob',
				'fixDoubleRedirect' => 'DoubleRedirectJob',
				'AssembleUploadChunks' => 'AssembleUploadChunksJob',
				'PublishStashedFile' => 'PublishStashedFileJob',
				'ThumbnailRender' => 'ThumbnailRenderJob',
				'recentChangesUpdate' => 'RecentChangesUpdateJob',
				'refreshLinksPrioritized' => 'RefreshLinksJob',
				'refreshLinksDynamic' => 'RefreshLinksJob',
				'activityUpdateJob' => 'ActivityUpdateJob',
				'categoryMembershipChange' => 'CategoryMembershipChangeJob',
				'clearUserWatchlist' => 'ClearUserWatchlistJob',
				'watchlistExpiry' => 'WatchlistExpiryJob',
				'cdnPurge' => 'CdnPurgeJob',
				'userGroupExpiry' => 'UserGroupExpiryJob',
				'clearWatchlistNotifications' => 'ClearWatchlistNotificationsJob',
				'userOptionsUpdate' => 'UserOptionsUpdateJob',
				'revertedTagUpdate' => 'RevertedTagUpdateJob',
				'enqueue' => 'EnqueueJob',
				'null' => 'NullJob',
				'userEditCountInit' => 'UserEditCountInitJob',
			],
			'type' => 'object',
		],
		'JobTypesExcludedFromDefaultQueue' => [
			'default' => [
				0 => 'AssembleUploadChunks',
				1 => 'PublishStashedFile',
			],
			'type' => 'array',
		],
		'JobBackoffThrottling' => [
			'default' => [
			],
			'type' => 'array',
			'items' => [
				'type' => 'number',
			],
		],
		'JobSerialCommitThreshold' => [
			'default' => false,
			'type' => [
				0 => 'number',
				1 => 'boolean',
			],
		],
		'JobTypeConf' => [
			'default' => [
				'default' => [
					'class' => 'JobQueueDB',
					'order' => 'random',
					'claimTTL' => 3600,
				],
			],
			'type' => 'object',
		],
		'JobQueueIncludeInMaxLagFactor' => [
			'default' => false,
		],
		'SpecialPageCacheUpdates' => [
			'default' => [
				'Statistics' => [
					0 => 'SiteStatsUpdate',
					1 => 'cacheUpdate',
				],
			],
			'type' => 'object',
		],
		'PagePropLinkInvalidations' => [
			'default' => [
				'hiddencat' => 'categorylinks',
			],
			'type' => 'object',
		],
		'CategoryMagicGallery' => [
			'default' => true,
		],
		'CategoryPagingLimit' => [
			'default' => 200,
		],
		'CategoryCollation' => [
			'default' => 'uppercase',
		],
		'TempCategoryCollations' => [
			'default' => [
			],
			'type' => 'array',
		],
		'TrackingCategories' => [
			'default' => [
			],
			'type' => 'array',
		],
		'LogTypes' => [
			'default' => [
				0 => '',
				1 => 'block',
				2 => 'protect',
				3 => 'rights',
				4 => 'delete',
				5 => 'upload',
				6 => 'move',
				7 => 'import',
				8 => 'patrol',
				9 => 'merge',
				10 => 'suppress',
				11 => 'tag',
				12 => 'managetags',
				13 => 'contentmodel',
			],
			'type' => 'array',
		],
		'LogRestrictions' => [
			'default' => [
				'suppress' => 'suppressionlog',
			],
			'type' => 'object',
		],
		'FilterLogTypes' => [
			'default' => [
				'patrol' => true,
				'tag' => true,
				'newusers' => false,
			],
			'type' => 'object',
		],
		'LogNames' => [
			'default' => [
				'' => 'all-logs-page',
				'block' => 'blocklogpage',
				'protect' => 'protectlogpage',
				'rights' => 'rightslog',
				'delete' => 'dellogpage',
				'upload' => 'uploadlogpage',
				'move' => 'movelogpage',
				'import' => 'importlogpage',
				'patrol' => 'patrol-log-page',
				'merge' => 'mergelog',
				'suppress' => 'suppressionlog',
			],
			'type' => 'object',
		],
		'LogHeaders' => [
			'default' => [
				'' => 'alllogstext',
				'block' => 'blocklogtext',
				'delete' => 'dellogpagetext',
				'import' => 'importlogpagetext',
				'merge' => 'mergelogpagetext',
				'move' => 'movelogpagetext',
				'patrol' => 'patrol-log-header',
				'protect' => 'protectlogtext',
				'rights' => 'rightslogtext',
				'suppress' => 'suppressionlogtext',
				'upload' => 'uploadlogpagetext',
			],
			'type' => 'object',
		],
		'LogActions' => [
			'default' => [
			],
			'type' => 'object',
		],
		'LogActionsHandlers' => [
			'default' => [
				'block/block' => 'BlockLogFormatter',
				'block/reblock' => 'BlockLogFormatter',
				'block/unblock' => 'BlockLogFormatter',
				'contentmodel/change' => 'ContentModelLogFormatter',
				'contentmodel/new' => 'ContentModelLogFormatter',
				'delete/delete' => 'DeleteLogFormatter',
				'delete/delete_redir' => 'DeleteLogFormatter',
				'delete/delete_redir2' => 'DeleteLogFormatter',
				'delete/event' => 'DeleteLogFormatter',
				'delete/restore' => 'DeleteLogFormatter',
				'delete/revision' => 'DeleteLogFormatter',
				'import/interwiki' => 'ImportLogFormatter',
				'import/upload' => 'ImportLogFormatter',
				'managetags/activate' => 'LogFormatter',
				'managetags/create' => 'LogFormatter',
				'managetags/deactivate' => 'LogFormatter',
				'managetags/delete' => 'LogFormatter',
				'merge/merge' => 'MergeLogFormatter',
				'move/move' => 'MoveLogFormatter',
				'move/move_redir' => 'MoveLogFormatter',
				'patrol/patrol' => 'PatrolLogFormatter',
				'patrol/autopatrol' => 'PatrolLogFormatter',
				'protect/modify' => 'ProtectLogFormatter',
				'protect/move_prot' => 'ProtectLogFormatter',
				'protect/protect' => 'ProtectLogFormatter',
				'protect/unprotect' => 'ProtectLogFormatter',
				'rights/autopromote' => 'RightsLogFormatter',
				'rights/rights' => 'RightsLogFormatter',
				'suppress/block' => 'BlockLogFormatter',
				'suppress/delete' => 'DeleteLogFormatter',
				'suppress/event' => 'DeleteLogFormatter',
				'suppress/reblock' => 'BlockLogFormatter',
				'suppress/revision' => 'DeleteLogFormatter',
				'tag/update' => 'TagLogFormatter',
				'upload/overwrite' => 'UploadLogFormatter',
				'upload/revert' => 'UploadLogFormatter',
				'upload/upload' => 'UploadLogFormatter',
			],
			'type' => 'object',
		],
		'ActionFilteredLogs' => [
			'default' => [
				'block' => [
					'block' => [
						0 => 'block',
					],
					'reblock' => [
						0 => 'reblock',
					],
					'unblock' => [
						0 => 'unblock',
					],
				],
				'contentmodel' => [
					'change' => [
						0 => 'change',
					],
					'new' => [
						0 => 'new',
					],
				],
				'delete' => [
					'delete' => [
						0 => 'delete',
					],
					'delete_redir' => [
						0 => 'delete_redir',
						1 => 'delete_redir2',
					],
					'restore' => [
						0 => 'restore',
					],
					'event' => [
						0 => 'event',
					],
					'revision' => [
						0 => 'revision',
					],
				],
				'import' => [
					'interwiki' => [
						0 => 'interwiki',
					],
					'upload' => [
						0 => 'upload',
					],
				],
				'managetags' => [
					'create' => [
						0 => 'create',
					],
					'delete' => [
						0 => 'delete',
					],
					'activate' => [
						0 => 'activate',
					],
					'deactivate' => [
						0 => 'deactivate',
					],
				],
				'move' => [
					'move' => [
						0 => 'move',
					],
					'move_redir' => [
						0 => 'move_redir',
					],
				],
				'newusers' => [
					'create' => [
						0 => 'create',
						1 => 'newusers',
					],
					'create2' => [
						0 => 'create2',
					],
					'autocreate' => [
						0 => 'autocreate',
					],
					'byemail' => [
						0 => 'byemail',
					],
				],
				'protect' => [
					'protect' => [
						0 => 'protect',
					],
					'modify' => [
						0 => 'modify',
					],
					'unprotect' => [
						0 => 'unprotect',
					],
					'move_prot' => [
						0 => 'move_prot',
					],
				],
				'rights' => [
					'rights' => [
						0 => 'rights',
					],
					'autopromote' => [
						0 => 'autopromote',
					],
				],
				'suppress' => [
					'event' => [
						0 => 'event',
					],
					'revision' => [
						0 => 'revision',
					],
					'delete' => [
						0 => 'delete',
					],
					'block' => [
						0 => 'block',
					],
					'reblock' => [
						0 => 'reblock',
					],
				],
				'upload' => [
					'upload' => [
						0 => 'upload',
					],
					'overwrite' => [
						0 => 'overwrite',
					],
					'revert' => [
						0 => 'revert',
					],
				],
			],
			'type' => 'object',
		],
		'NewUserLog' => [
			'default' => true,
		],
		'PageCreationLog' => [
			'default' => true,
		],
		'AllowSpecialInclusion' => [
			'default' => true,
		],
		'DisableQueryPageUpdate' => [
			'default' => false,
		],
		'CountCategorizedImagesAsUsed' => [
			'default' => false,
		],
		'MaxRedirectLinksRetrieved' => [
			'default' => 500,
		],
		'RangeContributionsCIDRLimit' => [
			'default' => [
				'IPv4' => 16,
				'IPv6' => 32,
			],
			'type' => 'object',
			'additionalProperties' => [
				'type' => 'integer',
			],
		],
		'Actions' => [
			'default' => [
			],
			'type' => 'object',
		],
		'DefaultRobotPolicy' => [
			'default' => 'index,follow',
		],
		'NamespaceRobotPolicies' => [
			'default' => [
			],
			'type' => 'object',
		],
		'ArticleRobotPolicies' => [
			'default' => [
			],
			'type' => 'object',
		],
		'ExemptFromUserRobotsControl' => [
			'default' => null,
			'type' => [
				0 => 'null',
				1 => 'array',
			],
		],
		'DebugAPI' => [
			'default' => false,
		],
		'APIModules' => [
			'default' => [
			],
			'type' => 'object',
		],
		'APIFormatModules' => [
			'default' => [
			],
			'type' => 'object',
		],
		'APIMetaModules' => [
			'default' => [
			],
			'type' => 'object',
		],
		'APIPropModules' => [
			'default' => [
			],
			'type' => 'object',
		],
		'APIListModules' => [
			'default' => [
			],
			'type' => 'object',
		],
		'APIMaxDBRows' => [
			'default' => 5000,
		],
		'APIMaxResultSize' => [
			'default' => 8388608,
		],
		'APIMaxUncachedDiffs' => [
			'default' => 1,
		],
		'APIMaxLagThreshold' => [
			'default' => 7,
		],
		'APIRequestLog' => [
			'default' => false,
		],
		'APICacheHelpTimeout' => [
			'default' => 3600,
		],
		'APIUselessQueryPages' => [
			'default' => [
				0 => 'MIMEsearch',
				1 => 'LinkSearch',
			],
			'type' => 'array',
		],
		'AjaxUploadDestCheck' => [
			'default' => true,
		],
		'AjaxLicensePreview' => [
			'default' => true,
		],
		'CrossSiteAJAXdomains' => [
			'default' => [
			],
			'type' => 'object',
		],
		'CrossSiteAJAXdomainExceptions' => [
			'default' => [
			],
			'type' => 'object',
		],
		'AllowedCorsHeaders' => [
			'default' => [
				0 => 'Accept',
				1 => 'Accept-Language',
				2 => 'Content-Language',
				3 => 'Content-Type',
				4 => 'Accept-Encoding',
				5 => 'DNT',
				6 => 'Origin',
				7 => 'User-Agent',
				8 => 'Api-User-Agent',
				9 => 'Access-Control-Max-Age',
			],
			'type' => 'array',
		],
		'RestAPIAdditionalRouteFiles' => [
			'default' => [
			],
			'type' => 'array',
		],
		'MaxShellMemory' => [
			'default' => 307200,
		],
		'MaxShellFileSize' => [
			'default' => 102400,
		],
		'MaxShellTime' => [
			'default' => 180,
		],
		'MaxShellWallClockTime' => [
			'default' => 180,
		],
		'ShellCgroup' => [
			'default' => false,
		],
		'PhpCli' => [
			'default' => '/usr/bin/php',
		],
		'ShellRestrictionMethod' => [
			'default' => 'autodetect',
			'type' => [
				0 => 'string',
				1 => 'boolean',
			],
		],
		'ShellboxUrl' => [
			'default' => null,
		],
		'ShellboxUrls' => [
			'default' => [
				'default' => null,
			],
			'type' => 'object',
			'additionalProperies' => [
				'type' => [
					0 => 'string',
					1 => 'boolean',
					2 => null,
				],
			],
		],
		'ShellboxSecretKey' => [
			'default' => null,
			'type' => [
				0 => 'string',
				1 => 'null',
			],
		],
		'HTTPTimeout' => [
			'default' => 25,
			'type' => 'number',
		],
		'HTTPConnectTimeout' => [
			'default' => 5,
			'type' => 'number',
		],
		'HTTPMaxTimeout' => [
			'default' => 0,
			'type' => 'number',
		],
		'HTTPMaxConnectTimeout' => [
			'default' => 0,
			'type' => 'number',
		],
		'HTTPImportTimeout' => [
			'default' => 25,
		],
		'AsyncHTTPTimeout' => [
			'default' => 25,
		],
		'HTTPProxy' => [
			'default' => '',
		],
		'LocalVirtualHosts' => [
			'default' => [
			],
			'type' => 'object',
		],
		'LocalHTTPProxy' => [
			'default' => false,
			'type' => [
				0 => 'string',
				1 => 'boolean',
			],
		],
		'AllowExternalReqID' => [
			'default' => false,
		],
		'JobRunRate' => [
			'default' => 1,
		],
		'RunJobsAsync' => [
			'default' => false,
		],
		'UpdateRowsPerJob' => [
			'default' => 300,
		],
		'UpdateRowsPerQuery' => [
			'default' => 100,
		],
		'RedirectOnLogin' => [
			'default' => null,
		],
		'VirtualRestConfig' => [
			'default' => [
				'paths' => [
				],
				'modules' => [
				],
				'global' => [
					'timeout' => 360,
					'forwardCookies' => false,
					'HTTPProxy' => null,
				],
			],
			'mergeStrategy' => 'array_plus_2d',
			'type' => 'object',
		],
		'EventRelayerConfig' => [
			'default' => [
				'default' => [
					'class' => 'EventRelayerNull',
				],
			],
			'type' => 'object',
		],
		'Pingback' => [
			'default' => false,
			'type' => 'boolean',
		],
		'OriginTrials' => [
			'default' => [
			],
			'type' => 'array',
		],
		'PriorityHints' => [
			'default' => false,
			'type' => 'boolean',
		],
		'PriorityHintsRatio' => [
			'default' => 1.0,
			'type' => 'number',
		],
		'ElementTiming' => [
			'default' => false,
			'type' => 'boolean',
		],
		'ReportToExpiry' => [
			'default' => 86400,
			'type' => 'integer',
		],
		'ReportToEndpoints' => [
			'default' => [
			],
			'type' => 'array',
		],
		'FeaturePolicyReportOnly' => [
			'default' => [
			],
			'type' => 'array',
		],
		'SkinsPreferred' => [
			'default' => [
				0 => 'vector-2022',
				1 => 'vector',
			],
			'type' => 'array',
		],
	],
];
