"use strict";

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
module.exports = {
  rootDir: '../',
  setupFiles: ['<rootDir>/test/polyfills.ts', '<rootDir>/test/setupTests.ts'],
  setupFilesAfterEnv: ['<rootDir>/test/setup.jest.ts'],
  roots: ['<rootDir>'],
  coverageDirectory: './coverage',
  moduleNameMapper: {
    '\\.(css|less|scss)$': '<rootDir>/test/mocks/styleMock.ts'
  },
  testEnvironment: 'jest-environment-jsdom',
  coverageReporters: ['lcov', 'text', 'cobertura'],
  testMatch: ['**/*.test.js', '**/*.test.jsx', '**/*.test.ts', '**/*.test.tsx'],
  collectCoverageFrom: ['**/*.ts', '**/*.tsx', '**/*.js', '**/*.jsx', '!**/models/**', '!**/node_modules/**', '!**/index.js', '!<rootDir>/public/app.js', '!<rootDir>/index.js', '!<rootDir>/babel.config.js', '!<rootDir>/test/**', '!<rootDir>/server/**', '!<rootDir>/coverage/**', '!<rootDir>/scripts/**', '!<rootDir>/build/**', '!**/vendor/**'],
  clearMocks: true,
  modulePathIgnorePatterns: ['<rootDir>/offline-module-cache/'],
  testPathIgnorePatterns: ['<rootDir>/build/', '<rootDir>/node_modules/'],
  transformIgnorePatterns: ['<rootDir>/node_modules']
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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