/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import org.apache.catalina.Globals;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.core.StandardContext;
import org.apache.tomcat.util.descriptor.web.FilterMap;

public final class ApplicationFilterFactory {
    private ApplicationFilterFactory() {
    }

    public static ApplicationFilterChain createFilterChain(ServletRequest servletRequest, Wrapper wrapper, Servlet servlet) {
        ApplicationFilterConfig applicationFilterConfig;
        Object object;
        if (servlet == null) {
            return null;
        }
        ApplicationFilterChain applicationFilterChain = null;
        if (servletRequest instanceof Request) {
            object = (Request)servletRequest;
            if (Globals.IS_SECURITY_ENABLED) {
                applicationFilterChain = new ApplicationFilterChain();
            } else {
                applicationFilterChain = (ApplicationFilterChain)((Request)object).getFilterChain();
                if (applicationFilterChain == null) {
                    applicationFilterChain = new ApplicationFilterChain();
                    ((Request)object).setFilterChain(applicationFilterChain);
                }
            }
        } else {
            applicationFilterChain = new ApplicationFilterChain();
        }
        applicationFilterChain.setServlet(servlet);
        applicationFilterChain.setServletSupportsAsync(wrapper.isAsyncSupported());
        object = (StandardContext)wrapper.getParent();
        FilterMap[] filterMapArray = ((StandardContext)object).findFilterMaps();
        if (filterMapArray == null || filterMapArray.length == 0) {
            return applicationFilterChain;
        }
        DispatcherType dispatcherType = (DispatcherType)servletRequest.getAttribute("org.apache.catalina.core.DISPATCHER_TYPE");
        String string = null;
        Object object2 = servletRequest.getAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH");
        if (object2 != null) {
            string = object2.toString();
        }
        String string2 = wrapper.getName();
        for (FilterMap filterMap : filterMapArray) {
            if (!ApplicationFilterFactory.matchDispatcher(filterMap, dispatcherType) || !ApplicationFilterFactory.matchFiltersURL(filterMap, string) || (applicationFilterConfig = (ApplicationFilterConfig)((StandardContext)object).findFilterConfig(filterMap.getFilterName())) == null) continue;
            applicationFilterChain.addFilter(applicationFilterConfig);
        }
        for (FilterMap filterMap : filterMapArray) {
            if (!ApplicationFilterFactory.matchDispatcher(filterMap, dispatcherType) || !ApplicationFilterFactory.matchFiltersServlet(filterMap, string2) || (applicationFilterConfig = (ApplicationFilterConfig)((StandardContext)object).findFilterConfig(filterMap.getFilterName())) == null) continue;
            applicationFilterChain.addFilter(applicationFilterConfig);
        }
        return applicationFilterChain;
    }

    private static boolean matchFiltersURL(FilterMap filterMap, String string) {
        String[] stringArray;
        if (filterMap.getMatchAllUrlPatterns()) {
            return true;
        }
        if (string == null) {
            return false;
        }
        for (String string2 : stringArray = filterMap.getURLPatterns()) {
            if (!ApplicationFilterFactory.matchFiltersURL(string2, string)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchFiltersURL(String string, String string2) {
        if (string == null) {
            return false;
        }
        if (string.equals(string2)) {
            return true;
        }
        if (string.equals("/*")) {
            return true;
        }
        if (string.endsWith("/*")) {
            if (string.regionMatches(0, string2, 0, string.length() - 2)) {
                if (string2.length() == string.length() - 2) {
                    return true;
                }
                if ('/' == string2.charAt(string.length() - 2)) {
                    return true;
                }
            }
            return false;
        }
        if (string.startsWith("*.")) {
            int n = string2.lastIndexOf(47);
            int n2 = string2.lastIndexOf(46);
            if (n >= 0 && n2 > n && n2 != string2.length() - 1 && string2.length() - n2 == string.length() - 1) {
                return string.regionMatches(2, string2, n2 + 1, string.length() - 2);
            }
        }
        return false;
    }

    private static boolean matchFiltersServlet(FilterMap filterMap, String string) {
        String[] stringArray;
        if (string == null) {
            return false;
        }
        if (filterMap.getMatchAllServletNames()) {
            return true;
        }
        for (String string2 : stringArray = filterMap.getServletNames()) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchDispatcher(FilterMap filterMap, DispatcherType dispatcherType) {
        switch (dispatcherType) {
            case FORWARD: {
                if ((filterMap.getDispatcherMapping() & 2) == 0) break;
                return true;
            }
            case INCLUDE: {
                if ((filterMap.getDispatcherMapping() & 4) == 0) break;
                return true;
            }
            case REQUEST: {
                if ((filterMap.getDispatcherMapping() & 8) == 0) break;
                return true;
            }
            case ERROR: {
                if ((filterMap.getDispatcherMapping() & 1) == 0) break;
                return true;
            }
            case ASYNC: {
                if ((filterMap.getDispatcherMapping() & 0x10) == 0) break;
                return true;
            }
        }
        return false;
    }
}

