/* rygel-tracker-root-container.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-tracker-root-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-tracker3.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libtracker-sparql/tracker-sparql.h>
#include "rygel-server.h"
#include "rygel-core.h"

#define RYGEL_TRACKER_ROOT_CONTAINER_TRACKER_SERVICE "org.freedesktop.Tracker3.Miner.Files"

enum  {
	RYGEL_TRACKER_ROOT_CONTAINER_0_PROPERTY,
	RYGEL_TRACKER_ROOT_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* rygel_tracker_root_container_properties[RYGEL_TRACKER_ROOT_CONTAINER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

static gpointer rygel_tracker_root_container_parent_class = NULL;
TrackerSparqlConnection* rygel_tracker_root_container_connection = NULL;

static gboolean rygel_tracker_root_container_get_bool_config_without_error (RygelTrackerRootContainer* self,
                                                                     const gchar* key);
static void rygel_tracker_root_container_finalize (GObject * obj);
static GType rygel_tracker_root_container_get_type_once (void);

RygelTrackerRootContainer*
rygel_tracker_root_container_construct (GType object_type,
                                        const gchar* title,
                                        GError** error)
{
	RygelTrackerRootContainer * self = NULL;
	TrackerSparqlConnection* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = rygel_tracker_root_container_connection;
	if (_tmp0_ == NULL) {
		TrackerSparqlConnection* _tmp1_ = NULL;
		TrackerSparqlConnection* _tmp2_;
		TrackerSparqlConnection* _tmp3_;
		_tmp2_ = tracker_sparql_connection_bus_new (RYGEL_TRACKER_ROOT_CONTAINER_TRACKER_SERVICE, NULL, NULL, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (rygel_tracker_root_container_connection);
		rygel_tracker_root_container_connection = _tmp3_;
		_g_object_unref0 (_tmp1_);
	}
	self = (RygelTrackerRootContainer*) rygel_simple_container_construct_root (object_type, title);
	if (rygel_tracker_root_container_get_bool_config_without_error (self, "share-music")) {
		RygelTrackerMusic* _tmp4_;
		RygelTrackerMusic* _tmp5_;
		_tmp4_ = rygel_tracker_music_new ("Music", (RygelMediaContainer*) self, "Music");
		_tmp5_ = _tmp4_;
		rygel_simple_container_add_child_container ((RygelSimpleContainer*) self, (RygelMediaContainer*) _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
	if (rygel_tracker_root_container_get_bool_config_without_error (self, "share-videos")) {
		RygelTrackerVideos* _tmp6_;
		RygelTrackerVideos* _tmp7_;
		_tmp6_ = rygel_tracker_videos_new ("Videos", (RygelMediaContainer*) self, "Videos");
		_tmp7_ = _tmp6_;
		rygel_simple_container_add_child_container ((RygelSimpleContainer*) self, (RygelMediaContainer*) _tmp7_);
		_g_object_unref0 (_tmp7_);
	}
	if (rygel_tracker_root_container_get_bool_config_without_error (self, "share-pictures")) {
		RygelTrackerPictures* _tmp8_;
		RygelTrackerPictures* _tmp9_;
		_tmp8_ = rygel_tracker_pictures_new ("Pictures", (RygelMediaContainer*) self, "Pictures");
		_tmp9_ = _tmp8_;
		rygel_simple_container_add_child_container ((RygelSimpleContainer*) self, (RygelMediaContainer*) _tmp9_);
		_g_object_unref0 (_tmp9_);
	}
	return self;
}

RygelTrackerRootContainer*
rygel_tracker_root_container_new (const gchar* title,
                                  GError** error)
{
	return rygel_tracker_root_container_construct (RYGEL_TRACKER_TYPE_ROOT_CONTAINER, title, error);
}

static gboolean
rygel_tracker_root_container_get_bool_config_without_error (RygelTrackerRootContainer* self,
                                                            const gchar* key)
{
	gboolean value = FALSE;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	value = TRUE;
	_tmp0_ = rygel_meta_config_get_default ();
	config = _tmp0_;
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = rygel_configuration_get_bool ((RygelConfiguration*) config, "Tracker3", key, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		value = _tmp1_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp2_;
	}
	result = value;
	_g_object_unref0 (config);
	return result;
}

static void
rygel_tracker_root_container_class_init (RygelTrackerRootContainerClass * klass,
                                         gpointer klass_data)
{
	rygel_tracker_root_container_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_tracker_root_container_finalize;
}

static void
rygel_tracker_root_container_instance_init (RygelTrackerRootContainer * self,
                                            gpointer klass)
{
}

static void
rygel_tracker_root_container_finalize (GObject * obj)
{
	RygelTrackerRootContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TRACKER_TYPE_ROOT_CONTAINER, RygelTrackerRootContainer);
	G_OBJECT_CLASS (rygel_tracker_root_container_parent_class)->finalize (obj);
}

/**
 * Represents the root container for Tracker media content hierarchy.
 */
static GType
rygel_tracker_root_container_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerRootContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_root_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerRootContainer), 0, (GInstanceInitFunc) rygel_tracker_root_container_instance_init, NULL };
	GType rygel_tracker_root_container_type_id;
	rygel_tracker_root_container_type_id = g_type_register_static (RYGEL_TYPE_SIMPLE_CONTAINER, "RygelTrackerRootContainer", &g_define_type_info, 0);
	return rygel_tracker_root_container_type_id;
}

GType
rygel_tracker_root_container_get_type (void)
{
	static volatile gsize rygel_tracker_root_container_type_id__once = 0;
	if (g_once_init_enter (&rygel_tracker_root_container_type_id__once)) {
		GType rygel_tracker_root_container_type_id;
		rygel_tracker_root_container_type_id = rygel_tracker_root_container_get_type_once ();
		g_once_init_leave (&rygel_tracker_root_container_type_id__once, rygel_tracker_root_container_type_id);
	}
	return rygel_tracker_root_container_type_id__once;
}

