/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import org.apache.tomcat.util.bcel.classfile.Constant;
import org.apache.tomcat.util.bcel.classfile.ConstantClass;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.ConstantUtf8;

final class Utility {
    private Utility() {
    }

    static String compactClassName(String string) {
        return string.replace('/', '.');
    }

    static String getClassName(ConstantPool constantPool, int n) {
        Constant constant = constantPool.getConstant(n, (byte)7);
        int n2 = ((ConstantClass)constant).getNameIndex();
        constant = constantPool.getConstant(n2, (byte)1);
        String string = ((ConstantUtf8)constant).getBytes();
        return Utility.compactClassName(string);
    }

    static void skipFully(DataInput dataInput, int n) throws IOException {
        int n2 = dataInput.skipBytes(n);
        if (n2 != n) {
            throw new EOFException();
        }
    }

    static void swallowAttribute(DataInput dataInput) throws IOException {
        Utility.skipFully(dataInput, 2);
        int n = dataInput.readInt();
        Utility.skipFully(dataInput, n);
    }
}

