/// <reference types="node" />
import { OAuth2Client, JWT, Compute, UserRefreshClient, BaseExternalAccountClient, GaxiosPromise, GoogleConfigurable, MethodOptions, StreamMethodOptions, GlobalOptions, GoogleAuth, BodyResponseCallback, APIRequestContext } from 'googleapis-common';
import { Readable } from 'stream';
export declare namespace chat_v1 {
    export interface Options extends GlobalOptions {
        version: 'v1';
    }
    interface StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient | BaseExternalAccountClient | GoogleAuth;
        /**
         * V1 error format.
         */
        '$.xgafv'?: string;
        /**
         * OAuth access token.
         */
        access_token?: string;
        /**
         * Data format for response.
         */
        alt?: string;
        /**
         * JSONP
         */
        callback?: string;
        /**
         * Selector specifying which fields to include in a partial response.
         */
        fields?: string;
        /**
         * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
         */
        key?: string;
        /**
         * OAuth 2.0 token for the current user.
         */
        oauth_token?: string;
        /**
         * Returns response with indentations and line breaks.
         */
        prettyPrint?: boolean;
        /**
         * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
         */
        quotaUser?: string;
        /**
         * Legacy upload protocol for media (e.g. "media", "multipart").
         */
        uploadType?: string;
        /**
         * Upload protocol for media (e.g. "raw", "multipart").
         */
        upload_protocol?: string;
    }
    /**
     * Google Chat API
     *
     * Enables bots to fetch information and perform actions in Google Chat.
     *
     * @example
     * ```js
     * const {google} = require('googleapis');
     * const chat = google.chat('v1');
     * ```
     */
    export class Chat {
        context: APIRequestContext;
        dms: Resource$Dms;
        media: Resource$Media;
        rooms: Resource$Rooms;
        spaces: Resource$Spaces;
        constructor(options: GlobalOptions, google?: GoogleConfigurable);
    }
    /**
     * List of string parameters to supply when the action method is invoked. For example, consider three snooze buttons: snooze now, snooze 1 day, snooze next week. You might use action method = snooze(), passing the snooze type and snooze time in the list of string parameters.
     */
    export interface Schema$ActionParameter {
        /**
         * The name of the parameter for the action script.
         */
        key?: string | null;
        /**
         * The value of the parameter.
         */
        value?: string | null;
    }
    /**
     * Parameters that a bot can use to configure how it's response is posted.
     */
    export interface Schema$ActionResponse {
        /**
         * The type of bot response.
         */
        type?: string | null;
        /**
         * URL for users to auth or config. (Only for REQUEST_CONFIG response types.)
         */
        url?: string | null;
    }
    /**
     * Annotations associated with the plain-text body of the message. Example plain-text message body: ``` Hello @FooBot how are you!" ``` The corresponding annotations metadata: ``` "annotations":[{ "type":"USER_MENTION", "startIndex":6, "length":7, "userMention": { "user": { "name":"users/107946847022116401880", "displayName":"FooBot", "avatarUrl":"https://goo.gl/aeDtrS", "type":"BOT" \}, "type":"MENTION" \} \}] ```
     */
    export interface Schema$Annotation {
        /**
         * Length of the substring in the plain-text message body this annotation corresponds to.
         */
        length?: number | null;
        /**
         * The metadata for a slash command.
         */
        slashCommand?: Schema$SlashCommandMetadata;
        /**
         * Start index (0-based, inclusive) in the plain-text message body this annotation corresponds to.
         */
        startIndex?: number | null;
        /**
         * The type of this annotation.
         */
        type?: string | null;
        /**
         * The metadata of user mention.
         */
        userMention?: Schema$UserMentionMetadata;
    }
    /**
     * An attachment in Hangouts Chat.
     */
    export interface Schema$Attachment {
        /**
         * A reference to the attachment data. This is used with the media API to download the attachment data.
         */
        attachmentDataRef?: Schema$AttachmentDataRef;
        /**
         * The original file name for the content, not the full path.
         */
        contentName?: string | null;
        /**
         * The content type (MIME type) of the file.
         */
        contentType?: string | null;
        /**
         * Output only. The download URL which should be used to allow a human user to download the attachment. Bots should not use this URL to download attachment content.
         */
        downloadUri?: string | null;
        /**
         * A reference to the drive attachment. This is used with the Drive API.
         */
        driveDataRef?: Schema$DriveDataRef;
        /**
         * Resource name of the attachment, in the form "spaces/x/messages/x/attachments/x".
         */
        name?: string | null;
        /**
         * The source of the attachment.
         */
        source?: string | null;
        /**
         * Output only. The thumbnail URL which should be used to preview the attachment to a human user. Bots should not use this URL to download attachment content.
         */
        thumbnailUri?: string | null;
    }
    /**
     * A reference to the data of an attachment.
     */
    export interface Schema$AttachmentDataRef {
        /**
         * The resource name of the attachment data. This is used with the media API to download the attachment data.
         */
        resourceName?: string | null;
    }
    /**
     * A button. Can be a text button or an image button.
     */
    export interface Schema$Button {
        /**
         * A button with image and onclick action.
         */
        imageButton?: Schema$ImageButton;
        /**
         * A button with text and onclick action.
         */
        textButton?: Schema$TextButton;
    }
    /**
     * A card is a UI element that can contain UI widgets such as texts, images.
     */
    export interface Schema$Card {
        /**
         * The actions of this card.
         */
        cardActions?: Schema$CardAction[];
        /**
         * The header of the card. A header usually contains a title and an image.
         */
        header?: Schema$CardHeader;
        /**
         * Name of the card.
         */
        name?: string | null;
        /**
         * Sections are separated by a line divider.
         */
        sections?: Schema$Section[];
    }
    /**
     * A card action is the action associated with the card. For an invoice card, a typical action would be: delete invoice, email invoice or open the invoice in browser.
     */
    export interface Schema$CardAction {
        /**
         * The label used to be displayed in the action menu item.
         */
        actionLabel?: string | null;
        /**
         * The onclick action for this action item.
         */
        onClick?: Schema$OnClick;
    }
    export interface Schema$CardHeader {
        /**
         * The image's type (e.g. square border or circular border).
         */
        imageStyle?: string | null;
        /**
         * The URL of the image in the card header.
         */
        imageUrl?: string | null;
        /**
         * The subtitle of the card header.
         */
        subtitle?: string | null;
        /**
         * The title must be specified. The header has a fixed height: if both a title and subtitle is specified, each will take up 1 line. If only the title is specified, it will take up both lines.
         */
        title?: string | null;
    }
    /**
     * Google Chat events.
     */
    export interface Schema$DeprecatedEvent {
        /**
         * The form action data associated with an interactive card that was clicked. Only populated for CARD_CLICKED events. See the [Interactive Cards guide](/hangouts/chat/how-tos/cards-onclick) for more information.
         */
        action?: Schema$FormAction;
        /**
         * The URL the bot should redirect the user to after they have completed an authorization or configuration flow outside of Google Chat. See the [Authorizing access to 3p services guide](/hangouts/chat/how-tos/auth-3p) for more information.
         */
        configCompleteRedirectUrl?: string | null;
        /**
         * The timestamp indicating when the event was dispatched.
         */
        eventTime?: string | null;
        /**
         * The message that triggered the event, if applicable.
         */
        message?: Schema$Message;
        /**
         * The room or DM in which the event occurred.
         */
        space?: Schema$Space;
        /**
         * The bot-defined key for the thread related to the event. See the thread_key field of the `spaces.message.create` request for more information.
         */
        threadKey?: string | null;
        /**
         * A secret value that bots can use to verify if a request is from Google. The token is randomly generated by Google, remains static, and can be obtained from the Google Chat API configuration page in the Cloud Console. Developers can revoke/regenerate it if needed from the same page.
         */
        token?: string | null;
        /**
         * The type of the event.
         */
        type?: string | null;
        /**
         * The user that triggered the event.
         */
        user?: Schema$User;
    }
    /**
     * A reference to the data of a drive attachment.
     */
    export interface Schema$DriveDataRef {
        /**
         * The id for the drive file, for use with the Drive API.
         */
        driveFileId?: string | null;
    }
    /**
     * A generic empty message that you can re-use to avoid defining duplicated empty messages in your APIs. A typical example is to use it as the request or the response type of an API method. For instance: service Foo { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); \} The JSON representation for `Empty` is empty JSON object `{\}`.
     */
    export interface Schema$Empty {
    }
    /**
     * A form action describes the behavior when the form is submitted. For example, an Apps Script can be invoked to handle the form.
     */
    export interface Schema$FormAction {
        /**
         * The method name is used to identify which part of the form triggered the form submission. This information is echoed back to the bot as part of the card click event. The same method name can be used for several elements that trigger a common behavior if desired.
         */
        actionMethodName?: string | null;
        /**
         * List of action parameters.
         */
        parameters?: Schema$ActionParameter[];
    }
    /**
     * An image that is specified by a URL and can have an onclick action.
     */
    export interface Schema$Image {
        /**
         * The aspect ratio of this image (width/height). This field allows clients to reserve the right height for the image while waiting for it to load. It's not meant to override the native aspect ratio of the image. If unset, the server fills it by prefetching the image.
         */
        aspectRatio?: number | null;
        /**
         * The URL of the image.
         */
        imageUrl?: string | null;
        /**
         * The onclick action.
         */
        onClick?: Schema$OnClick;
    }
    /**
     * An image button with an onclick action.
     */
    export interface Schema$ImageButton {
        /**
         * The icon specified by an enum that indices to an icon provided by Chat API.
         */
        icon?: string | null;
        /**
         * The icon specified by a URL.
         */
        iconUrl?: string | null;
        /**
         * The name of this image_button which will be used for accessibility. Default value will be provided if developers don't specify.
         */
        name?: string | null;
        /**
         * The onclick action.
         */
        onClick?: Schema$OnClick;
    }
    /**
     * A UI element contains a key (label) and a value (content). And this element may also contain some actions such as onclick button.
     */
    export interface Schema$KeyValue {
        /**
         * The text of the bottom label. Formatted text supported.
         */
        bottomLabel?: string | null;
        /**
         * A button that can be clicked to trigger an action.
         */
        button?: Schema$Button;
        /**
         * The text of the content. Formatted text supported and always required.
         */
        content?: string | null;
        /**
         * If the content should be multiline.
         */
        contentMultiline?: boolean | null;
        /**
         * An enum value that will be replaced by the Chat API with the corresponding icon image.
         */
        icon?: string | null;
        /**
         * The icon specified by a URL.
         */
        iconUrl?: string | null;
        /**
         * The onclick action. Only the top label, bottom label and content region are clickable.
         */
        onClick?: Schema$OnClick;
        /**
         * The text of the top label. Formatted text supported.
         */
        topLabel?: string | null;
    }
    export interface Schema$ListMembershipsResponse {
        /**
         * List of memberships in the requested (or first) page.
         */
        memberships?: Schema$Membership[];
        /**
         * Continuation token to retrieve the next page of results. It will be empty for the last page of results.
         */
        nextPageToken?: string | null;
    }
    export interface Schema$ListSpacesResponse {
        /**
         * Continuation token to retrieve the next page of results. It will be empty for the last page of results. Tokens expire in an hour. An error is thrown if an expired token is passed.
         */
        nextPageToken?: string | null;
        /**
         * List of spaces in the requested (or first) page.
         */
        spaces?: Schema$Space[];
    }
    /**
     * Media resource.
     */
    export interface Schema$Media {
        /**
         * Name of the media resource.
         */
        resourceName?: string | null;
    }
    /**
     * Represents a membership relation in Hangouts Chat.
     */
    export interface Schema$Membership {
        /**
         * The creation time of the membership a.k.a the time at which the member joined the space, if applicable.
         */
        createTime?: string | null;
        /**
         * A User in Hangout Chat
         */
        member?: Schema$User;
        name?: string | null;
        /**
         * State of the membership.
         */
        state?: string | null;
    }
    /**
     * A message in Hangouts Chat.
     */
    export interface Schema$Message {
        /**
         * Input only. Parameters that a bot can use to configure how its response is posted.
         */
        actionResponse?: Schema$ActionResponse;
        /**
         * Output only. Annotations associated with the text in this message.
         */
        annotations?: Schema$Annotation[];
        /**
         * Plain-text body of the message with all bot mentions stripped out.
         */
        argumentText?: string | null;
        /**
         * User uploaded attachment.
         */
        attachment?: Schema$Attachment[];
        /**
         * Rich, formatted and interactive cards that can be used to display UI elements such as: formatted texts, buttons, clickable images. Cards are normally displayed below the plain-text body of the message.
         */
        cards?: Schema$Card[];
        /**
         * Output only. The time at which the message was created in Hangouts Chat server.
         */
        createTime?: string | null;
        /**
         * A plain-text description of the message's cards, used when the actual cards cannot be displayed (e.g. mobile notifications).
         */
        fallbackText?: string | null;
        name?: string | null;
        /**
         * Text for generating preview chips. This text will not be displayed to the user, but any links to images, web pages, videos, etc. included here will generate preview chips.
         */
        previewText?: string | null;
        /**
         * The user who created the message.
         */
        sender?: Schema$User;
        /**
         * Slash command information, if applicable.
         */
        slashCommand?: Schema$SlashCommand;
        /**
         * The space the message belongs to.
         */
        space?: Schema$Space;
        /**
         * Plain-text body of the message.
         */
        text?: string | null;
        /**
         * The thread the message belongs to.
         */
        thread?: Schema$Thread;
    }
    /**
     * An onclick action (e.g. open a link).
     */
    export interface Schema$OnClick {
        /**
         * A form action will be triggered by this onclick if specified.
         */
        action?: Schema$FormAction;
        /**
         * This onclick triggers an open link action if specified.
         */
        openLink?: Schema$OpenLink;
    }
    /**
     * A link that opens a new window.
     */
    export interface Schema$OpenLink {
        /**
         * The URL to open.
         */
        url?: string | null;
    }
    /**
     * A section contains a collection of widgets that are rendered (vertically) in the order that they are specified. Across all platforms, cards have a narrow fixed width, so there is currently no need for layout properties (e.g. float).
     */
    export interface Schema$Section {
        /**
         * The header of the section, text formatted supported.
         */
        header?: string | null;
        /**
         * A section must contain at least 1 widget.
         */
        widgets?: Schema$WidgetMarkup[];
    }
    /**
     * A Slash Command in Chat.
     */
    export interface Schema$SlashCommand {
        /**
         * The id of the slash command invoked.
         */
        commandId?: string | null;
    }
    /**
     * Annotation metadata for slash commands (/).
     */
    export interface Schema$SlashCommandMetadata {
        /**
         * The bot whose command was invoked.
         */
        bot?: Schema$User;
        /**
         * The command id of the invoked slash command.
         */
        commandId?: string | null;
        /**
         * The name of the invoked slash command.
         */
        commandName?: string | null;
        /**
         * Indicating whether the slash command is for a dialog.
         */
        triggersDialog?: boolean | null;
        /**
         * The type of slash command.
         */
        type?: string | null;
    }
    /**
     * A room or DM in Hangouts Chat.
     */
    export interface Schema$Space {
        /**
         * Output only. The display name (only if the space is a room). Please note that this field might not be populated in direct messages between humans.
         */
        displayName?: string | null;
        /**
         * Resource name of the space, in the form "spaces/x". Example: spaces/AAAAMpdlehYs
         */
        name?: string | null;
        /**
         * Whether the space is a DM between a bot and a single human.
         */
        singleUserBotDm?: boolean | null;
        /**
         * Whether the messages are threaded in this space.
         */
        threaded?: boolean | null;
        /**
         * Output only. The type of a space. This is deprecated. Use `single_user_bot_dm` instead.
         */
        type?: string | null;
    }
    /**
     * A button with text and onclick action.
     */
    export interface Schema$TextButton {
        /**
         * The onclick action of the button.
         */
        onClick?: Schema$OnClick;
        /**
         * The text of the button.
         */
        text?: string | null;
    }
    /**
     * A paragraph of text. Formatted text supported.
     */
    export interface Schema$TextParagraph {
        text?: string | null;
    }
    /**
     * A thread in Hangouts Chat.
     */
    export interface Schema$Thread {
        /**
         * Resource name, in the form "spaces/x/threads/x". Example: spaces/AAAAMpdlehY/threads/UMxbHmzDlr4
         */
        name?: string | null;
    }
    /**
     * A user in Google Chat.
     */
    export interface Schema$User {
        /**
         * The user's display name.
         */
        displayName?: string | null;
        /**
         * Obfuscated domain information.
         */
        domainId?: string | null;
        /**
         * True when the user is deleted or the user's profile is not visible.
         */
        isAnonymous?: boolean | null;
        /**
         * Resource name, in the format "users/x".
         */
        name?: string | null;
        /**
         * User type.
         */
        type?: string | null;
    }
    /**
     * Annotation metadata for user mentions (@).
     */
    export interface Schema$UserMentionMetadata {
        /**
         * The type of user mention.
         */
        type?: string | null;
        /**
         * The user mentioned.
         */
        user?: Schema$User;
    }
    /**
     * A widget is a UI element that presents texts, images, etc.
     */
    export interface Schema$WidgetMarkup {
        /**
         * A list of buttons. Buttons is also oneof data and only one of these fields should be set.
         */
        buttons?: Schema$Button[];
        /**
         * Display an image in this widget.
         */
        image?: Schema$Image;
        /**
         * Display a key value item in this widget.
         */
        keyValue?: Schema$KeyValue;
        /**
         * Display a text paragraph in this widget.
         */
        textParagraph?: Schema$TextParagraph;
    }
    export class Resource$Dms {
        context: APIRequestContext;
        conversations: Resource$Dms$Conversations;
        constructor(context: APIRequestContext);
        /**
         * Legacy path for creating message. Calling these will result in a BadRequest response.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/chat.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const chat = google.chat('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await chat.dms.messages({
         *     // Required. Space resource name, in the form "spaces/x". Example: spaces/AAAAMpdlehY
         *     parent: 'dms/my-dm',
         *     // Opaque thread identifier string that can be specified to group messages into a single thread. If this is the first message with a given thread identifier, a new thread is created. Subsequent messages with the same thread identifier will be posted into the same thread. This relieves bots and webhooks from having to store the Hangouts Chat thread ID of a thread (created earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an existing thread, is set in message.
         *     threadKey: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "actionResponse": {},
         *       //   "annotations": [],
         *       //   "argumentText": "my_argumentText",
         *       //   "attachment": [],
         *       //   "cards": [],
         *       //   "createTime": "my_createTime",
         *       //   "fallbackText": "my_fallbackText",
         *       //   "name": "my_name",
         *       //   "previewText": "my_previewText",
         *       //   "sender": {},
         *       //   "slashCommand": {},
         *       //   "space": {},
         *       //   "text": "my_text",
         *       //   "thread": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "actionResponse": {},
         *   //   "annotations": [],
         *   //   "argumentText": "my_argumentText",
         *   //   "attachment": [],
         *   //   "cards": [],
         *   //   "createTime": "my_createTime",
         *   //   "fallbackText": "my_fallbackText",
         *   //   "name": "my_name",
         *   //   "previewText": "my_previewText",
         *   //   "sender": {},
         *   //   "slashCommand": {},
         *   //   "space": {},
         *   //   "text": "my_text",
         *   //   "thread": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        messages(params: Params$Resource$Dms$Messages, options: StreamMethodOptions): GaxiosPromise<Readable>;
        messages(params?: Params$Resource$Dms$Messages, options?: MethodOptions): GaxiosPromise<Schema$Message>;
        messages(params: Params$Resource$Dms$Messages, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        messages(params: Params$Resource$Dms$Messages, options: MethodOptions | BodyResponseCallback<Schema$Message>, callback: BodyResponseCallback<Schema$Message>): void;
        messages(params: Params$Resource$Dms$Messages, callback: BodyResponseCallback<Schema$Message>): void;
        messages(callback: BodyResponseCallback<Schema$Message>): void;
        /**
         * Legacy path for creating message. Calling these will result in a BadRequest response.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/chat.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const chat = google.chat('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await chat.dms.webhooks({
         *     // Required. Space resource name, in the form "spaces/x". Example: spaces/AAAAMpdlehY
         *     parent: 'dms/my-dm',
         *     // Opaque thread identifier string that can be specified to group messages into a single thread. If this is the first message with a given thread identifier, a new thread is created. Subsequent messages with the same thread identifier will be posted into the same thread. This relieves bots and webhooks from having to store the Hangouts Chat thread ID of a thread (created earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an existing thread, is set in message.
         *     threadKey: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "actionResponse": {},
         *       //   "annotations": [],
         *       //   "argumentText": "my_argumentText",
         *       //   "attachment": [],
         *       //   "cards": [],
         *       //   "createTime": "my_createTime",
         *       //   "fallbackText": "my_fallbackText",
         *       //   "name": "my_name",
         *       //   "previewText": "my_previewText",
         *       //   "sender": {},
         *       //   "slashCommand": {},
         *       //   "space": {},
         *       //   "text": "my_text",
         *       //   "thread": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "actionResponse": {},
         *   //   "annotations": [],
         *   //   "argumentText": "my_argumentText",
         *   //   "attachment": [],
         *   //   "cards": [],
         *   //   "createTime": "my_createTime",
         *   //   "fallbackText": "my_fallbackText",
         *   //   "name": "my_name",
         *   //   "previewText": "my_previewText",
         *   //   "sender": {},
         *   //   "slashCommand": {},
         *   //   "space": {},
         *   //   "text": "my_text",
         *   //   "thread": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        webhooks(params: Params$Resource$Dms$Webhooks, options: StreamMethodOptions): GaxiosPromise<Readable>;
        webhooks(params?: Params$Resource$Dms$Webhooks, options?: MethodOptions): GaxiosPromise<Schema$Message>;
        webhooks(params: Params$Resource$Dms$Webhooks, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        webhooks(params: Params$Resource$Dms$Webhooks, options: MethodOptions | BodyResponseCallback<Schema$Message>, callback: BodyResponseCallback<Schema$Message>): void;
        webhooks(params: Params$Resource$Dms$Webhooks, callback: BodyResponseCallback<Schema$Message>): void;
        webhooks(callback: BodyResponseCallback<Schema$Message>): void;
    }
    export interface Params$Resource$Dms$Messages extends StandardParameters {
        /**
         * Required. Space resource name, in the form "spaces/x". Example: spaces/AAAAMpdlehY
         */
        parent?: string;
        /**
         * Opaque thread identifier string that can be specified to group messages into a single thread. If this is the first message with a given thread identifier, a new thread is created. Subsequent messages with the same thread identifier will be posted into the same thread. This relieves bots and webhooks from having to store the Hangouts Chat thread ID of a thread (created earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an existing thread, is set in message.
         */
        threadKey?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Message;
    }
    export interface Params$Resource$Dms$Webhooks extends StandardParameters {
        /**
         * Required. Space resource name, in the form "spaces/x". Example: spaces/AAAAMpdlehY
         */
        parent?: string;
        /**
         * Opaque thread identifier string that can be specified to group messages into a single thread. If this is the first message with a given thread identifier, a new thread is created. Subsequent messages with the same thread identifier will be posted into the same thread. This relieves bots and webhooks from having to store the Hangouts Chat thread ID of a thread (created earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an existing thread, is set in message.
         */
        threadKey?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Message;
    }
    export class Resource$Dms$Conversations {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Legacy path for creating message. Calling these will result in a BadRequest response.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/chat.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const chat = google.chat('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await chat.dms.conversations.messages({
         *     // Required. Space resource name, in the form "spaces/x". Example: spaces/AAAAMpdlehY
         *     parent: 'dms/my-dm/conversations/my-conversation',
         *     // Opaque thread identifier string that can be specified to group messages into a single thread. If this is the first message with a given thread identifier, a new thread is created. Subsequent messages with the same thread identifier will be posted into the same thread. This relieves bots and webhooks from having to store the Hangouts Chat thread ID of a thread (created earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an existing thread, is set in message.
         *     threadKey: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "actionResponse": {},
         *       //   "annotations": [],
         *       //   "argumentText": "my_argumentText",
         *       //   "attachment": [],
         *       //   "cards": [],
         *       //   "createTime": "my_createTime",
         *       //   "fallbackText": "my_fallbackText",
         *       //   "name": "my_name",
         *       //   "previewText": "my_previewText",
         *       //   "sender": {},
         *       //   "slashCommand": {},
         *       //   "space": {},
         *       //   "text": "my_text",
         *       //   "thread": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "actionResponse": {},
         *   //   "annotations": [],
         *   //   "argumentText": "my_argumentText",
         *   //   "attachment": [],
         *   //   "cards": [],
         *   //   "createTime": "my_createTime",
         *   //   "fallbackText": "my_fallbackText",
         *   //   "name": "my_name",
         *   //   "previewText": "my_previewText",
         *   //   "sender": {},
         *   //   "slashCommand": {},
         *   //   "space": {},
         *   //   "text": "my_text",
         *   //   "thread": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        messages(params: Params$Resource$Dms$Conversations$Messages, options: StreamMethodOptions): GaxiosPromise<Readable>;
        messages(params?: Params$Resource$Dms$Conversations$Messages, options?: MethodOptions): GaxiosPromise<Schema$Message>;
        messages(params: Params$Resource$Dms$Conversations$Messages, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        messages(params: Params$Resource$Dms$Conversations$Messages, options: MethodOptions | BodyResponseCallback<Schema$Message>, callback: BodyResponseCallback<Schema$Message>): void;
        messages(params: Params$Resource$Dms$Conversations$Messages, callback: BodyResponseCallback<Schema$Message>): void;
        messages(callback: BodyResponseCallback<Schema$Message>): void;
    }
    export interface Params$Resource$Dms$Conversations$Messages extends StandardParameters {
        /**
         * Required. Space resource name, in the form "spaces/x". Example: spaces/AAAAMpdlehY
         */
        parent?: string;
        /**
         * Opaque thread identifier string that can be specified to group messages into a single thread. If this is the first message with a given thread identifier, a new thread is created. Subsequent messages with the same thread identifier will be posted into the same thread. This relieves bots and webhooks from having to store the Hangouts Chat thread ID of a thread (created earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an existing thread, is set in message.
         */
        threadKey?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Message;
    }
    export class Resource$Media {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Downloads media. Download is supported on the URI `/v1/media/{+name\}?alt=media`.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/chat.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const chat = google.chat('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await chat.media.download({
         *     // Name of the media that is being downloaded. See ReadRequest.resource_name.
         *     resourceName: '.*',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "resourceName": "my_resourceName"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        download(params: Params$Resource$Media$Download, options: StreamMethodOptions): GaxiosPromise<Readable>;
        download(params?: Params$Resource$Media$Download, options?: MethodOptions): GaxiosPromise<Schema$Media>;
        download(params: Params$Resource$Media$Download, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        download(params: Params$Resource$Media$Download, options: MethodOptions | BodyResponseCallback<Schema$Media>, callback: BodyResponseCallback<Schema$Media>): void;
        download(params: Params$Resource$Media$Download, callback: BodyResponseCallback<Schema$Media>): void;
        download(callback: BodyResponseCallback<Schema$Media>): void;
    }
    export interface Params$Resource$Media$Download extends StandardParameters {
        /**
         * Name of the media that is being downloaded. See ReadRequest.resource_name.
         */
        resourceName?: string;
    }
    export class Resource$Rooms {
        context: APIRequestContext;
        conversations: Resource$Rooms$Conversations;
        constructor(context: APIRequestContext);
        /**
         * Legacy path for creating message. Calling these will result in a BadRequest response.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/chat.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const chat = google.chat('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await chat.rooms.messages({
         *     // Required. Space resource name, in the form "spaces/x". Example: spaces/AAAAMpdlehY
         *     parent: 'rooms/my-room',
         *     // Opaque thread identifier string that can be specified to group messages into a single thread. If this is the first message with a given thread identifier, a new thread is created. Subsequent messages with the same thread identifier will be posted into the same thread. This relieves bots and webhooks from having to store the Hangouts Chat thread ID of a thread (created earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an existing thread, is set in message.
         *     threadKey: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "actionResponse": {},
         *       //   "annotations": [],
         *       //   "argumentText": "my_argumentText",
         *       //   "attachment": [],
         *       //   "cards": [],
         *       //   "createTime": "my_createTime",
         *       //   "fallbackText": "my_fallbackText",
         *       //   "name": "my_name",
         *       //   "previewText": "my_previewText",
         *       //   "sender": {},
         *       //   "slashCommand": {},
         *       //   "space": {},
         *       //   "text": "my_text",
         *       //   "thread": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "actionResponse": {},
         *   //   "annotations": [],
         *   //   "argumentText": "my_argumentText",
         *   //   "attachment": [],
         *   //   "cards": [],
         *   //   "createTime": "my_createTime",
         *   //   "fallbackText": "my_fallbackText",
         *   //   "name": "my_name",
         *   //   "previewText": "my_previewText",
         *   //   "sender": {},
         *   //   "slashCommand": {},
         *   //   "space": {},
         *   //   "text": "my_text",
         *   //   "thread": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        messages(params: Params$Resource$Rooms$Messages, options: StreamMethodOptions): GaxiosPromise<Readable>;
        messages(params?: Params$Resource$Rooms$Messages, options?: MethodOptions): GaxiosPromise<Schema$Message>;
        messages(params: Params$Resource$Rooms$Messages, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        messages(params: Params$Resource$Rooms$Messages, options: MethodOptions | BodyResponseCallback<Schema$Message>, callback: BodyResponseCallback<Schema$Message>): void;
        messages(params: Params$Resource$Rooms$Messages, callback: BodyResponseCallback<Schema$Message>): void;
        messages(callback: BodyResponseCallback<Schema$Message>): void;
        /**
         * Legacy path for creating message. Calling these will result in a BadRequest response.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/chat.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const chat = google.chat('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await chat.rooms.webhooks({
         *     // Required. Space resource name, in the form "spaces/x". Example: spaces/AAAAMpdlehY
         *     parent: 'rooms/my-room',
         *     // Opaque thread identifier string that can be specified to group messages into a single thread. If this is the first message with a given thread identifier, a new thread is created. Subsequent messages with the same thread identifier will be posted into the same thread. This relieves bots and webhooks from having to store the Hangouts Chat thread ID of a thread (created earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an existing thread, is set in message.
         *     threadKey: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "actionResponse": {},
         *       //   "annotations": [],
         *       //   "argumentText": "my_argumentText",
         *       //   "attachment": [],
         *       //   "cards": [],
         *       //   "createTime": "my_createTime",
         *       //   "fallbackText": "my_fallbackText",
         *       //   "name": "my_name",
         *       //   "previewText": "my_previewText",
         *       //   "sender": {},
         *       //   "slashCommand": {},
         *       //   "space": {},
         *       //   "text": "my_text",
         *       //   "thread": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "actionResponse": {},
         *   //   "annotations": [],
         *   //   "argumentText": "my_argumentText",
         *   //   "attachment": [],
         *   //   "cards": [],
         *   //   "createTime": "my_createTime",
         *   //   "fallbackText": "my_fallbackText",
         *   //   "name": "my_name",
         *   //   "previewText": "my_previewText",
         *   //   "sender": {},
         *   //   "slashCommand": {},
         *   //   "space": {},
         *   //   "text": "my_text",
         *   //   "thread": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        webhooks(params: Params$Resource$Rooms$Webhooks, options: StreamMethodOptions): GaxiosPromise<Readable>;
        webhooks(params?: Params$Resource$Rooms$Webhooks, options?: MethodOptions): GaxiosPromise<Schema$Message>;
        webhooks(params: Params$Resource$Rooms$Webhooks, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        webhooks(params: Params$Resource$Rooms$Webhooks, options: MethodOptions | BodyResponseCallback<Schema$Message>, callback: BodyResponseCallback<Schema$Message>): void;
        webhooks(params: Params$Resource$Rooms$Webhooks, callback: BodyResponseCallback<Schema$Message>): void;
        webhooks(callback: BodyResponseCallback<Schema$Message>): void;
    }
    export interface Params$Resource$Rooms$Messages extends StandardParameters {
        /**
         * Required. Space resource name, in the form "spaces/x". Example: spaces/AAAAMpdlehY
         */
        parent?: string;
        /**
         * Opaque thread identifier string that can be specified to group messages into a single thread. If this is the first message with a given thread identifier, a new thread is created. Subsequent messages with the same thread identifier will be posted into the same thread. This relieves bots and webhooks from having to store the Hangouts Chat thread ID of a thread (created earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an existing thread, is set in message.
         */
        threadKey?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Message;
    }
    export interface Params$Resource$Rooms$Webhooks extends StandardParameters {
        /**
         * Required. Space resource name, in the form "spaces/x". Example: spaces/AAAAMpdlehY
         */
        parent?: string;
        /**
         * Opaque thread identifier string that can be specified to group messages into a single thread. If this is the first message with a given thread identifier, a new thread is created. Subsequent messages with the same thread identifier will be posted into the same thread. This relieves bots and webhooks from having to store the Hangouts Chat thread ID of a thread (created earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an existing thread, is set in message.
         */
        threadKey?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Message;
    }
    export class Resource$Rooms$Conversations {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Legacy path for creating message. Calling these will result in a BadRequest response.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/chat.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const chat = google.chat('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await chat.rooms.conversations.messages({
         *     // Required. Space resource name, in the form "spaces/x". Example: spaces/AAAAMpdlehY
         *     parent: 'rooms/my-room/conversations/my-conversation',
         *     // Opaque thread identifier string that can be specified to group messages into a single thread. If this is the first message with a given thread identifier, a new thread is created. Subsequent messages with the same thread identifier will be posted into the same thread. This relieves bots and webhooks from having to store the Hangouts Chat thread ID of a thread (created earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an existing thread, is set in message.
         *     threadKey: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "actionResponse": {},
         *       //   "annotations": [],
         *       //   "argumentText": "my_argumentText",
         *       //   "attachment": [],
         *       //   "cards": [],
         *       //   "createTime": "my_createTime",
         *       //   "fallbackText": "my_fallbackText",
         *       //   "name": "my_name",
         *       //   "previewText": "my_previewText",
         *       //   "sender": {},
         *       //   "slashCommand": {},
         *       //   "space": {},
         *       //   "text": "my_text",
         *       //   "thread": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "actionResponse": {},
         *   //   "annotations": [],
         *   //   "argumentText": "my_argumentText",
         *   //   "attachment": [],
         *   //   "cards": [],
         *   //   "createTime": "my_createTime",
         *   //   "fallbackText": "my_fallbackText",
         *   //   "name": "my_name",
         *   //   "previewText": "my_previewText",
         *   //   "sender": {},
         *   //   "slashCommand": {},
         *   //   "space": {},
         *   //   "text": "my_text",
         *   //   "thread": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        messages(params: Params$Resource$Rooms$Conversations$Messages, options: StreamMethodOptions): GaxiosPromise<Readable>;
        messages(params?: Params$Resource$Rooms$Conversations$Messages, options?: MethodOptions): GaxiosPromise<Schema$Message>;
        messages(params: Params$Resource$Rooms$Conversations$Messages, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        messages(params: Params$Resource$Rooms$Conversations$Messages, options: MethodOptions | BodyResponseCallback<Schema$Message>, callback: BodyResponseCallback<Schema$Message>): void;
        messages(params: Params$Resource$Rooms$Conversations$Messages, callback: BodyResponseCallback<Schema$Message>): void;
        messages(callback: BodyResponseCallback<Schema$Message>): void;
    }
    export interface Params$Resource$Rooms$Conversations$Messages extends StandardParameters {
        /**
         * Required. Space resource name, in the form "spaces/x". Example: spaces/AAAAMpdlehY
         */
        parent?: string;
        /**
         * Opaque thread identifier string that can be specified to group messages into a single thread. If this is the first message with a given thread identifier, a new thread is created. Subsequent messages with the same thread identifier will be posted into the same thread. This relieves bots and webhooks from having to store the Hangouts Chat thread ID of a thread (created earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an existing thread, is set in message.
         */
        threadKey?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Message;
    }
    export class Resource$Spaces {
        context: APIRequestContext;
        members: Resource$Spaces$Members;
        messages: Resource$Spaces$Messages;
        constructor(context: APIRequestContext);
        /**
         * Returns a space.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/chat.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const chat = google.chat('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await chat.spaces.get({
         *     // Required. Resource name of the space, in the form "spaces/x". Example: spaces/AAAAMpdlehY
         *     name: 'spaces/my-space',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "displayName": "my_displayName",
         *   //   "name": "my_name",
         *   //   "singleUserBotDm": false,
         *   //   "threaded": false,
         *   //   "type": "my_type"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Spaces$Get, options: StreamMethodOptions): GaxiosPromise<Readable>;
        get(params?: Params$Resource$Spaces$Get, options?: MethodOptions): GaxiosPromise<Schema$Space>;
        get(params: Params$Resource$Spaces$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Spaces$Get, options: MethodOptions | BodyResponseCallback<Schema$Space>, callback: BodyResponseCallback<Schema$Space>): void;
        get(params: Params$Resource$Spaces$Get, callback: BodyResponseCallback<Schema$Space>): void;
        get(callback: BodyResponseCallback<Schema$Space>): void;
        /**
         * Lists spaces the caller is a member of.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/chat.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const chat = google.chat('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await chat.spaces.list({
         *     // Requested page size. The value is capped at 1000. Server may return fewer results than requested. If unspecified, server will default to 100.
         *     pageSize: 'placeholder-value',
         *     // A token identifying a page of results the server should return.
         *     pageToken: 'placeholder-value',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "spaces": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Spaces$List, options: StreamMethodOptions): GaxiosPromise<Readable>;
        list(params?: Params$Resource$Spaces$List, options?: MethodOptions): GaxiosPromise<Schema$ListSpacesResponse>;
        list(params: Params$Resource$Spaces$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Spaces$List, options: MethodOptions | BodyResponseCallback<Schema$ListSpacesResponse>, callback: BodyResponseCallback<Schema$ListSpacesResponse>): void;
        list(params: Params$Resource$Spaces$List, callback: BodyResponseCallback<Schema$ListSpacesResponse>): void;
        list(callback: BodyResponseCallback<Schema$ListSpacesResponse>): void;
        /**
         * Legacy path for creating message. Calling these will result in a BadRequest response.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/chat.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const chat = google.chat('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await chat.spaces.webhooks({
         *     // Required. Space resource name, in the form "spaces/x". Example: spaces/AAAAMpdlehY
         *     parent: 'spaces/my-space',
         *     // Opaque thread identifier string that can be specified to group messages into a single thread. If this is the first message with a given thread identifier, a new thread is created. Subsequent messages with the same thread identifier will be posted into the same thread. This relieves bots and webhooks from having to store the Hangouts Chat thread ID of a thread (created earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an existing thread, is set in message.
         *     threadKey: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "actionResponse": {},
         *       //   "annotations": [],
         *       //   "argumentText": "my_argumentText",
         *       //   "attachment": [],
         *       //   "cards": [],
         *       //   "createTime": "my_createTime",
         *       //   "fallbackText": "my_fallbackText",
         *       //   "name": "my_name",
         *       //   "previewText": "my_previewText",
         *       //   "sender": {},
         *       //   "slashCommand": {},
         *       //   "space": {},
         *       //   "text": "my_text",
         *       //   "thread": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "actionResponse": {},
         *   //   "annotations": [],
         *   //   "argumentText": "my_argumentText",
         *   //   "attachment": [],
         *   //   "cards": [],
         *   //   "createTime": "my_createTime",
         *   //   "fallbackText": "my_fallbackText",
         *   //   "name": "my_name",
         *   //   "previewText": "my_previewText",
         *   //   "sender": {},
         *   //   "slashCommand": {},
         *   //   "space": {},
         *   //   "text": "my_text",
         *   //   "thread": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        webhooks(params: Params$Resource$Spaces$Webhooks, options: StreamMethodOptions): GaxiosPromise<Readable>;
        webhooks(params?: Params$Resource$Spaces$Webhooks, options?: MethodOptions): GaxiosPromise<Schema$Message>;
        webhooks(params: Params$Resource$Spaces$Webhooks, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        webhooks(params: Params$Resource$Spaces$Webhooks, options: MethodOptions | BodyResponseCallback<Schema$Message>, callback: BodyResponseCallback<Schema$Message>): void;
        webhooks(params: Params$Resource$Spaces$Webhooks, callback: BodyResponseCallback<Schema$Message>): void;
        webhooks(callback: BodyResponseCallback<Schema$Message>): void;
    }
    export interface Params$Resource$Spaces$Get extends StandardParameters {
        /**
         * Required. Resource name of the space, in the form "spaces/x". Example: spaces/AAAAMpdlehY
         */
        name?: string;
    }
    export interface Params$Resource$Spaces$List extends StandardParameters {
        /**
         * Requested page size. The value is capped at 1000. Server may return fewer results than requested. If unspecified, server will default to 100.
         */
        pageSize?: number;
        /**
         * A token identifying a page of results the server should return.
         */
        pageToken?: string;
    }
    export interface Params$Resource$Spaces$Webhooks extends StandardParameters {
        /**
         * Required. Space resource name, in the form "spaces/x". Example: spaces/AAAAMpdlehY
         */
        parent?: string;
        /**
         * Opaque thread identifier string that can be specified to group messages into a single thread. If this is the first message with a given thread identifier, a new thread is created. Subsequent messages with the same thread identifier will be posted into the same thread. This relieves bots and webhooks from having to store the Hangouts Chat thread ID of a thread (created earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an existing thread, is set in message.
         */
        threadKey?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Message;
    }
    export class Resource$Spaces$Members {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Returns a membership.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/chat.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const chat = google.chat('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await chat.spaces.members.get({
         *     // Required. Resource name of the membership to be retrieved, in the form "spaces/x/members/x". Example: spaces/AAAAMpdlehY/members/105115627578887013105
         *     name: 'spaces/my-space/members/my-member',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "member": {},
         *   //   "name": "my_name",
         *   //   "state": "my_state"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Spaces$Members$Get, options: StreamMethodOptions): GaxiosPromise<Readable>;
        get(params?: Params$Resource$Spaces$Members$Get, options?: MethodOptions): GaxiosPromise<Schema$Membership>;
        get(params: Params$Resource$Spaces$Members$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Spaces$Members$Get, options: MethodOptions | BodyResponseCallback<Schema$Membership>, callback: BodyResponseCallback<Schema$Membership>): void;
        get(params: Params$Resource$Spaces$Members$Get, callback: BodyResponseCallback<Schema$Membership>): void;
        get(callback: BodyResponseCallback<Schema$Membership>): void;
        /**
         * Lists human memberships in a space.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/chat.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const chat = google.chat('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await chat.spaces.members.list({
         *     // Requested page size. The value is capped at 1000. Server may return fewer results than requested. If unspecified, server will default to 100.
         *     pageSize: 'placeholder-value',
         *     // A token identifying a page of results the server should return.
         *     pageToken: 'placeholder-value',
         *     // Required. The resource name of the space for which membership list is to be fetched, in the form "spaces/x". Example: spaces/AAAAMpdlehY
         *     parent: 'spaces/my-space',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "memberships": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Spaces$Members$List, options: StreamMethodOptions): GaxiosPromise<Readable>;
        list(params?: Params$Resource$Spaces$Members$List, options?: MethodOptions): GaxiosPromise<Schema$ListMembershipsResponse>;
        list(params: Params$Resource$Spaces$Members$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Spaces$Members$List, options: MethodOptions | BodyResponseCallback<Schema$ListMembershipsResponse>, callback: BodyResponseCallback<Schema$ListMembershipsResponse>): void;
        list(params: Params$Resource$Spaces$Members$List, callback: BodyResponseCallback<Schema$ListMembershipsResponse>): void;
        list(callback: BodyResponseCallback<Schema$ListMembershipsResponse>): void;
    }
    export interface Params$Resource$Spaces$Members$Get extends StandardParameters {
        /**
         * Required. Resource name of the membership to be retrieved, in the form "spaces/x/members/x". Example: spaces/AAAAMpdlehY/members/105115627578887013105
         */
        name?: string;
    }
    export interface Params$Resource$Spaces$Members$List extends StandardParameters {
        /**
         * Requested page size. The value is capped at 1000. Server may return fewer results than requested. If unspecified, server will default to 100.
         */
        pageSize?: number;
        /**
         * A token identifying a page of results the server should return.
         */
        pageToken?: string;
        /**
         * Required. The resource name of the space for which membership list is to be fetched, in the form "spaces/x". Example: spaces/AAAAMpdlehY
         */
        parent?: string;
    }
    export class Resource$Spaces$Messages {
        context: APIRequestContext;
        attachments: Resource$Spaces$Messages$Attachments;
        constructor(context: APIRequestContext);
        /**
         * Creates a message.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/chat.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const chat = google.chat('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await chat.spaces.messages.create({
         *     // Required. Space resource name, in the form "spaces/x". Example: spaces/AAAAMpdlehY
         *     parent: 'spaces/my-space',
         *     // Opaque thread identifier string that can be specified to group messages into a single thread. If this is the first message with a given thread identifier, a new thread is created. Subsequent messages with the same thread identifier will be posted into the same thread. This relieves bots and webhooks from having to store the Hangouts Chat thread ID of a thread (created earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an existing thread, is set in message.
         *     threadKey: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "actionResponse": {},
         *       //   "annotations": [],
         *       //   "argumentText": "my_argumentText",
         *       //   "attachment": [],
         *       //   "cards": [],
         *       //   "createTime": "my_createTime",
         *       //   "fallbackText": "my_fallbackText",
         *       //   "name": "my_name",
         *       //   "previewText": "my_previewText",
         *       //   "sender": {},
         *       //   "slashCommand": {},
         *       //   "space": {},
         *       //   "text": "my_text",
         *       //   "thread": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "actionResponse": {},
         *   //   "annotations": [],
         *   //   "argumentText": "my_argumentText",
         *   //   "attachment": [],
         *   //   "cards": [],
         *   //   "createTime": "my_createTime",
         *   //   "fallbackText": "my_fallbackText",
         *   //   "name": "my_name",
         *   //   "previewText": "my_previewText",
         *   //   "sender": {},
         *   //   "slashCommand": {},
         *   //   "space": {},
         *   //   "text": "my_text",
         *   //   "thread": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Spaces$Messages$Create, options: StreamMethodOptions): GaxiosPromise<Readable>;
        create(params?: Params$Resource$Spaces$Messages$Create, options?: MethodOptions): GaxiosPromise<Schema$Message>;
        create(params: Params$Resource$Spaces$Messages$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Spaces$Messages$Create, options: MethodOptions | BodyResponseCallback<Schema$Message>, callback: BodyResponseCallback<Schema$Message>): void;
        create(params: Params$Resource$Spaces$Messages$Create, callback: BodyResponseCallback<Schema$Message>): void;
        create(callback: BodyResponseCallback<Schema$Message>): void;
        /**
         * Deletes a message.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/chat.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const chat = google.chat('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await chat.spaces.messages.delete({
         *     // Required. Resource name of the message to be deleted, in the form "spaces/x/messages/x" Example: spaces/AAAAMpdlehY/messages/UMxbHmzDlr4.UMxbHmzDlr4
         *     name: 'spaces/my-space/messages/my-message',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Spaces$Messages$Delete, options: StreamMethodOptions): GaxiosPromise<Readable>;
        delete(params?: Params$Resource$Spaces$Messages$Delete, options?: MethodOptions): GaxiosPromise<Schema$Empty>;
        delete(params: Params$Resource$Spaces$Messages$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Spaces$Messages$Delete, options: MethodOptions | BodyResponseCallback<Schema$Empty>, callback: BodyResponseCallback<Schema$Empty>): void;
        delete(params: Params$Resource$Spaces$Messages$Delete, callback: BodyResponseCallback<Schema$Empty>): void;
        delete(callback: BodyResponseCallback<Schema$Empty>): void;
        /**
         * Returns a message.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/chat.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const chat = google.chat('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await chat.spaces.messages.get({
         *     // Required. Resource name of the message to be retrieved, in the form "spaces/x/messages/x". Example: spaces/AAAAMpdlehY/messages/UMxbHmzDlr4.UMxbHmzDlr4
         *     name: 'spaces/my-space/messages/my-message',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "actionResponse": {},
         *   //   "annotations": [],
         *   //   "argumentText": "my_argumentText",
         *   //   "attachment": [],
         *   //   "cards": [],
         *   //   "createTime": "my_createTime",
         *   //   "fallbackText": "my_fallbackText",
         *   //   "name": "my_name",
         *   //   "previewText": "my_previewText",
         *   //   "sender": {},
         *   //   "slashCommand": {},
         *   //   "space": {},
         *   //   "text": "my_text",
         *   //   "thread": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Spaces$Messages$Get, options: StreamMethodOptions): GaxiosPromise<Readable>;
        get(params?: Params$Resource$Spaces$Messages$Get, options?: MethodOptions): GaxiosPromise<Schema$Message>;
        get(params: Params$Resource$Spaces$Messages$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Spaces$Messages$Get, options: MethodOptions | BodyResponseCallback<Schema$Message>, callback: BodyResponseCallback<Schema$Message>): void;
        get(params: Params$Resource$Spaces$Messages$Get, callback: BodyResponseCallback<Schema$Message>): void;
        get(callback: BodyResponseCallback<Schema$Message>): void;
        /**
         * Updates a message.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/chat.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const chat = google.chat('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await chat.spaces.messages.update({
         *     name: 'spaces/my-space/messages/my-message',
         *     // Required. The field paths to be updated, comma separated if there are multiple. Currently supported field paths: * text * cards
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "actionResponse": {},
         *       //   "annotations": [],
         *       //   "argumentText": "my_argumentText",
         *       //   "attachment": [],
         *       //   "cards": [],
         *       //   "createTime": "my_createTime",
         *       //   "fallbackText": "my_fallbackText",
         *       //   "name": "my_name",
         *       //   "previewText": "my_previewText",
         *       //   "sender": {},
         *       //   "slashCommand": {},
         *       //   "space": {},
         *       //   "text": "my_text",
         *       //   "thread": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "actionResponse": {},
         *   //   "annotations": [],
         *   //   "argumentText": "my_argumentText",
         *   //   "attachment": [],
         *   //   "cards": [],
         *   //   "createTime": "my_createTime",
         *   //   "fallbackText": "my_fallbackText",
         *   //   "name": "my_name",
         *   //   "previewText": "my_previewText",
         *   //   "sender": {},
         *   //   "slashCommand": {},
         *   //   "space": {},
         *   //   "text": "my_text",
         *   //   "thread": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        update(params: Params$Resource$Spaces$Messages$Update, options: StreamMethodOptions): GaxiosPromise<Readable>;
        update(params?: Params$Resource$Spaces$Messages$Update, options?: MethodOptions): GaxiosPromise<Schema$Message>;
        update(params: Params$Resource$Spaces$Messages$Update, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        update(params: Params$Resource$Spaces$Messages$Update, options: MethodOptions | BodyResponseCallback<Schema$Message>, callback: BodyResponseCallback<Schema$Message>): void;
        update(params: Params$Resource$Spaces$Messages$Update, callback: BodyResponseCallback<Schema$Message>): void;
        update(callback: BodyResponseCallback<Schema$Message>): void;
    }
    export interface Params$Resource$Spaces$Messages$Create extends StandardParameters {
        /**
         * Required. Space resource name, in the form "spaces/x". Example: spaces/AAAAMpdlehY
         */
        parent?: string;
        /**
         * Opaque thread identifier string that can be specified to group messages into a single thread. If this is the first message with a given thread identifier, a new thread is created. Subsequent messages with the same thread identifier will be posted into the same thread. This relieves bots and webhooks from having to store the Hangouts Chat thread ID of a thread (created earlier by them) to post further updates to it. Has no effect if thread field, corresponding to an existing thread, is set in message.
         */
        threadKey?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Message;
    }
    export interface Params$Resource$Spaces$Messages$Delete extends StandardParameters {
        /**
         * Required. Resource name of the message to be deleted, in the form "spaces/x/messages/x" Example: spaces/AAAAMpdlehY/messages/UMxbHmzDlr4.UMxbHmzDlr4
         */
        name?: string;
    }
    export interface Params$Resource$Spaces$Messages$Get extends StandardParameters {
        /**
         * Required. Resource name of the message to be retrieved, in the form "spaces/x/messages/x". Example: spaces/AAAAMpdlehY/messages/UMxbHmzDlr4.UMxbHmzDlr4
         */
        name?: string;
    }
    export interface Params$Resource$Spaces$Messages$Update extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         * Required. The field paths to be updated, comma separated if there are multiple. Currently supported field paths: * text * cards
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Message;
    }
    export class Resource$Spaces$Messages$Attachments {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Gets the metadata of a message attachment. The attachment data is fetched using the media API.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/chat.googleapis.com
         * // - Login into gcloud by running:
         * //   `$ gcloud auth application-default login`
         * // - Install the npm module by running:
         * //   `$ npm install googleapis`
         *
         * const {google} = require('googleapis');
         * const chat = google.chat('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await chat.spaces.messages.attachments.get({
         *     // Resource name of the attachment, in the form "spaces/x/messages/x/attachments/x".
         *     name: 'spaces/my-space/messages/my-message/attachments/my-attachment',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "attachmentDataRef": {},
         *   //   "contentName": "my_contentName",
         *   //   "contentType": "my_contentType",
         *   //   "downloadUri": "my_downloadUri",
         *   //   "driveDataRef": {},
         *   //   "name": "my_name",
         *   //   "source": "my_source",
         *   //   "thumbnailUri": "my_thumbnailUri"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Spaces$Messages$Attachments$Get, options: StreamMethodOptions): GaxiosPromise<Readable>;
        get(params?: Params$Resource$Spaces$Messages$Attachments$Get, options?: MethodOptions): GaxiosPromise<Schema$Attachment>;
        get(params: Params$Resource$Spaces$Messages$Attachments$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Spaces$Messages$Attachments$Get, options: MethodOptions | BodyResponseCallback<Schema$Attachment>, callback: BodyResponseCallback<Schema$Attachment>): void;
        get(params: Params$Resource$Spaces$Messages$Attachments$Get, callback: BodyResponseCallback<Schema$Attachment>): void;
        get(callback: BodyResponseCallback<Schema$Attachment>): void;
    }
    export interface Params$Resource$Spaces$Messages$Attachments$Get extends StandardParameters {
        /**
         * Resource name of the attachment, in the form "spaces/x/messages/x/attachments/x".
         */
        name?: string;
    }
    export {};
}
//# sourceMappingURL=v1.d.ts.map