// generated from file '../src/plugins/mbe.dsp' by dsp2cc:
// Code generated with Faust (https://faust.grame.fr)

#include "gx_faust_support.h"
#include "gx_plugin.h"

namespace pluginlib {
namespace mbe {

class Dsp: public PluginDef {
private:
	int fSampleRate;
	double fConst1;
	double fConst2;
	FAUSTFLOAT fHslider0;
	FAUSTFLOAT fHslider1;
	double fVec0[2];
	double fRec8[2];
	double fRec7[3];
	FAUSTFLOAT fHslider2;
	double fRec6[3];
	FAUSTFLOAT fHslider3;
	double fRec5[3];
	double fRec4[3];
	FAUSTFLOAT fHslider4;
	double fRec9[2];
	int IOTA0;
	double fConst3;
	FAUSTFLOAT fHslider5;
	double fConst4;
	double fConst5;
	double fRec10[2];
	double fRec11[2];
	double fRec12[2];
	double fRec13[2];
	double fRec3[524288];
	double fRec0[2];
	int iRec1[2];
	double fRec2[2];
	FAUSTFLOAT fVbargraph0;
	double fRec23[2];
	double fRec22[3];
	double fVec1[2];
	double fRec21[2];
	double fRec20[3];
	double fRec19[3];
	double fRec18[3];
	FAUSTFLOAT fHslider6;
	double fRec24[2];
	FAUSTFLOAT fHslider7;
	double fRec25[2];
	double fRec26[2];
	double fRec27[2];
	double fRec28[2];
	double fRec17[524288];
	double fRec14[2];
	int iRec15[2];
	double fRec16[2];
	FAUSTFLOAT fVbargraph1;
	double fRec37[2];
	double fRec36[3];
	double fVec2[2];
	double fRec35[2];
	double fRec34[3];
	double fRec33[3];
	FAUSTFLOAT fHslider8;
	double fRec38[2];
	FAUSTFLOAT fHslider9;
	double fRec39[2];
	double fRec40[2];
	double fRec41[2];
	double fRec42[2];
	double fRec32[524288];
	double fRec29[2];
	int iRec30[2];
	double fRec31[2];
	FAUSTFLOAT fVbargraph2;
	FAUSTFLOAT fHslider10;
	double fRec47[2];
	FAUSTFLOAT fHslider11;
	double fRec48[2];
	double fRec49[2];
	double fRec50[2];
	double fRec51[2];
	double fRec55[2];
	double fRec54[3];
	double fVec3[2];
	double fRec53[2];
	double fRec52[3];
	double fRec46[524288];
	double fRec43[2];
	int iRec44[2];
	double fRec45[2];
	FAUSTFLOAT fVbargraph3;
	FAUSTFLOAT fHslider12;
	double fRec60[2];
	FAUSTFLOAT fHslider13;
	double fRec61[2];
	double fRec62[2];
	double fRec63[2];
	double fRec64[2];
	double fRec66[2];
	double fRec65[3];
	double fRec59[524288];
	double fRec56[2];
	int iRec57[2];
	double fRec58[2];
	FAUSTFLOAT fVbargraph4;

	void clear_state_f();
	int load_ui_f(const UiBuilder& b, int form);
	static const char *glade_def;
	void init(unsigned int sample_rate);
	void compute(int count, FAUSTFLOAT *input0, FAUSTFLOAT *output0);
	int register_par(const ParamReg& reg);

	static void clear_state_f_static(PluginDef*);
	static int load_ui_f_static(const UiBuilder& b, int form);
	static void init_static(unsigned int sample_rate, PluginDef*);
	static void compute_static(int count, FAUSTFLOAT *input0, FAUSTFLOAT *output0, PluginDef*);
	static int register_params_static(const ParamReg& reg);
	static void del_instance(PluginDef *p);
public:
	Dsp();
	~Dsp();
};



Dsp::Dsp()
	: PluginDef() {
	version = PLUGINDEF_VERSION;
	flags = 0;
	id = "mbe";
	name = N_("MultiBand Echo");
	groups = 0;
	description = N_("Multi Band Echo"); // description (tooltip)
	category = N_("Echo / Delay");       // category
	shortname = N_("MB Echo");     // shortname
	mono_audio = compute_static;
	stereo_audio = 0;
	set_samplerate = init_static;
	activate_plugin = 0;
	register_params = register_params_static;
	load_ui = load_ui_f_static;
	clear_state = clear_state_f_static;
	delete_instance = del_instance;
}

Dsp::~Dsp() {
}

inline void Dsp::clear_state_f()
{
	for (int l0 = 0; l0 < 2; l0 = l0 + 1) fVec0[l0] = 0.0;
	for (int l1 = 0; l1 < 2; l1 = l1 + 1) fRec8[l1] = 0.0;
	for (int l2 = 0; l2 < 3; l2 = l2 + 1) fRec7[l2] = 0.0;
	for (int l3 = 0; l3 < 3; l3 = l3 + 1) fRec6[l3] = 0.0;
	for (int l4 = 0; l4 < 3; l4 = l4 + 1) fRec5[l4] = 0.0;
	for (int l5 = 0; l5 < 3; l5 = l5 + 1) fRec4[l5] = 0.0;
	for (int l6 = 0; l6 < 2; l6 = l6 + 1) fRec9[l6] = 0.0;
	for (int l7 = 0; l7 < 2; l7 = l7 + 1) fRec10[l7] = 0.0;
	for (int l8 = 0; l8 < 2; l8 = l8 + 1) fRec11[l8] = 0.0;
	for (int l9 = 0; l9 < 2; l9 = l9 + 1) fRec12[l9] = 0.0;
	for (int l10 = 0; l10 < 2; l10 = l10 + 1) fRec13[l10] = 0.0;
	for (int l11 = 0; l11 < 524288; l11 = l11 + 1) fRec3[l11] = 0.0;
	for (int l12 = 0; l12 < 2; l12 = l12 + 1) fRec0[l12] = 0.0;
	for (int l13 = 0; l13 < 2; l13 = l13 + 1) iRec1[l13] = 0;
	for (int l14 = 0; l14 < 2; l14 = l14 + 1) fRec2[l14] = 0.0;
	for (int l15 = 0; l15 < 2; l15 = l15 + 1) fRec23[l15] = 0.0;
	for (int l16 = 0; l16 < 3; l16 = l16 + 1) fRec22[l16] = 0.0;
	for (int l17 = 0; l17 < 2; l17 = l17 + 1) fVec1[l17] = 0.0;
	for (int l18 = 0; l18 < 2; l18 = l18 + 1) fRec21[l18] = 0.0;
	for (int l19 = 0; l19 < 3; l19 = l19 + 1) fRec20[l19] = 0.0;
	for (int l20 = 0; l20 < 3; l20 = l20 + 1) fRec19[l20] = 0.0;
	for (int l21 = 0; l21 < 3; l21 = l21 + 1) fRec18[l21] = 0.0;
	for (int l22 = 0; l22 < 2; l22 = l22 + 1) fRec24[l22] = 0.0;
	for (int l23 = 0; l23 < 2; l23 = l23 + 1) fRec25[l23] = 0.0;
	for (int l24 = 0; l24 < 2; l24 = l24 + 1) fRec26[l24] = 0.0;
	for (int l25 = 0; l25 < 2; l25 = l25 + 1) fRec27[l25] = 0.0;
	for (int l26 = 0; l26 < 2; l26 = l26 + 1) fRec28[l26] = 0.0;
	for (int l27 = 0; l27 < 524288; l27 = l27 + 1) fRec17[l27] = 0.0;
	for (int l28 = 0; l28 < 2; l28 = l28 + 1) fRec14[l28] = 0.0;
	for (int l29 = 0; l29 < 2; l29 = l29 + 1) iRec15[l29] = 0;
	for (int l30 = 0; l30 < 2; l30 = l30 + 1) fRec16[l30] = 0.0;
	for (int l31 = 0; l31 < 2; l31 = l31 + 1) fRec37[l31] = 0.0;
	for (int l32 = 0; l32 < 3; l32 = l32 + 1) fRec36[l32] = 0.0;
	for (int l33 = 0; l33 < 2; l33 = l33 + 1) fVec2[l33] = 0.0;
	for (int l34 = 0; l34 < 2; l34 = l34 + 1) fRec35[l34] = 0.0;
	for (int l35 = 0; l35 < 3; l35 = l35 + 1) fRec34[l35] = 0.0;
	for (int l36 = 0; l36 < 3; l36 = l36 + 1) fRec33[l36] = 0.0;
	for (int l37 = 0; l37 < 2; l37 = l37 + 1) fRec38[l37] = 0.0;
	for (int l38 = 0; l38 < 2; l38 = l38 + 1) fRec39[l38] = 0.0;
	for (int l39 = 0; l39 < 2; l39 = l39 + 1) fRec40[l39] = 0.0;
	for (int l40 = 0; l40 < 2; l40 = l40 + 1) fRec41[l40] = 0.0;
	for (int l41 = 0; l41 < 2; l41 = l41 + 1) fRec42[l41] = 0.0;
	for (int l42 = 0; l42 < 524288; l42 = l42 + 1) fRec32[l42] = 0.0;
	for (int l43 = 0; l43 < 2; l43 = l43 + 1) fRec29[l43] = 0.0;
	for (int l44 = 0; l44 < 2; l44 = l44 + 1) iRec30[l44] = 0;
	for (int l45 = 0; l45 < 2; l45 = l45 + 1) fRec31[l45] = 0.0;
	for (int l46 = 0; l46 < 2; l46 = l46 + 1) fRec47[l46] = 0.0;
	for (int l47 = 0; l47 < 2; l47 = l47 + 1) fRec48[l47] = 0.0;
	for (int l48 = 0; l48 < 2; l48 = l48 + 1) fRec49[l48] = 0.0;
	for (int l49 = 0; l49 < 2; l49 = l49 + 1) fRec50[l49] = 0.0;
	for (int l50 = 0; l50 < 2; l50 = l50 + 1) fRec51[l50] = 0.0;
	for (int l51 = 0; l51 < 2; l51 = l51 + 1) fRec55[l51] = 0.0;
	for (int l52 = 0; l52 < 3; l52 = l52 + 1) fRec54[l52] = 0.0;
	for (int l53 = 0; l53 < 2; l53 = l53 + 1) fVec3[l53] = 0.0;
	for (int l54 = 0; l54 < 2; l54 = l54 + 1) fRec53[l54] = 0.0;
	for (int l55 = 0; l55 < 3; l55 = l55 + 1) fRec52[l55] = 0.0;
	for (int l56 = 0; l56 < 524288; l56 = l56 + 1) fRec46[l56] = 0.0;
	for (int l57 = 0; l57 < 2; l57 = l57 + 1) fRec43[l57] = 0.0;
	for (int l58 = 0; l58 < 2; l58 = l58 + 1) iRec44[l58] = 0;
	for (int l59 = 0; l59 < 2; l59 = l59 + 1) fRec45[l59] = 0.0;
	for (int l60 = 0; l60 < 2; l60 = l60 + 1) fRec60[l60] = 0.0;
	for (int l61 = 0; l61 < 2; l61 = l61 + 1) fRec61[l61] = 0.0;
	for (int l62 = 0; l62 < 2; l62 = l62 + 1) fRec62[l62] = 0.0;
	for (int l63 = 0; l63 < 2; l63 = l63 + 1) fRec63[l63] = 0.0;
	for (int l64 = 0; l64 < 2; l64 = l64 + 1) fRec64[l64] = 0.0;
	for (int l65 = 0; l65 < 2; l65 = l65 + 1) fRec66[l65] = 0.0;
	for (int l66 = 0; l66 < 3; l66 = l66 + 1) fRec65[l66] = 0.0;
	for (int l67 = 0; l67 < 524288; l67 = l67 + 1) fRec59[l67] = 0.0;
	for (int l68 = 0; l68 < 2; l68 = l68 + 1) fRec56[l68] = 0.0;
	for (int l69 = 0; l69 < 2; l69 = l69 + 1) iRec57[l69] = 0;
	for (int l70 = 0; l70 < 2; l70 = l70 + 1) fRec58[l70] = 0.0;
}

void Dsp::clear_state_f_static(PluginDef *p)
{
	static_cast<Dsp*>(p)->clear_state_f();
}

inline void Dsp::init(unsigned int sample_rate)
{
	fSampleRate = sample_rate;
	double fConst0 = std::min<double>(192000.0, std::max<double>(1.0, double(fSampleRate)));
	fConst1 = 1.0 / fConst0;
	fConst2 = 3.1415926535897931 / fConst0;
	fConst3 = 60.0 * fConst0;
	fConst4 = 10.0 / fConst0;
	fConst5 = 0.0 - fConst4;
	IOTA0 = 0;
	clear_state_f();
}

void Dsp::init_static(unsigned int sample_rate, PluginDef *p)
{
	static_cast<Dsp*>(p)->init(sample_rate);
}

void always_inline Dsp::compute(int count, FAUSTFLOAT *input0, FAUSTFLOAT *output0)
{
	double fSlow0 = std::tan(fConst2 * double(fHslider0));
	double fSlow1 = 1.0 / fSlow0;
	double fSlow2 = fSlow1 + 1.0;
	double fSlow3 = 1.0 / (fSlow2 / fSlow0 + 1.0);
	double fSlow4 = mydsp_faustpower2_f(fSlow0);
	double fSlow5 = 1.0 / fSlow4;
	double fSlow6 = 2.0 * (1.0 - fSlow5);
	double fSlow7 = std::tan(fConst2 * double(fHslider1));
	double fSlow8 = 1.0 / fSlow7;
	double fSlow9 = (fSlow8 + 1.0000000000000004) / fSlow7 + 1.0;
	double fSlow10 = 1.0 / fSlow9;
	double fSlow11 = mydsp_faustpower2_f(fSlow7);
	double fSlow12 = 1.0 / fSlow11;
	double fSlow13 = fSlow8 + 1.0;
	double fSlow14 = 0.0 - 1.0 / (fSlow7 * fSlow13);
	double fSlow15 = 1.0 / fSlow13;
	double fSlow16 = 1.0 - fSlow8;
	double fSlow17 = (fSlow8 + -1.0000000000000004) / fSlow7 + 1.0;
	double fSlow18 = 2.0 * (1.0 - fSlow12);
	double fSlow19 = 0.0 - 2.0 / fSlow11;
	double fSlow20 = std::tan(fConst2 * double(fHslider2));
	double fSlow21 = 1.0 / fSlow20;
	double fSlow22 = fSlow21 + 1.0;
	double fSlow23 = 1.0 / (fSlow22 / fSlow20 + 1.0);
	double fSlow24 = (fSlow21 + -1.0) / fSlow20 + 1.0;
	double fSlow25 = mydsp_faustpower2_f(fSlow20);
	double fSlow26 = 1.0 / fSlow25;
	double fSlow27 = 2.0 * (1.0 - fSlow26);
	double fSlow28 = std::tan(fConst2 * double(fHslider3));
	double fSlow29 = 1.0 / fSlow28;
	double fSlow30 = fSlow29 + 1.0;
	double fSlow31 = 1.0 / (fSlow30 / fSlow28 + 1.0);
	double fSlow32 = 1.0 - fSlow29;
	double fSlow33 = 1.0 - fSlow32 / fSlow28;
	double fSlow34 = mydsp_faustpower2_f(fSlow28);
	double fSlow35 = 1.0 / fSlow34;
	double fSlow36 = 2.0 * (1.0 - fSlow35);
	double fSlow37 = 1.0 - fSlow1;
	double fSlow38 = 1.0 - fSlow37 / fSlow0;
	double fSlow39 = 1.0000000000000009e-05 * double(fHslider4);
	double fSlow40 = fConst3 / double(fHslider5);
	double fSlow41 = (fSlow21 + 1.0000000000000004) / fSlow20 + 1.0;
	double fSlow42 = 1.0 / fSlow41;
	double fSlow43 = 0.0 - 1.0 / (fSlow20 * fSlow22);
	double fSlow44 = 1.0 / fSlow22;
	double fSlow45 = 1.0 - fSlow21;
	double fSlow46 = 1.0 / (fSlow20 * fSlow9);
	double fSlow47 = (fSlow21 + -1.0000000000000004) / fSlow20 + 1.0;
	double fSlow48 = 0.0 - 2.0 / fSlow25;
	double fSlow49 = 1.0000000000000009e-05 * double(fHslider6);
	double fSlow50 = fConst3 / double(fHslider7);
	double fSlow51 = (fSlow29 + 1.0000000000000004) / fSlow28 + 1.0;
	double fSlow52 = 1.0 / fSlow51;
	double fSlow53 = 0.0 - 1.0 / (fSlow28 * fSlow30);
	double fSlow54 = 1.0 / fSlow30;
	double fSlow55 = 1.0 / (fSlow28 * fSlow41);
	double fSlow56 = (fSlow29 + -1.0000000000000004) / fSlow28 + 1.0;
	double fSlow57 = 0.0 - 2.0 / fSlow34;
	double fSlow58 = 1.0000000000000009e-05 * double(fHslider8);
	double fSlow59 = fConst3 / double(fHslider9);
	double fSlow60 = 1.0000000000000009e-05 * double(fHslider10);
	double fSlow61 = fConst3 / double(fHslider11);
	double fSlow62 = 1.0 / ((fSlow1 + 1.0000000000000004) / fSlow0 + 1.0);
	double fSlow63 = 0.0 - 1.0 / (fSlow0 * fSlow2);
	double fSlow64 = 1.0 / fSlow2;
	double fSlow65 = 1.0 / (fSlow0 * fSlow51);
	double fSlow66 = (fSlow1 + -1.0000000000000004) / fSlow0 + 1.0;
	double fSlow67 = 0.0 - 2.0 / fSlow4;
	double fSlow68 = 1.0000000000000009e-05 * double(fHslider12);
	double fSlow69 = fConst3 / double(fHslider13);
	for (int i0 = 0; i0 < count; i0 = i0 + 1) {
		int iTemp0 = iRec1[1] < 4096;
		double fTemp1 = double(input0[i0]);
		fVec0[0] = fTemp1;
		fRec8[0] = fSlow14 * fVec0[1] - fSlow15 * (fSlow16 * fRec8[1] - fSlow8 * fTemp1);
		fRec7[0] = fRec8[0] - fSlow10 * (fSlow17 * fRec7[2] + fSlow18 * fRec7[1]);
		double fTemp2 = fSlow27 * fRec6[1];
		fRec6[0] = fSlow10 * (fSlow12 * fRec7[0] + fSlow19 * fRec7[1] + fSlow12 * fRec7[2]) - fSlow23 * (fSlow24 * fRec6[2] + fTemp2);
		double fTemp3 = fSlow36 * fRec5[1];
		fRec5[0] = (fRec6[2] + fSlow23 * (fTemp2 + fSlow24 * fRec6[0])) - fSlow31 * (fSlow33 * fRec5[2] + fTemp3);
		double fTemp4 = fSlow6 * fRec4[1];
		fRec4[0] = (fRec5[2] + fSlow31 * (fTemp3 + fSlow33 * fRec5[0])) - fSlow3 * (fSlow38 * fRec4[2] + fTemp4);
		fRec9[0] = fSlow39 + 0.999 * fRec9[1];
		double fThen1 = (((fRec11[1] == 1.0) & (fSlow40 != fRec13[1])) ? fConst5 : 0.0);
		double fThen3 = (((fRec11[1] == 0.0) & (fSlow40 != fRec12[1])) ? fConst4 : fThen1);
		double fElse3 = (((fRec11[1] > 0.0) & (fRec11[1] < 1.0)) ? fRec10[1] : 0.0);
		double fTemp5 = ((fRec10[1] != 0.0) ? fElse3 : fThen3);
		fRec10[0] = fTemp5;
		fRec11[0] = std::max<double>(0.0, std::min<double>(1.0, fRec11[1] + fTemp5));
		fRec12[0] = (((fRec11[1] >= 1.0) & (fRec13[1] != fSlow40)) ? fSlow40 : fRec12[1]);
		fRec13[0] = (((fRec11[1] <= 0.0) & (fRec12[1] != fSlow40)) ? fSlow40 : fRec13[1]);
		double fTemp6 = fRec3[(IOTA0 - (int(std::min<double>(262144.0, std::max<double>(0.0, fRec12[0]))) + 1)) & 524287];
		fRec3[IOTA0 & 524287] = fSlow3 * (fTemp4 + fSlow38 * fRec4[0]) + fRec9[0] * (fTemp6 + fRec11[0] * (fRec3[(IOTA0 - (int(std::min<double>(262144.0, std::max<double>(0.0, fRec13[0]))) + 1)) & 524287] - fTemp6)) + fRec4[2];
		double fTemp7 = fRec3[IOTA0 & 524287];
		double fTemp8 = std::max<double>(fConst1, std::fabs(fTemp7));
		double fElse6 = fTemp8 + fRec0[1];
		fRec0[0] = ((iTemp0) ? fElse6 : fTemp8);
		int iElse7 = iRec1[1] + 1;
		iRec1[0] = ((iTemp0) ? iElse7 : 1);
		double fThen8 = 0.000244140625 * fRec0[1];
		fRec2[0] = ((iTemp0) ? fRec2[1] : fThen8);
		fVbargraph0 = FAUSTFLOAT(fRec2[0]);
		int iTemp9 = iRec15[1] < 4096;
		fRec23[0] = 0.0 - fSlow15 * (fSlow16 * fRec23[1] - (fTemp1 + fVec0[1]));
		fRec22[0] = fRec23[0] - fSlow10 * (fSlow17 * fRec22[2] + fSlow18 * fRec22[1]);
		double fTemp10 = fRec22[2] + fRec22[0] + 2.0 * fRec22[1];
		double fTemp11 = fSlow10 * fTemp10;
		fVec1[0] = fTemp11;
		fRec21[0] = fSlow43 * fVec1[1] - fSlow44 * (fSlow45 * fRec21[1] - fSlow46 * fTemp10);
		fRec20[0] = fRec21[0] - fSlow42 * (fSlow47 * fRec20[2] + fSlow27 * fRec20[1]);
		double fTemp12 = fSlow36 * fRec19[1];
		fRec19[0] = fSlow42 * (fSlow26 * fRec20[0] + fSlow48 * fRec20[1] + fSlow26 * fRec20[2]) - fSlow31 * (fSlow33 * fRec19[2] + fTemp12);
		double fTemp13 = fSlow6 * fRec18[1];
		fRec18[0] = (fRec19[2] + fSlow31 * (fTemp12 + fSlow33 * fRec19[0])) - fSlow3 * (fSlow38 * fRec18[2] + fTemp13);
		fRec24[0] = fSlow49 + 0.999 * fRec24[1];
		double fThen10 = (((fRec26[1] == 1.0) & (fSlow50 != fRec28[1])) ? fConst5 : 0.0);
		double fThen12 = (((fRec26[1] == 0.0) & (fSlow50 != fRec27[1])) ? fConst4 : fThen10);
		double fElse12 = (((fRec26[1] > 0.0) & (fRec26[1] < 1.0)) ? fRec25[1] : 0.0);
		double fTemp14 = ((fRec25[1] != 0.0) ? fElse12 : fThen12);
		fRec25[0] = fTemp14;
		fRec26[0] = std::max<double>(0.0, std::min<double>(1.0, fRec26[1] + fTemp14));
		fRec27[0] = (((fRec26[1] >= 1.0) & (fRec28[1] != fSlow50)) ? fSlow50 : fRec27[1]);
		fRec28[0] = (((fRec26[1] <= 0.0) & (fRec27[1] != fSlow50)) ? fSlow50 : fRec28[1]);
		double fTemp15 = fRec17[(IOTA0 - (int(std::min<double>(262144.0, std::max<double>(0.0, fRec27[0]))) + 1)) & 524287];
		fRec17[IOTA0 & 524287] = fSlow3 * (fTemp13 + fSlow38 * fRec18[0]) + fRec24[0] * (fTemp15 + fRec26[0] * (fRec17[(IOTA0 - (int(std::min<double>(262144.0, std::max<double>(0.0, fRec28[0]))) + 1)) & 524287] - fTemp15)) + fRec18[2];
		double fTemp16 = fRec17[IOTA0 & 524287];
		double fTemp17 = std::max<double>(fConst1, std::fabs(fTemp16));
		double fElse15 = fTemp17 + fRec14[1];
		fRec14[0] = ((iTemp9) ? fElse15 : fTemp17);
		int iElse16 = iRec15[1] + 1;
		iRec15[0] = ((iTemp9) ? iElse16 : 1);
		double fThen17 = 0.000244140625 * fRec14[1];
		fRec16[0] = ((iTemp9) ? fRec16[1] : fThen17);
		fVbargraph1 = FAUSTFLOAT(fRec16[0]);
		int iTemp18 = iRec30[1] < 4096;
		fRec37[0] = 0.0 - fSlow44 * (fSlow45 * fRec37[1] - (fTemp11 + fVec1[1]));
		fRec36[0] = fRec37[0] - fSlow42 * (fSlow47 * fRec36[2] + fSlow27 * fRec36[1]);
		double fTemp19 = fRec36[2] + fRec36[0] + 2.0 * fRec36[1];
		double fTemp20 = fSlow42 * fTemp19;
		fVec2[0] = fTemp20;
		fRec35[0] = fSlow53 * fVec2[1] - fSlow54 * (fSlow32 * fRec35[1] - fSlow55 * fTemp19);
		fRec34[0] = fRec35[0] - fSlow52 * (fSlow56 * fRec34[2] + fSlow36 * fRec34[1]);
		double fTemp21 = fSlow6 * fRec33[1];
		fRec33[0] = fSlow52 * (fSlow35 * fRec34[0] + fSlow57 * fRec34[1] + fSlow35 * fRec34[2]) - fSlow3 * (fSlow38 * fRec33[2] + fTemp21);
		fRec38[0] = fSlow58 + 0.999 * fRec38[1];
		double fThen19 = (((fRec40[1] == 1.0) & (fSlow59 != fRec42[1])) ? fConst5 : 0.0);
		double fThen21 = (((fRec40[1] == 0.0) & (fSlow59 != fRec41[1])) ? fConst4 : fThen19);
		double fElse21 = (((fRec40[1] > 0.0) & (fRec40[1] < 1.0)) ? fRec39[1] : 0.0);
		double fTemp22 = ((fRec39[1] != 0.0) ? fElse21 : fThen21);
		fRec39[0] = fTemp22;
		fRec40[0] = std::max<double>(0.0, std::min<double>(1.0, fRec40[1] + fTemp22));
		fRec41[0] = (((fRec40[1] >= 1.0) & (fRec42[1] != fSlow59)) ? fSlow59 : fRec41[1]);
		fRec42[0] = (((fRec40[1] <= 0.0) & (fRec41[1] != fSlow59)) ? fSlow59 : fRec42[1]);
		double fTemp23 = fRec32[(IOTA0 - (int(std::min<double>(262144.0, std::max<double>(0.0, fRec41[0]))) + 1)) & 524287];
		fRec32[IOTA0 & 524287] = fSlow3 * (fTemp21 + fSlow38 * fRec33[0]) + fRec38[0] * (fTemp23 + fRec40[0] * (fRec32[(IOTA0 - (int(std::min<double>(262144.0, std::max<double>(0.0, fRec42[0]))) + 1)) & 524287] - fTemp23)) + fRec33[2];
		double fTemp24 = fRec32[IOTA0 & 524287];
		double fTemp25 = std::max<double>(fConst1, std::fabs(fTemp24));
		double fElse24 = fTemp25 + fRec29[1];
		fRec29[0] = ((iTemp18) ? fElse24 : fTemp25);
		int iElse25 = iRec30[1] + 1;
		iRec30[0] = ((iTemp18) ? iElse25 : 1);
		double fThen26 = 0.000244140625 * fRec29[1];
		fRec31[0] = ((iTemp18) ? fRec31[1] : fThen26);
		fVbargraph2 = FAUSTFLOAT(fRec31[0]);
		int iTemp26 = iRec44[1] < 4096;
		fRec47[0] = fSlow60 + 0.999 * fRec47[1];
		double fThen28 = (((fRec49[1] == 1.0) & (fSlow61 != fRec51[1])) ? fConst5 : 0.0);
		double fThen30 = (((fRec49[1] == 0.0) & (fSlow61 != fRec50[1])) ? fConst4 : fThen28);
		double fElse30 = (((fRec49[1] > 0.0) & (fRec49[1] < 1.0)) ? fRec48[1] : 0.0);
		double fTemp27 = ((fRec48[1] != 0.0) ? fElse30 : fThen30);
		fRec48[0] = fTemp27;
		fRec49[0] = std::max<double>(0.0, std::min<double>(1.0, fRec49[1] + fTemp27));
		fRec50[0] = (((fRec49[1] >= 1.0) & (fRec51[1] != fSlow61)) ? fSlow61 : fRec50[1]);
		fRec51[0] = (((fRec49[1] <= 0.0) & (fRec50[1] != fSlow61)) ? fSlow61 : fRec51[1]);
		double fTemp28 = fRec46[(IOTA0 - (int(std::min<double>(262144.0, std::max<double>(0.0, fRec50[0]))) + 1)) & 524287];
		fRec55[0] = 0.0 - fSlow54 * (fSlow32 * fRec55[1] - (fTemp20 + fVec2[1]));
		fRec54[0] = fRec55[0] - fSlow52 * (fSlow56 * fRec54[2] + fSlow36 * fRec54[1]);
		double fTemp29 = fRec54[2] + fRec54[0] + 2.0 * fRec54[1];
		double fTemp30 = fSlow52 * fTemp29;
		fVec3[0] = fTemp30;
		fRec53[0] = fSlow63 * fVec3[1] - fSlow64 * (fSlow37 * fRec53[1] - fSlow65 * fTemp29);
		fRec52[0] = fRec53[0] - fSlow62 * (fSlow66 * fRec52[2] + fSlow6 * fRec52[1]);
		fRec46[IOTA0 & 524287] = fRec47[0] * (fTemp28 + fRec49[0] * (fRec46[(IOTA0 - (int(std::min<double>(262144.0, std::max<double>(0.0, fRec51[0]))) + 1)) & 524287] - fTemp28)) + fSlow62 * (fSlow5 * fRec52[0] + fSlow67 * fRec52[1] + fSlow5 * fRec52[2]);
		double fTemp31 = fRec46[IOTA0 & 524287];
		double fTemp32 = std::max<double>(fConst1, std::fabs(fTemp31));
		double fElse33 = fTemp32 + fRec43[1];
		fRec43[0] = ((iTemp26) ? fElse33 : fTemp32);
		int iElse34 = iRec44[1] + 1;
		iRec44[0] = ((iTemp26) ? iElse34 : 1);
		double fThen35 = 0.000244140625 * fRec43[1];
		fRec45[0] = ((iTemp26) ? fRec45[1] : fThen35);
		fVbargraph3 = FAUSTFLOAT(fRec45[0]);
		int iTemp33 = iRec57[1] < 4096;
		fRec60[0] = fSlow68 + 0.999 * fRec60[1];
		double fThen37 = (((fRec62[1] == 1.0) & (fSlow69 != fRec64[1])) ? fConst5 : 0.0);
		double fThen39 = (((fRec62[1] == 0.0) & (fSlow69 != fRec63[1])) ? fConst4 : fThen37);
		double fElse39 = (((fRec62[1] > 0.0) & (fRec62[1] < 1.0)) ? fRec61[1] : 0.0);
		double fTemp34 = ((fRec61[1] != 0.0) ? fElse39 : fThen39);
		fRec61[0] = fTemp34;
		fRec62[0] = std::max<double>(0.0, std::min<double>(1.0, fRec62[1] + fTemp34));
		fRec63[0] = (((fRec62[1] >= 1.0) & (fRec64[1] != fSlow69)) ? fSlow69 : fRec63[1]);
		fRec64[0] = (((fRec62[1] <= 0.0) & (fRec63[1] != fSlow69)) ? fSlow69 : fRec64[1]);
		double fTemp35 = fRec59[(IOTA0 - (int(std::min<double>(262144.0, std::max<double>(0.0, fRec63[0]))) + 1)) & 524287];
		fRec66[0] = 0.0 - fSlow64 * (fSlow37 * fRec66[1] - (fTemp30 + fVec3[1]));
		fRec65[0] = fRec66[0] - fSlow62 * (fSlow66 * fRec65[2] + fSlow6 * fRec65[1]);
		fRec59[IOTA0 & 524287] = fRec60[0] * (fTemp35 + fRec62[0] * (fRec59[(IOTA0 - (int(std::min<double>(262144.0, std::max<double>(0.0, fRec64[0]))) + 1)) & 524287] - fTemp35)) + fSlow62 * (fRec65[2] + fRec65[0] + 2.0 * fRec65[1]);
		double fTemp36 = fRec59[IOTA0 & 524287];
		double fTemp37 = std::max<double>(fConst1, std::fabs(fTemp36));
		double fElse42 = fTemp37 + fRec56[1];
		fRec56[0] = ((iTemp33) ? fElse42 : fTemp37);
		int iElse43 = iRec57[1] + 1;
		iRec57[0] = ((iTemp33) ? iElse43 : 1);
		double fThen44 = 0.000244140625 * fRec56[1];
		fRec58[0] = ((iTemp33) ? fRec58[1] : fThen44);
		fVbargraph4 = FAUSTFLOAT(fRec58[0]);
		output0[i0] = FAUSTFLOAT(fTemp7 + fTemp16 + fTemp24 + fTemp31 + fTemp36);
		fVec0[1] = fVec0[0];
		fRec8[1] = fRec8[0];
		fRec7[2] = fRec7[1];
		fRec7[1] = fRec7[0];
		fRec6[2] = fRec6[1];
		fRec6[1] = fRec6[0];
		fRec5[2] = fRec5[1];
		fRec5[1] = fRec5[0];
		fRec4[2] = fRec4[1];
		fRec4[1] = fRec4[0];
		fRec9[1] = fRec9[0];
		IOTA0 = IOTA0 + 1;
		fRec10[1] = fRec10[0];
		fRec11[1] = fRec11[0];
		fRec12[1] = fRec12[0];
		fRec13[1] = fRec13[0];
		fRec0[1] = fRec0[0];
		iRec1[1] = iRec1[0];
		fRec2[1] = fRec2[0];
		fRec23[1] = fRec23[0];
		fRec22[2] = fRec22[1];
		fRec22[1] = fRec22[0];
		fVec1[1] = fVec1[0];
		fRec21[1] = fRec21[0];
		fRec20[2] = fRec20[1];
		fRec20[1] = fRec20[0];
		fRec19[2] = fRec19[1];
		fRec19[1] = fRec19[0];
		fRec18[2] = fRec18[1];
		fRec18[1] = fRec18[0];
		fRec24[1] = fRec24[0];
		fRec25[1] = fRec25[0];
		fRec26[1] = fRec26[0];
		fRec27[1] = fRec27[0];
		fRec28[1] = fRec28[0];
		fRec14[1] = fRec14[0];
		iRec15[1] = iRec15[0];
		fRec16[1] = fRec16[0];
		fRec37[1] = fRec37[0];
		fRec36[2] = fRec36[1];
		fRec36[1] = fRec36[0];
		fVec2[1] = fVec2[0];
		fRec35[1] = fRec35[0];
		fRec34[2] = fRec34[1];
		fRec34[1] = fRec34[0];
		fRec33[2] = fRec33[1];
		fRec33[1] = fRec33[0];
		fRec38[1] = fRec38[0];
		fRec39[1] = fRec39[0];
		fRec40[1] = fRec40[0];
		fRec41[1] = fRec41[0];
		fRec42[1] = fRec42[0];
		fRec29[1] = fRec29[0];
		iRec30[1] = iRec30[0];
		fRec31[1] = fRec31[0];
		fRec47[1] = fRec47[0];
		fRec48[1] = fRec48[0];
		fRec49[1] = fRec49[0];
		fRec50[1] = fRec50[0];
		fRec51[1] = fRec51[0];
		fRec55[1] = fRec55[0];
		fRec54[2] = fRec54[1];
		fRec54[1] = fRec54[0];
		fVec3[1] = fVec3[0];
		fRec53[1] = fRec53[0];
		fRec52[2] = fRec52[1];
		fRec52[1] = fRec52[0];
		fRec43[1] = fRec43[0];
		iRec44[1] = iRec44[0];
		fRec45[1] = fRec45[0];
		fRec60[1] = fRec60[0];
		fRec61[1] = fRec61[0];
		fRec62[1] = fRec62[0];
		fRec63[1] = fRec63[0];
		fRec64[1] = fRec64[0];
		fRec66[1] = fRec66[0];
		fRec65[2] = fRec65[1];
		fRec65[1] = fRec65[0];
		fRec56[1] = fRec56[0];
		iRec57[1] = iRec57[0];
		fRec58[1] = fRec58[0];
	}
}

void __rt_func Dsp::compute_static(int count, FAUSTFLOAT *input0, FAUSTFLOAT *output0, PluginDef *p)
{
	static_cast<Dsp*>(p)->compute(count, input0, output0);
}

int Dsp::register_par(const ParamReg& reg)
{
	reg.registerFloatVar("mbe.crossover_b1_b2",N_("Crossover B1-B2 (hz)"),"SL",N_("Crossover fi.bandpass frequency"),&fHslider0, 80.0, 20.0, 20000.0, 1.0800000000000001, 0);
	reg.registerFloatVar("mbe.crossover_b2_b3",N_("Crossover B2-B3 (hz)"),"SL",N_("Crossover fi.bandpass frequency"),&fHslider3, 210.0, 20.0, 20000.0, 1.0800000000000001, 0);
	reg.registerFloatVar("mbe.crossover_b3_b4",N_("Crossover B3-B4 (hz)"),"SL",N_("Crossover fi.bandpass frequency"),&fHslider2, 1700.0, 20.0, 20000.0, 1.0800000000000001, 0);
	reg.registerFloatVar("mbe.crossover_b4_b5",N_("Crossover B4-B5 (hz)"),"SL",N_("Crossover fi.bandpass frequency"),&fHslider1, 5000.0, 20.0, 20000.0, 1.0800000000000001, 0);
	reg.registerFloatVar("mbe.percent1","","S","",&fHslider12, 10.0, 0.0, 100.0, 0.10000000000000001, 0);
	reg.registerFloatVar("mbe.percent2","","S","",&fHslider10, 30.0, 0.0, 100.0, 0.10000000000000001, 0);
	reg.registerFloatVar("mbe.percent3","","S","",&fHslider8, 45.0, 0.0, 100.0, 0.10000000000000001, 0);
	reg.registerFloatVar("mbe.percent4","","S","",&fHslider6, 20.0, 0.0, 100.0, 0.10000000000000001, 0);
	reg.registerFloatVar("mbe.percent5","","S","",&fHslider4, 0.0, 0.0, 100.0, 0.10000000000000001, 0);
	reg.registerFloatVar("mbe.time1","","S",N_("Echo in Beats per Minute"),&fHslider13, 30.0, 24.0, 360.0, 1.0, 0);
	reg.registerFloatVar("mbe.time2","","S",N_("Echo in Beats per Minute"),&fHslider11, 60.0, 24.0, 360.0, 1.0, 0);
	reg.registerFloatVar("mbe.time3","","S",N_("Echo in Beats per Minute"),&fHslider9, 120.0, 24.0, 360.0, 1.0, 0);
	reg.registerFloatVar("mbe.time4","","S",N_("Echo in Beats per Minute"),&fHslider7, 150.0, 24.0, 360.0, 1.0, 0);
	reg.registerFloatVar("mbe.time5","","S",N_("Echo in Beats per Minute"),&fHslider5, 240.0, 24.0, 360.0, 1.0, 0);
	reg.registerFloatVar("mbe.v1","","SOLN","",&fVbargraph4, 0, -70.0, 5.0, 0, 0);
	reg.registerFloatVar("mbe.v2","","SOLN","",&fVbargraph3, 0, -70.0, 5.0, 0, 0);
	reg.registerFloatVar("mbe.v3","","SOLN","",&fVbargraph2, 0, -70.0, 5.0, 0, 0);
	reg.registerFloatVar("mbe.v4","","SOLN","",&fVbargraph1, 0, -70.0, 5.0, 0, 0);
	reg.registerFloatVar("mbe.v5","","SOLN","",&fVbargraph0, 0, -70.0, 5.0, 0, 0);
	return 0;
}

int Dsp::register_params_static(const ParamReg& reg)
{
	return static_cast<Dsp*>(reg.plugin)->register_par(reg);
}

const char *Dsp::glade_def = "\
<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\
<!-- Generated with glade 3.22.1 -->\n\
<interface>\n\
  <requires lib=\"gtk+\" version=\"3.20\"/>\n\
  <requires lib=\"gxwidgets\" version=\"0.0\"/>\n\
  <object class=\"GtkWindow\" id=\"window1\">\n\
    <property name=\"can_focus\">False</property>\n\
    <child>\n\
      <placeholder/>\n\
    </child>\n\
    <child>\n\
      <object class=\"GtkBox\" id=\"vbox1\">\n\
        <property name=\"visible\">True</property>\n\
        <property name=\"can_focus\">False</property>\n\
        <property name=\"orientation\">vertical</property>\n\
        <child>\n\
          <object class=\"GtkBox\" id=\"rackbox\">\n\
            <property name=\"visible\">True</property>\n\
            <property name=\"can_focus\">False</property>\n\
            <property name=\"spacing\">4</property>\n\
            <child>\n\
              <object class=\"GtkBox\" id=\"hbox1\">\n\
                <property name=\"visible\">True</property>\n\
                <property name=\"can_focus\">False</property>\n\
                <child>\n\
                  <object class=\"GtkNotebook\" id=\"notebook\">\n\
                    <property name=\"visible\">True</property>\n\
                    <property name=\"can_focus\">True</property>\n\
                    <child>\n\
                      <object class=\"GtkBox\" id=\"hbox2\">\n\
                        <property name=\"visible\">True</property>\n\
                        <property name=\"can_focus\">False</property>\n\
                        <property name=\"margin_left\">4</property>\n\
                        <property name=\"margin_right\">4</property>\n\
                        <property name=\"margin_top\">4</property>\n\
                        <property name=\"margin_bottom\">4</property>\n\
                        <property name=\"spacing\">4</property>\n\
                        <child>\n\
                          <object class=\"GtkBox\" id=\"hbox4\">\n\
                            <property name=\"visible\">True</property>\n\
                            <property name=\"can_focus\">False</property>\n\
                            <child>\n\
                              <object class=\"GtkBox\" id=\"vbox3\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">False</property>\n\
                                <property name=\"orientation\">vertical</property>\n\
                                <child>\n\
                                  <object class=\"GtkLabel\" id=\"label_81:rack_label\">\n\
                                    <property name=\"visible\">True</property>\n\
                                    <property name=\"can_focus\">False</property>\n\
                                    <property name=\"label\" translatable=\"yes\">BPM</property>\n\
                                  </object>\n\
                                  <packing>\n\
                                    <property name=\"expand\">False</property>\n\
                                    <property name=\"fill\">False</property>\n\
                                    <property name=\"position\">0</property>\n\
                                  </packing>\n\
                                </child>\n\
                                <child>\n\
                                  <object class=\"GxSmallKnobR\" id=\"gxmediumknob1\">\n\
                                    <property name=\"visible\">True</property>\n\
                                    <property name=\"can_focus\">True</property>\n\
                                    <property name=\"receives_default\">True</property>\n\
                                    <property name=\"show_fill_level\">True</property>\n\
                                    <property name=\"var_id\">mbe.time1</property>\n\
                                  </object>\n\
                                  <packing>\n\
                                    <property name=\"expand\">False</property>\n\
                                    <property name=\"fill\">False</property>\n\
                                    <property name=\"position\">1</property>\n\
                                  </packing>\n\
                                </child>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"expand\">True</property>\n\
                                <property name=\"fill\">True</property>\n\
                                <property name=\"position\">0</property>\n\
                              </packing>\n\
                            </child>\n\
                            <child>\n\
                              <object class=\"GtkBox\" id=\"vbox4\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">False</property>\n\
                                <property name=\"orientation\">vertical</property>\n\
                                <child>\n\
                                  <object class=\"GtkLabel\" id=\"label_91:rack_label\">\n\
                                    <property name=\"visible\">True</property>\n\
                                    <property name=\"can_focus\">False</property>\n\
                                    <property name=\"label\" translatable=\"yes\">Amount</property>\n\
                                  </object>\n\
                                  <packing>\n\
                                    <property name=\"expand\">False</property>\n\
                                    <property name=\"fill\">False</property>\n\
                                    <property name=\"position\">0</property>\n\
                                  </packing>\n\
                                </child>\n\
                                <child>\n\
                                  <object class=\"GxSmallKnobR\" id=\"gxmediumknob2\">\n\
                                    <property name=\"visible\">True</property>\n\
                                    <property name=\"can_focus\">True</property>\n\
                                    <property name=\"receives_default\">True</property>\n\
                                    <property name=\"var_id\">mbe.percent1</property>\n\
                                  </object>\n\
                                  <packing>\n\
                                    <property name=\"expand\">False</property>\n\
                                    <property name=\"fill\">False</property>\n\
                                    <property name=\"position\">1</property>\n\
                                  </packing>\n\
                                </child>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"expand\">True</property>\n\
                                <property name=\"fill\">True</property>\n\
                                <property name=\"position\">1</property>\n\
                              </packing>\n\
                            </child>\n\
                          </object>\n\
                          <packing>\n\
                            <property name=\"expand\">True</property>\n\
                            <property name=\"fill\">True</property>\n\
                            <property name=\"position\">0</property>\n\
                          </packing>\n\
                        </child>\n\
                        <child>\n\
                          <object class=\"GtkGrid\" id=\"table1\">\n\
                            <property name=\"visible\">True</property>\n\
                            <property name=\"can_focus\">False</property>\n\
                            <property name=\"halign\">center</property>\n\
                            <property name=\"margin_left\">4</property>\n\
                            <property name=\"margin_right\">4</property>\n\
                            <property name=\"margin_top\">4</property>\n\
                            <property name=\"margin_bottom\">4</property>\n\
                            <property name=\"row_spacing\">4</property>\n\
                            <property name=\"column_spacing\">4</property>\n\
                            <property name=\"row_homogeneous\">True</property>\n\
                            <child>\n\
                              <object class=\"GtkLabel\" id=\"label_141:rack_label\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">False</property>\n\
                                <property name=\"hexpand\">True</property>\n\
                                <property name=\"label\" translatable=\"yes\">High</property>\n\
                                <property name=\"xalign\">1</property>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"left_attach\">0</property>\n\
                                <property name=\"top_attach\">0</property>\n\
                              </packing>\n\
                            </child>\n\
                            <child>\n\
                              <object class=\"GxSmallKnob\" id=\"gxsmallknob2\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">True</property>\n\
                                <property name=\"receives_default\">True</property>\n\
                                <property name=\"var_id\">mbe.crossover_b1_b2</property>\n\
                                <property name=\"value_position\">right</property>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"left_attach\">1</property>\n\
                                <property name=\"top_attach\">0</property>\n\
                              </packing>\n\
                            </child>\n\
                            <child>\n\
                              <object class=\"GtkLabel\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">False</property>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"left_attach\">0</property>\n\
                                <property name=\"top_attach\">1</property>\n\
                              </packing>\n\
                            </child>\n\
                            <child>\n\
                              <placeholder/>\n\
                            </child>\n\
                          </object>\n\
                          <packing>\n\
                            <property name=\"expand\">True</property>\n\
                            <property name=\"fill\">True</property>\n\
                            <property name=\"position\">1</property>\n\
                          </packing>\n\
                        </child>\n\
                      </object>\n\
                    </child>\n\
                    <child type=\"tab\">\n\
                      <object class=\"GtkLabel\" id=\"label1\">\n\
                        <property name=\"visible\">True</property>\n\
                        <property name=\"can_focus\">False</property>\n\
                        <property name=\"label\" translatable=\"yes\">Band 1</property>\n\
                      </object>\n\
                      <packing>\n\
                        <property name=\"tab_fill\">False</property>\n\
                      </packing>\n\
                    </child>\n\
                    <child>\n\
                      <object class=\"GtkBox\" id=\"hbox5\">\n\
                        <property name=\"visible\">True</property>\n\
                        <property name=\"can_focus\">False</property>\n\
                        <property name=\"margin_left\">4</property>\n\
                        <property name=\"margin_right\">4</property>\n\
                        <property name=\"margin_top\">4</property>\n\
                        <property name=\"margin_bottom\">4</property>\n\
                        <property name=\"spacing\">4</property>\n\
                        <child>\n\
                          <object class=\"GtkBox\" id=\"hbox6\">\n\
                            <property name=\"visible\">True</property>\n\
                            <property name=\"can_focus\">False</property>\n\
                            <child>\n\
                              <object class=\"GtkBox\" id=\"vbox8\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">False</property>\n\
                                <property name=\"orientation\">vertical</property>\n\
                                <child>\n\
                                  <object class=\"GtkLabel\" id=\"label_8:rack_label\">\n\
                                    <property name=\"visible\">True</property>\n\
                                    <property name=\"can_focus\">False</property>\n\
                                    <property name=\"label\" translatable=\"yes\">BPM</property>\n\
                                  </object>\n\
                                  <packing>\n\
                                    <property name=\"expand\">False</property>\n\
                                    <property name=\"fill\">False</property>\n\
                                    <property name=\"position\">0</property>\n\
                                  </packing>\n\
                                </child>\n\
                                <child>\n\
                                  <object class=\"GxSmallKnobR\" id=\"gxmediumknob4\">\n\
                                    <property name=\"visible\">True</property>\n\
                                    <property name=\"can_focus\">True</property>\n\
                                    <property name=\"receives_default\">True</property>\n\
                                    <property name=\"show_fill_level\">True</property>\n\
                                    <property name=\"var_id\">mbe.time2</property>\n\
                                  </object>\n\
                                  <packing>\n\
                                    <property name=\"expand\">False</property>\n\
                                    <property name=\"fill\">False</property>\n\
                                    <property name=\"position\">1</property>\n\
                                  </packing>\n\
                                </child>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"expand\">True</property>\n\
                                <property name=\"fill\">True</property>\n\
                                <property name=\"position\">0</property>\n\
                              </packing>\n\
                            </child>\n\
                            <child>\n\
                              <object class=\"GtkBox\" id=\"vbox9\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">False</property>\n\
                                <property name=\"orientation\">vertical</property>\n\
                                <child>\n\
                                  <object class=\"GtkLabel\" id=\"label_9:rack_label\">\n\
                                    <property name=\"visible\">True</property>\n\
                                    <property name=\"can_focus\">False</property>\n\
                                    <property name=\"label\" translatable=\"yes\">Amount</property>\n\
                                  </object>\n\
                                  <packing>\n\
                                    <property name=\"expand\">False</property>\n\
                                    <property name=\"fill\">False</property>\n\
                                    <property name=\"position\">0</property>\n\
                                  </packing>\n\
                                </child>\n\
                                <child>\n\
                                  <object class=\"GxSmallKnobR\" id=\"gxmediumknob5\">\n\
                                    <property name=\"visible\">True</property>\n\
                                    <property name=\"can_focus\">True</property>\n\
                                    <property name=\"receives_default\">True</property>\n\
                                    <property name=\"var_id\">mbe.percent2</property>\n\
                                  </object>\n\
                                  <packing>\n\
                                    <property name=\"expand\">False</property>\n\
                                    <property name=\"fill\">False</property>\n\
                                    <property name=\"position\">1</property>\n\
                                  </packing>\n\
                                </child>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"expand\">True</property>\n\
                                <property name=\"fill\">True</property>\n\
                                <property name=\"position\">1</property>\n\
                              </packing>\n\
                            </child>\n\
                          </object>\n\
                          <packing>\n\
                            <property name=\"expand\">True</property>\n\
                            <property name=\"fill\">True</property>\n\
                            <property name=\"position\">0</property>\n\
                          </packing>\n\
                        </child>\n\
                        <child>\n\
                          <object class=\"GtkGrid\" id=\"table2\">\n\
                            <property name=\"visible\">True</property>\n\
                            <property name=\"can_focus\">False</property>\n\
                            <property name=\"halign\">center</property>\n\
                            <property name=\"margin_left\">4</property>\n\
                            <property name=\"margin_right\">4</property>\n\
                            <property name=\"margin_top\">4</property>\n\
                            <property name=\"margin_bottom\">4</property>\n\
                            <property name=\"row_spacing\">4</property>\n\
                            <property name=\"column_spacing\">4</property>\n\
                            <property name=\"row_homogeneous\">True</property>\n\
                            <child>\n\
                              <object class=\"GtkLabel\" id=\"label_13:rack_label\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">False</property>\n\
                                <property name=\"hexpand\">True</property>\n\
                                <property name=\"label\" translatable=\"yes\">Low</property>\n\
                                <property name=\"xalign\">1</property>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"left_attach\">0</property>\n\
                                <property name=\"top_attach\">1</property>\n\
                              </packing>\n\
                            </child>\n\
                            <child>\n\
                              <object class=\"GxSmallKnob\" id=\"gxsmallknob7\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">True</property>\n\
                                <property name=\"receives_default\">True</property>\n\
                                <property name=\"var_id\">mbe.crossover_b1_b2</property>\n\
                                <property name=\"value_position\">right</property>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"left_attach\">1</property>\n\
                                <property name=\"top_attach\">1</property>\n\
                              </packing>\n\
                            </child>\n\
                            <child>\n\
                              <object class=\"GtkLabel\" id=\"label_14:rack_label\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">False</property>\n\
                                <property name=\"hexpand\">True</property>\n\
                                <property name=\"label\" translatable=\"yes\">High</property>\n\
                                <property name=\"xalign\">1</property>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"left_attach\">0</property>\n\
                                <property name=\"top_attach\">0</property>\n\
                              </packing>\n\
                            </child>\n\
                            <child>\n\
                              <object class=\"GxSmallKnob\" id=\"gxsmallknob6\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">True</property>\n\
                                <property name=\"receives_default\">True</property>\n\
                                <property name=\"var_id\">mbe.crossover_b2_b3</property>\n\
                                <property name=\"value_position\">right</property>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"left_attach\">1</property>\n\
                                <property name=\"top_attach\">0</property>\n\
                              </packing>\n\
                            </child>\n\
                          </object>\n\
                          <packing>\n\
                            <property name=\"expand\">True</property>\n\
                            <property name=\"fill\">True</property>\n\
                            <property name=\"position\">1</property>\n\
                          </packing>\n\
                        </child>\n\
                      </object>\n\
                      <packing>\n\
                        <property name=\"position\">1</property>\n\
                      </packing>\n\
                    </child>\n\
                    <child type=\"tab\">\n\
                      <object class=\"GtkLabel\" id=\"label2\">\n\
                        <property name=\"visible\">True</property>\n\
                        <property name=\"can_focus\">False</property>\n\
                        <property name=\"label\" translatable=\"yes\">Band 2</property>\n\
                      </object>\n\
                      <packing>\n\
                        <property name=\"position\">1</property>\n\
                        <property name=\"tab_fill\">False</property>\n\
                      </packing>\n\
                    </child>\n\
                    <child>\n\
                      <object class=\"GtkBox\" id=\"hbox7\">\n\
                        <property name=\"visible\">True</property>\n\
                        <property name=\"can_focus\">False</property>\n\
                        <property name=\"margin_left\">4</property>\n\
                        <property name=\"margin_right\">4</property>\n\
                        <property name=\"margin_top\">4</property>\n\
                        <property name=\"margin_bottom\">4</property>\n\
                        <property name=\"spacing\">4</property>\n\
                        <child>\n\
                          <object class=\"GtkBox\" id=\"hbox8\">\n\
                            <property name=\"visible\">True</property>\n\
                            <property name=\"can_focus\">False</property>\n\
                            <child>\n\
                              <object class=\"GtkBox\" id=\"vbox7\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">False</property>\n\
                                <property name=\"orientation\">vertical</property>\n\
                                <child>\n\
                                  <object class=\"GtkLabel\" id=\"label_82:rack_label\">\n\
                                    <property name=\"visible\">True</property>\n\
                                    <property name=\"can_focus\">False</property>\n\
                                    <property name=\"label\" translatable=\"yes\">BPM</property>\n\
                                  </object>\n\
                                  <packing>\n\
                                    <property name=\"expand\">False</property>\n\
                                    <property name=\"fill\">False</property>\n\
                                    <property name=\"position\">0</property>\n\
                                  </packing>\n\
                                </child>\n\
                                <child>\n\
                                  <object class=\"GxSmallKnobR\" id=\"gxmediumknob7\">\n\
                                    <property name=\"visible\">True</property>\n\
                                    <property name=\"can_focus\">True</property>\n\
                                    <property name=\"receives_default\">True</property>\n\
                                    <property name=\"show_fill_level\">True</property>\n\
                                    <property name=\"var_id\">mbe.time3</property>\n\
                                  </object>\n\
                                  <packing>\n\
                                    <property name=\"expand\">False</property>\n\
                                    <property name=\"fill\">False</property>\n\
                                    <property name=\"position\">1</property>\n\
                                  </packing>\n\
                                </child>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"expand\">True</property>\n\
                                <property name=\"fill\">True</property>\n\
                                <property name=\"position\">0</property>\n\
                              </packing>\n\
                            </child>\n\
                            <child>\n\
                              <object class=\"GtkBox\" id=\"vbox11\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">False</property>\n\
                                <property name=\"orientation\">vertical</property>\n\
                                <child>\n\
                                  <object class=\"GtkLabel\" id=\"label_92:rack_label\">\n\
                                    <property name=\"visible\">True</property>\n\
                                    <property name=\"can_focus\">False</property>\n\
                                    <property name=\"label\" translatable=\"yes\">Amount</property>\n\
                                  </object>\n\
                                  <packing>\n\
                                    <property name=\"expand\">False</property>\n\
                                    <property name=\"fill\">False</property>\n\
                                    <property name=\"position\">0</property>\n\
                                  </packing>\n\
                                </child>\n\
                                <child>\n\
                                  <object class=\"GxSmallKnobR\" id=\"gxmediumknob8\">\n\
                                    <property name=\"visible\">True</property>\n\
                                    <property name=\"can_focus\">True</property>\n\
                                    <property name=\"receives_default\">True</property>\n\
                                    <property name=\"var_id\">mbe.percent3</property>\n\
                                  </object>\n\
                                  <packing>\n\
                                    <property name=\"expand\">False</property>\n\
                                    <property name=\"fill\">False</property>\n\
                                    <property name=\"position\">1</property>\n\
                                  </packing>\n\
                                </child>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"expand\">True</property>\n\
                                <property name=\"fill\">True</property>\n\
                                <property name=\"position\">1</property>\n\
                              </packing>\n\
                            </child>\n\
                          </object>\n\
                          <packing>\n\
                            <property name=\"expand\">True</property>\n\
                            <property name=\"fill\">True</property>\n\
                            <property name=\"position\">0</property>\n\
                          </packing>\n\
                        </child>\n\
                        <child>\n\
                          <object class=\"GtkGrid\" id=\"table3\">\n\
                            <property name=\"visible\">True</property>\n\
                            <property name=\"can_focus\">False</property>\n\
                            <property name=\"halign\">center</property>\n\
                            <property name=\"margin_left\">4</property>\n\
                            <property name=\"margin_right\">4</property>\n\
                            <property name=\"margin_top\">4</property>\n\
                            <property name=\"margin_bottom\">4</property>\n\
                            <property name=\"row_spacing\">4</property>\n\
                            <property name=\"column_spacing\">4</property>\n\
                            <property name=\"row_homogeneous\">True</property>\n\
                            <child>\n\
                              <object class=\"GtkLabel\" id=\"label_132:rack_label\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">False</property>\n\
                                <property name=\"hexpand\">True</property>\n\
                                <property name=\"label\" translatable=\"yes\">Low</property>\n\
                                <property name=\"xalign\">1</property>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"left_attach\">0</property>\n\
                                <property name=\"top_attach\">1</property>\n\
                              </packing>\n\
                            </child>\n\
                            <child>\n\
                              <object class=\"GxSmallKnob\" id=\"gxsmallknob3\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">True</property>\n\
                                <property name=\"receives_default\">True</property>\n\
                                <property name=\"var_id\">mbe.crossover_b2_b3</property>\n\
                                <property name=\"value_position\">right</property>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"left_attach\">1</property>\n\
                                <property name=\"top_attach\">1</property>\n\
                              </packing>\n\
                            </child>\n\
                            <child>\n\
                              <object class=\"GtkLabel\" id=\"label_142:rack_label\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">False</property>\n\
                                <property name=\"hexpand\">True</property>\n\
                                <property name=\"label\" translatable=\"yes\">High</property>\n\
                                <property name=\"xalign\">1</property>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"left_attach\">0</property>\n\
                                <property name=\"top_attach\">0</property>\n\
                              </packing>\n\
                            </child>\n\
                            <child>\n\
                              <object class=\"GxSmallKnob\" id=\"gxsmallknob4\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">True</property>\n\
                                <property name=\"receives_default\">True</property>\n\
                                <property name=\"var_id\">mbe.crossover_b3_b4</property>\n\
                                <property name=\"value_position\">right</property>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"left_attach\">1</property>\n\
                                <property name=\"top_attach\">0</property>\n\
                              </packing>\n\
                            </child>\n\
                          </object>\n\
                          <packing>\n\
                            <property name=\"expand\">True</property>\n\
                            <property name=\"fill\">True</property>\n\
                            <property name=\"position\">1</property>\n\
                          </packing>\n\
                        </child>\n\
                      </object>\n\
                      <packing>\n\
                        <property name=\"position\">2</property>\n\
                      </packing>\n\
                    </child>\n\
                    <child type=\"tab\">\n\
                      <object class=\"GtkLabel\" id=\"label3\">\n\
                        <property name=\"visible\">True</property>\n\
                        <property name=\"can_focus\">False</property>\n\
                        <property name=\"label\" translatable=\"yes\">Band 3</property>\n\
                      </object>\n\
                      <packing>\n\
                        <property name=\"position\">2</property>\n\
                        <property name=\"tab_fill\">False</property>\n\
                      </packing>\n\
                    </child>\n\
                    <child>\n\
                      <object class=\"GtkBox\" id=\"hbox9\">\n\
                        <property name=\"visible\">True</property>\n\
                        <property name=\"can_focus\">False</property>\n\
                        <property name=\"margin_left\">4</property>\n\
                        <property name=\"margin_right\">4</property>\n\
                        <property name=\"margin_top\">4</property>\n\
                        <property name=\"margin_bottom\">4</property>\n\
                        <property name=\"spacing\">4</property>\n\
                        <child>\n\
                          <object class=\"GtkBox\" id=\"hbox10\">\n\
                            <property name=\"visible\">True</property>\n\
                            <property name=\"can_focus\">False</property>\n\
                            <child>\n\
                              <object class=\"GtkBox\" id=\"vbox14\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">False</property>\n\
                                <property name=\"orientation\">vertical</property>\n\
                                <child>\n\
                                  <object class=\"GtkLabel\" id=\"label_83:rack_label\">\n\
                                    <property name=\"visible\">True</property>\n\
                                    <property name=\"can_focus\">False</property>\n\
                                    <property name=\"label\" translatable=\"yes\">BPM</property>\n\
                                  </object>\n\
                                  <packing>\n\
                                    <property name=\"expand\">False</property>\n\
                                    <property name=\"fill\">False</property>\n\
                                    <property name=\"position\">0</property>\n\
                                  </packing>\n\
                                </child>\n\
                                <child>\n\
                                  <object class=\"GxSmallKnobR\" id=\"gxmediumknob10\">\n\
                                    <property name=\"visible\">True</property>\n\
                                    <property name=\"can_focus\">True</property>\n\
                                    <property name=\"receives_default\">True</property>\n\
                                    <property name=\"show_fill_level\">True</property>\n\
                                    <property name=\"var_id\">mbe.time4</property>\n\
                                  </object>\n\
                                  <packing>\n\
                                    <property name=\"expand\">False</property>\n\
                                    <property name=\"fill\">False</property>\n\
                                    <property name=\"position\">1</property>\n\
                                  </packing>\n\
                                </child>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"expand\">True</property>\n\
                                <property name=\"fill\">True</property>\n\
                                <property name=\"position\">0</property>\n\
                              </packing>\n\
                            </child>\n\
                            <child>\n\
                              <object class=\"GtkBox\" id=\"vbox15\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">False</property>\n\
                                <property name=\"orientation\">vertical</property>\n\
                                <child>\n\
                                  <object class=\"GtkLabel\" id=\"label_93:rack_label\">\n\
                                    <property name=\"visible\">True</property>\n\
                                    <property name=\"can_focus\">False</property>\n\
                                    <property name=\"label\" translatable=\"yes\">Amount</property>\n\
                                  </object>\n\
                                  <packing>\n\
                                    <property name=\"expand\">False</property>\n\
                                    <property name=\"fill\">False</property>\n\
                                    <property name=\"position\">0</property>\n\
                                  </packing>\n\
                                </child>\n\
                                <child>\n\
                                  <object class=\"GxSmallKnobR\" id=\"gxmediumknob11\">\n\
                                    <property name=\"visible\">True</property>\n\
                                    <property name=\"can_focus\">True</property>\n\
                                    <property name=\"receives_default\">True</property>\n\
                                    <property name=\"var_id\">mbe.percent4</property>\n\
                                  </object>\n\
                                  <packing>\n\
                                    <property name=\"expand\">False</property>\n\
                                    <property name=\"fill\">False</property>\n\
                                    <property name=\"position\">1</property>\n\
                                  </packing>\n\
                                </child>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"expand\">True</property>\n\
                                <property name=\"fill\">True</property>\n\
                                <property name=\"position\">1</property>\n\
                              </packing>\n\
                            </child>\n\
                          </object>\n\
                          <packing>\n\
                            <property name=\"expand\">True</property>\n\
                            <property name=\"fill\">True</property>\n\
                            <property name=\"position\">0</property>\n\
                          </packing>\n\
                        </child>\n\
                        <child>\n\
                          <object class=\"GtkGrid\" id=\"table4\">\n\
                            <property name=\"visible\">True</property>\n\
                            <property name=\"can_focus\">False</property>\n\
                            <property name=\"halign\">center</property>\n\
                            <property name=\"margin_left\">4</property>\n\
                            <property name=\"margin_right\">4</property>\n\
                            <property name=\"margin_top\">4</property>\n\
                            <property name=\"margin_bottom\">4</property>\n\
                            <property name=\"row_spacing\">4</property>\n\
                            <property name=\"column_spacing\">4</property>\n\
                            <property name=\"row_homogeneous\">True</property>\n\
                            <child>\n\
                              <object class=\"GtkLabel\" id=\"label_133:rack_label\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">False</property>\n\
                                <property name=\"hexpand\">True</property>\n\
                                <property name=\"label\" translatable=\"yes\">Low</property>\n\
                                <property name=\"xalign\">1</property>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"left_attach\">0</property>\n\
                                <property name=\"top_attach\">1</property>\n\
                              </packing>\n\
                            </child>\n\
                            <child>\n\
                              <object class=\"GxSmallKnob\" id=\"gxsmallknob5\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">True</property>\n\
                                <property name=\"receives_default\">True</property>\n\
                                <property name=\"var_id\">mbe.crossover_b3_b4</property>\n\
                                <property name=\"value_position\">right</property>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"left_attach\">1</property>\n\
                                <property name=\"top_attach\">1</property>\n\
                              </packing>\n\
                            </child>\n\
                            <child>\n\
                              <object class=\"GtkLabel\" id=\"label_143:rack_label\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">False</property>\n\
                                <property name=\"hexpand\">True</property>\n\
                                <property name=\"label\" translatable=\"yes\">High</property>\n\
                                <property name=\"xalign\">1</property>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"left_attach\">0</property>\n\
                                <property name=\"top_attach\">0</property>\n\
                              </packing>\n\
                            </child>\n\
                            <child>\n\
                              <object class=\"GxSmallKnob\" id=\"gxsmallknob8\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">True</property>\n\
                                <property name=\"receives_default\">True</property>\n\
                                <property name=\"var_id\">mbe.crossover_b4_b5</property>\n\
                                <property name=\"value_position\">right</property>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"left_attach\">1</property>\n\
                                <property name=\"top_attach\">0</property>\n\
                              </packing>\n\
                            </child>\n\
                          </object>\n\
                          <packing>\n\
                            <property name=\"expand\">True</property>\n\
                            <property name=\"fill\">True</property>\n\
                            <property name=\"position\">1</property>\n\
                          </packing>\n\
                        </child>\n\
                      </object>\n\
                      <packing>\n\
                        <property name=\"position\">3</property>\n\
                      </packing>\n\
                    </child>\n\
                    <child type=\"tab\">\n\
                      <object class=\"GtkLabel\" id=\"label4\">\n\
                        <property name=\"visible\">True</property>\n\
                        <property name=\"can_focus\">False</property>\n\
                        <property name=\"label\" translatable=\"yes\">Band 4</property>\n\
                      </object>\n\
                      <packing>\n\
                        <property name=\"position\">3</property>\n\
                        <property name=\"tab_fill\">False</property>\n\
                      </packing>\n\
                    </child>\n\
                    <child>\n\
                      <object class=\"GtkBox\" id=\"hbox11\">\n\
                        <property name=\"visible\">True</property>\n\
                        <property name=\"can_focus\">False</property>\n\
                        <property name=\"margin_left\">4</property>\n\
                        <property name=\"margin_right\">4</property>\n\
                        <property name=\"margin_top\">4</property>\n\
                        <property name=\"margin_bottom\">4</property>\n\
                        <property name=\"spacing\">4</property>\n\
                        <child>\n\
                          <object class=\"GtkBox\" id=\"hbox12\">\n\
                            <property name=\"visible\">True</property>\n\
                            <property name=\"can_focus\">False</property>\n\
                            <child>\n\
                              <object class=\"GtkBox\" id=\"vbox18\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">False</property>\n\
                                <property name=\"orientation\">vertical</property>\n\
                                <child>\n\
                                  <object class=\"GtkLabel\" id=\"label_84:rack_label\">\n\
                                    <property name=\"visible\">True</property>\n\
                                    <property name=\"can_focus\">False</property>\n\
                                    <property name=\"label\" translatable=\"yes\">BPM</property>\n\
                                  </object>\n\
                                  <packing>\n\
                                    <property name=\"expand\">False</property>\n\
                                    <property name=\"fill\">False</property>\n\
                                    <property name=\"position\">0</property>\n\
                                  </packing>\n\
                                </child>\n\
                                <child>\n\
                                  <object class=\"GxSmallKnobR\" id=\"gxmediumknob13\">\n\
                                    <property name=\"visible\">True</property>\n\
                                    <property name=\"can_focus\">True</property>\n\
                                    <property name=\"receives_default\">True</property>\n\
                                    <property name=\"show_fill_level\">True</property>\n\
                                    <property name=\"var_id\">mbe.time5</property>\n\
                                  </object>\n\
                                  <packing>\n\
                                    <property name=\"expand\">False</property>\n\
                                    <property name=\"fill\">False</property>\n\
                                    <property name=\"position\">1</property>\n\
                                  </packing>\n\
                                </child>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"expand\">True</property>\n\
                                <property name=\"fill\">True</property>\n\
                                <property name=\"position\">0</property>\n\
                              </packing>\n\
                            </child>\n\
                            <child>\n\
                              <object class=\"GtkBox\" id=\"vbox19\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">False</property>\n\
                                <property name=\"orientation\">vertical</property>\n\
                                <child>\n\
                                  <object class=\"GtkLabel\" id=\"label_94:rack_label\">\n\
                                    <property name=\"visible\">True</property>\n\
                                    <property name=\"can_focus\">False</property>\n\
                                    <property name=\"label\" translatable=\"yes\">Amount</property>\n\
                                  </object>\n\
                                  <packing>\n\
                                    <property name=\"expand\">False</property>\n\
                                    <property name=\"fill\">False</property>\n\
                                    <property name=\"position\">0</property>\n\
                                  </packing>\n\
                                </child>\n\
                                <child>\n\
                                  <object class=\"GxSmallKnobR\" id=\"gxmediumknob14\">\n\
                                    <property name=\"visible\">True</property>\n\
                                    <property name=\"can_focus\">True</property>\n\
                                    <property name=\"receives_default\">True</property>\n\
                                    <property name=\"var_id\">mbe.percent5</property>\n\
                                  </object>\n\
                                  <packing>\n\
                                    <property name=\"expand\">False</property>\n\
                                    <property name=\"fill\">False</property>\n\
                                    <property name=\"position\">1</property>\n\
                                  </packing>\n\
                                </child>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"expand\">True</property>\n\
                                <property name=\"fill\">True</property>\n\
                                <property name=\"position\">1</property>\n\
                              </packing>\n\
                            </child>\n\
                          </object>\n\
                          <packing>\n\
                            <property name=\"expand\">True</property>\n\
                            <property name=\"fill\">True</property>\n\
                            <property name=\"position\">0</property>\n\
                          </packing>\n\
                        </child>\n\
                        <child>\n\
                          <object class=\"GtkGrid\" id=\"table5\">\n\
                            <property name=\"visible\">True</property>\n\
                            <property name=\"can_focus\">False</property>\n\
                            <property name=\"halign\">center</property>\n\
                            <property name=\"margin_left\">4</property>\n\
                            <property name=\"margin_right\">4</property>\n\
                            <property name=\"margin_top\">4</property>\n\
                            <property name=\"margin_bottom\">4</property>\n\
                            <property name=\"row_spacing\">4</property>\n\
                            <property name=\"column_spacing\">4</property>\n\
                            <property name=\"row_homogeneous\">True</property>\n\
                            <child>\n\
                              <object class=\"GtkLabel\" id=\"label_134:rack_label\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">False</property>\n\
                                <property name=\"hexpand\">True</property>\n\
                                <property name=\"label\" translatable=\"yes\">Low</property>\n\
                                <property name=\"xalign\">1</property>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"left_attach\">0</property>\n\
                                <property name=\"top_attach\">1</property>\n\
                              </packing>\n\
                            </child>\n\
                            <child>\n\
                              <object class=\"GxSmallKnob\" id=\"gxsmallknob9\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">True</property>\n\
                                <property name=\"receives_default\">True</property>\n\
                                <property name=\"var_id\">mbe.crossover_b4_b5</property>\n\
                                <property name=\"value_position\">right</property>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"left_attach\">1</property>\n\
                                <property name=\"top_attach\">1</property>\n\
                              </packing>\n\
                            </child>\n\
                            <child>\n\
                              <object class=\"GtkLabel\">\n\
                                <property name=\"visible\">True</property>\n\
                                <property name=\"can_focus\">False</property>\n\
                              </object>\n\
                              <packing>\n\
                                <property name=\"left_attach\">0</property>\n\
                                <property name=\"top_attach\">0</property>\n\
                              </packing>\n\
                            </child>\n\
                            <child>\n\
                              <placeholder/>\n\
                            </child>\n\
                          </object>\n\
                          <packing>\n\
                            <property name=\"expand\">True</property>\n\
                            <property name=\"fill\">True</property>\n\
                            <property name=\"position\">1</property>\n\
                          </packing>\n\
                        </child>\n\
                      </object>\n\
                      <packing>\n\
                        <property name=\"position\">4</property>\n\
                      </packing>\n\
                    </child>\n\
                    <child type=\"tab\">\n\
                      <object class=\"GtkLabel\" id=\"label6\">\n\
                        <property name=\"visible\">True</property>\n\
                        <property name=\"can_focus\">False</property>\n\
                        <property name=\"label\" translatable=\"yes\">Band 5</property>\n\
                      </object>\n\
                      <packing>\n\
                        <property name=\"position\">4</property>\n\
                        <property name=\"tab_fill\">False</property>\n\
                      </packing>\n\
                    </child>\n\
                    <style>\n\
                      <class name=\"tab_rack\"/>\n\
                    </style>\n\
                  </object>\n\
                  <packing>\n\
                    <property name=\"expand\">True</property>\n\
                    <property name=\"fill\">True</property>\n\
                    <property name=\"position\">0</property>\n\
                  </packing>\n\
                </child>\n\
                <child>\n\
                  <object class=\"GtkBox\" id=\"vbox2\">\n\
                    <property name=\"visible\">True</property>\n\
                    <property name=\"can_focus\">False</property>\n\
                    <property name=\"halign\">center</property>\n\
                    <property name=\"orientation\">vertical</property>\n\
                    <child>\n\
                      <object class=\"GtkLabel\" id=\"label5:rack_label\">\n\
                        <property name=\"visible\">True</property>\n\
                        <property name=\"can_focus\">False</property>\n\
                        <property name=\"label\" translatable=\"yes\">Levels</property>\n\
                        <property name=\"xalign\">0</property>\n\
                      </object>\n\
                      <packing>\n\
                        <property name=\"expand\">False</property>\n\
                        <property name=\"fill\">False</property>\n\
                        <property name=\"position\">0</property>\n\
                      </packing>\n\
                    </child>\n\
                    <child>\n\
                      <object class=\"GtkBox\" id=\"hbox3\">\n\
                        <property name=\"visible\">True</property>\n\
                        <property name=\"can_focus\">False</property>\n\
                        <property name=\"margin_bottom\">4</property>\n\
                        <property name=\"spacing\">10</property>\n\
                        <child>\n\
                          <object class=\"GxFastMeter\" id=\"gxfastmeter1\">\n\
                            <property name=\"visible\">True</property>\n\
                            <property name=\"can_focus\">False</property>\n\
                            <property name=\"orientation\">vertical</property>\n\
                            <property name=\"hold\">0</property>\n\
                            <property name=\"dimen\">0</property>\n\
                            <property name=\"var_id\">mbe.v1</property>\n\
                            <property name=\"falloff\">True</property>\n\
                          </object>\n\
                          <packing>\n\
                            <property name=\"expand\">True</property>\n\
                            <property name=\"fill\">True</property>\n\
                            <property name=\"position\">0</property>\n\
                          </packing>\n\
                        </child>\n\
                        <child>\n\
                          <object class=\"GxFastMeter\" id=\"gxfastmeter2\">\n\
                            <property name=\"visible\">True</property>\n\
                            <property name=\"can_focus\">False</property>\n\
                            <property name=\"orientation\">vertical</property>\n\
                            <property name=\"hold\">0</property>\n\
                            <property name=\"dimen\">0</property>\n\
                            <property name=\"var_id\">mbe.v2</property>\n\
                            <property name=\"falloff\">True</property>\n\
                          </object>\n\
                          <packing>\n\
                            <property name=\"expand\">True</property>\n\
                            <property name=\"fill\">True</property>\n\
                            <property name=\"position\">1</property>\n\
                          </packing>\n\
                        </child>\n\
                        <child>\n\
                          <object class=\"GxFastMeter\" id=\"gxfastmeter3\">\n\
                            <property name=\"visible\">True</property>\n\
                            <property name=\"can_focus\">False</property>\n\
                            <property name=\"orientation\">vertical</property>\n\
                            <property name=\"hold\">0</property>\n\
                            <property name=\"dimen\">0</property>\n\
                            <property name=\"var_id\">mbe.v3</property>\n\
                            <property name=\"falloff\">True</property>\n\
                          </object>\n\
                          <packing>\n\
                            <property name=\"expand\">True</property>\n\
                            <property name=\"fill\">True</property>\n\
                            <property name=\"position\">2</property>\n\
                          </packing>\n\
                        </child>\n\
                        <child>\n\
                          <object class=\"GxFastMeter\" id=\"gxfastmeter4\">\n\
                            <property name=\"visible\">True</property>\n\
                            <property name=\"can_focus\">False</property>\n\
                            <property name=\"orientation\">vertical</property>\n\
                            <property name=\"hold\">0</property>\n\
                            <property name=\"dimen\">0</property>\n\
                            <property name=\"var_id\">mbe.v4</property>\n\
                            <property name=\"falloff\">True</property>\n\
                          </object>\n\
                          <packing>\n\
                            <property name=\"expand\">True</property>\n\
                            <property name=\"fill\">True</property>\n\
                            <property name=\"position\">3</property>\n\
                          </packing>\n\
                        </child>\n\
                        <child>\n\
                          <object class=\"GxFastMeter\" id=\"gxfastmeter5\">\n\
                            <property name=\"visible\">True</property>\n\
                            <property name=\"can_focus\">False</property>\n\
                            <property name=\"orientation\">vertical</property>\n\
                            <property name=\"hold\">0</property>\n\
                            <property name=\"dimen\">0</property>\n\
                            <property name=\"var_id\">mbe.v5</property>\n\
                            <property name=\"falloff\">True</property>\n\
                          </object>\n\
                          <packing>\n\
                            <property name=\"expand\">True</property>\n\
                            <property name=\"fill\">True</property>\n\
                            <property name=\"position\">4</property>\n\
                          </packing>\n\
                        </child>\n\
                      </object>\n\
                      <packing>\n\
                        <property name=\"expand\">True</property>\n\
                        <property name=\"fill\">True</property>\n\
                        <property name=\"position\">1</property>\n\
                      </packing>\n\
                    </child>\n\
                  </object>\n\
                  <packing>\n\
                    <property name=\"expand\">True</property>\n\
                    <property name=\"fill\">True</property>\n\
                    <property name=\"position\">1</property>\n\
                  </packing>\n\
                </child>\n\
              </object>\n\
              <packing>\n\
                <property name=\"expand\">True</property>\n\
                <property name=\"fill\">True</property>\n\
                <property name=\"position\">0</property>\n\
              </packing>\n\
            </child>\n\
          </object>\n\
          <packing>\n\
            <property name=\"expand\">True</property>\n\
            <property name=\"fill\">True</property>\n\
            <property name=\"position\">0</property>\n\
          </packing>\n\
        </child>\n\
        <child>\n\
          <object class=\"GtkBox\" id=\"minibox\">\n\
            <property name=\"visible\">True</property>\n\
            <property name=\"can_focus\">False</property>\n\
            <property name=\"spacing\">4</property>\n\
            <child>\n\
              <placeholder/>\n\
            </child>\n\
          </object>\n\
          <packing>\n\
            <property name=\"expand\">True</property>\n\
            <property name=\"fill\">True</property>\n\
            <property name=\"position\">1</property>\n\
          </packing>\n\
        </child>\n\
      </object>\n\
    </child>\n\
  </object>\n\
</interface>\n\
";

inline int Dsp::load_ui_f(const UiBuilder& b, int form)
{
    if (form & UI_FORM_GLADE) {
        b.load_glade(glade_def);
        return 0;
    }
    if (form & UI_FORM_STACK) {
#define PARAM(p) ("mbe" "." p)

b.openHorizontalhideBox("");
b.closeBox();

b.openHorizontalBox("");
b.openVerticalBox("");

b.openTabBox("");

b.openHorizontalBox(N_("Band 1"));
b.openVerticalBox("");
b.openpaintampBox("");
b.openHorizontalBox("");
b.set_next_flags(UI_NUM_SHOW_ALWAYS|UI_NUM_RIGHT);
b.create_small_rackknob(PARAM("time1"), N_("BPM"));
b.set_next_flags(UI_NUM_RIGHT);
b.create_small_rackknob(PARAM("percent1"), N_("Amount"));
b.set_next_flags(UI_NUM_SHOW_ALWAYS|UI_NUM_RIGHT);
b.create_small_rackknob(PARAM("crossover_b1_b2"), N_("Low Shelf (Hz)"));
b.closeBox();
b.closeBox();
b.closeBox();
b.closeBox();

b.openHorizontalBox(N_("Band 2"));
b.openVerticalBox("");
b.openpaintampBox("");
b.openHorizontalBox("");
b.set_next_flags(UI_NUM_SHOW_ALWAYS|UI_NUM_RIGHT);
b.create_small_rackknob(PARAM("time2"), N_("BPM"));
b.set_next_flags(UI_NUM_RIGHT);
b.create_small_rackknob(PARAM("percent2"), N_("Amount"));
b.set_next_flags(UI_NUM_SHOW_ALWAYS|UI_NUM_RIGHT);
b.create_small_rackknob(PARAM("crossover_b1_b2"), N_("Low (Hz)"));
b.set_next_flags(UI_NUM_SHOW_ALWAYS|UI_NUM_RIGHT);
b.create_small_rackknob(PARAM("crossover_b2_b3"), N_("High (hz)"));
b.closeBox();
b.closeBox();
b.closeBox();
b.closeBox();

b.openHorizontalBox(N_("Band 3"));
b.openVerticalBox("");
b.openpaintampBox("");
b.openHorizontalBox("");
b.set_next_flags(UI_NUM_SHOW_ALWAYS|UI_NUM_RIGHT);
b.create_small_rackknob(PARAM("time3"), N_("BPM"));
b.set_next_flags(UI_NUM_RIGHT);
b.create_small_rackknob(PARAM("percent3"), N_("Amount"));
b.set_next_flags(UI_NUM_SHOW_ALWAYS|UI_NUM_RIGHT);
b.create_small_rackknob(PARAM("crossover_b2_b3"), N_("Low (Hz)"));
b.set_next_flags(UI_NUM_SHOW_ALWAYS|UI_NUM_RIGHT);
b.create_small_rackknob(PARAM("crossover_b3_b4"), N_("High (hz)"));
b.closeBox();
b.closeBox();
b.closeBox();
b.closeBox();

b.openHorizontalBox(N_("Band 4"));
b.openVerticalBox("");
b.openpaintampBox("");
b.openHorizontalBox("");
b.set_next_flags(UI_NUM_SHOW_ALWAYS|UI_NUM_RIGHT);
b.create_small_rackknob(PARAM("time4"), N_("BPM"));
b.set_next_flags(UI_NUM_RIGHT);
b.create_small_rackknob(PARAM("percent4"), N_("Amount"));
b.set_next_flags(UI_NUM_SHOW_ALWAYS|UI_NUM_RIGHT);
b.create_small_rackknob(PARAM("crossover_b3_b4"), N_("Low (Hz)"));
b.set_next_flags(UI_NUM_SHOW_ALWAYS|UI_NUM_RIGHT);
b.create_small_rackknob(PARAM("crossover_b4_b5"), N_("High (hz)"));
b.closeBox();
b.closeBox();
b.closeBox();
b.closeBox();

b.openHorizontalBox(N_("Band 5"));
b.openVerticalBox("");
b.openpaintampBox("");
b.openHorizontalBox("");
b.set_next_flags(UI_NUM_SHOW_ALWAYS|UI_NUM_RIGHT);
b.create_small_rackknob(PARAM("time5"), N_("BPM"));
b.set_next_flags(UI_NUM_RIGHT);
b.create_small_rackknob(PARAM("percent5"), N_("Amount"));
b.set_next_flags(UI_NUM_SHOW_ALWAYS|UI_NUM_RIGHT);
b.create_small_rackknob(PARAM("crossover_b4_b5"), N_("High Shelf (Hz)"));
b.closeBox();
b.closeBox();
b.closeBox();
b.closeBox();

b.closeBox();
b.closeBox();
b.openVerticalBox2("Analyze");
b.create_simple_meter(PARAM("v1"));
b.create_simple_meter(PARAM("v2"));
b.create_simple_meter(PARAM("v3"));
b.create_simple_meter(PARAM("v4"));
b.create_simple_meter(PARAM("v5"));
b.closeBox();
b.closeBox();

#undef PARAM
        return 0;
    }
	return -1;
}

int Dsp::load_ui_f_static(const UiBuilder& b, int form)
{
	return static_cast<Dsp*>(b.plugin)->load_ui_f(b, form);
}
PluginDef *plugin() {
	return new Dsp();
}

void Dsp::del_instance(PluginDef *p)
{
	delete static_cast<Dsp*>(p);
}

} // end namespace mbe
} // end namespace pluginlib
