/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.tool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipException;
import javax.tools.JavaFileObject;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.tool.Archive;
import org.eclipse.jdt.internal.compiler.tool.ArchiveFileObject;
import org.eclipse.jdt.internal.compiler.tool.ModuleLocationHandler;
import org.eclipse.jdt.internal.compiler.tool.Util;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;

public class JrtFileSystem
extends Archive {
    private static URI JRT_URI = URI.create("jrt:/");
    static final String BOOT_MODULE = "jrt-fs.jar";
    public HashMap<String, Path> modulePathMap;
    Path modules;
    private FileSystem jrtfs;

    public JrtFileSystem(File file) throws ZipException, IOException {
        this.file = file;
        this.initialize();
    }

    public void initialize() throws IOException {
        this.modulePathMap = new HashMap();
        URL uRL = null;
        if (this.file.exists()) {
            uRL = Paths.get(this.file.toPath().toString(), "lib", BOOT_MODULE).toUri().toURL();
            try (URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL});){
                HashMap hashMap = new HashMap();
                this.jrtfs = FileSystems.newFileSystem(JRT_URI, hashMap, (ClassLoader)uRLClassLoader);
                this.modules = this.jrtfs.getPath("/modules", new String[0]);
            }
        } else {
            return;
        }
        JRTUtil.walkModuleImage(this.file, new JRTUtil.JrtFileVisitor<Path>(){

            @Override
            public FileVisitResult visitPackage(Path path, Path path2, BasicFileAttributes basicFileAttributes) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path, Path path2, BasicFileAttributes basicFileAttributes) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitModule(Path path, String string) throws IOException {
                JrtFileSystem.this.modulePathMap.put(string, path);
                return FileVisitResult.CONTINUE;
            }
        }, 4);
    }

    public List<JrtFileObject> list(ModuleLocationHandler.ModuleLocationWrapper moduleLocationWrapper, String string, Set<JavaFileObject.Kind> set, boolean bl, Charset charset) {
        Object object;
        String string2 = moduleLocationWrapper.modName;
        Path path2 = this.modules.resolve(string2);
        Path path3 = path2.resolve(string);
        List list = null;
        try {
            object = Files.list(path3);
            try {
                list = object.filter(path -> !Files.isDirectory(path, new LinkOption[0])).collect(Collectors.toList());
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = new ArrayList();
        for (Path path4 : list) {
            object.add(new JrtFileObject(this.file, path4, string2, charset));
        }
        return object;
    }

    @Override
    public ArchiveFileObject getArchiveFileObject(String string, String string2, Charset charset) {
        return new JrtFileObject(this.file, this.modules.resolve(string2).resolve(string), string2, charset);
    }

    @Override
    public boolean contains(String string) {
        return false;
    }

    @Override
    public String toString() {
        return "JRT: " + (this.file == null ? "UNKNOWN_ARCHIVE" : this.file.getAbsolutePath());
    }

    class JrtFileObject
    extends ArchiveFileObject {
        String module;
        Path path;

        private JrtFileObject(File file, Path path, String string, Charset charset) {
            super(file, path.toString(), charset);
            this.path = path;
        }

        @Override
        protected ClassFileReader getClassReader() {
            ClassFileReader classFileReader = null;
            try {
                byte[] byArray = JRTUtil.getClassfileContent(this.file, this.entryName, this.module);
                if (byArray == null) {
                    return null;
                }
                return new ClassFileReader(byArray, this.entryName.toCharArray());
            }
            catch (ClassFormatException classFormatException) {
                classFormatException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return classFileReader;
        }

        @Override
        public CharSequence getCharContent(boolean bl) throws IOException {
            return Util.getCharContents(this, bl, JRTUtil.getClassfileContent(this.file, this.entryName, this.module), this.charset.name());
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public String getName() {
            return this.path.toString();
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return Files.newInputStream(this.path, new OpenOption[0]);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reader openReader(boolean bl) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Writer openWriter() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI toUri() {
            try {
                return new URI("JRT:" + this.file.toURI().getPath() + "!" + this.entryName);
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }

        @Override
        public String toString() {
            return this.file.getAbsolutePath() + "[" + this.entryName + "]";
        }
    }
}

