/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ExceptionLabel
extends Label {
    public int[] ranges = new int[]{-1, -1};
    private int count = 0;
    public TypeBinding exceptionType;
    public TypeReference exceptionTypeReference;
    public Annotation[] se7Annotations;

    public ExceptionLabel(CodeStream codeStream, TypeBinding typeBinding, TypeReference typeReference, Annotation[] annotationArray) {
        super(codeStream);
        this.exceptionType = typeBinding;
        this.exceptionTypeReference = typeReference;
        this.se7Annotations = annotationArray;
    }

    public ExceptionLabel(CodeStream codeStream, TypeBinding typeBinding) {
        super(codeStream);
        this.exceptionType = typeBinding;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public void place() {
        this.codeStream.registerExceptionHandler(this);
        this.position = this.codeStream.getPosition();
    }

    public void placeEnd() {
        int n = this.codeStream.position;
        if (this.ranges[this.count - 1] == n) {
            --this.count;
        } else {
            this.ranges[this.count++] = n;
        }
    }

    public void placeStart() {
        int n = this.codeStream.position;
        if (this.count > 0 && this.ranges[this.count - 1] == n) {
            --this.count;
            return;
        }
        int n2 = this.ranges.length;
        if (this.count == n2) {
            this.ranges = new int[n2 * 2];
            System.arraycopy(this.ranges, 0, this.ranges, 0, n2);
        }
        this.ranges[this.count++] = n;
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append('@').append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("(type=").append(this.exceptionType == null ? CharOperation.NO_CHAR : this.exceptionType.readableName());
        stringBuilder.append(", position=").append(this.position);
        stringBuilder.append(", ranges = ");
        if (this.count == 0) {
            stringBuilder.append("[]");
        } else {
            for (int i = 0; i < this.count; ++i) {
                if ((i & 1) == 0) {
                    stringBuilder.append("[").append(this.ranges[i]);
                    continue;
                }
                stringBuilder.append(",").append(this.ranges[i]).append("]");
            }
            if ((this.count & 1) == 1) {
                stringBuilder.append(",?]");
            }
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

