/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.env;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class AutomaticModuleNaming {
    private static final String AUTOMATIC_MODULE_NAME = "Automatic-Module-Name";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] determineAutomaticModuleName(String string) {
        try (JarFile jarFile = new JarFile(string);){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) return AutomaticModuleNaming.determineAutomaticModuleNameFromFileName(string, true, true);
            String string2 = manifest.getMainAttributes().getValue(AUTOMATIC_MODULE_NAME);
            if (string2 == null) return AutomaticModuleNaming.determineAutomaticModuleNameFromFileName(string, true, true);
            char[] cArray = string2.toCharArray();
            return cArray;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return AutomaticModuleNaming.determineAutomaticModuleNameFromFileName(string, true, true);
    }

    public static char[] determineAutomaticModuleName(String string, boolean bl, Manifest manifest) {
        String string2;
        if (manifest != null && (string2 = manifest.getMainAttributes().getValue(AUTOMATIC_MODULE_NAME)) != null) {
            return string2.toCharArray();
        }
        return AutomaticModuleNaming.determineAutomaticModuleNameFromFileName(string, true, bl);
    }

    public static char[] determineAutomaticModuleNameFromManifest(Manifest manifest) {
        String string;
        if (manifest != null && (string = manifest.getMainAttributes().getValue(AUTOMATIC_MODULE_NAME)) != null) {
            return string.toCharArray();
        }
        return null;
    }

    public static char[] determineAutomaticModuleNameFromFileName(String string, boolean bl, boolean bl2) {
        char c;
        int n;
        int n2 = 0;
        int n3 = string.length();
        if (bl) {
            n = string.lastIndexOf(File.separatorChar);
            n2 = n + 1;
        }
        if (bl2 && (string.endsWith(".jar") || string.endsWith(".JAR"))) {
            n3 -= 4;
        }
        block0: for (n = n2; n < n3 - 1; ++n) {
            if (string.charAt(n) != '-' || string.charAt(n + 1) < '0' || string.charAt(n + 1) > '9') continue;
            for (int i = n + 2; i < n3 && (c = string.charAt(i)) != '.'; ++i) {
                if (c < '0' || c > '9') continue block0;
            }
            n3 = n;
            break;
        }
        StringBuilder stringBuilder = new StringBuilder(n3 - n2);
        c = '\u0000';
        for (int i = n2; i < n3; ++i) {
            char c2 = string.charAt(i);
            if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9') {
                if (c != '\u0000') {
                    stringBuilder.append('.');
                    c = '\u0000';
                }
                stringBuilder.append(c2);
                continue;
            }
            if (stringBuilder.length() <= 0) continue;
            c = '\u0001';
        }
        return stringBuilder.toString().toCharArray();
    }
}

