/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimppatternselect_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimppatternselect
 * @title: gimppatternselect
 * @short_description: Functions providing a pattern selection dialog.
 *
 * Functions providing a pattern selection dialog.
 **/


/**
 * gimp_patterns_popup:
 * @pattern_callback: The callback PDB proc to call when pattern selection is made.
 * @popup_title: Title of the pattern selection dialog.
 * @initial_pattern: The name of the pattern to set as the first selected.
 *
 * Invokes the Gimp pattern selection.
 *
 * This procedure opens the pattern selection dialog.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_patterns_popup (const gchar *pattern_callback,
                     const gchar *popup_title,
                     const gchar *initial_pattern)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-patterns-popup",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, pattern_callback,
                                    GIMP_PDB_STRING, popup_title,
                                    GIMP_PDB_STRING, initial_pattern,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_patterns_close_popup:
 * @pattern_callback: The name of the callback registered for this pop-up.
 *
 * Close the pattern selection dialog.
 *
 * This procedure closes an opened pattern selection dialog.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_patterns_close_popup (const gchar *pattern_callback)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-patterns-close-popup",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, pattern_callback,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_patterns_set_popup:
 * @pattern_callback: The name of the callback registered for this pop-up.
 * @pattern_name: The name of the pattern to set as selected.
 *
 * Sets the current pattern in a pattern selection dialog.
 *
 * Sets the current pattern in a pattern selection dialog.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_patterns_set_popup (const gchar *pattern_callback,
                         const gchar *pattern_name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-patterns-set-popup",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, pattern_callback,
                                    GIMP_PDB_STRING, pattern_name,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}
