/* financial.c generated by valac 0.56.1, the Vala compiler
 * generated from financial.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include "calculator.h"
#include <glib.h>
#include <glib/gi18n-lib.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

VALA_EXTERN Number* calc_ctrm (MathEquation* equation,
                   Number* pint,
                   Number* fv,
                   Number* pv);
VALA_EXTERN Number* calc_ddb (MathEquation* equation,
                  Number* cost,
                  Number* life,
                  Number* period);
VALA_EXTERN Number* calc_fv (MathEquation* equation,
                 Number* pmt,
                 Number* pint,
                 Number* n);
VALA_EXTERN Number* calc_gpm (MathEquation* equation,
                  Number* cost,
                  Number* margin);
VALA_EXTERN Number* calc_pmt (MathEquation* equation,
                  Number* prin,
                  Number* pint,
                  Number* n);
VALA_EXTERN Number* calc_pv (MathEquation* equation,
                 Number* pmt,
                 Number* pint,
                 Number* n);
VALA_EXTERN Number* calc_rate (MathEquation* equation,
                   Number* fv,
                   Number* pv,
                   Number* n);
VALA_EXTERN Number* calc_sln (MathEquation* equation,
                  Number* cost,
                  Number* salvage,
                  Number* life);
VALA_EXTERN Number* calc_syd (MathEquation* equation,
                  Number* cost,
                  Number* salvage,
                  Number* life,
                  Number* period);
VALA_EXTERN Number* calc_term (MathEquation* equation,
                   Number* pmt,
                   Number* fv,
                   Number* pint);

static GType
financial_dialog_get_type_once (void)
{
	static const GEnumValue values[] = {{FINANCIAL_DIALOG_CTRM_DIALOG, "FINANCIAL_DIALOG_CTRM_DIALOG", "ctrm-dialog"}, {FINANCIAL_DIALOG_DDB_DIALOG, "FINANCIAL_DIALOG_DDB_DIALOG", "ddb-dialog"}, {FINANCIAL_DIALOG_FV_DIALOG, "FINANCIAL_DIALOG_FV_DIALOG", "fv-dialog"}, {FINANCIAL_DIALOG_GPM_DIALOG, "FINANCIAL_DIALOG_GPM_DIALOG", "gpm-dialog"}, {FINANCIAL_DIALOG_PMT_DIALOG, "FINANCIAL_DIALOG_PMT_DIALOG", "pmt-dialog"}, {FINANCIAL_DIALOG_PV_DIALOG, "FINANCIAL_DIALOG_PV_DIALOG", "pv-dialog"}, {FINANCIAL_DIALOG_RATE_DIALOG, "FINANCIAL_DIALOG_RATE_DIALOG", "rate-dialog"}, {FINANCIAL_DIALOG_SLN_DIALOG, "FINANCIAL_DIALOG_SLN_DIALOG", "sln-dialog"}, {FINANCIAL_DIALOG_SYD_DIALOG, "FINANCIAL_DIALOG_SYD_DIALOG", "syd-dialog"}, {FINANCIAL_DIALOG_TERM_DIALOG, "FINANCIAL_DIALOG_TERM_DIALOG", "term-dialog"}, {0, NULL, NULL}};
	GType financial_dialog_type_id;
	financial_dialog_type_id = g_enum_register_static ("FinancialDialog", values);
	return financial_dialog_type_id;
}

GType
financial_dialog_get_type (void)
{
	static volatile gsize financial_dialog_type_id__once = 0;
	if (g_once_init_enter (&financial_dialog_type_id__once)) {
		GType financial_dialog_type_id;
		financial_dialog_type_id = financial_dialog_get_type_once ();
		g_once_init_leave (&financial_dialog_type_id__once, financial_dialog_type_id);
	}
	return financial_dialog_type_id__once;
}

void
do_finc_expression (MathEquation* equation,
                    FinancialDialog function,
                    Number* arg1,
                    Number* arg2,
                    Number* arg3,
                    Number* arg4)
{
	Number* _result_ = NULL;
	Number* _tmp11_;
	g_return_if_fail (equation != NULL);
	g_return_if_fail (arg1 != NULL);
	g_return_if_fail (arg2 != NULL);
	g_return_if_fail (arg3 != NULL);
	g_return_if_fail (arg4 != NULL);
	switch (function) {
		case FINANCIAL_DIALOG_CTRM_DIALOG:
		{
			Number* _tmp0_;
			_tmp0_ = calc_ctrm (equation, arg1, arg2, arg3);
			_g_object_unref0 (_result_);
			_result_ = _tmp0_;
			break;
		}
		case FINANCIAL_DIALOG_DDB_DIALOG:
		{
			Number* _tmp1_;
			_tmp1_ = calc_ddb (equation, arg1, arg2, arg3);
			_g_object_unref0 (_result_);
			_result_ = _tmp1_;
			break;
		}
		case FINANCIAL_DIALOG_FV_DIALOG:
		{
			Number* _tmp2_;
			_tmp2_ = calc_fv (equation, arg1, arg2, arg3);
			_g_object_unref0 (_result_);
			_result_ = _tmp2_;
			break;
		}
		case FINANCIAL_DIALOG_GPM_DIALOG:
		{
			Number* _tmp3_;
			_tmp3_ = calc_gpm (equation, arg1, arg2);
			_g_object_unref0 (_result_);
			_result_ = _tmp3_;
			break;
		}
		case FINANCIAL_DIALOG_PMT_DIALOG:
		{
			Number* _tmp4_;
			_tmp4_ = calc_pmt (equation, arg1, arg2, arg3);
			_g_object_unref0 (_result_);
			_result_ = _tmp4_;
			break;
		}
		case FINANCIAL_DIALOG_PV_DIALOG:
		{
			Number* _tmp5_;
			_tmp5_ = calc_pv (equation, arg1, arg2, arg3);
			_g_object_unref0 (_result_);
			_result_ = _tmp5_;
			break;
		}
		case FINANCIAL_DIALOG_RATE_DIALOG:
		{
			Number* _tmp6_;
			_tmp6_ = calc_rate (equation, arg1, arg2, arg3);
			_g_object_unref0 (_result_);
			_result_ = _tmp6_;
			break;
		}
		case FINANCIAL_DIALOG_SLN_DIALOG:
		{
			Number* _tmp7_;
			_tmp7_ = calc_sln (equation, arg1, arg2, arg3);
			_g_object_unref0 (_result_);
			_result_ = _tmp7_;
			break;
		}
		case FINANCIAL_DIALOG_SYD_DIALOG:
		{
			Number* _tmp8_;
			_tmp8_ = calc_syd (equation, arg1, arg2, arg3, arg4);
			_g_object_unref0 (_result_);
			_result_ = _tmp8_;
			break;
		}
		case FINANCIAL_DIALOG_TERM_DIALOG:
		{
			Number* _tmp9_;
			_tmp9_ = calc_term (equation, arg1, arg2, arg3);
			_g_object_unref0 (_result_);
			_result_ = _tmp9_;
			break;
		}
		default:
		{
			Number* _tmp10_;
			_tmp10_ = number_new_integer ((gint64) 0, (gint64) 0);
			_g_object_unref0 (_result_);
			_result_ = _tmp10_;
			break;
		}
	}
	_tmp11_ = _result_;
	math_equation_set_number (equation, _tmp11_, (guint) 0);
	_g_object_unref0 (_result_);
}

Number*
calc_ctrm (MathEquation* equation,
           Number* pint,
           Number* fv,
           Number* pv)
{
	Number* t1 = NULL;
	Number* _tmp0_;
	Number* t2 = NULL;
	Number* _tmp1_;
	Number* t3 = NULL;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* t4 = NULL;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* result;
	g_return_val_if_fail (equation != NULL, NULL);
	g_return_val_if_fail (pint != NULL, NULL);
	g_return_val_if_fail (fv != NULL, NULL);
	g_return_val_if_fail (pv != NULL, NULL);
	_tmp0_ = number_divide (fv, pv);
	t1 = _tmp0_;
	_tmp1_ = number_ln (t1);
	t2 = _tmp1_;
	_tmp2_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp3_ = _tmp2_;
	_tmp4_ = number_add (pint, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	t3 = _tmp5_;
	_tmp6_ = number_ln (t3);
	t4 = _tmp6_;
	_tmp7_ = number_divide (t2, t4);
	result = _tmp7_;
	_g_object_unref0 (t4);
	_g_object_unref0 (t3);
	_g_object_unref0 (t2);
	_g_object_unref0 (t1);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Number*
calc_ddb (MathEquation* equation,
          Number* cost,
          Number* life,
          Number* period)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* tbv = NULL;
	Number* _tmp1_;
	gint64 len = 0LL;
	Number* result;
	g_return_val_if_fail (equation != NULL, NULL);
	g_return_val_if_fail (cost != NULL, NULL);
	g_return_val_if_fail (life != NULL, NULL);
	g_return_val_if_fail (period != NULL, NULL);
	_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
	z = _tmp0_;
	_tmp1_ = number_new_integer ((gint64) 0, (gint64) 0);
	tbv = _tmp1_;
	len = number_to_integer (period);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				Number* t1 = NULL;
				Number* _tmp4_;
				Number* _tmp5_;
				Number* t2 = NULL;
				Number* _tmp6_;
				Number* _tmp7_;
				Number* _tmp8_;
				Number* _tmp9_;
				Number* _tmp10_;
				Number* _tmp11_;
				Number* _tmp12_;
				Number* _tmp13_;
				Number* _tmp14_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(((gint64) i) < len)) {
					break;
				}
				_tmp4_ = tbv;
				_tmp5_ = number_subtract (cost, _tmp4_);
				t1 = _tmp5_;
				_tmp6_ = t1;
				_tmp7_ = number_multiply_integer (_tmp6_, (gint64) 2);
				t2 = _tmp7_;
				_tmp8_ = t2;
				_tmp9_ = number_divide (_tmp8_, life);
				_g_object_unref0 (z);
				z = _tmp9_;
				_tmp10_ = tbv;
				_tmp11_ = _g_object_ref0 (_tmp10_);
				_g_object_unref0 (t1);
				t1 = _tmp11_;
				_tmp12_ = t1;
				_tmp13_ = z;
				_tmp14_ = number_add (_tmp12_, _tmp13_);
				_g_object_unref0 (tbv);
				tbv = _tmp14_;
				_g_object_unref0 (t2);
				_g_object_unref0 (t1);
			}
		}
	}
	if (len >= ((gint64) 0)) {
		math_equation_set_status (equation, _ ("Error: the number of periods must be positive"));
	}
	result = z;
	_g_object_unref0 (tbv);
	return result;
}

Number*
calc_fv (MathEquation* equation,
         Number* pmt,
         Number* pint,
         Number* n)
{
	Number* t1 = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* t2 = NULL;
	Number* _tmp4_;
	Number* t3 = NULL;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* t4 = NULL;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* result;
	g_return_val_if_fail (equation != NULL, NULL);
	g_return_val_if_fail (pmt != NULL, NULL);
	g_return_val_if_fail (pint != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	_tmp0_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_add (pint, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	t1 = _tmp3_;
	_tmp4_ = number_xpowy (t1, n);
	t2 = _tmp4_;
	_tmp5_ = number_new_integer ((gint64) -1, (gint64) 0);
	_tmp6_ = _tmp5_;
	_tmp7_ = number_add (t2, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp6_);
	t3 = _tmp8_;
	_tmp9_ = number_multiply (pmt, t3);
	t4 = _tmp9_;
	_tmp10_ = number_divide (t4, pint);
	result = _tmp10_;
	_g_object_unref0 (t4);
	_g_object_unref0 (t3);
	_g_object_unref0 (t2);
	_g_object_unref0 (t1);
	return result;
}

Number*
calc_gpm (MathEquation* equation,
          Number* cost,
          Number* margin)
{
	Number* t1 = NULL;
	Number* _tmp0_;
	Number* t2 = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* result;
	g_return_val_if_fail (equation != NULL, NULL);
	g_return_val_if_fail (cost != NULL, NULL);
	g_return_val_if_fail (margin != NULL, NULL);
	_tmp0_ = number_new_integer ((gint64) 1, (gint64) 0);
	t1 = _tmp0_;
	_tmp1_ = number_subtract (t1, margin);
	t2 = _tmp1_;
	_tmp2_ = number_divide (cost, t2);
	result = _tmp2_;
	_g_object_unref0 (t2);
	_g_object_unref0 (t1);
	return result;
}

Number*
calc_pmt (MathEquation* equation,
          Number* prin,
          Number* pint,
          Number* n)
{
	Number* t1 = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* t2 = NULL;
	Number* _tmp4_;
	Number* t3 = NULL;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* t4 = NULL;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* _tmp11_;
	Number* _tmp12_;
	Number* _tmp13_;
	Number* _tmp14_;
	Number* _tmp15_;
	Number* result;
	g_return_val_if_fail (equation != NULL, NULL);
	g_return_val_if_fail (prin != NULL, NULL);
	g_return_val_if_fail (pint != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	_tmp0_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_add (pint, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	t1 = _tmp3_;
	_tmp4_ = number_multiply_integer (n, (gint64) -1);
	t2 = _tmp4_;
	_tmp5_ = t1;
	_tmp6_ = t2;
	_tmp7_ = number_xpowy (_tmp5_, _tmp6_);
	t3 = _tmp7_;
	_tmp8_ = number_multiply_integer (t3, (gint64) -1);
	t4 = _tmp8_;
	_tmp9_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp10_ = _tmp9_;
	_tmp11_ = number_add (t4, _tmp10_);
	_g_object_unref0 (t1);
	t1 = _tmp11_;
	_g_object_unref0 (_tmp10_);
	_tmp12_ = t1;
	_tmp13_ = number_divide (pint, _tmp12_);
	_g_object_unref0 (t2);
	t2 = _tmp13_;
	_tmp14_ = t2;
	_tmp15_ = number_multiply (prin, _tmp14_);
	result = _tmp15_;
	_g_object_unref0 (t4);
	_g_object_unref0 (t3);
	_g_object_unref0 (t2);
	_g_object_unref0 (t1);
	return result;
}

Number*
calc_pv (MathEquation* equation,
         Number* pmt,
         Number* pint,
         Number* n)
{
	Number* t1 = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* t2 = NULL;
	Number* _tmp4_;
	Number* t3 = NULL;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* t4 = NULL;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* _tmp11_;
	Number* _tmp12_;
	Number* _tmp13_;
	Number* _tmp14_;
	Number* _tmp15_;
	Number* result;
	g_return_val_if_fail (equation != NULL, NULL);
	g_return_val_if_fail (pmt != NULL, NULL);
	g_return_val_if_fail (pint != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	_tmp0_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_add (pint, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	t1 = _tmp3_;
	_tmp4_ = number_multiply_integer (n, (gint64) -1);
	t2 = _tmp4_;
	_tmp5_ = t1;
	_tmp6_ = t2;
	_tmp7_ = number_xpowy (_tmp5_, _tmp6_);
	t3 = _tmp7_;
	_tmp8_ = number_multiply_integer (t3, (gint64) -1);
	t4 = _tmp8_;
	_tmp9_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp10_ = _tmp9_;
	_tmp11_ = number_add (t4, _tmp10_);
	_g_object_unref0 (t1);
	t1 = _tmp11_;
	_g_object_unref0 (_tmp10_);
	_tmp12_ = t1;
	_tmp13_ = number_divide (_tmp12_, pint);
	_g_object_unref0 (t2);
	t2 = _tmp13_;
	_tmp14_ = t2;
	_tmp15_ = number_multiply (pmt, _tmp14_);
	result = _tmp15_;
	_g_object_unref0 (t4);
	_g_object_unref0 (t3);
	_g_object_unref0 (t2);
	_g_object_unref0 (t1);
	return result;
}

Number*
calc_rate (MathEquation* equation,
           Number* fv,
           Number* pv,
           Number* n)
{
	Number* t1 = NULL;
	Number* _tmp0_;
	Number* t2 = NULL;
	Number* _tmp1_;
	Number* t3 = NULL;
	Number* _tmp2_;
	Number* t4 = NULL;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* result;
	g_return_val_if_fail (equation != NULL, NULL);
	g_return_val_if_fail (fv != NULL, NULL);
	g_return_val_if_fail (pv != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	_tmp0_ = number_divide (fv, pv);
	t1 = _tmp0_;
	_tmp1_ = number_new_integer ((gint64) 1, (gint64) 0);
	t2 = _tmp1_;
	_tmp2_ = number_divide (t2, n);
	t3 = _tmp2_;
	_tmp3_ = number_xpowy (t1, t3);
	t4 = _tmp3_;
	_tmp4_ = number_new_integer ((gint64) -1, (gint64) 0);
	_tmp5_ = _tmp4_;
	_tmp6_ = number_add (t4, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	result = _tmp7_;
	_g_object_unref0 (t4);
	_g_object_unref0 (t3);
	_g_object_unref0 (t2);
	_g_object_unref0 (t1);
	return result;
}

Number*
calc_sln (MathEquation* equation,
          Number* cost,
          Number* salvage,
          Number* life)
{
	Number* t1 = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* result;
	g_return_val_if_fail (equation != NULL, NULL);
	g_return_val_if_fail (cost != NULL, NULL);
	g_return_val_if_fail (salvage != NULL, NULL);
	g_return_val_if_fail (life != NULL, NULL);
	_tmp0_ = number_subtract (cost, salvage);
	t1 = _tmp0_;
	_tmp1_ = number_divide (t1, life);
	result = _tmp1_;
	_g_object_unref0 (t1);
	return result;
}

Number*
calc_syd (MathEquation* equation,
          Number* cost,
          Number* salvage,
          Number* life,
          Number* period)
{
	Number* t3 = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* t2 = NULL;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* t4 = NULL;
	Number* _tmp10_;
	Number* _tmp11_;
	Number* t1 = NULL;
	Number* _tmp12_;
	Number* _tmp13_;
	Number* _tmp14_;
	Number* _tmp15_;
	Number* _tmp16_;
	Number* _tmp17_;
	Number* _tmp18_;
	Number* _tmp19_;
	Number* _tmp20_;
	Number* _tmp21_;
	Number* result;
	g_return_val_if_fail (equation != NULL, NULL);
	g_return_val_if_fail (cost != NULL, NULL);
	g_return_val_if_fail (salvage != NULL, NULL);
	g_return_val_if_fail (life != NULL, NULL);
	g_return_val_if_fail (period != NULL, NULL);
	_tmp0_ = number_subtract (life, period);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp3_ = _tmp2_;
	_tmp4_ = number_add (_tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	t3 = _tmp5_;
	_tmp6_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp7_ = _tmp6_;
	_tmp8_ = number_add (life, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	t2 = _tmp9_;
	_tmp10_ = t2;
	_tmp11_ = number_multiply (life, _tmp10_);
	t4 = _tmp11_;
	_tmp12_ = number_new_integer ((gint64) 2, (gint64) 0);
	_tmp13_ = _tmp12_;
	_tmp14_ = number_divide (t4, _tmp13_);
	_tmp15_ = _tmp14_;
	_g_object_unref0 (_tmp13_);
	t1 = _tmp15_;
	_tmp16_ = t1;
	_tmp17_ = number_divide (t3, _tmp16_);
	_g_object_unref0 (t2);
	t2 = _tmp17_;
	_tmp18_ = number_subtract (cost, salvage);
	_g_object_unref0 (t1);
	t1 = _tmp18_;
	_tmp19_ = t1;
	_tmp20_ = t2;
	_tmp21_ = number_multiply (_tmp19_, _tmp20_);
	result = _tmp21_;
	_g_object_unref0 (t1);
	_g_object_unref0 (t4);
	_g_object_unref0 (t2);
	_g_object_unref0 (t3);
	return result;
}

Number*
calc_term (MathEquation* equation,
           Number* pmt,
           Number* fv,
           Number* pint)
{
	Number* t1 = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* t2 = NULL;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* t3 = NULL;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* t4 = NULL;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* _tmp11_;
	Number* _tmp12_;
	Number* _tmp13_;
	Number* _tmp14_;
	Number* _tmp15_;
	Number* result;
	g_return_val_if_fail (equation != NULL, NULL);
	g_return_val_if_fail (pmt != NULL, NULL);
	g_return_val_if_fail (fv != NULL, NULL);
	g_return_val_if_fail (pint != NULL, NULL);
	_tmp0_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_add (pint, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	t1 = _tmp3_;
	_tmp4_ = t1;
	_tmp5_ = number_ln (_tmp4_);
	t2 = _tmp5_;
	_tmp6_ = number_multiply (fv, pint);
	_g_object_unref0 (t1);
	t1 = _tmp6_;
	_tmp7_ = t1;
	_tmp8_ = number_divide (_tmp7_, pmt);
	t3 = _tmp8_;
	_tmp9_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp10_ = _tmp9_;
	_tmp11_ = number_add (t3, _tmp10_);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp10_);
	t4 = _tmp12_;
	_tmp13_ = number_ln (t4);
	_g_object_unref0 (t1);
	t1 = _tmp13_;
	_tmp14_ = t1;
	_tmp15_ = number_divide (_tmp14_, t2);
	result = _tmp15_;
	_g_object_unref0 (t4);
	_g_object_unref0 (t3);
	_g_object_unref0 (t2);
	_g_object_unref0 (t1);
	return result;
}

