/* math-window.c generated by valac 0.56.1, the Vala compiler
 * generated from math-window.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <adwaita.h>
#include <glib-object.h>
#include "calculator.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MATH_WINDOW (math_window_get_type ())
#define MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_WINDOW, MathWindow))
#define MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_WINDOW, MathWindowClass))
#define IS_MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_WINDOW))
#define IS_MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_WINDOW))
#define MATH_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_WINDOW, MathWindowClass))

typedef struct _MathWindow MathWindow;
typedef struct _MathWindowClass MathWindowClass;
typedef struct _MathWindowPrivate MathWindowPrivate;

#define TYPE_HISTORY_VIEW (history_view_get_type ())
#define HISTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_VIEW, HistoryView))
#define HISTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_VIEW, HistoryViewClass))
#define IS_HISTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_VIEW))
#define IS_HISTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_VIEW))
#define HISTORY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_VIEW, HistoryViewClass))

typedef struct _HistoryView HistoryView;
typedef struct _HistoryViewClass HistoryViewClass;

#define TYPE_MATH_DISPLAY (math_display_get_type ())
#define MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_DISPLAY, MathDisplay))
#define MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_DISPLAY, MathDisplayClass))
#define IS_MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_DISPLAY))
#define IS_MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_DISPLAY))
#define MATH_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_DISPLAY, MathDisplayClass))

typedef struct _MathDisplay MathDisplay;
typedef struct _MathDisplayClass MathDisplayClass;

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;

#define TYPE_MATH_CONVERTER (math_converter_get_type ())
#define MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_CONVERTER, MathConverter))
#define MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_CONVERTER, MathConverterClass))
#define IS_MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_CONVERTER))
#define IS_MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_CONVERTER))
#define MATH_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_CONVERTER, MathConverterClass))

typedef struct _MathConverter MathConverter;
typedef struct _MathConverterClass MathConverterClass;
enum  {
	MATH_WINDOW_0_PROPERTY,
	MATH_WINDOW_EQUATION_PROPERTY,
	MATH_WINDOW_MATH_DISPLAY_PROPERTY,
	MATH_WINDOW_BUTTONS_PROPERTY,
	MATH_WINDOW_NUM_PROPERTIES
};
static GParamSpec* math_window_properties[MATH_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING,
	BUTTON_MODE_KEYBOARD
} ButtonMode;

#define TYPE_BUTTON_MODE (button_mode_get_type ())
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MathWindow {
	AdwApplicationWindow parent_instance;
	MathWindowPrivate * priv;
};

struct _MathWindowClass {
	AdwApplicationWindowClass parent_class;
};

struct _MathWindowPrivate {
	MathEquation* _equation;
	HistoryView* history;
	MathDisplay* _display;
	MathButtons* _buttons;
	gboolean right_aligned;
	gboolean remove_buttons;
	GtkMenuButton* menu_button;
	GtkGrid* grid;
	MathConverter* converter;
	GtkEventControllerKey* event_controller;
};

static gint MathWindow_private_offset;
static gpointer math_window_parent_class = NULL;

VALA_EXTERN GType math_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathWindow, g_object_unref)
VALA_EXTERN GType history_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HistoryView, g_object_unref)
VALA_EXTERN GType math_display_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathDisplay, g_object_unref)
VALA_EXTERN GType math_buttons_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathButtons, g_object_unref)
VALA_EXTERN GType math_converter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathConverter, g_object_unref)
static void math_window_copy_cb (MathWindow* self);
static void _math_window_copy_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void math_window_paste_cb (MathWindow* self);
static void _math_window_paste_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void math_window_undo_cb (MathWindow* self);
static void _math_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void math_window_redo_cb (MathWindow* self);
static void _math_window_redo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void math_window_mode_cb (MathWindow* self,
                          GSimpleAction* action,
                          GVariant* parameter);
static void _math_window_mode_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void math_window_clear_cb (MathWindow* self);
static void _math_window_clear_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void _gtk_window_close_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self);
VALA_EXTERN MathWindow* math_window_new (GtkApplication* app,
                             MathEquation* equation);
VALA_EXTERN MathWindow* math_window_construct (GType object_type,
                                   GtkApplication* app,
                                   MathEquation* equation);
VALA_EXTERN void math_converter_set_equation (MathConverter* self,
                                  MathEquation* equation);
VALA_EXTERN void math_converter_set_category (MathConverter* self,
                                  const gchar* category);
VALA_EXTERN void math_converter_set_conversion (MathConverter* self,
                                    const gchar* unit_a,
                                    const gchar* unit_b);
VALA_EXTERN gboolean math_window_key_press_cb (MathWindow* self,
                                   GtkEventControllerKey* controller,
                                   guint keyval,
                                   guint keycode,
                                   GdkModifierType state);
static gboolean _math_window_key_press_cb_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                         guint keyval,
                                                                         guint keycode,
                                                                         GdkModifierType state,
                                                                         gpointer self);
VALA_EXTERN MathDisplay* math_display_new (MathEquation* equation);
VALA_EXTERN MathDisplay* math_display_construct (GType object_type,
                                     MathEquation* equation);
VALA_EXTERN MathEquation* math_display_get_equation (MathDisplay* self);
VALA_EXTERN void history_view_set_serializer (HistoryView* self,
                                  Serializer* serializer);
static void _history_view_set_serializer_math_equation_display_changed (MathEquation* _sender,
                                                                 Serializer* serializer,
                                                                 gpointer self);
VALA_EXTERN void math_window_update_history (MathWindow* self,
                                 const gchar* answer,
                                 Number* number,
                                 gint number_base,
                                 guint representation_base);
static void _math_window_update_history_math_equation_history_signal (MathEquation* _sender,
                                                               const gchar* answer,
                                                               Number* number,
                                                               gint number_base,
                                                               guint representation_base,
                                                               gpointer self);
VALA_EXTERN HistoryView* history_view_new (void);
VALA_EXTERN HistoryView* history_view_construct (GType object_type);
static void __lambda40_ (MathWindow* self,
                  const gchar* ans);
VALA_EXTERN void math_display_insert_text (MathDisplay* self,
                               const gchar* answer);
static void ___lambda40__history_view_answer_clicked (HistoryView* _sender,
                                               const gchar* ans,
                                               gpointer self);
static void __lambda41_ (MathWindow* self,
                  const gchar* eq);
VALA_EXTERN void math_display_display_text (MathDisplay* self,
                                const gchar* prev_eq);
static void ___lambda41__history_view_equation_clicked (HistoryView* _sender,
                                                 const gchar* equation,
                                                 gpointer self);
VALA_EXTERN MathButtons* math_buttons_new (MathEquation* equation,
                               MathWindow* window);
VALA_EXTERN MathButtons* math_buttons_construct (GType object_type,
                                     MathEquation* equation,
                                     MathWindow* window);
VALA_EXTERN GType button_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ButtonMode math_buttons_get_mode (MathButtons* self);
static void math_window_mode_changed_cb (MathWindow* self);
static void _math_window_mode_changed_cb_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self);
VALA_EXTERN void math_display_grabfocus (MathDisplay* self);
VALA_EXTERN void history_view_clear (HistoryView* self);
VALA_EXTERN MathButtons* math_window_get_buttons (MathWindow* self);
VALA_EXTERN void math_display_set_enable_osk (MathDisplay* self,
                                  gboolean enable_osk);
VALA_EXTERN void math_window_critical_error (MathWindow* self,
                                 const gchar* title,
                                 const gchar* contents);
static void __lambda42_ (MathWindow* self);
static void ___lambda42__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
VALA_EXTERN MathEquation* math_window_get_equation (MathWindow* self);
static void math_window_scroll_changed_cb (MathWindow* self,
                                    GtkAdjustment* adjustment);
static void _math_window_scroll_changed_cb_gtk_adjustment_changed (GtkAdjustment* _sender,
                                                            gpointer self);
static void math_window_scroll_value_changed_cb (MathWindow* self,
                                          GtkAdjustment* adjustment);
static void _math_window_scroll_value_changed_cb_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                        gpointer self);
VALA_EXTERN void math_display_grab_focus (MathDisplay* self);
VALA_EXTERN void math_buttons_set_mode (MathButtons* self,
                            ButtonMode value);
VALA_EXTERN void history_view_insert_entry (HistoryView* self,
                                const gchar* equation,
                                Number* answer,
                                gint number_base,
                                guint representation_base);
VALA_EXTERN MathDisplay* math_window_get_math_display (MathWindow* self);
static void math_window_finalize (GObject * obj);
static GType math_window_get_type_once (void);
static void _vala_math_window_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GActionEntry MATH_WINDOW_window_entries[7] = {{"copy", _math_window_copy_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"paste", _math_window_paste_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"undo", _math_window_undo_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"redo", _math_window_redo_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"mode", _math_window_mode_cb_gsimple_action_activate_callback, "s", "\"basic\"", NULL}, {"clear", _math_window_clear_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"close", _gtk_window_close_gsimple_action_activate_callback, NULL, NULL, NULL}};

static inline gpointer
math_window_get_instance_private (MathWindow* self)
{
	return G_STRUCT_MEMBER_P (self, MathWindow_private_offset);
}

static void
_math_window_copy_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	math_window_copy_cb ((MathWindow*) self);
}

static void
_math_window_paste_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	math_window_paste_cb ((MathWindow*) self);
}

static void
_math_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	math_window_undo_cb ((MathWindow*) self);
}

static void
_math_window_redo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	math_window_redo_cb ((MathWindow*) self);
}

static void
_math_window_mode_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	math_window_mode_cb ((MathWindow*) self, action, parameter);
}

static void
_math_window_clear_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	math_window_clear_cb ((MathWindow*) self);
}

static void
_gtk_window_close_gsimple_action_activate_callback (GSimpleAction* action,
                                                    GVariant* parameter,
                                                    gpointer self)
{
	gtk_window_close ((GtkWindow*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_math_window_key_press_cb_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                guint keyval,
                                                                guint keycode,
                                                                GdkModifierType state,
                                                                gpointer self)
{
	gboolean result;
	result = math_window_key_press_cb ((MathWindow*) self, _sender, keyval, keycode, state);
	return result;
}

static void
_history_view_set_serializer_math_equation_display_changed (MathEquation* _sender,
                                                            Serializer* serializer,
                                                            gpointer self)
{
	history_view_set_serializer ((HistoryView*) self, serializer);
}

static void
_math_window_update_history_math_equation_history_signal (MathEquation* _sender,
                                                          const gchar* answer,
                                                          Number* number,
                                                          gint number_base,
                                                          guint representation_base,
                                                          gpointer self)
{
	math_window_update_history ((MathWindow*) self, answer, number, number_base, representation_base);
}

static void
__lambda40_ (MathWindow* self,
             const gchar* ans)
{
	MathDisplay* _tmp0_;
	g_return_if_fail (ans != NULL);
	_tmp0_ = self->priv->_display;
	math_display_insert_text (_tmp0_, ans);
}

static void
___lambda40__history_view_answer_clicked (HistoryView* _sender,
                                          const gchar* ans,
                                          gpointer self)
{
	__lambda40_ ((MathWindow*) self, ans);
}

static void
__lambda41_ (MathWindow* self,
             const gchar* eq)
{
	MathDisplay* _tmp0_;
	g_return_if_fail (eq != NULL);
	_tmp0_ = self->priv->_display;
	math_display_display_text (_tmp0_, eq);
}

static void
___lambda41__history_view_equation_clicked (HistoryView* _sender,
                                            const gchar* equation,
                                            gpointer self)
{
	__lambda41_ ((MathWindow*) self, equation);
}

static void
_math_window_mode_changed_cb_g_object_notify (GObject* _sender,
                                              GParamSpec* pspec,
                                              gpointer self)
{
	math_window_mode_changed_cb ((MathWindow*) self);
}

MathWindow*
math_window_construct (GType object_type,
                       GtkApplication* app,
                       MathEquation* equation)
{
	MathWindow * self = NULL;
	MathEquation* _tmp0_;
	GSettings* settings = NULL;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GAction* _tmp3_;
	GAction* _tmp4_;
	GSettings* _tmp5_;
	MathEquation* _tmp6_;
	MathConverter* _tmp7_;
	MathEquation* _tmp8_;
	MathConverter* _tmp9_;
	MathConverter* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GtkEventControllerKey* _tmp17_;
	GtkEventControllerKey* _tmp18_;
	GtkEventController* _tmp19_;
	GtkEventControllerKey* _tmp20_;
	GtkBox* box = NULL;
	GtkBox* _tmp21_;
	GtkBox* _tmp22_;
	GtkBox* _tmp23_;
	GtkBox* _tmp24_;
	GtkGrid* _tmp25_;
	GtkBox* _tmp26_;
	MathDisplay* _tmp27_;
	MathDisplay* _tmp28_;
	MathDisplay* _tmp29_;
	MathEquation* _tmp30_;
	MathEquation* _tmp31_;
	HistoryView* _tmp32_;
	MathDisplay* _tmp33_;
	MathEquation* _tmp34_;
	MathEquation* _tmp35_;
	HistoryView* _tmp36_;
	HistoryView* _tmp37_;
	HistoryView* _tmp38_;
	HistoryView* _tmp39_;
	MathDisplay* _tmp40_;
	MathEquation* _tmp41_;
	MathEquation* _tmp42_;
	Serializer* _tmp43_;
	Serializer* _tmp44_;
	GtkBox* _tmp45_;
	HistoryView* _tmp46_;
	GtkBox* _tmp47_;
	MathDisplay* _tmp48_;
	MathButtons* _tmp49_;
	GtkGrid* _tmp50_;
	MathButtons* _tmp51_;
	GtkBox* _tmp52_;
	gboolean _tmp53_ = FALSE;
	MathButtons* _tmp54_;
	ButtonMode _tmp55_;
	ButtonMode _tmp56_;
	MathButtons* _tmp57_;
	MathDisplay* _tmp58_;
	g_return_val_if_fail (app != NULL, NULL);
	g_return_val_if_fail (equation != NULL, NULL);
	self = (MathWindow*) g_object_new (object_type, "application", app, NULL);
	_tmp0_ = _g_object_ref0 (equation);
	_g_object_unref0 (self->priv->_equation);
	self->priv->_equation = _tmp0_;
	self->priv->right_aligned = TRUE;
	g_action_map_add_action_entries ((GActionMap*) self, MATH_WINDOW_window_entries, (gint) G_N_ELEMENTS (MATH_WINDOW_window_entries), self);
	_tmp1_ = g_settings_new ("org.gnome.calculator");
	settings = _tmp1_;
	_tmp2_ = settings;
	_tmp3_ = g_settings_create_action (_tmp2_, "number-format");
	_tmp4_ = _tmp3_;
	g_action_map_add_action ((GActionMap*) self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = settings;
	_tmp6_ = self->priv->_equation;
	g_settings_bind (_tmp5_, "number-format", (GObject*) _tmp6_, "number_format", G_SETTINGS_BIND_DEFAULT);
	_tmp7_ = self->priv->converter;
	_tmp8_ = self->priv->_equation;
	math_converter_set_equation (_tmp7_, _tmp8_);
	_tmp9_ = self->priv->converter;
	math_converter_set_category (_tmp9_, NULL);
	_tmp10_ = self->priv->converter;
	_tmp11_ = math_equation_get_source_units (equation);
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp14_ = math_equation_get_target_units (equation);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_;
	math_converter_set_conversion (_tmp10_, _tmp13_, _tmp16_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp13_);
	_tmp17_ = (GtkEventControllerKey*) gtk_event_controller_key_new ();
	_g_object_unref0 (self->priv->event_controller);
	self->priv->event_controller = _tmp17_;
	_tmp18_ = self->priv->event_controller;
	_tmp19_ = _g_object_ref0 ((GtkEventController*) _tmp18_);
	gtk_widget_add_controller (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_widget_get_type ()) ? ((GtkWidget*) self) : NULL, _tmp19_);
	_tmp20_ = self->priv->event_controller;
	g_signal_connect_object (_tmp20_, "key-pressed", (GCallback) _math_window_key_press_cb_gtk_event_controller_key_key_pressed, self, 0);
	_tmp21_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp21_);
	box = _tmp21_;
	_tmp22_ = box;
	gtk_widget_set_overflow ((GtkWidget*) _tmp22_, GTK_OVERFLOW_HIDDEN);
	_tmp23_ = box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp23_, "display-container");
	_tmp24_ = box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp24_, "card");
	_tmp25_ = self->priv->grid;
	_tmp26_ = box;
	gtk_grid_attach (_tmp25_, (GtkWidget*) _tmp26_, 0, 1, 1, 1);
	_tmp27_ = math_display_new (equation);
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->_display);
	self->priv->_display = _tmp27_;
	_tmp28_ = self->priv->_display;
	gtk_widget_show ((GtkWidget*) _tmp28_);
	_tmp29_ = self->priv->_display;
	_tmp30_ = math_display_get_equation (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = self->priv->history;
	g_signal_connect_object (_tmp31_, "display-changed", (GCallback) _history_view_set_serializer_math_equation_display_changed, _tmp32_, 0);
	_tmp33_ = self->priv->_display;
	_tmp34_ = math_display_get_equation (_tmp33_);
	_tmp35_ = _tmp34_;
	g_signal_connect_object (_tmp35_, "history-signal", (GCallback) _math_window_update_history_math_equation_history_signal, self, 0);
	_tmp36_ = history_view_new ();
	g_object_ref_sink (_tmp36_);
	_g_object_unref0 (self->priv->history);
	self->priv->history = _tmp36_;
	_tmp37_ = self->priv->history;
	g_signal_connect_object (_tmp37_, "answer-clicked", (GCallback) ___lambda40__history_view_answer_clicked, self, 0);
	_tmp38_ = self->priv->history;
	g_signal_connect_object (_tmp38_, "equation-clicked", (GCallback) ___lambda41__history_view_equation_clicked, self, 0);
	_tmp39_ = self->priv->history;
	_tmp40_ = self->priv->_display;
	_tmp41_ = math_display_get_equation (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = math_equation_get_serializer (_tmp42_);
	_tmp44_ = _tmp43_;
	history_view_set_serializer (_tmp39_, _tmp44_);
	_tmp45_ = box;
	_tmp46_ = self->priv->history;
	gtk_box_append (_tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = box;
	_tmp48_ = self->priv->_display;
	gtk_box_append (_tmp47_, (GtkWidget*) _tmp48_);
	_tmp49_ = math_buttons_new (equation, self);
	g_object_ref_sink (_tmp49_);
	_g_object_unref0 (self->priv->_buttons);
	self->priv->_buttons = _tmp49_;
	_tmp50_ = self->priv->grid;
	_tmp51_ = self->priv->_buttons;
	_tmp52_ = box;
	gtk_grid_attach_next_to (_tmp50_, (GtkWidget*) _tmp51_, (GtkWidget*) _tmp52_, GTK_POS_BOTTOM, 1, 1);
	_tmp54_ = self->priv->_buttons;
	_tmp55_ = math_buttons_get_mode (_tmp54_);
	_tmp56_ = _tmp55_;
	if (_tmp56_ != BUTTON_MODE_KEYBOARD) {
		_tmp53_ = TRUE;
	} else {
		_tmp53_ = FALSE;
	}
	self->priv->remove_buttons = _tmp53_;
	_tmp57_ = self->priv->_buttons;
	g_signal_connect_object ((GObject*) _tmp57_, "notify::mode", (GCallback) _math_window_mode_changed_cb_g_object_notify, self, 0);
	math_window_mode_changed_cb (self);
	if (DEVELOPMENT_BUILD) {
		gtk_widget_add_css_class ((GtkWidget*) self, "devel");
	}
	_tmp58_ = self->priv->_display;
	math_display_grabfocus (_tmp58_);
	_g_object_unref0 (box);
	_g_object_unref0 (settings);
	return self;
}

MathWindow*
math_window_new (GtkApplication* app,
                 MathEquation* equation)
{
	return math_window_construct (TYPE_MATH_WINDOW, app, equation);
}

static void
math_window_clear_cb (MathWindow* self)
{
	HistoryView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->history;
	history_view_clear (_tmp0_);
}

static void
math_window_mode_changed_cb (MathWindow* self)
{
	GSimpleAction* action = NULL;
	GAction* _tmp0_;
	GSimpleAction* _tmp1_;
	MathButtons* _tmp2_;
	MathButtons* _tmp3_;
	ButtonMode _tmp4_;
	ButtonMode _tmp5_;
	gboolean _tmp26_ = FALSE;
	MathDisplay* _tmp38_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "mode");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction));
	action = _tmp1_;
	_tmp2_ = math_window_get_buttons (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = math_buttons_get_mode (_tmp3_);
	_tmp5_ = _tmp4_;
	switch (_tmp5_) {
		default:
		case BUTTON_MODE_BASIC:
		{
			GtkMenuButton* _tmp6_;
			GSimpleAction* _tmp7_;
			GVariant* _tmp8_;
			GVariant* _tmp9_;
			_tmp6_ = self->priv->menu_button;
			gtk_menu_button_set_label (_tmp6_, _ ("Basic"));
			g_object_set ((GtkWindow*) self, "default-width", 360, NULL);
			_tmp7_ = action;
			_tmp8_ = g_variant_new_string ("basic");
			g_variant_ref_sink (_tmp8_);
			_tmp9_ = _tmp8_;
			g_simple_action_set_state (_tmp7_, _tmp9_);
			_g_variant_unref0 (_tmp9_);
			break;
		}
		case BUTTON_MODE_ADVANCED:
		{
			GtkMenuButton* _tmp10_;
			GSimpleAction* _tmp11_;
			GVariant* _tmp12_;
			GVariant* _tmp13_;
			_tmp10_ = self->priv->menu_button;
			gtk_menu_button_set_label (_tmp10_, _ ("Advanced"));
			g_object_set ((GtkWindow*) self, "default-width", 680, NULL);
			_tmp11_ = action;
			_tmp12_ = g_variant_new_string ("advanced");
			g_variant_ref_sink (_tmp12_);
			_tmp13_ = _tmp12_;
			g_simple_action_set_state (_tmp11_, _tmp13_);
			_g_variant_unref0 (_tmp13_);
			break;
		}
		case BUTTON_MODE_FINANCIAL:
		{
			GtkMenuButton* _tmp14_;
			GSimpleAction* _tmp15_;
			GVariant* _tmp16_;
			GVariant* _tmp17_;
			_tmp14_ = self->priv->menu_button;
			gtk_menu_button_set_label (_tmp14_, _ ("Financial"));
			g_object_set ((GtkWindow*) self, "default-width", 680, NULL);
			_tmp15_ = action;
			_tmp16_ = g_variant_new_string ("financial");
			g_variant_ref_sink (_tmp16_);
			_tmp17_ = _tmp16_;
			g_simple_action_set_state (_tmp15_, _tmp17_);
			_g_variant_unref0 (_tmp17_);
			break;
		}
		case BUTTON_MODE_PROGRAMMING:
		{
			GtkMenuButton* _tmp18_;
			GSimpleAction* _tmp19_;
			GVariant* _tmp20_;
			GVariant* _tmp21_;
			_tmp18_ = self->priv->menu_button;
			gtk_menu_button_set_label (_tmp18_, _ ("Programming"));
			g_object_set ((GtkWindow*) self, "default-width", 680, NULL);
			_tmp19_ = action;
			_tmp20_ = g_variant_new_string ("programming");
			g_variant_ref_sink (_tmp20_);
			_tmp21_ = _tmp20_;
			g_simple_action_set_state (_tmp19_, _tmp21_);
			_g_variant_unref0 (_tmp21_);
			break;
		}
		case BUTTON_MODE_KEYBOARD:
		{
			GtkMenuButton* _tmp22_;
			GSimpleAction* _tmp23_;
			GVariant* _tmp24_;
			GVariant* _tmp25_;
			_tmp22_ = self->priv->menu_button;
			gtk_menu_button_set_label (_tmp22_, _ ("Keyboard"));
			g_object_set ((GtkWindow*) self, "default-width", 680, NULL);
			_tmp23_ = action;
			_tmp24_ = g_variant_new_string ("keyboard");
			g_variant_ref_sink (_tmp24_);
			_tmp25_ = _tmp24_;
			g_simple_action_set_state (_tmp23_, _tmp25_);
			_g_variant_unref0 (_tmp25_);
			break;
		}
	}
	if (self->priv->remove_buttons == TRUE) {
		MathButtons* _tmp27_;
		ButtonMode _tmp28_;
		ButtonMode _tmp29_;
		_tmp27_ = self->priv->_buttons;
		_tmp28_ = math_buttons_get_mode (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp26_ = _tmp29_ != BUTTON_MODE_KEYBOARD;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		MathButtons* _tmp30_;
		MathConverter* _tmp31_;
		_tmp30_ = self->priv->_buttons;
		gtk_widget_show ((GtkWidget*) _tmp30_);
		self->priv->remove_buttons = FALSE;
		_tmp31_ = self->priv->converter;
		gtk_widget_hide ((GtkWidget*) _tmp31_);
	} else {
		gboolean _tmp32_ = FALSE;
		if (self->priv->remove_buttons == FALSE) {
			MathButtons* _tmp33_;
			ButtonMode _tmp34_;
			ButtonMode _tmp35_;
			_tmp33_ = self->priv->_buttons;
			_tmp34_ = math_buttons_get_mode (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp32_ = _tmp35_ == BUTTON_MODE_KEYBOARD;
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			MathButtons* _tmp36_;
			MathConverter* _tmp37_;
			_tmp36_ = self->priv->_buttons;
			gtk_widget_hide ((GtkWidget*) _tmp36_);
			self->priv->remove_buttons = TRUE;
			_tmp37_ = self->priv->converter;
			gtk_widget_show ((GtkWidget*) _tmp37_);
		}
	}
	_tmp38_ = self->priv->_display;
	math_display_set_enable_osk (_tmp38_, self->priv->remove_buttons);
	_g_object_unref0 (action);
}

static void
__lambda42_ (MathWindow* self)
{
	gtk_window_destroy ((GtkWindow*) self);
}

static void
___lambda42__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda42_ ((MathWindow*) self);
}

void
math_window_critical_error (MathWindow* self,
                            const gchar* title,
                            const gchar* contents)
{
	GtkMessageDialog* dialog = NULL;
	GtkMessageDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	g_return_if_fail (contents != NULL);
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "%s", title);
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	gtk_message_dialog_format_secondary_text (dialog, "%s", contents);
	gtk_dialog_add_buttons ((GtkDialog*) dialog, _ ("_Quit"), GTK_RESPONSE_ACCEPT, NULL);
	g_signal_connect_object ((GtkDialog*) dialog, "response", (GCallback) ___lambda42__gtk_dialog_response, self, 0);
	gtk_widget_show ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}

gboolean
math_window_key_press_cb (MathWindow* self,
                          GtkEventControllerKey* controller,
                          guint keyval,
                          guint keycode,
                          GdkModifierType state)
{
	gboolean _tmp0_ = FALSE;
	MathButtons* _tmp1_;
	MathButtons* _tmp2_;
	ButtonMode _tmp3_;
	ButtonMode _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (controller != NULL, FALSE);
	_tmp1_ = math_window_get_buttons (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = math_buttons_get_mode (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == BUTTON_MODE_PROGRAMMING) {
		_tmp0_ = (state & GDK_CONTROL_MASK) == GDK_CONTROL_MASK;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		switch (keyval) {
			case GDK_KEY_b:
			{
				MathEquation* _tmp5_;
				MathEquation* _tmp6_;
				_tmp5_ = math_window_get_equation (self);
				_tmp6_ = _tmp5_;
				math_equation_set_number_base (_tmp6_, 2);
				result = TRUE;
				return result;
			}
			case GDK_KEY_o:
			{
				MathEquation* _tmp7_;
				MathEquation* _tmp8_;
				_tmp7_ = math_window_get_equation (self);
				_tmp8_ = _tmp7_;
				math_equation_set_number_base (_tmp8_, 8);
				result = TRUE;
				return result;
			}
			case GDK_KEY_d:
			{
				MathEquation* _tmp9_;
				MathEquation* _tmp10_;
				_tmp9_ = math_window_get_equation (self);
				_tmp10_ = _tmp9_;
				math_equation_set_number_base (_tmp10_, 10);
				result = TRUE;
				return result;
			}
			case GDK_KEY_h:
			{
				MathEquation* _tmp11_;
				MathEquation* _tmp12_;
				_tmp11_ = math_window_get_equation (self);
				_tmp12_ = _tmp11_;
				math_equation_set_number_base (_tmp12_, 16);
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	}
	result = FALSE;
	return result;
}

static void
math_window_scroll_changed_cb (MathWindow* self,
                               GtkAdjustment* adjustment)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	if (self->priv->right_aligned) {
		gtk_adjustment_set_value (adjustment, gtk_adjustment_get_upper (adjustment) - gtk_adjustment_get_page_size (adjustment));
	}
}

static void
_math_window_scroll_changed_cb_gtk_adjustment_changed (GtkAdjustment* _sender,
                                                       gpointer self)
{
	math_window_scroll_changed_cb ((MathWindow*) self, _sender);
}

static void
math_window_scroll_value_changed_cb (MathWindow* self,
                                     GtkAdjustment* adjustment)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	if (gtk_adjustment_get_value (adjustment) == (gtk_adjustment_get_upper (adjustment) - gtk_adjustment_get_page_size (adjustment))) {
		self->priv->right_aligned = TRUE;
	} else {
		self->priv->right_aligned = FALSE;
	}
}

static void
_math_window_scroll_value_changed_cb_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                   gpointer self)
{
	math_window_scroll_value_changed_cb ((MathWindow*) self, _sender);
}

static void
math_window_copy_cb (MathWindow* self)
{
	MathEquation* _tmp0_;
	MathEquation* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_window_get_equation (self);
	_tmp1_ = _tmp0_;
	math_equation_copy (_tmp1_);
}

static void
math_window_paste_cb (MathWindow* self)
{
	MathEquation* _tmp0_;
	MathEquation* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_window_get_equation (self);
	_tmp1_ = _tmp0_;
	math_equation_paste (_tmp1_);
}

static void
math_window_undo_cb (MathWindow* self)
{
	MathEquation* _tmp0_;
	MathEquation* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_window_get_equation (self);
	_tmp1_ = _tmp0_;
	math_equation_undo (_tmp1_);
}

static void
math_window_redo_cb (MathWindow* self)
{
	MathEquation* _tmp0_;
	MathEquation* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_window_get_equation (self);
	_tmp1_ = _tmp0_;
	math_equation_redo (_tmp1_);
}

static void
math_window_mode_cb (MathWindow* self,
                     GSimpleAction* action,
                     GVariant* parameter)
{
	const GVariantType* _tmp0_;
	GtkMenuButton* _tmp1_;
	MathDisplay* _tmp2_;
	ButtonMode mode = 0;
	gchar* mode_str = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	MathButtons* _tmp10_;
	MathButtons* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (parameter != NULL, "parameter != null");
	_tmp0_ = G_VARIANT_TYPE_STRING;
	_vala_return_if_fail (g_variant_is_of_type (parameter, _tmp0_), "parameter.is_of_type (VariantType.STRING)");
	_tmp1_ = self->priv->menu_button;
	gtk_menu_button_popdown (_tmp1_);
	_tmp2_ = self->priv->_display;
	math_display_grab_focus (_tmp2_);
	mode = BUTTON_MODE_BASIC;
	_tmp3_ = g_variant_get_string (parameter, NULL);
	_tmp4_ = g_strdup (_tmp3_);
	mode_str = _tmp4_;
	_tmp5_ = mode_str;
	if (g_strcmp0 (_tmp5_, "basic") == 0) {
		mode = BUTTON_MODE_BASIC;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = mode_str;
		if (g_strcmp0 (_tmp6_, "advanced") == 0) {
			mode = BUTTON_MODE_ADVANCED;
		} else {
			const gchar* _tmp7_;
			_tmp7_ = mode_str;
			if (g_strcmp0 (_tmp7_, "financial") == 0) {
				mode = BUTTON_MODE_FINANCIAL;
			} else {
				const gchar* _tmp8_;
				_tmp8_ = mode_str;
				if (g_strcmp0 (_tmp8_, "programming") == 0) {
					mode = BUTTON_MODE_PROGRAMMING;
				} else {
					const gchar* _tmp9_;
					_tmp9_ = mode_str;
					if (g_strcmp0 (_tmp9_, "keyboard") == 0) {
						mode = BUTTON_MODE_KEYBOARD;
					} else {
						g_assert_not_reached ();
					}
				}
			}
		}
	}
	_tmp10_ = math_window_get_buttons (self);
	_tmp11_ = _tmp10_;
	math_buttons_set_mode (_tmp11_, mode);
	_g_free0 (mode_str);
}

void
math_window_update_history (MathWindow* self,
                            const gchar* answer,
                            Number* number,
                            gint number_base,
                            guint representation_base)
{
	HistoryView* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (answer != NULL);
	g_return_if_fail (number != NULL);
	_tmp0_ = self->priv->history;
	history_view_insert_entry (_tmp0_, answer, number, number_base, representation_base);
}

MathEquation*
math_window_get_equation (MathWindow* self)
{
	MathEquation* result;
	MathEquation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equation;
	result = _tmp0_;
	return result;
}

MathDisplay*
math_window_get_math_display (MathWindow* self)
{
	MathDisplay* result;
	MathDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

MathButtons*
math_window_get_buttons (MathWindow* self)
{
	MathButtons* result;
	MathButtons* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_buttons;
	result = _tmp0_;
	return result;
}

static void
math_window_class_init (MathWindowClass * klass,
                        gpointer klass_data)
{
	math_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MathWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_math_window_get_property;
	G_OBJECT_CLASS (klass)->finalize = math_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_WINDOW_EQUATION_PROPERTY, math_window_properties[MATH_WINDOW_EQUATION_PROPERTY] = g_param_spec_object ("equation", "equation", "equation", TYPE_MATH_EQUATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_WINDOW_MATH_DISPLAY_PROPERTY, math_window_properties[MATH_WINDOW_MATH_DISPLAY_PROPERTY] = g_param_spec_object ("math-display", "math-display", "math-display", TYPE_MATH_DISPLAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_WINDOW_BUTTONS_PROPERTY, math_window_properties[MATH_WINDOW_BUTTONS_PROPERTY] = g_param_spec_object ("buttons", "buttons", "buttons", TYPE_MATH_BUTTONS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/calculator/math-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "menu_button", FALSE, MathWindow_private_offset + G_STRUCT_OFFSET (MathWindowPrivate, menu_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid", FALSE, MathWindow_private_offset + G_STRUCT_OFFSET (MathWindowPrivate, grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "converter", FALSE, MathWindow_private_offset + G_STRUCT_OFFSET (MathWindowPrivate, converter));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "scroll_changed_cb", G_CALLBACK(_math_window_scroll_changed_cb_gtk_adjustment_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "scroll_value_changed_cb", G_CALLBACK(_math_window_scroll_value_changed_cb_gtk_adjustment_value_changed));
}

static void
math_window_instance_init (MathWindow * self,
                           gpointer klass)
{
	self->priv = math_window_get_instance_private (self);
	g_type_ensure (TYPE_MATH_CONVERTER);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
math_window_finalize (GObject * obj)
{
	MathWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_WINDOW, MathWindow);
	_g_object_unref0 (self->priv->_equation);
	_g_object_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->_display);
	_g_object_unref0 (self->priv->_buttons);
	_g_object_unref0 (self->priv->event_controller);
	G_OBJECT_CLASS (math_window_parent_class)->finalize (obj);
}

static GType
math_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MathWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathWindow), 0, (GInstanceInitFunc) math_window_instance_init, NULL };
	GType math_window_type_id;
	math_window_type_id = g_type_register_static (adw_application_window_get_type (), "MathWindow", &g_define_type_info, 0);
	MathWindow_private_offset = g_type_add_instance_private (math_window_type_id, sizeof (MathWindowPrivate));
	return math_window_type_id;
}

GType
math_window_get_type (void)
{
	static volatile gsize math_window_type_id__once = 0;
	if (g_once_init_enter (&math_window_type_id__once)) {
		GType math_window_type_id;
		math_window_type_id = math_window_get_type_once ();
		g_once_init_leave (&math_window_type_id__once, math_window_type_id);
	}
	return math_window_type_id__once;
}

static void
_vala_math_window_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	MathWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_WINDOW, MathWindow);
	switch (property_id) {
		case MATH_WINDOW_EQUATION_PROPERTY:
		g_value_set_object (value, math_window_get_equation (self));
		break;
		case MATH_WINDOW_MATH_DISPLAY_PROPERTY:
		g_value_set_object (value, math_window_get_math_display (self));
		break;
		case MATH_WINDOW_BUTTONS_PROPERTY:
		g_value_set_object (value, math_window_get_buttons (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

