/* contacts-store.c generated by valac 0.56.0, the Vala compiler
 * generated from contacts-store.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "contacts.h"
#include <folks/folks.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gio/gio.h>

enum  {
	CONTACTS_STORE_0_PROPERTY,
	CONTACTS_STORE_AGGREGATOR_PROPERTY,
	CONTACTS_STORE_BACKEND_STORE_PROPERTY,
	CONTACTS_STORE_IS_QUIESCENT_PROPERTY,
	CONTACTS_STORE_IS_PREPARED_PROPERTY,
	CONTACTS_STORE_NUM_PROPERTIES
};
static GParamSpec* contacts_store_properties[CONTACTS_STORE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _ContactsStoreFindContactData ContactsStoreFindContactData;
enum  {
	CONTACTS_STORE_ADDED_SIGNAL,
	CONTACTS_STORE_REMOVED_SIGNAL,
	CONTACTS_STORE_QUIESCENT_SIGNAL,
	CONTACTS_STORE_PREPARED_SIGNAL,
	CONTACTS_STORE_NUM_SIGNALS
};
static guint contacts_store_signals[CONTACTS_STORE_NUM_SIGNALS] = {0};

struct _ContactsStorePrivate {
	FolksIndividualAggregator* _aggregator;
};

struct _Block1Data {
	int _ref_count_;
	ContactsStore* self;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _ContactsStoreFindContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsStore* self;
	FolksQuery* query;
	FolksIndividual* result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	Block1Data* _data1_;
	gulong signal_id;
	gulong _tmp2_;
	FolksIndividual* matched;
	guint strength;
	GeeIterator* _i_it;
	FolksIndividualAggregator* _tmp3_;
	GeeMap* _tmp4_;
	GeeMap* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp8_;
	GeeIterator* _tmp9_;
	GeeIterator* _tmp10_;
	GeeIterator* _tmp11_;
	FolksIndividual* i;
	GeeIterator* _tmp12_;
	gpointer _tmp13_;
	guint this_strength;
	FolksIndividual* _tmp14_;
	FolksIndividual* _tmp15_;
	FolksIndividual* _tmp16_;
};

static gint ContactsStore_private_offset;
static gpointer contacts_store_parent_class = NULL;

static void contacts_store_read_dont_suggest_db (ContactsStore* self);
static void contacts_store_write_dont_suggest_db (ContactsStore* self);
static void contacts_store_on_individuals_changed_detailed (ContactsStore* self,
                                                     GeeMultiMap* changes);
static void contacts_store_find_contact_data_free (gpointer _data);
static gboolean contacts_store_find_contact_co (ContactsStoreFindContactData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean _contacts_store_find_contact_co_gsource_func (gpointer self);
static void ___lambda12_ (Block1Data* _data1_);
static void ____lambda12__contacts_store_quiescent (ContactsStore* _sender,
                                             gpointer self);
static void contacts_store_set_aggregator (ContactsStore* self,
                                    FolksIndividualAggregator* value);
static GObject * contacts_store_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static void _contacts_store___lambda13_ (ContactsStore* self,
                                  GObject* obj,
                                  GParamSpec* pspec);
static gboolean __lambda14_ (ContactsStore* self);
static gboolean ___lambda14__gsource_func (gpointer self);
static void __contacts_store___lambda13__g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self);
static void _contacts_store___lambda15_ (ContactsStore* self,
                                  GObject* obj,
                                  GParamSpec* pspec);
static gboolean __lambda16_ (ContactsStore* self);
static gboolean ___lambda16__gsource_func (gpointer self);
static void __contacts_store___lambda15__g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self);
static void _contacts_store_on_individuals_changed_detailed_folks_individual_aggregator_individuals_changed_detailed (FolksIndividualAggregator* _sender,
                                                                                                               GeeMultiMap* changes,
                                                                                                               gpointer self);
static void contacts_store_finalize (GObject * obj);
static GType contacts_store_get_type_once (void);
static void _vala_contacts_store_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_contacts_store_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
contacts_store_get_instance_private (ContactsStore* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsStore_private_offset);
}

static void
contacts_store_read_dont_suggest_db (ContactsStore* self)
{
	GeeHashMultiMap* _tmp0_;
	gchar* path = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->dont_suggest_link;
	gee_multi_map_clear ((GeeMultiMap*) _tmp0_);
	_tmp1_ = g_get_user_config_dir ();
	_tmp2_ = g_build_filename (_tmp1_, "gnome-contacts", "dont_suggest.db", NULL);
	path = _tmp2_;
	{
		gchar* contents = NULL;
		gchar* _tmp3_ = NULL;
		gchar** rows = NULL;
		gchar** _tmp4_;
		gchar** _tmp5_;
		gint rows_length1;
		gint _rows_size_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		g_file_get_contents (path, &_tmp3_, NULL, &_inner_error0_);
		_g_free0 (contents);
		contents = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (contents);
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp4_ = g_strsplit (contents, "\n", 0);
		rows = _tmp5_;
		rows_length1 = _vala_array_length (_tmp4_);
		_rows_size_ = rows_length1;
		_tmp6_ = rows;
		_tmp6__length1 = rows_length1;
		{
			gchar** r_collection = NULL;
			gint r_collection_length1 = 0;
			gint _r_collection_size_ = 0;
			gint r_it = 0;
			r_collection = _tmp6_;
			r_collection_length1 = _tmp6__length1;
			for (r_it = 0; r_it < r_collection_length1; r_it = r_it + 1) {
				const gchar* r = NULL;
				r = r_collection[r_it];
				{
					gchar** ids = NULL;
					const gchar* _tmp7_;
					gchar** _tmp8_;
					gchar** _tmp9_;
					gint ids_length1;
					gint _ids_size_;
					gchar** _tmp10_;
					gint _tmp10__length1;
					_tmp7_ = r;
					_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, " ", 0);
					ids = _tmp9_;
					ids_length1 = _vala_array_length (_tmp8_);
					_ids_size_ = ids_length1;
					_tmp10_ = ids;
					_tmp10__length1 = ids_length1;
					if (_tmp10__length1 == 2) {
						GeeHashMultiMap* _tmp11_;
						gchar** _tmp12_;
						gint _tmp12__length1;
						const gchar* _tmp13_;
						gchar** _tmp14_;
						gint _tmp14__length1;
						const gchar* _tmp15_;
						_tmp11_ = self->dont_suggest_link;
						_tmp12_ = ids;
						_tmp12__length1 = ids_length1;
						_tmp13_ = _tmp12_[0];
						_tmp14_ = ids;
						_tmp14__length1 = ids_length1;
						_tmp15_ = _tmp14_[1];
						gee_multi_map_set ((GeeMultiMap*) _tmp11_, _tmp13_, _tmp15_);
					}
					ids = (_vala_array_free (ids, ids_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
		rows = (_vala_array_free (rows, rows_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (contents);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		if (g_error_matches (_tmp16_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
			_g_error_free0 (e);
			_g_free0 (path);
			return;
		}
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_warning ("contacts-store.vala:62: error loading no suggestion db: %s\n", _tmp18_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (path);
}

static void
contacts_store_write_dont_suggest_db (ContactsStore* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar* dir = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* path = NULL;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		GString* s = NULL;
		GString* _tmp5_;
		const gchar* _tmp26_;
		GString* _tmp27_;
		const gchar* _tmp28_;
		GString* _tmp29_;
		_tmp0_ = g_get_user_config_dir ();
		_tmp1_ = g_build_filename (_tmp0_, "gnome-contacts", NULL);
		dir = _tmp1_;
		_tmp2_ = dir;
		g_mkdir_with_parents (_tmp2_, 0700);
		_tmp3_ = dir;
		_tmp4_ = g_build_filename (_tmp3_, "dont_suggest.db", NULL);
		path = _tmp4_;
		_tmp5_ = g_string_new ("");
		s = _tmp5_;
		{
			GeeIterator* _key_it = NULL;
			GeeHashMultiMap* _tmp6_;
			GeeSet* _tmp7_;
			GeeSet* _tmp8_;
			GeeIterator* _tmp9_;
			GeeIterator* _tmp10_;
			_tmp6_ = self->dont_suggest_link;
			_tmp7_ = gee_multi_map_get_keys ((GeeMultiMap*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
			_tmp10_ = _tmp9_;
			_g_object_unref0 (_tmp8_);
			_key_it = _tmp10_;
			while (TRUE) {
				GeeIterator* _tmp11_;
				gchar* key = NULL;
				GeeIterator* _tmp12_;
				gpointer _tmp13_;
				_tmp11_ = _key_it;
				if (!gee_iterator_next (_tmp11_)) {
					break;
				}
				_tmp12_ = _key_it;
				_tmp13_ = gee_iterator_get (_tmp12_);
				key = (gchar*) _tmp13_;
				{
					GeeIterator* _value_it = NULL;
					GeeHashMultiMap* _tmp14_;
					const gchar* _tmp15_;
					GeeCollection* _tmp16_;
					GeeCollection* _tmp17_;
					GeeIterator* _tmp18_;
					GeeIterator* _tmp19_;
					_tmp14_ = self->dont_suggest_link;
					_tmp15_ = key;
					_tmp16_ = gee_multi_map_get ((GeeMultiMap*) _tmp14_, _tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
					_tmp19_ = _tmp18_;
					_g_object_unref0 (_tmp17_);
					_value_it = _tmp19_;
					while (TRUE) {
						GeeIterator* _tmp20_;
						gchar* value = NULL;
						GeeIterator* _tmp21_;
						gpointer _tmp22_;
						GString* _tmp23_;
						const gchar* _tmp24_;
						const gchar* _tmp25_;
						_tmp20_ = _value_it;
						if (!gee_iterator_next (_tmp20_)) {
							break;
						}
						_tmp21_ = _value_it;
						_tmp22_ = gee_iterator_get (_tmp21_);
						value = (gchar*) _tmp22_;
						_tmp23_ = s;
						_tmp24_ = key;
						_tmp25_ = value;
						g_string_append_printf (_tmp23_, "%s %s\n", _tmp24_, _tmp25_);
						_g_free0 (value);
					}
					_g_object_unref0 (_value_it);
				}
				_g_free0 (key);
			}
			_g_object_unref0 (_key_it);
		}
		_tmp26_ = path;
		_tmp27_ = s;
		_tmp28_ = _tmp27_->str;
		_tmp29_ = s;
		g_file_set_contents (_tmp26_, _tmp28_, _tmp29_->len, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_string_free0 (s);
			_g_free0 (path);
			_g_free0 (dir);
			goto __catch0_g_error;
		}
		_g_string_free0 (s);
		_g_free0 (path);
		_g_free0 (dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp30_ = e;
		_tmp31_ = _tmp30_->message;
		g_warning ("contacts-store.vala:79: error writing no suggestion db: %s\n", _tmp31_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gboolean
contacts_store_may_suggest_link (ContactsStore* self,
                                 FolksIndividual* a,
                                 FolksIndividual* b)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	{
		GeeIterator* _a_persona_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp0_ = folks_individual_get_personas (a);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_a_persona_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			FolksPersona* a_persona = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			_tmp3_ = _a_persona_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _a_persona_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			a_persona = (FolksPersona*) _tmp5_;
			{
				GeeIterator* _no_link_uid_it = NULL;
				GeeHashMultiMap* _tmp6_;
				FolksPersona* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				GeeCollection* _tmp10_;
				GeeCollection* _tmp11_;
				GeeIterator* _tmp12_;
				GeeIterator* _tmp13_;
				_tmp6_ = self->dont_suggest_link;
				_tmp7_ = a_persona;
				_tmp8_ = folks_persona_get_uid (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = gee_multi_map_get ((GeeMultiMap*) _tmp6_, _tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = gee_iterable_iterator ((GeeIterable*) _tmp11_);
				_tmp13_ = _tmp12_;
				_g_object_unref0 (_tmp11_);
				_no_link_uid_it = _tmp13_;
				while (TRUE) {
					GeeIterator* _tmp14_;
					gchar* no_link_uid = NULL;
					GeeIterator* _tmp15_;
					gpointer _tmp16_;
					_tmp14_ = _no_link_uid_it;
					if (!gee_iterator_next (_tmp14_)) {
						break;
					}
					_tmp15_ = _no_link_uid_it;
					_tmp16_ = gee_iterator_get (_tmp15_);
					no_link_uid = (gchar*) _tmp16_;
					{
						GeeIterator* _b_persona_it = NULL;
						GeeSet* _tmp17_;
						GeeSet* _tmp18_;
						GeeIterator* _tmp19_;
						_tmp17_ = folks_individual_get_personas (b);
						_tmp18_ = _tmp17_;
						_tmp19_ = gee_iterable_iterator ((GeeIterable*) _tmp18_);
						_b_persona_it = _tmp19_;
						while (TRUE) {
							GeeIterator* _tmp20_;
							FolksPersona* b_persona = NULL;
							GeeIterator* _tmp21_;
							gpointer _tmp22_;
							FolksPersona* _tmp23_;
							const gchar* _tmp24_;
							const gchar* _tmp25_;
							const gchar* _tmp26_;
							_tmp20_ = _b_persona_it;
							if (!gee_iterator_next (_tmp20_)) {
								break;
							}
							_tmp21_ = _b_persona_it;
							_tmp22_ = gee_iterator_get (_tmp21_);
							b_persona = (FolksPersona*) _tmp22_;
							_tmp23_ = b_persona;
							_tmp24_ = folks_persona_get_uid (_tmp23_);
							_tmp25_ = _tmp24_;
							_tmp26_ = no_link_uid;
							if (g_strcmp0 (_tmp25_, _tmp26_) == 0) {
								result = FALSE;
								_g_object_unref0 (b_persona);
								_g_object_unref0 (_b_persona_it);
								_g_free0 (no_link_uid);
								_g_object_unref0 (_no_link_uid_it);
								_g_object_unref0 (a_persona);
								_g_object_unref0 (_a_persona_it);
								return result;
							}
							_g_object_unref0 (b_persona);
						}
						_g_object_unref0 (_b_persona_it);
					}
					_g_free0 (no_link_uid);
				}
				_g_object_unref0 (_no_link_uid_it);
			}
			_g_object_unref0 (a_persona);
		}
		_g_object_unref0 (_a_persona_it);
	}
	{
		GeeIterator* _b_persona_it = NULL;
		GeeSet* _tmp27_;
		GeeSet* _tmp28_;
		GeeIterator* _tmp29_;
		_tmp27_ = folks_individual_get_personas (b);
		_tmp28_ = _tmp27_;
		_tmp29_ = gee_iterable_iterator ((GeeIterable*) _tmp28_);
		_b_persona_it = _tmp29_;
		while (TRUE) {
			GeeIterator* _tmp30_;
			FolksPersona* b_persona = NULL;
			GeeIterator* _tmp31_;
			gpointer _tmp32_;
			_tmp30_ = _b_persona_it;
			if (!gee_iterator_next (_tmp30_)) {
				break;
			}
			_tmp31_ = _b_persona_it;
			_tmp32_ = gee_iterator_get (_tmp31_);
			b_persona = (FolksPersona*) _tmp32_;
			{
				GeeIterator* _no_link_uid_it = NULL;
				GeeHashMultiMap* _tmp33_;
				FolksPersona* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				GeeCollection* _tmp37_;
				GeeCollection* _tmp38_;
				GeeIterator* _tmp39_;
				GeeIterator* _tmp40_;
				_tmp33_ = self->dont_suggest_link;
				_tmp34_ = b_persona;
				_tmp35_ = folks_persona_get_uid (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = gee_multi_map_get ((GeeMultiMap*) _tmp33_, _tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = gee_iterable_iterator ((GeeIterable*) _tmp38_);
				_tmp40_ = _tmp39_;
				_g_object_unref0 (_tmp38_);
				_no_link_uid_it = _tmp40_;
				while (TRUE) {
					GeeIterator* _tmp41_;
					gchar* no_link_uid = NULL;
					GeeIterator* _tmp42_;
					gpointer _tmp43_;
					_tmp41_ = _no_link_uid_it;
					if (!gee_iterator_next (_tmp41_)) {
						break;
					}
					_tmp42_ = _no_link_uid_it;
					_tmp43_ = gee_iterator_get (_tmp42_);
					no_link_uid = (gchar*) _tmp43_;
					{
						GeeIterator* _a_persona_it = NULL;
						GeeSet* _tmp44_;
						GeeSet* _tmp45_;
						GeeIterator* _tmp46_;
						_tmp44_ = folks_individual_get_personas (a);
						_tmp45_ = _tmp44_;
						_tmp46_ = gee_iterable_iterator ((GeeIterable*) _tmp45_);
						_a_persona_it = _tmp46_;
						while (TRUE) {
							GeeIterator* _tmp47_;
							FolksPersona* a_persona = NULL;
							GeeIterator* _tmp48_;
							gpointer _tmp49_;
							FolksPersona* _tmp50_;
							const gchar* _tmp51_;
							const gchar* _tmp52_;
							const gchar* _tmp53_;
							_tmp47_ = _a_persona_it;
							if (!gee_iterator_next (_tmp47_)) {
								break;
							}
							_tmp48_ = _a_persona_it;
							_tmp49_ = gee_iterator_get (_tmp48_);
							a_persona = (FolksPersona*) _tmp49_;
							_tmp50_ = a_persona;
							_tmp51_ = folks_persona_get_uid (_tmp50_);
							_tmp52_ = _tmp51_;
							_tmp53_ = no_link_uid;
							if (g_strcmp0 (_tmp52_, _tmp53_) == 0) {
								result = FALSE;
								_g_object_unref0 (a_persona);
								_g_object_unref0 (_a_persona_it);
								_g_free0 (no_link_uid);
								_g_object_unref0 (_no_link_uid_it);
								_g_object_unref0 (b_persona);
								_g_object_unref0 (_b_persona_it);
								return result;
							}
							_g_object_unref0 (a_persona);
						}
						_g_object_unref0 (_a_persona_it);
					}
					_g_free0 (no_link_uid);
				}
				_g_object_unref0 (_no_link_uid_it);
			}
			_g_object_unref0 (b_persona);
		}
		_g_object_unref0 (_b_persona_it);
	}
	result = TRUE;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
contacts_store_add_no_suggest_link (ContactsStore* self,
                                    FolksIndividual* a,
                                    FolksIndividual* b)
{
	FolksPersona* persona1 = NULL;
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	gint _tmp2_ = 0;
	gpointer* _tmp3_;
	FolksPersona** _tmp4_;
	gint _tmp4__length1;
	FolksPersona* _tmp5_;
	FolksPersona* _tmp6_;
	FolksPersona* _tmp7_;
	FolksPersona* persona2 = NULL;
	GeeSet* _tmp8_;
	GeeSet* _tmp9_;
	gint _tmp10_ = 0;
	gpointer* _tmp11_;
	FolksPersona** _tmp12_;
	gint _tmp12__length1;
	FolksPersona* _tmp13_;
	FolksPersona* _tmp14_;
	FolksPersona* _tmp15_;
	GeeHashMultiMap* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	_tmp0_ = folks_individual_get_personas (a);
	_tmp1_ = _tmp0_;
	_tmp3_ = gee_collection_to_array ((GeeCollection*) _tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_tmp5_ = _tmp4_[0];
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_object_unref), NULL);
	persona1 = _tmp7_;
	_tmp8_ = folks_individual_get_personas (b);
	_tmp9_ = _tmp8_;
	_tmp11_ = gee_collection_to_array ((GeeCollection*) _tmp9_, &_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp12__length1 = _tmp10_;
	_tmp13_ = _tmp12_[0];
	_tmp14_ = _g_object_ref0 (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_object_unref), NULL);
	persona2 = _tmp15_;
	_tmp16_ = self->dont_suggest_link;
	_tmp17_ = folks_persona_get_uid (persona1);
	_tmp18_ = _tmp17_;
	_tmp19_ = folks_persona_get_uid (persona2);
	_tmp20_ = _tmp19_;
	gee_multi_map_set ((GeeMultiMap*) _tmp16_, _tmp18_, _tmp20_);
	contacts_store_write_dont_suggest_db (self);
	_g_object_unref0 (persona2);
	_g_object_unref0 (persona1);
}

static void
contacts_store_on_individuals_changed_detailed (ContactsStore* self,
                                                GeeMultiMap* changes)
{
	GeeHashSet* to_add = NULL;
	GeeHashSet* _tmp0_;
	GeeHashSet* to_remove = NULL;
	GeeHashSet* _tmp1_;
	GeeHashSet* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GeeHashSet* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (changes != NULL);
	_tmp0_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	to_add = _tmp0_;
	_tmp1_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	to_remove = _tmp1_;
	{
		GeeIterator* _i_it = NULL;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp2_ = gee_multi_map_get_keys (changes);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_i_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			FolksIndividual* i = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			FolksIndividual* _tmp9_;
			_tmp6_ = _i_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _i_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			i = (FolksIndividual*) _tmp8_;
			_tmp9_ = i;
			if (_tmp9_ != NULL) {
				GeeHashSet* _tmp10_;
				FolksIndividual* _tmp11_;
				_tmp10_ = to_remove;
				_tmp11_ = i;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
			}
			{
				GeeIterator* _new_i_it = NULL;
				FolksIndividual* _tmp12_;
				GeeCollection* _tmp13_;
				GeeCollection* _tmp14_;
				GeeIterator* _tmp15_;
				GeeIterator* _tmp16_;
				_tmp12_ = i;
				_tmp13_ = gee_multi_map_get (changes, _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
				_tmp16_ = _tmp15_;
				_g_object_unref0 (_tmp14_);
				_new_i_it = _tmp16_;
				while (TRUE) {
					GeeIterator* _tmp17_;
					FolksIndividual* new_i = NULL;
					GeeIterator* _tmp18_;
					gpointer _tmp19_;
					FolksIndividual* _tmp20_;
					_tmp17_ = _new_i_it;
					if (!gee_iterator_next (_tmp17_)) {
						break;
					}
					_tmp18_ = _new_i_it;
					_tmp19_ = gee_iterator_get (_tmp18_);
					new_i = (FolksIndividual*) _tmp19_;
					_tmp20_ = new_i;
					if (_tmp20_ != NULL) {
						GeeHashSet* _tmp21_;
						FolksIndividual* _tmp22_;
						_tmp21_ = to_add;
						_tmp22_ = new_i;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
					}
					_g_object_unref0 (new_i);
				}
				_g_object_unref0 (_new_i_it);
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	_tmp23_ = to_add;
	_tmp24_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = to_remove;
	_tmp27_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp26_);
	_tmp28_ = _tmp27_;
	g_debug ("contacts-store.vala:152: Individuals changed: %d old, %d new", _tmp25_, _tmp28_);
	{
		GeeIterator* _i_it = NULL;
		GeeHashSet* _tmp29_;
		GeeIterator* _tmp30_;
		_tmp29_ = to_add;
		_tmp30_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp29_);
		_i_it = _tmp30_;
		while (TRUE) {
			GeeIterator* _tmp31_;
			FolksIndividual* i = NULL;
			GeeIterator* _tmp32_;
			gpointer _tmp33_;
			FolksIndividual* _tmp34_;
			GeeSet* _tmp35_;
			GeeSet* _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			_tmp31_ = _i_it;
			if (!gee_iterator_next (_tmp31_)) {
				break;
			}
			_tmp32_ = _i_it;
			_tmp33_ = gee_iterator_get (_tmp32_);
			i = (FolksIndividual*) _tmp33_;
			_tmp34_ = i;
			_tmp35_ = folks_individual_get_personas (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = gee_collection_get_size ((GeeCollection*) _tmp36_);
			_tmp38_ = _tmp37_;
			if (_tmp38_ > 0) {
				FolksIndividual* _tmp39_;
				_tmp39_ = i;
				g_signal_emit (self, contacts_store_signals[CONTACTS_STORE_ADDED_SIGNAL], 0, _tmp39_);
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	{
		GeeIterator* _i_it = NULL;
		GeeHashSet* _tmp40_;
		GeeIterator* _tmp41_;
		_tmp40_ = to_remove;
		_tmp41_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp40_);
		_i_it = _tmp41_;
		while (TRUE) {
			GeeIterator* _tmp42_;
			FolksIndividual* i = NULL;
			GeeIterator* _tmp43_;
			gpointer _tmp44_;
			FolksIndividual* _tmp45_;
			_tmp42_ = _i_it;
			if (!gee_iterator_next (_tmp42_)) {
				break;
			}
			_tmp43_ = _i_it;
			_tmp44_ = gee_iterator_get (_tmp43_);
			i = (FolksIndividual*) _tmp44_;
			_tmp45_ = i;
			g_signal_emit (self, contacts_store_signals[CONTACTS_STORE_REMOVED_SIGNAL], 0, _tmp45_);
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	_g_object_unref0 (to_remove);
	_g_object_unref0 (to_add);
}

GeeCollection*
contacts_store_get_contacts (ContactsStore* self)
{
	FolksIndividualAggregator* _tmp0_;
	GeeMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp8_;
	GeeCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_aggregator;
	_tmp1_ = folks_individual_aggregator_get_individuals (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_map_get_values (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_collection_get_read_only_view (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp5_);
	result = _tmp8_;
	return result;
}

static void
contacts_store_find_contact_data_free (gpointer _data)
{
	ContactsStoreFindContactData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->query);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsStoreFindContactData, _data_);
}

void
contacts_store_find_contact (ContactsStore* self,
                             FolksQuery* query,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	ContactsStoreFindContactData* _data_;
	ContactsStore* _tmp0_;
	FolksQuery* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query != NULL);
	_data_ = g_slice_new0 (ContactsStoreFindContactData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_store_find_contact_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (query);
	_g_object_unref0 (_data_->query);
	_data_->query = _tmp1_;
	contacts_store_find_contact_co (_data_);
}

FolksIndividual*
contacts_store_find_contact_finish (ContactsStore* self,
                                    GAsyncResult* _res_)
{
	FolksIndividual* result;
	ContactsStoreFindContactData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ContactsStore* self;
		self = _data1_->self;
		(_data1_->callback_target_destroy_notify == NULL) ? NULL : (_data1_->callback_target_destroy_notify (_data1_->callback_target), NULL);
		_data1_->callback = NULL;
		_data1_->callback_target = NULL;
		_data1_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
_contacts_store_find_contact_co_gsource_func (gpointer self)
{
	gboolean result;
	result = contacts_store_find_contact_co (self);
	return result;
}

static void
___lambda12_ (Block1Data* _data1_)
{
	ContactsStore* self;
	GSourceFunc _tmp0_;
	gpointer _tmp0__target;
	self = _data1_->self;
	_tmp0_ = _data1_->callback;
	_tmp0__target = _data1_->callback_target;
	_tmp0_ (_tmp0__target);
}

static void
____lambda12__contacts_store_quiescent (ContactsStore* _sender,
                                        gpointer self)
{
	___lambda12_ (self);
}

static gboolean
contacts_store_find_contact_co (ContactsStoreFindContactData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = contacts_store_get_is_quiescent (_data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (!_data_->_tmp1_) {
		_data_->_data1_ = g_slice_new0 (Block1Data);
		_data_->_data1_->_ref_count_ = 1;
		_data_->_data1_->self = g_object_ref (_data_->self);
		_data_->_data1_->callback = _contacts_store_find_contact_co_gsource_func;
		_data_->_data1_->callback_target = _data_;
		_data_->_data1_->callback_target_destroy_notify = NULL;
		_data_->_tmp2_ = g_signal_connect_data (_data_->self, "quiescent", (GCallback) ____lambda12__contacts_store_quiescent, block1_data_ref (_data_->_data1_), (GClosureNotify) block1_data_unref, 0);
		_data_->signal_id = _data_->_tmp2_;
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		g_signal_handler_disconnect ((GObject*) _data_->self, _data_->signal_id);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
	}
	_data_->matched = NULL;
	_data_->strength = (guint) 0;
	{
		_data_->_tmp3_ = _data_->self->priv->_aggregator;
		_data_->_tmp4_ = folks_individual_aggregator_get_individuals (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = gee_map_get_values (_data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_g_object_unref0 (_data_->_tmp8_);
		_data_->_i_it = _data_->_tmp10_;
		while (TRUE) {
			_data_->_tmp11_ = _data_->_i_it;
			if (!gee_iterator_next (_data_->_tmp11_)) {
				break;
			}
			_data_->_tmp12_ = _data_->_i_it;
			_data_->_tmp13_ = gee_iterator_get (_data_->_tmp12_);
			_data_->i = (FolksIndividual*) _data_->_tmp13_;
			_data_->_tmp14_ = _data_->i;
			_data_->this_strength = folks_query_is_match (_data_->query, _data_->_tmp14_);
			if (_data_->this_strength > _data_->strength) {
				_data_->_tmp15_ = _data_->i;
				_data_->_tmp16_ = _g_object_ref0 (_data_->_tmp15_);
				_g_object_unref0 (_data_->matched);
				_data_->matched = _data_->_tmp16_;
				_data_->strength = _data_->this_strength;
			}
			_g_object_unref0 (_data_->i);
		}
		_g_object_unref0 (_data_->_i_it);
	}
	_data_->result = _data_->matched;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

ContactsStore*
contacts_store_construct (GType object_type)
{
	ContactsStore * self = NULL;
	self = (ContactsStore*) g_object_new (object_type, NULL);
	return self;
}

ContactsStore*
contacts_store_new (void)
{
	return contacts_store_construct (CONTACTS_TYPE_STORE);
}

FolksIndividualAggregator*
contacts_store_get_aggregator (ContactsStore* self)
{
	FolksIndividualAggregator* result;
	FolksIndividualAggregator* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_aggregator;
	result = _tmp0_;
	return result;
}

static void
contacts_store_set_aggregator (ContactsStore* self,
                               FolksIndividualAggregator* value)
{
	FolksIndividualAggregator* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_store_get_aggregator (self);
	if (old_value != value) {
		FolksIndividualAggregator* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_aggregator);
		self->priv->_aggregator = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_store_properties[CONTACTS_STORE_AGGREGATOR_PROPERTY]);
	}
}

FolksBackendStore*
contacts_store_get_backend_store (ContactsStore* self)
{
	FolksBackendStore* result;
	FolksIndividualAggregator* _tmp0_;
	FolksBackendStore* _tmp1_;
	FolksBackendStore* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_aggregator;
	_tmp1_ = folks_individual_aggregator_get_backend_store (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gboolean
contacts_store_get_is_quiescent (ContactsStore* self)
{
	gboolean result;
	FolksIndividualAggregator* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_aggregator;
	_tmp1_ = folks_individual_aggregator_get_is_quiescent (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gboolean
contacts_store_get_is_prepared (ContactsStore* self)
{
	gboolean result;
	FolksIndividualAggregator* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_aggregator;
	_tmp1_ = folks_individual_aggregator_get_is_prepared (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static gboolean
__lambda14_ (ContactsStore* self)
{
	gboolean result;
	g_signal_emit (self, contacts_store_signals[CONTACTS_STORE_QUIESCENT_SIGNAL], 0);
	result = FALSE;
	return result;
}

static gboolean
___lambda14__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda14_ ((ContactsStore*) self);
	return result;
}

static void
_contacts_store___lambda13_ (ContactsStore* self,
                             GObject* obj,
                             GParamSpec* pspec)
{
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda14__gsource_func, g_object_ref (self), g_object_unref);
}

static void
__contacts_store___lambda13__g_object_notify (GObject* _sender,
                                              GParamSpec* pspec,
                                              gpointer self)
{
	_contacts_store___lambda13_ ((ContactsStore*) self, _sender, pspec);
}

static gboolean
__lambda16_ (ContactsStore* self)
{
	gboolean result;
	g_signal_emit (self, contacts_store_signals[CONTACTS_STORE_PREPARED_SIGNAL], 0);
	result = FALSE;
	return result;
}

static gboolean
___lambda16__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda16_ ((ContactsStore*) self);
	return result;
}

static void
_contacts_store___lambda15_ (ContactsStore* self,
                             GObject* obj,
                             GParamSpec* pspec)
{
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda16__gsource_func, g_object_ref (self), g_object_unref);
}

static void
__contacts_store___lambda15__g_object_notify (GObject* _sender,
                                              GParamSpec* pspec,
                                              gpointer self)
{
	_contacts_store___lambda15_ ((ContactsStore*) self, _sender, pspec);
}

static void
_contacts_store_on_individuals_changed_detailed_folks_individual_aggregator_individuals_changed_detailed (FolksIndividualAggregator* _sender,
                                                                                                          GeeMultiMap* changes,
                                                                                                          gpointer self)
{
	contacts_store_on_individuals_changed_detailed ((ContactsStore*) self, changes);
}

static GObject *
contacts_store_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsStore * self;
	GeeHashMultiMap* _tmp0_;
	FolksBackendStore* backend_store = NULL;
	FolksBackendStore* _tmp1_;
	FolksBackendStore* _tmp2_;
	FolksIndividualAggregator* _tmp3_;
	FolksIndividualAggregator* _tmp4_;
	FolksIndividualAggregator* _tmp5_;
	FolksIndividualAggregator* _tmp6_;
	FolksIndividualAggregator* _tmp7_;
	FolksIndividualAggregator* _tmp8_;
	parent_class = G_OBJECT_CLASS (contacts_store_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_STORE, ContactsStore);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->dont_suggest_link);
	self->dont_suggest_link = _tmp0_;
	contacts_store_read_dont_suggest_db (self);
	_tmp1_ = folks_backend_store_dup ();
	backend_store = _tmp1_;
	_tmp2_ = backend_store;
	_tmp3_ = folks_individual_aggregator_dup_with_backend_store (_tmp2_);
	_tmp4_ = _tmp3_;
	contacts_store_set_aggregator (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = self->priv->_aggregator;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::is-quiescent", (GCallback) __contacts_store___lambda13__g_object_notify, self, 0);
	_tmp6_ = self->priv->_aggregator;
	g_signal_connect_object ((GObject*) _tmp6_, "notify::is-prepared", (GCallback) __contacts_store___lambda15__g_object_notify, self, 0);
	_tmp7_ = self->priv->_aggregator;
	g_signal_connect_object (_tmp7_, "individuals-changed-detailed", (GCallback) _contacts_store_on_individuals_changed_detailed_folks_individual_aggregator_individuals_changed_detailed, self, 0);
	_tmp8_ = self->priv->_aggregator;
	folks_individual_aggregator_prepare (_tmp8_, NULL, NULL);
	_g_object_unref0 (backend_store);
	return obj;
}

static void
contacts_store_class_init (ContactsStoreClass * klass,
                           gpointer klass_data)
{
	contacts_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsStore_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_store_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_store_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_STORE_AGGREGATOR_PROPERTY, contacts_store_properties[CONTACTS_STORE_AGGREGATOR_PROPERTY] = g_param_spec_object ("aggregator", "aggregator", "aggregator", FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_STORE_BACKEND_STORE_PROPERTY, contacts_store_properties[CONTACTS_STORE_BACKEND_STORE_PROPERTY] = g_param_spec_object ("backend-store", "backend-store", "backend-store", FOLKS_TYPE_BACKEND_STORE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_STORE_IS_QUIESCENT_PROPERTY, contacts_store_properties[CONTACTS_STORE_IS_QUIESCENT_PROPERTY] = g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_STORE_IS_PREPARED_PROPERTY, contacts_store_properties[CONTACTS_STORE_IS_PREPARED_PROPERTY] = g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	contacts_store_signals[CONTACTS_STORE_ADDED_SIGNAL] = g_signal_new ("added", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, FOLKS_TYPE_INDIVIDUAL);
	contacts_store_signals[CONTACTS_STORE_REMOVED_SIGNAL] = g_signal_new ("removed", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, FOLKS_TYPE_INDIVIDUAL);
	contacts_store_signals[CONTACTS_STORE_QUIESCENT_SIGNAL] = g_signal_new ("quiescent", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	contacts_store_signals[CONTACTS_STORE_PREPARED_SIGNAL] = g_signal_new ("prepared", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
contacts_store_instance_init (ContactsStore * self,
                              gpointer klass)
{
	self->priv = contacts_store_get_instance_private (self);
}

static void
contacts_store_finalize (GObject * obj)
{
	ContactsStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_STORE, ContactsStore);
	_g_object_unref0 (self->priv->_aggregator);
	_g_object_unref0 (self->dont_suggest_link);
	G_OBJECT_CLASS (contacts_store_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_store_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsStore), 0, (GInstanceInitFunc) contacts_store_instance_init, NULL };
	GType contacts_store_type_id;
	contacts_store_type_id = g_type_register_static (G_TYPE_OBJECT, "ContactsStore", &g_define_type_info, 0);
	ContactsStore_private_offset = g_type_add_instance_private (contacts_store_type_id, sizeof (ContactsStorePrivate));
	return contacts_store_type_id;
}

GType
contacts_store_get_type (void)
{
	static volatile gsize contacts_store_type_id__once = 0;
	if (g_once_init_enter (&contacts_store_type_id__once)) {
		GType contacts_store_type_id;
		contacts_store_type_id = contacts_store_get_type_once ();
		g_once_init_leave (&contacts_store_type_id__once, contacts_store_type_id);
	}
	return contacts_store_type_id__once;
}

static void
_vala_contacts_store_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	ContactsStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_STORE, ContactsStore);
	switch (property_id) {
		case CONTACTS_STORE_AGGREGATOR_PROPERTY:
		g_value_set_object (value, contacts_store_get_aggregator (self));
		break;
		case CONTACTS_STORE_BACKEND_STORE_PROPERTY:
		g_value_set_object (value, contacts_store_get_backend_store (self));
		break;
		case CONTACTS_STORE_IS_QUIESCENT_PROPERTY:
		g_value_set_boolean (value, contacts_store_get_is_quiescent (self));
		break;
		case CONTACTS_STORE_IS_PREPARED_PROPERTY:
		g_value_set_boolean (value, contacts_store_get_is_prepared (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_store_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	ContactsStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_STORE, ContactsStore);
	switch (property_id) {
		case CONTACTS_STORE_AGGREGATOR_PROPERTY:
		contacts_store_set_aggregator (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

