/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.util;

import com.sun.org.apache.xerces.internal.impl.xs.util.SimpleLocator;
import com.sun.org.apache.xerces.internal.jaxp.validation.WrappedSAXException;
import com.sun.org.apache.xerces.internal.util.LocatorWrapper;
import com.sun.org.apache.xerces.internal.util.NamespaceSupport;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.util.XMLAttributesImpl;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xni.XMLDocumentHandler;
import com.sun.org.apache.xerces.internal.xni.XMLLocator;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import com.sun.org.apache.xerces.internal.xni.parser.XMLDocumentSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAX2XNI
implements ContentHandler,
XMLDocumentSource {
    private XMLDocumentHandler fCore;
    private final NamespaceSupport nsContext = new NamespaceSupport();
    private final SymbolTable symbolTable = new SymbolTable();
    private Locator locator;
    private final XMLAttributes xa = new XMLAttributesImpl();

    public SAX2XNI(XMLDocumentHandler core) {
        this.fCore = core;
    }

    @Override
    public void setDocumentHandler(XMLDocumentHandler handler) {
        this.fCore = handler;
    }

    @Override
    public XMLDocumentHandler getDocumentHandler() {
        return this.fCore;
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.nsContext.reset();
            XMLLocator xmlLocator = this.locator == null ? new SimpleLocator(null, null, -1, -1) : new LocatorWrapper(this.locator);
            this.fCore.startDocument(xmlLocator, null, this.nsContext, null);
        }
        catch (WrappedSAXException e) {
            throw e.exception;
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.fCore.endDocument(null);
        }
        catch (WrappedSAXException e) {
            throw e.exception;
        }
    }

    @Override
    public void startElement(String uri, String local, String qname, Attributes att) throws SAXException {
        try {
            this.fCore.startElement(this.createQName(uri, local, qname), this.createAttributes(att), null);
        }
        catch (WrappedSAXException e) {
            throw e.exception;
        }
    }

    @Override
    public void endElement(String uri, String local, String qname) throws SAXException {
        try {
            this.fCore.endElement(this.createQName(uri, local, qname), null);
        }
        catch (WrappedSAXException e) {
            throw e.exception;
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        try {
            this.fCore.characters(new XMLString(buf, offset, len), null);
        }
        catch (WrappedSAXException e) {
            throw e.exception;
        }
    }

    @Override
    public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
        try {
            this.fCore.ignorableWhitespace(new XMLString(buf, offset, len), null);
        }
        catch (WrappedSAXException e) {
            throw e.exception;
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.nsContext.pushContext();
        this.nsContext.declarePrefix(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) {
        this.nsContext.popContext();
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.fCore.processingInstruction(this.symbolize(target), this.createXMLString(data), null);
        }
        catch (WrappedSAXException e) {
            throw e.exception;
        }
    }

    @Override
    public void skippedEntity(String name) {
    }

    @Override
    public void setDocumentLocator(Locator _loc) {
        this.locator = _loc;
    }

    private QName createQName(String uri, String local, String raw) {
        int idx = raw.indexOf(58);
        if (local.length() == 0) {
            uri = "";
            local = idx < 0 ? raw : raw.substring(idx + 1);
        }
        String prefix = idx < 0 ? null : raw.substring(0, idx);
        if (uri != null && uri.length() == 0) {
            uri = null;
        }
        return new QName(this.symbolize(prefix), this.symbolize(local), this.symbolize(raw), this.symbolize(uri));
    }

    private String symbolize(String s) {
        if (s == null) {
            return null;
        }
        return this.symbolTable.addSymbol(s);
    }

    private XMLString createXMLString(String str) {
        return new XMLString(str.toCharArray(), 0, str.length());
    }

    private XMLAttributes createAttributes(Attributes att) {
        this.xa.removeAllAttributes();
        int len = att.getLength();
        for (int i = 0; i < len; ++i) {
            this.xa.addAttribute(this.createQName(att.getURI(i), att.getLocalName(i), att.getQName(i)), att.getType(i), att.getValue(i));
        }
        return this.xa;
    }
}

