/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import javax.swing.FocusManager;
import javax.swing.LayoutComparator;
import javax.swing.LegacyGlueFocusTraversalPolicy;
import javax.swing.LegacyLayoutFocusTraversalPolicy;

public class DefaultFocusManager
extends FocusManager {
    final FocusTraversalPolicy gluePolicy = new LegacyGlueFocusTraversalPolicy(this);
    private final FocusTraversalPolicy layoutPolicy = new LegacyLayoutFocusTraversalPolicy(this);
    private final LayoutComparator comparator = new LayoutComparator();

    public DefaultFocusManager() {
        this.setDefaultFocusTraversalPolicy(this.gluePolicy);
    }

    public Component getComponentAfter(Container aContainer, Component aComponent) {
        Container root;
        Container container = root = aContainer.isFocusCycleRoot() ? aContainer : aContainer.getFocusCycleRootAncestor();
        if (root != null) {
            FocusTraversalPolicy policy = root.getFocusTraversalPolicy();
            if (policy != this.gluePolicy) {
                return policy.getComponentAfter(root, aComponent);
            }
            this.comparator.setComponentOrientation(root.getComponentOrientation());
            return this.layoutPolicy.getComponentAfter(root, aComponent);
        }
        return null;
    }

    public Component getComponentBefore(Container aContainer, Component aComponent) {
        Container root;
        Container container = root = aContainer.isFocusCycleRoot() ? aContainer : aContainer.getFocusCycleRootAncestor();
        if (root != null) {
            FocusTraversalPolicy policy = root.getFocusTraversalPolicy();
            if (policy != this.gluePolicy) {
                return policy.getComponentBefore(root, aComponent);
            }
            this.comparator.setComponentOrientation(root.getComponentOrientation());
            return this.layoutPolicy.getComponentBefore(root, aComponent);
        }
        return null;
    }

    public Component getFirstComponent(Container aContainer) {
        Container root;
        Container container = root = aContainer.isFocusCycleRoot() ? aContainer : aContainer.getFocusCycleRootAncestor();
        if (root != null) {
            FocusTraversalPolicy policy = root.getFocusTraversalPolicy();
            if (policy != this.gluePolicy) {
                return policy.getFirstComponent(root);
            }
            this.comparator.setComponentOrientation(root.getComponentOrientation());
            return this.layoutPolicy.getFirstComponent(root);
        }
        return null;
    }

    public Component getLastComponent(Container aContainer) {
        Container root;
        Container container = root = aContainer.isFocusCycleRoot() ? aContainer : aContainer.getFocusCycleRootAncestor();
        if (root != null) {
            FocusTraversalPolicy policy = root.getFocusTraversalPolicy();
            if (policy != this.gluePolicy) {
                return policy.getLastComponent(root);
            }
            this.comparator.setComponentOrientation(root.getComponentOrientation());
            return this.layoutPolicy.getLastComponent(root);
        }
        return null;
    }

    public boolean compareTabOrder(Component a, Component b) {
        return this.comparator.compare(a, b) < 0;
    }
}

