/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.im.spi.InputMethodContext;
import java.awt.peer.ComponentPeer;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11InputMethod;
import sun.util.logging.PlatformLogger;

public class XInputMethod
extends X11InputMethod {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XInputMethod");
    private static volatile long xicFocus = 0L;

    @Override
    public void setInputMethodContext(InputMethodContext context) {
        context.enableClientWindowNotification(this, true);
    }

    @Override
    public void notifyClientWindowChange(Rectangle location) {
        XComponentPeer peer = (XComponentPeer)this.getPeer(this.clientComponentWindow);
        if (peer != null) {
            this.adjustStatusWindow(peer.getContentWindow());
        }
    }

    @Override
    protected boolean openXIM() {
        return this.openXIMNative(XToolkit.getDisplay());
    }

    @Override
    protected boolean createXIC() {
        XComponentPeer peer = (XComponentPeer)this.getPeer(this.clientComponentWindow);
        if (peer == null) {
            return false;
        }
        return this.createXICNative(peer.getContentWindow());
    }

    @Override
    protected void setXICFocus(ComponentPeer peer, boolean value, boolean active) {
        if (peer == null) {
            return;
        }
        xicFocus = ((XComponentPeer)peer).getContentWindow();
        this.setXICFocusNative(((XComponentPeer)peer).getContentWindow(), value, active);
    }

    public static long getXICFocus() {
        return xicFocus;
    }

    @Override
    protected Container getParent(Component client) {
        return client.getParent();
    }

    @Override
    protected ComponentPeer getPeer(Component client) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Client is " + client);
        }
        XComponentPeer peer = (XComponentPeer)XToolkit.targetToPeer(client);
        while (client != null && peer == null) {
            client = this.getParent(client);
            peer = (XComponentPeer)XToolkit.targetToPeer(client);
        }
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Peer is {0}, client is {1}", peer, client);
        }
        if (peer != null) {
            return peer;
        }
        return null;
    }

    @Override
    protected synchronized void disposeImpl() {
        super.disposeImpl();
        this.clientComponentWindow = null;
    }

    @Override
    protected void awtLock() {
        XToolkit.awtLock();
    }

    @Override
    protected void awtUnlock() {
        XToolkit.awtUnlock();
    }

    long getCurrentParentWindow() {
        return ((XWindow)((Object)this.clientComponentWindow.getPeer())).getContentWindow();
    }

    private native boolean openXIMNative(long var1);

    private native boolean createXICNative(long var1);

    private native void setXICFocusNative(long var1, boolean var3, boolean var4);

    private native void adjustStatusWindow(long var1);
}

