/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import sun.awt.geom.PathConsumer2D;
import sun.java2d.pisces.Helpers;

final class Dasher
implements PathConsumer2D {
    private final PathConsumer2D out;
    private final float[] dash;
    private final float startPhase;
    private final boolean startDashOn;
    private final int startIdx;
    private boolean starting;
    private boolean needsMoveTo;
    private int idx;
    private boolean dashOn;
    private float phase;
    private float sx;
    private float sy;
    private float x0;
    private float y0;
    private float[] curCurvepts;
    private float[] firstSegmentsBuffer = new float[7];
    private int firstSegidx = 0;
    private LengthIterator li = null;

    public Dasher(PathConsumer2D out, float[] dash, float phase) {
        if (phase < 0.0f) {
            throw new IllegalArgumentException("phase < 0 !");
        }
        this.out = out;
        int idx = 0;
        this.dashOn = true;
        while (true) {
            float f;
            float d = dash[idx];
            if (!(phase >= f)) break;
            phase -= d;
            idx = (idx + 1) % dash.length;
            this.dashOn = !this.dashOn;
        }
        this.dash = dash;
        this.startPhase = this.phase = phase;
        this.startDashOn = this.dashOn;
        this.startIdx = idx;
        this.starting = true;
        this.curCurvepts = new float[16];
    }

    @Override
    public void moveTo(float x0, float y0) {
        if (this.firstSegidx > 0) {
            this.out.moveTo(this.sx, this.sy);
            this.emitFirstSegments();
        }
        this.needsMoveTo = true;
        this.idx = this.startIdx;
        this.dashOn = this.startDashOn;
        this.phase = this.startPhase;
        this.sx = this.x0 = x0;
        this.sy = this.y0 = y0;
        this.starting = true;
    }

    private void emitSeg(float[] buf, int off, int type) {
        switch (type) {
            case 8: {
                this.out.curveTo(buf[off + 0], buf[off + 1], buf[off + 2], buf[off + 3], buf[off + 4], buf[off + 5]);
                break;
            }
            case 6: {
                this.out.quadTo(buf[off + 0], buf[off + 1], buf[off + 2], buf[off + 3]);
                break;
            }
            case 4: {
                this.out.lineTo(buf[off], buf[off + 1]);
            }
        }
    }

    private void emitFirstSegments() {
        for (int i = 0; i < this.firstSegidx; i += (int)this.firstSegmentsBuffer[i] - 1) {
            this.emitSeg(this.firstSegmentsBuffer, i + 1, (int)this.firstSegmentsBuffer[i]);
        }
        this.firstSegidx = 0;
    }

    private void goTo(float[] pts, int off, int type) {
        float x = pts[off + type - 4];
        float y = pts[off + type - 3];
        if (this.dashOn) {
            if (this.starting) {
                this.firstSegmentsBuffer = Helpers.widenArray(this.firstSegmentsBuffer, this.firstSegidx, type - 2 + 1);
                this.firstSegmentsBuffer[this.firstSegidx++] = type;
                System.arraycopy(pts, off, this.firstSegmentsBuffer, this.firstSegidx, type - 2);
                this.firstSegidx += type - 2;
            } else {
                if (this.needsMoveTo) {
                    this.out.moveTo(this.x0, this.y0);
                    this.needsMoveTo = false;
                }
                this.emitSeg(pts, off, type);
            }
        } else {
            this.starting = false;
            this.needsMoveTo = true;
        }
        this.x0 = x;
        this.y0 = y;
    }

    @Override
    public void lineTo(float x1, float y1) {
        float dx = x1 - this.x0;
        float dy = y1 - this.y0;
        float len = (float)Math.sqrt(dx * dx + dy * dy);
        if (len == 0.0f) {
            return;
        }
        float cx = dx / len;
        float cy = dy / len;
        while (true) {
            float leftInThisDashSegment;
            if (len <= (leftInThisDashSegment = this.dash[this.idx] - this.phase)) {
                this.curCurvepts[0] = x1;
                this.curCurvepts[1] = y1;
                this.goTo(this.curCurvepts, 0, 4);
                this.phase += len;
                if (len == leftInThisDashSegment) {
                    this.phase = 0.0f;
                    this.idx = (this.idx + 1) % this.dash.length;
                    this.dashOn = !this.dashOn;
                }
                return;
            }
            float dashdx = this.dash[this.idx] * cx;
            float dashdy = this.dash[this.idx] * cy;
            if (this.phase == 0.0f) {
                this.curCurvepts[0] = this.x0 + dashdx;
                this.curCurvepts[1] = this.y0 + dashdy;
            } else {
                float p = leftInThisDashSegment / this.dash[this.idx];
                this.curCurvepts[0] = this.x0 + p * dashdx;
                this.curCurvepts[1] = this.y0 + p * dashdy;
            }
            this.goTo(this.curCurvepts, 0, 4);
            len -= leftInThisDashSegment;
            this.idx = (this.idx + 1) % this.dash.length;
            this.dashOn = !this.dashOn;
            this.phase = 0.0f;
        }
    }

    private void somethingTo(int type) {
        if (Dasher.pointCurve(this.curCurvepts, type)) {
            return;
        }
        if (this.li == null) {
            this.li = new LengthIterator(4, 0.01f);
        }
        this.li.initializeIterationOnCurve(this.curCurvepts, type);
        int curCurveoff = 0;
        float lastSplitT = 0.0f;
        float t = 0.0f;
        float leftInThisDashSegment = this.dash[this.idx] - this.phase;
        while (true) {
            float f;
            t = this.li.next(leftInThisDashSegment);
            if (!(f < 1.0f)) break;
            if (t != 0.0f) {
                Helpers.subdivideAt((t - lastSplitT) / (1.0f - lastSplitT), this.curCurvepts, curCurveoff, this.curCurvepts, 0, this.curCurvepts, type, type);
                lastSplitT = t;
                this.goTo(this.curCurvepts, 2, type);
                curCurveoff = type;
            }
            this.idx = (this.idx + 1) % this.dash.length;
            this.dashOn = !this.dashOn;
            this.phase = 0.0f;
            leftInThisDashSegment = this.dash[this.idx];
        }
        this.goTo(this.curCurvepts, curCurveoff + 2, type);
        this.phase += this.li.lastSegLen();
        if (this.phase >= this.dash[this.idx]) {
            this.phase = 0.0f;
            this.idx = (this.idx + 1) % this.dash.length;
            this.dashOn = !this.dashOn;
        }
    }

    private static boolean pointCurve(float[] curve, int type) {
        for (int i = 2; i < type; ++i) {
            if (curve[i] == curve[i - 2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.curCurvepts[0] = this.x0;
        this.curCurvepts[1] = this.y0;
        this.curCurvepts[2] = x1;
        this.curCurvepts[3] = y1;
        this.curCurvepts[4] = x2;
        this.curCurvepts[5] = y2;
        this.curCurvepts[6] = x3;
        this.curCurvepts[7] = y3;
        this.somethingTo(8);
    }

    @Override
    public void quadTo(float x1, float y1, float x2, float y2) {
        this.curCurvepts[0] = this.x0;
        this.curCurvepts[1] = this.y0;
        this.curCurvepts[2] = x1;
        this.curCurvepts[3] = y1;
        this.curCurvepts[4] = x2;
        this.curCurvepts[5] = y2;
        this.somethingTo(6);
    }

    @Override
    public void closePath() {
        this.lineTo(this.sx, this.sy);
        if (this.firstSegidx > 0) {
            if (!this.dashOn || this.needsMoveTo) {
                this.out.moveTo(this.sx, this.sy);
            }
            this.emitFirstSegments();
        }
        this.moveTo(this.sx, this.sy);
    }

    @Override
    public void pathDone() {
        if (this.firstSegidx > 0) {
            this.out.moveTo(this.sx, this.sy);
            this.emitFirstSegments();
        }
        this.out.pathDone();
    }

    @Override
    public long getNativeConsumer() {
        throw new InternalError("Dasher does not use a native consumer");
    }

    private static class LengthIterator {
        private float[][] recCurveStack;
        private Side[] sides;
        private int curveType;
        private final int limit;
        private final float ERR;
        private final float minTincrement;
        private float nextT;
        private float lenAtNextT;
        private float lastT;
        private float lenAtLastT;
        private float lenAtLastSplit;
        private float lastSegLen;
        private int recLevel;
        private boolean done;
        private float[] curLeafCtrlPolyLengths = new float[3];
        private int cachedHaveLowAcceleration = -1;
        private float[] nextRoots = new float[4];
        private float[] flatLeafCoefCache = new float[]{0.0f, 0.0f, -1.0f, 0.0f};

        public LengthIterator(int reclimit, float err) {
            this.limit = reclimit;
            this.minTincrement = 1.0f / (float)(1 << this.limit);
            this.ERR = err;
            this.recCurveStack = new float[reclimit + 1][8];
            this.sides = new Side[reclimit];
            this.nextT = Float.MAX_VALUE;
            this.lenAtNextT = Float.MAX_VALUE;
            this.lenAtLastSplit = Float.MIN_VALUE;
            this.recLevel = Integer.MIN_VALUE;
            this.lastSegLen = Float.MAX_VALUE;
            this.done = true;
        }

        public void initializeIterationOnCurve(float[] pts, int type) {
            System.arraycopy(pts, 0, this.recCurveStack[0], 0, type);
            this.curveType = type;
            this.recLevel = 0;
            this.lastT = 0.0f;
            this.lenAtLastT = 0.0f;
            this.nextT = 0.0f;
            this.lenAtNextT = 0.0f;
            this.goLeft();
            this.lenAtLastSplit = 0.0f;
            if (this.recLevel > 0) {
                this.sides[0] = Side.LEFT;
                this.done = false;
            } else {
                this.sides[0] = Side.RIGHT;
                this.done = true;
            }
            this.lastSegLen = 0.0f;
        }

        private boolean haveLowAcceleration(float err) {
            if (this.cachedHaveLowAcceleration == -1) {
                float len3;
                float len1 = this.curLeafCtrlPolyLengths[0];
                float len2 = this.curLeafCtrlPolyLengths[1];
                if (!Helpers.within(len1, len2, err * len2)) {
                    this.cachedHaveLowAcceleration = 0;
                    return false;
                }
                if (!(this.curveType != 8 || Helpers.within(len2, len3 = this.curLeafCtrlPolyLengths[2], err * len3) && Helpers.within(len1, len3, err * len3))) {
                    this.cachedHaveLowAcceleration = 0;
                    return false;
                }
                this.cachedHaveLowAcceleration = 1;
                return true;
            }
            return this.cachedHaveLowAcceleration == 1;
        }

        public float next(float len) {
            float targetLength = this.lenAtLastSplit + len;
            while (this.lenAtNextT < targetLength) {
                if (this.done) {
                    this.lastSegLen = this.lenAtNextT - this.lenAtLastSplit;
                    return 1.0f;
                }
                this.goToNextLeaf();
            }
            this.lenAtLastSplit = targetLength;
            float leaflen = this.lenAtNextT - this.lenAtLastT;
            float t = (targetLength - this.lenAtLastT) / leaflen;
            if (!this.haveLowAcceleration(0.05f)) {
                float d;
                float c;
                float b;
                float a;
                int n;
                if (this.flatLeafCoefCache[2] < 0.0f) {
                    float x = 0.0f + this.curLeafCtrlPolyLengths[0];
                    float y = x + this.curLeafCtrlPolyLengths[1];
                    if (this.curveType == 8) {
                        float z = y + this.curLeafCtrlPolyLengths[2];
                        this.flatLeafCoefCache[0] = 3.0f * (x - y) + z;
                        this.flatLeafCoefCache[1] = 3.0f * (y - 2.0f * x);
                        this.flatLeafCoefCache[2] = 3.0f * x;
                        this.flatLeafCoefCache[3] = -z;
                    } else if (this.curveType == 6) {
                        this.flatLeafCoefCache[0] = 0.0f;
                        this.flatLeafCoefCache[1] = y - 2.0f * x;
                        this.flatLeafCoefCache[2] = 2.0f * x;
                        this.flatLeafCoefCache[3] = -y;
                    }
                }
                if ((n = Helpers.cubicRootsInAB(a = this.flatLeafCoefCache[0], b = this.flatLeafCoefCache[1], c = this.flatLeafCoefCache[2], d = t * this.flatLeafCoefCache[3], this.nextRoots, 0, 0.0f, 1.0f)) == 1 && !Float.isNaN(this.nextRoots[0])) {
                    t = this.nextRoots[0];
                }
            }
            if ((t = t * (this.nextT - this.lastT) + this.lastT) >= 1.0f) {
                t = 1.0f;
                this.done = true;
            }
            this.lastSegLen = len;
            return t;
        }

        public float lastSegLen() {
            return this.lastSegLen;
        }

        private void goToNextLeaf() {
            --this.recLevel;
            while (this.sides[this.recLevel] == Side.RIGHT) {
                if (this.recLevel == 0) {
                    this.done = true;
                    return;
                }
                --this.recLevel;
            }
            this.sides[this.recLevel] = Side.RIGHT;
            System.arraycopy(this.recCurveStack[this.recLevel], 0, this.recCurveStack[this.recLevel + 1], 0, this.curveType);
            ++this.recLevel;
            this.goLeft();
        }

        private void goLeft() {
            float len = this.onLeaf();
            if (len >= 0.0f) {
                this.lastT = this.nextT;
                this.lenAtLastT = this.lenAtNextT;
                this.nextT += (float)(1 << this.limit - this.recLevel) * this.minTincrement;
                this.lenAtNextT += len;
                this.flatLeafCoefCache[2] = -1.0f;
                this.cachedHaveLowAcceleration = -1;
            } else {
                Helpers.subdivide(this.recCurveStack[this.recLevel], 0, this.recCurveStack[this.recLevel + 1], 0, this.recCurveStack[this.recLevel], 0, this.curveType);
                this.sides[this.recLevel] = Side.LEFT;
                ++this.recLevel;
                this.goLeft();
            }
        }

        private float onLeaf() {
            float[] curve = this.recCurveStack[this.recLevel];
            float polyLen = 0.0f;
            float x0 = curve[0];
            float y0 = curve[1];
            for (int i = 2; i < this.curveType; i += 2) {
                float x1 = curve[i];
                float y1 = curve[i + 1];
                float len = Helpers.linelen(x0, y0, x1, y1);
                polyLen += len;
                this.curLeafCtrlPolyLengths[i / 2 - 1] = len;
                x0 = x1;
                y0 = y1;
            }
            float lineLen = Helpers.linelen(curve[0], curve[1], curve[this.curveType - 2], curve[this.curveType - 1]);
            if (polyLen - lineLen < this.ERR || this.recLevel == this.limit) {
                return (polyLen + lineLen) / 2.0f;
            }
            return -1.0f;
        }

        private static enum Side {
            LEFT,
            RIGHT;

        }
    }
}

