/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.VMOption;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import sun.management.Flag;
import sun.management.Util;

public class HotSpotDiagnostic
implements HotSpotDiagnosticMXBean {
    @Override
    public void dumpHeap(String outputFile, boolean live) throws IOException {
        String propertyName = "jdk.management.heapdump.allowAnyFileSuffix";
        PrivilegedAction<Boolean> pa = new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.parseBoolean(System.getProperty("jdk.management.heapdump.allowAnyFileSuffix", "false"));
            }
        };
        boolean allowAnyFileSuffix = AccessController.doPrivileged(pa);
        if (!allowAnyFileSuffix && !outputFile.endsWith(".hprof")) {
            throw new IllegalArgumentException("heapdump file must have .hprof extention");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(outputFile);
            Util.checkControlAccess();
        }
        this.dumpHeap0(outputFile, live);
    }

    private native void dumpHeap0(String var1, boolean var2) throws IOException;

    @Override
    public List<VMOption> getDiagnosticOptions() {
        List<Flag> allFlags = Flag.getAllFlags();
        ArrayList<VMOption> result = new ArrayList<VMOption>();
        for (Flag flag : allFlags) {
            if (!flag.isWriteable() || !flag.isExternal()) continue;
            result.add(flag.getVMOption());
        }
        return result;
    }

    @Override
    public VMOption getVMOption(String name) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        Flag f = Flag.getFlag(name);
        if (f == null) {
            throw new IllegalArgumentException("VM option \"" + name + "\" does not exist");
        }
        return f.getVMOption();
    }

    @Override
    public void setVMOption(String name, String value) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (value == null) {
            throw new NullPointerException("value cannot be null");
        }
        Util.checkControlAccess();
        Flag flag = Flag.getFlag(name);
        if (flag == null) {
            throw new IllegalArgumentException("VM option \"" + name + "\" does not exist");
        }
        if (!flag.isWriteable()) {
            throw new IllegalArgumentException("VM Option \"" + name + "\" is not writeable");
        }
        Object v = flag.getValue();
        if (v instanceof Long) {
            try {
                long l = Long.parseLong(value);
                Flag.setLongValue(name, l);
            }
            catch (NumberFormatException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Invalid value: VM Option \"" + name + "\"" + " expects numeric value");
                iae.initCause(e);
                throw iae;
            }
        } else if (v instanceof Boolean) {
            if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                throw new IllegalArgumentException("Invalid value: VM Option \"" + name + "\"" + " expects \"true\" or \"false\".");
            }
            Flag.setBooleanValue(name, Boolean.parseBoolean(value));
        } else if (v instanceof String) {
            Flag.setStringValue(name, value);
        } else {
            throw new IllegalArgumentException("VM Option \"" + name + "\" is of an unsupported type: " + v.getClass().getName());
        }
    }

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName("com.sun.management:type=HotSpotDiagnostic");
    }
}

