/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import sun.misc.CEFormatException;
import sun.misc.CEStreamExhausted;
import sun.misc.CharacterDecoder;

public class UUDecoder
extends CharacterDecoder {
    public String bufferName;
    public int mode;
    private byte[] decoderBuffer = new byte[4];

    @Override
    protected int bytesPerAtom() {
        return 3;
    }

    @Override
    protected int bytesPerLine() {
        return 45;
    }

    @Override
    protected void decodeAtom(PushbackInputStream inStream, OutputStream outStream, int l) throws IOException {
        StringBuffer x = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            int c1 = inStream.read();
            if (c1 == -1) {
                throw new CEStreamExhausted();
            }
            x.append((char)c1);
            this.decoderBuffer[i] = (byte)(c1 - 32 & 0x3F);
        }
        int a = this.decoderBuffer[0] << 2 & 0xFC | this.decoderBuffer[1] >>> 4 & 3;
        int b = this.decoderBuffer[1] << 4 & 0xF0 | this.decoderBuffer[2] >>> 2 & 0xF;
        int c = this.decoderBuffer[2] << 6 & 0xC0 | this.decoderBuffer[3] & 0x3F;
        outStream.write((byte)(a & 0xFF));
        if (l > 1) {
            outStream.write((byte)(b & 0xFF));
        }
        if (l > 2) {
            outStream.write((byte)(c & 0xFF));
        }
    }

    @Override
    protected void decodeBufferPrefix(PushbackInputStream inStream, OutputStream outStream) throws IOException {
        int c;
        StringBuffer q = new StringBuffer(32);
        boolean sawNewLine = true;
        while (true) {
            if ((c = inStream.read()) == -1) {
                throw new CEFormatException("UUDecoder: No begin line.");
            }
            if (c == 98 && sawNewLine && (c = inStream.read()) == 101) break;
            sawNewLine = c == 10 || c == 13;
        }
        while (c != 10 && c != 13) {
            c = inStream.read();
            if (c == -1) {
                throw new CEFormatException("UUDecoder: No begin line.");
            }
            if (c == 10 || c == 13) continue;
            q.append((char)c);
        }
        String r = q.toString();
        if (r.indexOf(32) != 3) {
            throw new CEFormatException("UUDecoder: Malformed begin line.");
        }
        this.mode = Integer.parseInt(r.substring(4, 7));
        this.bufferName = r.substring(r.indexOf(32, 6) + 1);
        if (c == 13 && (c = inStream.read()) != 10 && c != -1) {
            inStream.unread(c);
        }
    }

    @Override
    protected int decodeLinePrefix(PushbackInputStream inStream, OutputStream outStream) throws IOException {
        int c = inStream.read();
        if (c == 32) {
            c = inStream.read();
            c = inStream.read();
            if (c != 10 && c != -1) {
                inStream.unread(c);
            }
            throw new CEStreamExhausted();
        }
        if (c == -1) {
            throw new CEFormatException("UUDecoder: Short Buffer.");
        }
        if ((c = c - 32 & 0x3F) > this.bytesPerLine()) {
            throw new CEFormatException("UUDecoder: Bad Line Length.");
        }
        return c;
    }

    @Override
    protected void decodeLineSuffix(PushbackInputStream inStream, OutputStream outStream) throws IOException {
        block3: {
            int c;
            do {
                if ((c = inStream.read()) == -1) {
                    throw new CEStreamExhausted();
                }
                if (c == 10) break block3;
            } while (c != 13);
            c = inStream.read();
            if (c != 10 && c != -1) {
                inStream.unread(c);
            }
        }
    }

    @Override
    protected void decodeBufferSuffix(PushbackInputStream inStream, OutputStream outStream) throws IOException {
        int c = inStream.read(this.decoderBuffer);
        if (this.decoderBuffer[0] != 101 || this.decoderBuffer[1] != 110 || this.decoderBuffer[2] != 100) {
            throw new CEFormatException("UUDecoder: Missing 'end' line.");
        }
    }
}

