/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import sun.nio.ch.SctpAssocChange;
import sun.nio.ch.SctpMessageInfoImpl;
import sun.nio.ch.SctpNotification;
import sun.nio.ch.SctpPeerAddrChange;
import sun.nio.ch.SctpSendFailed;
import sun.nio.ch.SctpShutdown;

public class SctpResultContainer {
    static final int NOTHING = 0;
    static final int MESSAGE = 1;
    static final int SEND_FAILED = 2;
    static final int ASSOCIATION_CHANGED = 3;
    static final int PEER_ADDRESS_CHANGED = 4;
    static final int SHUTDOWN = 5;
    private Object value;
    private int type;

    int type() {
        return this.type;
    }

    boolean hasSomething() {
        return this.type() != 0;
    }

    boolean isNotification() {
        return this.type() != 1 && this.type() != 0;
    }

    void clear() {
        this.type = 0;
        this.value = null;
    }

    SctpNotification notification() {
        assert (this.type() != 1 && this.type() != 0);
        return (SctpNotification)this.value;
    }

    SctpMessageInfoImpl getMessageInfo() {
        assert (this.type() == 1);
        if (this.value instanceof SctpMessageInfoImpl) {
            return (SctpMessageInfoImpl)this.value;
        }
        return null;
    }

    SctpSendFailed getSendFailed() {
        assert (this.type() == 2);
        if (this.value instanceof SctpSendFailed) {
            return (SctpSendFailed)this.value;
        }
        return null;
    }

    SctpAssocChange getAssociationChanged() {
        assert (this.type() == 3);
        if (this.value instanceof SctpAssocChange) {
            return (SctpAssocChange)this.value;
        }
        return null;
    }

    SctpPeerAddrChange getPeerAddressChanged() {
        assert (this.type() == 4);
        if (this.value instanceof SctpPeerAddrChange) {
            return (SctpPeerAddrChange)this.value;
        }
        return null;
    }

    SctpShutdown getShutdown() {
        assert (this.type() == 5);
        if (this.value instanceof SctpShutdown) {
            return (SctpShutdown)this.value;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Type: ");
        switch (this.type) {
            case 0: {
                sb.append("NOTHING");
                break;
            }
            case 1: {
                sb.append("MESSAGE");
                break;
            }
            case 2: {
                sb.append("SEND FAILED");
                break;
            }
            case 3: {
                sb.append("ASSOCIATION CHANGE");
                break;
            }
            case 4: {
                sb.append("PEER ADDRESS CHANGE");
                break;
            }
            case 5: {
                sb.append("SHUTDOWN");
                break;
            }
            default: {
                sb.append("Unknown result type");
            }
        }
        sb.append(", Value: ");
        sb.append(this.value == null ? "null" : this.value.toString());
        return sb.toString();
    }
}

