/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.log;

import java.io.IOException;
import java.io.InputStream;

public class LogInputStream
extends InputStream {
    private InputStream in;
    private int length;

    public LogInputStream(InputStream in, int length) throws IOException {
        this.in = in;
        this.length = length;
    }

    @Override
    public int read() throws IOException {
        if (this.length == 0) {
            return -1;
        }
        int c = this.in.read();
        this.length = c != -1 ? this.length - 1 : 0;
        return c;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.length == 0) {
            return -1;
        }
        len = this.length < len ? this.length : len;
        int n = this.in.read(b, off, len);
        this.length = n != -1 ? this.length - n : 0;
        return n;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n > Integer.MAX_VALUE) {
            throw new IOException("Too many bytes to skip - " + n);
        }
        if (this.length == 0) {
            return 0L;
        }
        n = (long)this.length < n ? (long)this.length : n;
        n = this.in.skip(n);
        this.length = (int)((long)this.length - n);
        return n;
    }

    @Override
    public int available() throws IOException {
        int avail = this.in.available();
        return this.length < avail ? this.length : avail;
    }

    @Override
    public void close() {
        this.length = 0;
    }

    protected void finalize() throws IOException {
        this.close();
    }
}

