/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.KeyTab;
import sun.security.jgss.krb5.Krb5Util;

class SubjectComber {
    private static final boolean DEBUG = Krb5Util.DEBUG;

    private SubjectComber() {
    }

    static <T> T find(Subject subject, String serverPrincipal, String clientPrincipal, Class<T> credClass) {
        return credClass.cast(SubjectComber.findAux(subject, serverPrincipal, clientPrincipal, credClass, true));
    }

    static <T> List<T> findMany(Subject subject, String serverPrincipal, String clientPrincipal, Class<T> credClass) {
        return (List)SubjectComber.findAux(subject, serverPrincipal, clientPrincipal, credClass, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Object findAux(Subject subject, String serverPrincipal, String clientPrincipal, Class<T> credClass, boolean oneOnly) {
        ArrayList<T> answer;
        if (subject == null) {
            return null;
        }
        ArrayList<T> arrayList = answer = oneOnly ? null : new ArrayList<T>();
        if (credClass == KeyTab.class) {
            for (T t : subject.getPrivateCredentials(credClass)) {
                if (DEBUG) {
                    System.out.println("Found " + credClass.getSimpleName());
                }
                if (oneOnly) {
                    return t;
                }
                answer.add(t);
            }
        } else if (credClass == KerberosKey.class) {
            for (KerberosKey t : subject.getPrivateCredentials(KerberosKey.class)) {
                String name = t.getPrincipal().getName();
                if (serverPrincipal != null && !serverPrincipal.equals(name)) continue;
                if (DEBUG) {
                    System.out.println("Found " + credClass.getSimpleName() + " for " + name);
                }
                if (oneOnly) {
                    return t;
                }
                if (serverPrincipal == null) {
                    serverPrincipal = name;
                }
                answer.add(credClass.cast(t));
            }
        } else if (credClass == KerberosTicket.class) {
            Set<Object> pcs;
            Set<Object> set = pcs = subject.getPrivateCredentials();
            synchronized (set) {
                Iterator<Object> iterator = pcs.iterator();
                while (iterator.hasNext()) {
                    Object obj = iterator.next();
                    if (!(obj instanceof KerberosTicket)) continue;
                    KerberosTicket ticket = (KerberosTicket)obj;
                    if (DEBUG) {
                        System.out.println("Found ticket for " + ticket.getClient() + " to go to " + ticket.getServer() + " expiring on " + ticket.getEndTime());
                    }
                    if (!ticket.isCurrent()) {
                        if (subject.isReadOnly()) continue;
                        iterator.remove();
                        try {
                            ticket.destroy();
                            if (!DEBUG) continue;
                            System.out.println("Removed and destroyed the expired Ticket \n" + ticket);
                        }
                        catch (DestroyFailedException dfe) {
                            if (!DEBUG) continue;
                            System.out.println("Expired ticket not detroyed successfully. " + dfe);
                        }
                        continue;
                    }
                    if (serverPrincipal != null && !ticket.getServer().getName().equals(serverPrincipal) || clientPrincipal != null && !clientPrincipal.equals(ticket.getClient().getName())) continue;
                    if (oneOnly) {
                        return ticket;
                    }
                    if (clientPrincipal == null) {
                        clientPrincipal = ticket.getClient().getName();
                    }
                    if (serverPrincipal == null) {
                        serverPrincipal = ticket.getServer().getName();
                    }
                    answer.add(credClass.cast(ticket));
                }
            }
        }
        return answer;
    }
}

