/*
 * Decompiled with CFR 0.152.
 */
package sun.net.sdp;

import java.io.FileDescriptor;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;
import sun.security.action.GetPropertyAction;

public final class SdpSupport {
    private static final String os = AccessController.doPrivileged(new GetPropertyAction("os.name"));
    private static final boolean isSupported = os.equals("SunOS") || os.equals("Linux");
    private static final JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();

    private SdpSupport() {
    }

    public static FileDescriptor createSocket() throws IOException {
        if (!isSupported) {
            throw new UnsupportedOperationException("SDP not supported on this platform");
        }
        int n = SdpSupport.create0();
        FileDescriptor fileDescriptor = new FileDescriptor();
        fdAccess.set(fileDescriptor, n);
        return fileDescriptor;
    }

    public static void convertSocket(FileDescriptor fileDescriptor) throws IOException {
        if (!isSupported) {
            throw new UnsupportedOperationException("SDP not supported on this platform");
        }
        int n = fdAccess.get(fileDescriptor);
        SdpSupport.convert0(n);
    }

    private static native int create0() throws IOException;

    private static native void convert0(int var0) throws IOException;

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("net");
                return null;
            }
        });
    }
}

