/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.rcache;

import java.util.Iterator;
import java.util.LinkedList;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.rcache.AuthTimeWithHash;

public class AuthList {
    private final LinkedList<AuthTimeWithHash> entries;
    private final int lifespan;
    private volatile int oldestTime = Integer.MIN_VALUE;

    public AuthList(int n) {
        this.lifespan = n;
        this.entries = new LinkedList();
    }

    public synchronized void put(AuthTimeWithHash authTimeWithHash, KerberosTime kerberosTime) throws KrbApErrException {
        Object object;
        if (this.entries.isEmpty()) {
            this.entries.addFirst(authTimeWithHash);
            this.oldestTime = authTimeWithHash.ctime;
            return;
        }
        AuthTimeWithHash authTimeWithHash2 = this.entries.getFirst();
        int n = authTimeWithHash2.compareTo(authTimeWithHash);
        if (n < 0) {
            this.entries.addFirst(authTimeWithHash);
        } else {
            if (n == 0) {
                throw new KrbApErrException(34);
            }
            object = this.entries.listIterator(1);
            boolean bl = false;
            while (object.hasNext()) {
                authTimeWithHash2 = object.next();
                n = authTimeWithHash2.compareTo(authTimeWithHash);
                if (n < 0) {
                    this.entries.add(this.entries.indexOf(authTimeWithHash2), authTimeWithHash);
                    bl = true;
                    break;
                }
                if (n != 0) continue;
                throw new KrbApErrException(34);
            }
            if (!bl) {
                this.entries.addLast(authTimeWithHash);
            }
        }
        long l = kerberosTime.getSeconds() - this.lifespan;
        if ((long)this.oldestTime > l - 5L) {
            return;
        }
        while (!this.entries.isEmpty()) {
            object = this.entries.removeLast();
            if ((long)((AuthTimeWithHash)object).ctime < l) continue;
            this.entries.addLast((AuthTimeWithHash)object);
            this.oldestTime = ((AuthTimeWithHash)object).ctime;
            return;
        }
        this.oldestTime = Integer.MIN_VALUE;
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<AuthTimeWithHash> iterator = this.entries.descendingIterator();
        int n = this.entries.size();
        while (iterator.hasNext()) {
            AuthTimeWithHash authTimeWithHash = iterator.next();
            stringBuilder.append('#').append(n--).append(": ").append(authTimeWithHash.toString()).append('\n');
        }
        return stringBuilder.toString();
    }
}

