/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import sun.security.util.Cache;

class MemoryCache<K, V>
extends Cache<K, V> {
    private static final float LOAD_FACTOR = 0.75f;
    private static final boolean DEBUG = false;
    private final Map<K, CacheEntry<K, V>> cacheMap;
    private int maxSize;
    private long lifetime;
    private final ReferenceQueue<V> queue;

    public MemoryCache(boolean bl, int n) {
        this(bl, n, 0);
    }

    public MemoryCache(boolean bl, int n, int n2) {
        this.maxSize = n;
        this.lifetime = n2 * 1000;
        this.queue = bl ? new ReferenceQueue() : null;
        this.cacheMap = new LinkedHashMap<K, CacheEntry<K, V>>(1, 0.75f, true);
    }

    private void emptyQueue() {
        CacheEntry cacheEntry;
        if (this.queue == null) {
            return;
        }
        int n = this.cacheMap.size();
        while ((cacheEntry = (CacheEntry)((Object)this.queue.poll())) != null) {
            CacheEntry<K, V> cacheEntry2;
            Object k = cacheEntry.getKey();
            if (k == null || (cacheEntry2 = this.cacheMap.remove(k)) == null || cacheEntry == cacheEntry2) continue;
            this.cacheMap.put(k, cacheEntry2);
        }
    }

    private void expungeExpiredEntries() {
        this.emptyQueue();
        if (this.lifetime == 0L) {
            return;
        }
        int n = 0;
        long l = System.currentTimeMillis();
        Iterator<CacheEntry<K, V>> iterator = this.cacheMap.values().iterator();
        while (iterator.hasNext()) {
            CacheEntry<K, V> cacheEntry = iterator.next();
            if (cacheEntry.isValid(l)) continue;
            iterator.remove();
            ++n;
        }
    }

    @Override
    public synchronized int size() {
        this.expungeExpiredEntries();
        return this.cacheMap.size();
    }

    @Override
    public synchronized void clear() {
        if (this.queue != null) {
            for (CacheEntry<K, V> cacheEntry : this.cacheMap.values()) {
                cacheEntry.invalidate();
            }
            while (this.queue.poll() != null) {
            }
        }
        this.cacheMap.clear();
    }

    @Override
    public synchronized void put(K k, V v) {
        this.emptyQueue();
        long l = this.lifetime == 0L ? 0L : System.currentTimeMillis() + this.lifetime;
        CacheEntry<K, V> cacheEntry = this.newEntry(k, v, l, this.queue);
        CacheEntry<K, V> cacheEntry2 = this.cacheMap.put(k, cacheEntry);
        if (cacheEntry2 != null) {
            cacheEntry2.invalidate();
            return;
        }
        if (this.maxSize > 0 && this.cacheMap.size() > this.maxSize) {
            this.expungeExpiredEntries();
            if (this.cacheMap.size() > this.maxSize) {
                Iterator<CacheEntry<K, V>> iterator = this.cacheMap.values().iterator();
                CacheEntry<K, V> cacheEntry3 = iterator.next();
                iterator.remove();
                cacheEntry3.invalidate();
            }
        }
    }

    @Override
    public synchronized V get(Object object) {
        long l;
        this.emptyQueue();
        CacheEntry<K, V> cacheEntry = this.cacheMap.get(object);
        if (cacheEntry == null) {
            return null;
        }
        long l2 = l = this.lifetime == 0L ? 0L : System.currentTimeMillis();
        if (!cacheEntry.isValid(l)) {
            this.cacheMap.remove(object);
            return null;
        }
        return cacheEntry.getValue();
    }

    @Override
    public synchronized void remove(Object object) {
        this.emptyQueue();
        CacheEntry<K, V> cacheEntry = this.cacheMap.remove(object);
        if (cacheEntry != null) {
            cacheEntry.invalidate();
        }
    }

    @Override
    public synchronized void setCapacity(int n) {
        this.expungeExpiredEntries();
        if (n > 0 && this.cacheMap.size() > n) {
            Iterator<CacheEntry<K, V>> iterator = this.cacheMap.values().iterator();
            for (int i = this.cacheMap.size() - n; i > 0; --i) {
                CacheEntry<K, V> cacheEntry = iterator.next();
                iterator.remove();
                cacheEntry.invalidate();
            }
        }
        this.maxSize = n > 0 ? n : 0;
    }

    @Override
    public synchronized void setTimeout(int n) {
        this.emptyQueue();
        this.lifetime = n > 0 ? (long)n * 1000L : 0L;
    }

    @Override
    public synchronized void accept(Cache.CacheVisitor<K, V> cacheVisitor) {
        this.expungeExpiredEntries();
        Map<K, V> map = this.getCachedEntries();
        cacheVisitor.visit(map);
    }

    private Map<K, V> getCachedEntries() {
        HashMap<K, V> hashMap = new HashMap<K, V>(this.cacheMap.size());
        for (CacheEntry<K, V> cacheEntry : this.cacheMap.values()) {
            hashMap.put(cacheEntry.getKey(), cacheEntry.getValue());
        }
        return hashMap;
    }

    protected CacheEntry<K, V> newEntry(K k, V v, long l, ReferenceQueue<V> referenceQueue) {
        if (referenceQueue != null) {
            return new SoftCacheEntry<K, V>(k, v, l, referenceQueue);
        }
        return new HardCacheEntry<K, V>(k, v, l);
    }

    private static class SoftCacheEntry<K, V>
    extends SoftReference<V>
    implements CacheEntry<K, V> {
        private K key;
        private long expirationTime;

        SoftCacheEntry(K k, V v, long l, ReferenceQueue<V> referenceQueue) {
            super(v, referenceQueue);
            this.key = k;
            this.expirationTime = l;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return (V)this.get();
        }

        @Override
        public boolean isValid(long l) {
            boolean bl;
            boolean bl2 = bl = l <= this.expirationTime && this.get() != null;
            if (!bl) {
                this.invalidate();
            }
            return bl;
        }

        @Override
        public void invalidate() {
            this.clear();
            this.key = null;
            this.expirationTime = -1L;
        }
    }

    private static class HardCacheEntry<K, V>
    implements CacheEntry<K, V> {
        private K key;
        private V value;
        private long expirationTime;

        HardCacheEntry(K k, V v, long l) {
            this.key = k;
            this.value = v;
            this.expirationTime = l;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public boolean isValid(long l) {
            boolean bl;
            boolean bl2 = bl = l <= this.expirationTime;
            if (!bl) {
                this.invalidate();
            }
            return bl;
        }

        @Override
        public void invalidate() {
            this.key = null;
            this.value = null;
            this.expirationTime = -1L;
        }
    }

    private static interface CacheEntry<K, V> {
        public boolean isValid(long var1);

        public void invalidate();

        public K getKey();

        public V getValue();
    }
}

