/*
 * Decompiled with CFR 0.152.
 */
package sun.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import sun.util.locale.provider.CalendarDataUtility;

public class BuddhistCalendar
extends GregorianCalendar {
    private static final long serialVersionUID = -8527488697350388578L;
    private static final int BUDDHIST_YEAR_OFFSET = 543;
    private transient int yearOffset = 543;

    public BuddhistCalendar() {
    }

    public BuddhistCalendar(TimeZone timeZone) {
        super(timeZone);
    }

    public BuddhistCalendar(Locale locale) {
        super(locale);
    }

    public BuddhistCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
    }

    @Override
    public String getCalendarType() {
        return "buddhist";
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof BuddhistCalendar && super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ 0x21F;
    }

    @Override
    public int get(int n) {
        if (n == 1) {
            return super.get(n) + this.yearOffset;
        }
        return super.get(n);
    }

    @Override
    public void set(int n, int n2) {
        if (n == 1) {
            super.set(n, n2 - this.yearOffset);
        } else {
            super.set(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int n, int n2) {
        int n3 = this.yearOffset;
        this.yearOffset = 0;
        try {
            super.add(n, n2);
        }
        finally {
            this.yearOffset = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void roll(int n, int n2) {
        int n3 = this.yearOffset;
        this.yearOffset = 0;
        try {
            super.roll(n, n2);
        }
        finally {
            this.yearOffset = n3;
        }
    }

    @Override
    public String getDisplayName(int n, int n2, Locale locale) {
        if (n != 0) {
            return super.getDisplayName(n, n2, locale);
        }
        return CalendarDataUtility.retrieveFieldValueName("buddhist", n, this.get(n), n2, locale);
    }

    @Override
    public Map<String, Integer> getDisplayNames(int n, int n2, Locale locale) {
        if (n != 0) {
            return super.getDisplayNames(n, n2, locale);
        }
        return CalendarDataUtility.retrieveFieldValueNames("buddhist", n, n2, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActualMaximum(int n) {
        int n2 = this.yearOffset;
        this.yearOffset = 0;
        try {
            int n3 = super.getActualMaximum(n);
            return n3;
        }
        finally {
            this.yearOffset = n2;
        }
    }

    @Override
    public String toString() {
        String string = super.toString();
        if (!this.isSet(1)) {
            return string;
        }
        int n = string.indexOf("YEAR=");
        if (n == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.substring(0, n += "YEAR=".length()));
        while (Character.isDigit(string.charAt(n++))) {
        }
        int n2 = this.internalGet(1) + 543;
        stringBuilder.append(n2).append(string.substring(n - 1));
        return stringBuilder.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.yearOffset = 543;
    }
}

