/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.ContentType;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.InputRecord;
import sun.security.ssl.Plaintext;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.Record;
import sun.security.ssl.SSLCipher;
import sun.security.ssl.SSLConfiguration;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLRecord;

final class SSLSocketInputRecord
extends InputRecord
implements SSLRecord {
    private InputStream is = null;
    private OutputStream os = null;
    private final byte[] temporary = new byte[1024];
    private boolean formatVerified = false;
    private ByteBuffer handshakeBuffer = null;
    private boolean hasHeader = false;

    SSLSocketInputRecord(HandshakeHash handshakeHash) {
        super(handshakeHash, SSLCipher.SSLReadCipher.nullTlsReadCipher());
    }

    @Override
    int bytesInCompletePacket() throws IOException {
        int n;
        if (!this.hasHeader) {
            try {
                n = SSLSocketInputRecord.read(this.is, this.temporary, 0, 5);
                if (n < 0) {
                    return -1;
                }
            }
            catch (EOFException eOFException) {
                return -1;
            }
            this.hasHeader = true;
        }
        n = this.temporary[0];
        int n2 = 0;
        if (this.formatVerified || n == ContentType.HANDSHAKE.id || n == ContentType.ALERT.id) {
            if (!ProtocolVersion.isNegotiable(this.temporary[1], this.temporary[2], false)) {
                throw new SSLException("Unrecognized record version " + ProtocolVersion.nameOf(this.temporary[1], this.temporary[2]) + " , plaintext connection?");
            }
            this.formatVerified = true;
            n2 = ((this.temporary[3] & 0xFF) << 8) + (this.temporary[4] & 0xFF) + 5;
        } else {
            boolean bl;
            boolean bl2 = bl = (n & 0x80) != 0;
            if (bl && (this.temporary[2] == 1 || this.temporary[2] == 4)) {
                if (!ProtocolVersion.isNegotiable(this.temporary[3], this.temporary[4], false)) {
                    throw new SSLException("Unrecognized record version " + ProtocolVersion.nameOf(this.temporary[3], this.temporary[4]) + " , plaintext connection?");
                }
                n2 = ((n & 0x7F) << 8) + (this.temporary[1] & 0xFF) + 2;
            } else {
                throw new SSLException("Unrecognized SSL message, plaintext connection?");
            }
        }
        return n2;
    }

    @Override
    Plaintext[] decode(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException, BadPaddingException {
        if (this.isClosed) {
            return null;
        }
        if (!this.hasHeader) {
            int n3 = SSLSocketInputRecord.read(this.is, this.temporary, 0, 5);
            if (n3 < 0) {
                throw new EOFException("SSL peer shut down incorrectly");
            }
            this.hasHeader = true;
        }
        Object var4_5 = null;
        if (!this.formatVerified) {
            this.formatVerified = true;
            if (this.temporary[0] != ContentType.HANDSHAKE.id && this.temporary[0] != ContentType.ALERT.id) {
                this.hasHeader = false;
                return this.handleUnknownRecord(this.temporary);
            }
        }
        this.hasHeader = false;
        return this.decodeInputRecord(this.temporary);
    }

    @Override
    void setReceiverStream(InputStream inputStream) {
        this.is = inputStream;
    }

    @Override
    void setDeliverStream(OutputStream outputStream) {
        this.os = outputStream;
    }

    private Plaintext[] decodeInputRecord(byte[] byArray) throws IOException, BadPaddingException {
        ByteBuffer byteBuffer;
        Object object;
        byte by = byArray[0];
        byte by2 = byArray[1];
        byte by3 = byArray[2];
        int n = ((byArray[3] & 0xFF) << 8) + (byArray[4] & 0xFF);
        if (SSLLogger.isOn && SSLLogger.isOn("record")) {
            SSLLogger.fine("READ: " + ProtocolVersion.nameOf(by2, by3) + " " + ContentType.nameOf(by) + ", length = " + n, new Object[0]);
        }
        if (n < 0 || n > 33088) {
            throw new SSLProtocolException("Bad input record size, TLSCiphertext.length = " + n);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(5 + n);
        int n2 = byteBuffer2.position();
        byteBuffer2.put(this.temporary, 0, 5);
        while (n > 0) {
            int n3 = Math.min(this.temporary.length, n);
            int n4 = SSLSocketInputRecord.read(this.is, this.temporary, 0, n3);
            if (n4 < 0) {
                throw new EOFException("SSL peer shut down incorrectly");
            }
            byteBuffer2.put(this.temporary, 0, n3);
            n -= n3;
        }
        byteBuffer2.flip();
        byteBuffer2.position(n2 + 5);
        if (SSLLogger.isOn && SSLLogger.isOn("record")) {
            SSLLogger.fine("READ: " + ProtocolVersion.nameOf(by2, by3) + " " + ContentType.nameOf(by) + ", length = " + byteBuffer2.remaining(), new Object[0]);
        }
        try {
            object = this.readCipher.decrypt(by, byteBuffer2, null);
            byteBuffer = ((Plaintext)object).fragment;
            by = ((Plaintext)object).contentType;
        }
        catch (BadPaddingException badPaddingException) {
            throw badPaddingException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (SSLProtocolException)new SSLProtocolException("Unexpected exception").initCause(generalSecurityException);
        }
        if (by != ContentType.HANDSHAKE.id && this.handshakeBuffer != null && this.handshakeBuffer.hasRemaining()) {
            throw new SSLProtocolException("Expecting a handshake fragment, but received " + ContentType.nameOf(by));
        }
        if (by == ContentType.HANDSHAKE.id) {
            Object object2;
            object = byteBuffer;
            if (this.handshakeBuffer != null && this.handshakeBuffer.remaining() != 0) {
                object2 = ByteBuffer.wrap(new byte[this.handshakeBuffer.remaining() + byteBuffer.remaining()]);
                ((ByteBuffer)object2).put(this.handshakeBuffer);
                ((ByteBuffer)object2).put(byteBuffer);
                object = (ByteBuffer)((ByteBuffer)object2).rewind();
                this.handshakeBuffer = null;
            }
            object2 = new ArrayList(5);
            while (((Buffer)object).hasRemaining()) {
                int n5 = ((Buffer)object).remaining();
                if (n5 < 4) {
                    this.handshakeBuffer = ByteBuffer.wrap(new byte[n5]);
                    this.handshakeBuffer.put((ByteBuffer)object);
                    this.handshakeBuffer.rewind();
                    break;
                }
                ((ByteBuffer)object).mark();
                byte by4 = ((ByteBuffer)object).get();
                int n6 = Record.getInt24((ByteBuffer)object);
                if (n6 > SSLConfiguration.maxHandshakeMessageSize) {
                    throw new SSLProtocolException("The size of the handshake message (" + n6 + ") exceeds the maximum allowed size (" + SSLConfiguration.maxHandshakeMessageSize + ")");
                }
                ((ByteBuffer)object).reset();
                int n7 = 4 + n6;
                if (n5 < n7) {
                    this.handshakeBuffer = ByteBuffer.wrap(new byte[n5]);
                    this.handshakeBuffer.put((ByteBuffer)object);
                    this.handshakeBuffer.rewind();
                    break;
                }
                if (n5 == n7) {
                    if (this.handshakeHash.isHashable(by4)) {
                        this.handshakeHash.receive((ByteBuffer)object);
                    }
                    ((ArrayList)object2).add(new Plaintext(by, by2, by3, -1, -1L, (ByteBuffer)object));
                    break;
                }
                int n8 = ((Buffer)object).position();
                int n9 = ((Buffer)object).limit();
                int n10 = n8 + n7;
                ((ByteBuffer)object).limit(n10);
                if (this.handshakeHash.isHashable(by4)) {
                    this.handshakeHash.receive((ByteBuffer)object);
                }
                ((ArrayList)object2).add(new Plaintext(by, by2, by3, -1, -1L, ((ByteBuffer)object).slice()));
                ((ByteBuffer)object).position(n10);
                ((ByteBuffer)object).limit(n9);
            }
            return ((ArrayList)object2).toArray(new Plaintext[0]);
        }
        return new Plaintext[]{new Plaintext(by, by2, by3, -1, -1L, byteBuffer)};
    }

    private Plaintext[] handleUnknownRecord(byte[] byArray) throws IOException, BadPaddingException {
        byte by = byArray[0];
        byte by2 = byArray[2];
        if ((by & 0x80) != 0 && by2 == 1) {
            if (this.helloVersion != ProtocolVersion.SSL20Hello) {
                throw new SSLHandshakeException("SSLv2Hello is not enabled");
            }
            byte by3 = byArray[3];
            byte by4 = byArray[4];
            if (by3 == ProtocolVersion.SSL20Hello.major && by4 == ProtocolVersion.SSL20Hello.minor) {
                this.os.write(SSLRecord.v2NoCipher);
                if (SSLLogger.isOn) {
                    if (SSLLogger.isOn("record")) {
                        SSLLogger.fine("Requested to negotiate unsupported SSLv2!", new Object[0]);
                    }
                    if (SSLLogger.isOn("packet")) {
                        SSLLogger.fine("Raw write", new Object[]{SSLRecord.v2NoCipher});
                    }
                }
                throw new SSLException("Unsupported SSL v2.0 ClientHello");
            }
            int n = (byArray[0] & 0x7F) << 8 | byArray[1] & 0xFF;
            ByteBuffer byteBuffer = ByteBuffer.allocate(5 + n);
            byteBuffer.put(this.temporary, 0, 5);
            n -= 3;
            while (n > 0) {
                int n2 = Math.min(this.temporary.length, n);
                int n3 = SSLSocketInputRecord.read(this.is, this.temporary, 0, n2);
                if (n3 < 0) {
                    throw new EOFException("SSL peer shut down incorrectly");
                }
                byteBuffer.put(this.temporary, 0, n2);
                n -= n2;
            }
            byteBuffer.flip();
            byteBuffer.position(2);
            this.handshakeHash.receive(byteBuffer);
            byteBuffer.position(0);
            ByteBuffer byteBuffer2 = SSLSocketInputRecord.convertToClientHello(byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
                SSLLogger.fine("[Converted] ClientHello", byteBuffer2);
            }
            return new Plaintext[]{new Plaintext(ContentType.HANDSHAKE.id, by3, by4, -1, -1L, byteBuffer2)};
        }
        if ((by & 0x80) != 0 && by2 == 4) {
            throw new SSLException("SSL V2.0 servers are not supported.");
        }
        throw new SSLException("Unsupported or unrecognized SSL message");
    }

    private static int read(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        for (n3 = 0; n3 < n2; n3 += n4) {
            n4 = inputStream.read(byArray, n + n3, n2 - n3);
            if (n4 < 0) {
                if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
                    SSLLogger.fine("Raw read: EOF", new Object[0]);
                }
                return -1;
            }
            if (!SSLLogger.isOn || !SSLLogger.isOn("packet")) continue;
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n + n3, n4);
            SSLLogger.fine("Raw read", byteBuffer);
        }
        return n3;
    }

    void deplete(boolean bl) throws IOException {
        int n = this.is.available();
        if (bl && n == 0) {
            this.is.read();
        }
        while ((n = this.is.available()) != 0) {
            this.is.skip(n);
        }
    }
}

