/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.util;

import com.sun.star.lib.util.DisposeListener;
import com.sun.star.lib.util.DisposeNotifier;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class WeakMap<K, V>
implements Map {
    private final HashMap<K, WeakReference<V>> map = new HashMap();
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    public WeakMap() {
    }

    public WeakMap(Map<K, V> m) {
        this.putAll(m);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public WeakReference<V> get(Object key) {
        return this.map.get(key);
    }

    public Object put(Object key, Object value) {
        this.cleanUp();
        return this.map.put(key, new Entry(key, value, this.queue));
    }

    public Object remove(Object key) {
        this.cleanUp();
        return this.map.remove(key);
    }

    public void putAll(Map m) {
        this.cleanUp();
        for (Map.Entry e : m.entrySet()) {
            Object k = e.getKey();
            this.map.put(k, new Entry(k, e.getValue(), this.queue));
        }
    }

    @Override
    public void clear() {
        this.cleanUp();
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Collection<WeakReference<V>> values() {
        return this.map.values();
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public static <T> T getValue(Object ref) {
        return ref == null ? null : (T)((WeakReference)ref).get();
    }

    private void cleanUp() {
        Entry e;
        while ((e = (Entry)this.queue.poll()) != null) {
            Object k = e.key;
            if (e != this.map.get(k)) continue;
            this.map.remove(k);
        }
    }

    private static final class Entry<K, V>
    extends WeakReference<V>
    implements DisposeListener {
        private final K key;

        private Entry(K key, V value, ReferenceQueue<V> queue) {
            super(value, queue);
            this.key = key;
            if (value instanceof DisposeNotifier) {
                ((DisposeNotifier)value).addDisposeListener(this);
            }
        }

        @Override
        public void notifyDispose(DisposeNotifier source) {
            this.clear();
            this.enqueue();
        }
    }
}

